/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domain.genericmodel.internal;

import iot.jcypher.domain.genericmodel.DOField;
import iot.jcypher.domain.genericmodel.DOType;
import iot.jcypher.domain.genericmodel.DOTypeBuilderFactory;
import iot.jcypher.domain.genericmodel.DomainObject;
import iot.jcypher.domain.genericmodel.InternalAccess;
import iot.jcypher.domain.internal.DomainAccess;
import iot.jcypher.domain.mapping.surrogate.AbstractSurrogate;
import iot.jcypher.graph.GrNode;
import iot.jcypher.graph.GrProperty;
import iot.jcypher.query.api.IClause;
import iot.jcypher.query.api.returns.RSortable;
import iot.jcypher.query.factories.clause.DO;
import iot.jcypher.query.factories.clause.MERGE;
import iot.jcypher.query.factories.clause.RETURN;
import iot.jcypher.query.factories.clause.WITH;
import iot.jcypher.query.values.JcNode;
import iot.jcypher.query.values.JcNumber;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;

public class DomainModel {
    private static final String JavaPkg = "java.";
    private static final String[] primitives = new String[]{"int", "boolean", "long", "short", "float", "double"};
    private static final String EnumVals = "$VALUES";
    private static final String TypeNodePostfix = "_mdl";
    private static final String Colon = ":";
    private static final String propTypeName = "typeName";
    private static final String propSuperTypeName = "superTypeName";
    private static final String propInterfaceNames = "interfaceNames";
    private static final String propFields = "fields";
    private static final String propKind = "kind";
    private static Map<String, ClassPool> classPools = new HashMap<String, ClassPool>();
    private String domainName;
    private String typeNodeName;
    private Map<String, DOType> doTypes;
    private List<DOType> unsaved;
    private TypeBuilderFactory typeBuilderFactory;
    private DomainAccess domainAccess;
    private Map<Object, DomainObject> nursery;
    private ThreadLocal<TransactionState> transactionState;
    private int version;

    DomainModel(String domName, String domLabel, DomainAccess domAccess) {
        this.domainName = domName;
        this.typeNodeName = domLabel.concat(TypeNodePostfix);
        this.doTypes = new HashMap<String, DOType>();
        this.unsaved = new ArrayList<DOType>();
        this.domainAccess = domAccess;
        this.transactionState = new ThreadLocal();
        this.version = -1;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public DOType addType(Class<?> clazz) {
        if (!AbstractSurrogate.class.isAssignableFrom(clazz)) {
            String name = clazz.getName();
            DOType doType = this.doTypes.get(name);
            if (doType == null) {
                doType = InternalAccess.createDOType(name, this);
                this.doTypes.put(name, doType);
                boolean buildIn = doType.isBuildIn();
                if (!buildIn) {
                    Class<?>[] ifss;
                    DOType.Builder builder = InternalAccess.createBuilder(doType);
                    DOType.Kind kind = clazz.isInterface() ? DOType.Kind.INTERFACE : (Enum.class.isAssignableFrom(clazz) ? DOType.Kind.ENUM : (Modifier.isAbstract(clazz.getModifiers()) ? DOType.Kind.ABSTRACT_CLASS : DOType.Kind.CLASS));
                    InternalAccess.setKind(builder, kind);
                    this.addToUnsaved(doType);
                    this.addFields(builder, clazz);
                    Class<?> sClass = clazz.getSuperclass();
                    DOType superType = null;
                    if (sClass != null) {
                        superType = this.addType(sClass);
                    }
                    if (superType != null) {
                        InternalAccess.setSuperType(builder, superType);
                    }
                    if ((ifss = clazz.getInterfaces()) != null) {
                        for (Class<?> ifs : ifss) {
                            DOType interf = this.addType(ifs);
                            if (interf == null) continue;
                            InternalAccess.addInterfaceUnique(doType, interf);
                        }
                    }
                }
            }
            return doType;
        }
        return null;
    }

    private void addFields(DOType.Builder builder, Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (Modifier.isTransient(fields[i].getModifiers()) || builder.build().getKind() == DOType.Kind.ENUM && fields[i].getName().indexOf(EnumVals) >= 0) continue;
            Class<?> fTyp = fields[i].getType();
            String tName = fTyp.getName();
            DOField fld = InternalAccess.createDOField(fields[i].getName(), tName, builder.build());
            InternalAccess.addDeclaredFieldUnique(builder.build(), fld);
            if (builder.build().isBuildIn()) continue;
            if (!fld.isBuidInType()) {
                this.addType(fTyp);
            }
            if (List.class.isAssignableFrom(fields[i].getType())) {
                boolean cTypeResolved = false;
                Type gtype = fields[i].getGenericType();
                if (gtype instanceof ParameterizedType) {
                    String nm;
                    Type lType = ((ParameterizedType)gtype).getActualTypeArguments()[0];
                    String string = nm = lType instanceof Class ? ((Class)lType).getName() : null;
                    if (nm != null) {
                        if (!DomainModel.isBuildIn(nm)) {
                            this.addType((Class)lType);
                        }
                        InternalAccess.setComponentTypeName(fld, nm);
                        cTypeResolved = true;
                    }
                }
                if (cTypeResolved) continue;
                InternalAccess.setComponentTypeName(fld, DOField.COMPONENTTYPE_Object);
                continue;
            }
            if (!fields[i].getType().isArray()) continue;
            Class<?> cType = fields[i].getType().getComponentType();
            if (!DomainModel.isBuildIn(cType.getName())) {
                this.addType(cType);
            }
            InternalAccess.setComponentTypeName(fld, cType.getName());
        }
    }

    public DOType getDOType(String typeName) {
        return this.doTypes.get(typeName);
    }

    public List<DOType> getDOTypes() {
        ArrayList<DOType> vals = new ArrayList<DOType>();
        vals.addAll(this.doTypes.values());
        Collections.sort(vals, new Comparator<DOType>(){

            @Override
            public int compare(DOType o1, DOType o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return vals;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getTypeNodeName() {
        return this.typeNodeName;
    }

    public void mergeFrom(List<GrNode> mdlInfos) {
        for (GrNode nd : mdlInfos) {
            if (nd == null) continue;
            GrProperty propTyp = nd.getProperty(propTypeName);
            String typNm = propTyp.getValue().toString();
            DOType doType = this.addType(typNm);
            InternalAccess.setNodeId(doType, nd.getId());
            this.setProperties(nd, doType);
        }
    }

    public void loadFrom(List<GrNode> mdlInfos) {
        for (GrNode nd : mdlInfos) {
            if (nd == null) continue;
            GrProperty propTyp = nd.getProperty(propTypeName);
            String typNm = propTyp.getValue().toString();
            DOType doType = this.addType(typNm);
            InternalAccess.setNodeId(doType, nd.getId());
            this.setProperties(nd, doType);
        }
    }

    private void setProperties(GrNode nd, DOType doType) {
        Object ifss;
        Object flds;
        GrProperty propSuperTyp = nd.getProperty(propSuperTypeName);
        GrProperty propFlds = nd.getProperty(propFields);
        GrProperty propKnd = nd.getProperty(propKind);
        GrProperty propIfss = nd.getProperty(propInterfaceNames);
        DOType.Kind knd = DOType.Kind.valueOf(propKnd.getValue().toString());
        DOType.Builder builder = InternalAccess.createBuilder(doType);
        InternalAccess.setKind(builder, knd);
        String sTypNm = propSuperTyp.getValue().toString();
        if (!sTypNm.isEmpty()) {
            InternalAccess.setSuperType(builder, this.addType(sTypNm));
        }
        if ((flds = propFlds.getValue()) instanceof List) {
            for (Object obj : (List)flds) {
                String[] fld = obj.toString().split(Colon);
                DOField doField = InternalAccess.createDOField(fld[0], fld[1], doType);
                if (fld.length == 3) {
                    InternalAccess.setComponentTypeName(doField, fld[2]);
                }
                InternalAccess.addDeclaredFieldUnique(doType, doField);
            }
        }
        if ((ifss = propIfss.getValue()) instanceof List) {
            for (Object obj : (List)ifss) {
                InternalAccess.addInterfaceUnique(doType, this.addType(obj.toString()));
            }
        }
    }

    private DOType addType(String typeName) {
        DOType typ = this.doTypes.get(typeName);
        if (typ == null) {
            typ = InternalAccess.createDOType(typeName, this);
            this.doTypes.put(typeName, typ);
        }
        return typ;
    }

    public boolean hasChanged() {
        return this.unsaved.size() > 0;
    }

    public List<IClause>[] getChangeClauses() {
        ArrayList<Object> clauses = null;
        ArrayList returnClauses = null;
        ArrayList<RSortable> withClauses = null;
        if (this.hasChanged()) {
            clauses = new ArrayList<Object>();
            returnClauses = new ArrayList();
            withClauses = new ArrayList<RSortable>();
            int idx = 0;
            for (DOType t : this.unsaved) {
                ArrayList<String> flds = new ArrayList<String>();
                for (DOField dOField : t.getDeclaredFields()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(dOField.getName());
                    sb.append(Colon);
                    sb.append(dOField.getTypeName());
                    String ctn = dOField.getComponentTypeName();
                    if (ctn != null) {
                        sb.append(Colon);
                        sb.append(ctn);
                    }
                    flds.add(sb.toString());
                }
                ArrayList<String> ifss = new ArrayList<String>();
                for (DOType ifs : t.getInterfaces()) {
                    String ifName = ifs.getName();
                    ifss.add(ifName);
                }
                String string = t.getSuperType() != null ? t.getSuperType().getName() : "";
                String strIdx = String.valueOf(idx);
                JcNode n = new JcNode("n_".concat(strIdx));
                JcNumber nid = new JcNumber("nid_".concat(strIdx));
                clauses.add(MERGE.node(n).label(this.getTypeNodeName()).property(propTypeName).value(t.getName()));
                clauses.add(DO.SET(n.property(propKind)).to(t.getKind()));
                clauses.add(DO.SET(n.property(propSuperTypeName)).to(string));
                clauses.add(DO.SET(n.property(propInterfaceNames)).to(ifss));
                clauses.add(DO.SET(n.property(propFields)).to(flds));
                returnClauses.add(RETURN.value(n.id()).AS(nid));
                withClauses.add(WITH.value(n));
                ++idx;
            }
            return new List[]{clauses, returnClauses, withClauses};
        }
        return null;
    }

    public static boolean isBuildIn(String typeName) {
        return typeName.startsWith(JavaPkg) || DomainModel.isPrimitive(typeName);
    }

    private static boolean isPrimitive(String typeName) {
        for (String prim : primitives) {
            if (!prim.equals(typeName)) continue;
            return true;
        }
        return false;
    }

    public List<DOType> getUnsaved() {
        return this.unsaved;
    }

    public void addToUnsaved(DOType typ) {
        TransactionState txState;
        if (this.unsaved.isEmpty()) {
            ++this.version;
        }
        if (!this.unsaved.contains(typ)) {
            this.unsaved.add(typ);
        }
        if ((txState = this.transactionState.get()) != null) {
            if (!txState.unsaved.contains(typ)) {
                txState.unsaved.add(typ);
            }
            txState.version = this.version;
        }
    }

    public void updatedToGraph() {
        this.unsaved.clear();
    }

    public Class<?> getClassForName(String name) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            DOType doType = this.getDOType(name);
            if (doType == null) {
                throw e;
            }
            try {
                this.createClassFor(doType);
                clazz = Class.forName(name);
            }
            catch (Throwable e1) {
                if (e1 instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)e1;
                }
                throw new RuntimeException(e1);
            }
        }
        return clazz;
    }

    public DomainObject getCreateDomainObjectFor(Object obj) {
        DomainObject dobj = this.getNurseryObject(obj);
        if (dobj == null) {
            String typNm = obj.getClass().getName();
            DOType typ = this.getDOType(typNm);
            if (typ == null) {
                throw new RuntimeException("missing type: [".concat(typNm).concat("] in domain model"));
            }
            dobj = InternalAccess.createDomainObject(typ);
            InternalAccess.setRawObject(dobj, obj);
        } else {
            this.removeNurseryObject(obj);
        }
        return dobj;
    }

    private void createClassFor(DOType doType) throws Throwable {
        this.createCtClassFor(doType, this.getClassPool());
    }

    private CtClass createCtClassFor(DOType doType, ClassPool cp) throws Throwable {
        CtClass cc = cp.getOrNull(doType.getName());
        if (cc == null) {
            CtField ctField;
            if (doType.getKind() == DOType.Kind.INTERFACE) {
                cc = cp.makeInterface(doType.getName());
            } else {
                cc = cp.makeClass(doType.getName());
                if (doType.getKind() == DOType.Kind.ABSTRACT_CLASS) {
                    cc.setModifiers(cc.getModifiers() | 0x400);
                }
            }
            DOType doSType = doType.getSuperType();
            if (doSType != null) {
                CtClass scc = this.createCtClassFor(doSType, cp);
                cc.setSuperclass(scc);
            }
            for (DOType dOType : doType.getInterfaces()) {
                CtClass ifct = this.createCtClassFor(dOType, cp);
                cc.addInterface(ifct);
            }
            if (doType.getKind() == DOType.Kind.ENUM) {
                int count = 0;
                for (DOField fld : doType.getDeclaredFields()) {
                    if (!fld.getTypeName().equals(doType.getName())) continue;
                    ++count;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("private static ");
                stringBuilder.append(doType.getName());
                stringBuilder.append("[] values = new ");
                stringBuilder.append(doType.getName());
                stringBuilder.append('[');
                stringBuilder.append(count);
                stringBuilder.append("];");
                ctField = CtField.make((String)stringBuilder.toString(), (CtClass)cc);
                cc.addField(ctField);
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append("public static ");
                stringBuilder2.append(doType.getName());
                stringBuilder2.append("[] ");
                stringBuilder2.append("values(){return values;}");
                CtMethod mthd = CtMethod.make((String)stringBuilder2.toString(), (CtClass)cc);
                cc.addMethod(mthd);
                StringBuilder stringBuilder3 = new StringBuilder();
                int idx = doType.getName().lastIndexOf(46);
                String nm = idx >= 0 ? doType.getName().substring(idx + 1) : doType.getName();
                stringBuilder3.append("public ");
                stringBuilder3.append(nm);
                stringBuilder3.append("(String name, int ordinal) {super(name, ordinal);}");
                CtConstructor constr = CtNewConstructor.make((String)stringBuilder3.toString(), (CtClass)cc);
                cc.addConstructor(constr);
            } else {
                for (DOField dOField : doType.getDeclaredFields()) {
                    String tn = dOField.getTypeName();
                    if (!dOField.isBuidInType()) {
                        DOType ft = this.getDOType(tn);
                        if (ft == null) {
                            throw new ClassNotFoundException(tn);
                        }
                        CtClass ctFt = this.createCtClassFor(ft, cp);
                        ctField = new CtField(ctFt, dOField.getName(), cc);
                        ctField.setModifiers(1);
                    } else {
                        StringBuilder sb = new StringBuilder();
                        sb.append("public ");
                        sb.append(tn);
                        sb.append(' ');
                        sb.append(dOField.getName());
                        sb.append(';');
                        ctField = CtField.make((String)sb.toString(), (CtClass)cc);
                    }
                    cc.addField(ctField);
                }
            }
            cc.toClass();
            if (doType.getKind() == DOType.Kind.ENUM) {
                Class<?> clazz = Class.forName(doType.getName());
                Field field = clazz.getDeclaredField("values");
                field.setAccessible(true);
                Object vals = field.get(clazz);
                Constructor<?> cstr = clazz.getDeclaredConstructor(String.class, Integer.TYPE);
                int ord = 0;
                for (DOField fld : doType.getDeclaredFields()) {
                    if (!fld.getTypeName().equals(doType.getName())) continue;
                    Object val = cstr.newInstance(fld.getName(), ord);
                    ((Object[])vals)[ord] = val;
                    ++ord;
                }
            }
        }
        return cc;
    }

    private ClassPool getClassPool() {
        ClassPool cp = classPools.get(this.getDomainName());
        if (cp == null) {
            cp = new ClassPool(true);
            classPools.put(this.getDomainName(), cp);
        }
        return cp;
    }

    void addDOTypeIfNeeded(DOType doType) {
        if (this.doTypes.get(doType.getName()) == null) {
            this.doTypes.put(doType.getName(), doType);
            if (!doType.isBuildIn()) {
                this.addToUnsaved(doType);
            }
        }
    }

    public DOTypeBuilderFactory getTypeBuilderFactory() {
        if (this.typeBuilderFactory == null) {
            this.typeBuilderFactory = new TypeBuilderFactory();
        }
        return this.typeBuilderFactory;
    }

    public void addNurseryObject(Object raw, DomainObject dobj) {
        if (this.nursery == null) {
            this.nursery = new IdentityHashMap<Object, DomainObject>();
        }
        this.nursery.put(raw, dobj);
        TransactionState txState = this.transactionState.get();
        if (txState != null) {
            if (txState.nursery == null) {
                txState.nursery = new IdentityHashMap();
            }
            txState.nursery.put(raw, dobj);
        }
    }

    public DomainObject getNurseryObject(Object raw) {
        if (this.nursery != null) {
            return this.nursery.get(raw);
        }
        return null;
    }

    public void removeNurseryObject(Object raw) {
        if (this.nursery != null) {
            this.nursery.remove(raw);
        }
    }

    public void clearNursery() {
        if (this.nursery != null) {
            this.nursery.clear();
        }
    }

    public void beginTx() {
        if (this.transactionState.get() == null) {
            TransactionState txState = new TransactionState();
            txState.unsaved = (List)((ArrayList)this.unsaved).clone();
            if (this.nursery != null) {
                txState.nursery = (Map)((IdentityHashMap)this.nursery).clone();
            }
            txState.version = this.version;
            this.transactionState.set(txState);
        }
    }

    public void closeTx(boolean failed) {
        TransactionState txState = this.transactionState.get();
        if (txState != null) {
            if (failed) {
                this.unsaved = txState.unsaved;
                this.nursery = txState.nursery;
                this.version = txState.version;
            }
            this.transactionState.remove();
        }
    }

    DomainAccess getDomainAccess() {
        return this.domainAccess;
    }

    public String asString() {
        String indent = "   ";
        StringBuilder sb = new StringBuilder();
        sb.append(this.domainName);
        sb.append(" (DomainModel Version: ");
        sb.append(this.version);
        sb.append(", DomainInfo Version: ");
        sb.append(this.domainAccess.getInternalDomainAccess().getDomainInfoVersion());
        sb.append(") {");
        List<DOType> vals = this.getDOTypes();
        for (DOType t : vals) {
            sb.append('\n');
            sb.append(t.asString(indent));
        }
        sb.append('\n');
        sb.append('}');
        return sb.toString();
    }

    public String nurseryAsString() {
        if (this.nursery != null) {
            ArrayList<String> keys = new ArrayList<String>();
            HashMap<String, Integer> cont = new HashMap<String, Integer>();
            Iterator<Object> it = this.nursery.keySet().iterator();
            while (it.hasNext()) {
                String nm = it.next().getClass().getName();
                Integer cnt = (Integer)cont.get(nm);
                cnt = cnt == null ? new Integer(1) : new Integer(cnt + 1);
                cont.put(nm, cnt);
            }
            for (Map.Entry entry : cont.entrySet()) {
                StringBuilder sb = new StringBuilder();
                sb.append((String)entry.getKey());
                sb.append('(');
                sb.append(entry.getValue());
                sb.append(')');
                keys.add(sb.toString());
            }
            Collections.sort(keys);
            return ((Object)keys).toString();
        }
        return "null";
    }

    private static class TransactionState {
        private List<DOType> unsaved;
        private Map<Object, DomainObject> nursery;
        private int version;

        private TransactionState() {
        }
    }

    public class TypeBuilderFactory
    implements DOTypeBuilderFactory {
        @Override
        public DOType.DOClassBuilder createClassBuilder(String typeName) {
            DOType.DOClassBuilder ret = InternalAccess.createClassBuilder(typeName, DomainModel.this);
            DomainModel.this.addDOTypeIfNeeded(ret.build());
            DOType sType = DomainModel.this.getDOType("java.lang.Object");
            if (sType == null) {
                sType = InternalAccess.createDOType("java.lang.Object", DomainModel.this);
                DomainModel.this.addDOTypeIfNeeded(sType);
            }
            ret.setSuperType(sType);
            return ret;
        }

        @Override
        public DOType.DOInterfaceBuilder createInterfaceBuilder(String typeName) {
            DOType.DOInterfaceBuilder ret = InternalAccess.createInterfaceBuilder(typeName, DomainModel.this);
            DomainModel.this.addDOTypeIfNeeded(ret.build());
            return ret;
        }

        @Override
        public DOType.DOEnumBuilder createEnumBuilder(String typeName) {
            DOType.DOEnumBuilder ret = InternalAccess.createEnumBuilder(typeName, DomainModel.this);
            DomainModel.this.addDOTypeIfNeeded(ret.build());
            DOType sType = DomainModel.this.getDOType("java.lang.Enum");
            if (sType == null) {
                sType = InternalAccess.createDOType("java.lang.Enum", DomainModel.this);
                DomainModel.this.addDOTypeIfNeeded(sType);
            }
            ret.setSuperType(sType);
            return ret;
        }
    }
}

