/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domain.internal;

import iot.jcypher.concurrency.Locking;
import iot.jcypher.concurrency.QExecution;
import iot.jcypher.database.DBType;
import iot.jcypher.database.IDBAccess;
import iot.jcypher.domain.IDomainAccess;
import iot.jcypher.domain.IGenericDomainAccess;
import iot.jcypher.domain.ResolutionDepth;
import iot.jcypher.domain.SyncInfo;
import iot.jcypher.domain.genericmodel.DOType;
import iot.jcypher.domain.genericmodel.DOTypeBuilderFactory;
import iot.jcypher.domain.genericmodel.DomainObject;
import iot.jcypher.domain.genericmodel.internal.DomainModel;
import iot.jcypher.domain.internal.CurrentDomain;
import iot.jcypher.domain.internal.IIntDomainAccess;
import iot.jcypher.domain.internal.SkipLimitCalc;
import iot.jcypher.domain.mapping.CompoundObjectMapping;
import iot.jcypher.domain.mapping.CompoundObjectType;
import iot.jcypher.domain.mapping.DefaultObjectMappingCreator;
import iot.jcypher.domain.mapping.DomainState;
import iot.jcypher.domain.mapping.FieldMapping;
import iot.jcypher.domain.mapping.IMapEntry;
import iot.jcypher.domain.mapping.MapTerminator;
import iot.jcypher.domain.mapping.MappingUtil;
import iot.jcypher.domain.mapping.ObjectMapping;
import iot.jcypher.domain.mapping.surrogate.AbstractDeferred;
import iot.jcypher.domain.mapping.surrogate.AbstractSurrogate;
import iot.jcypher.domain.mapping.surrogate.Array;
import iot.jcypher.domain.mapping.surrogate.Collection;
import iot.jcypher.domain.mapping.surrogate.Deferred2DO;
import iot.jcypher.domain.mapping.surrogate.IDeferred;
import iot.jcypher.domain.mapping.surrogate.IEntryUpdater;
import iot.jcypher.domain.mapping.surrogate.ISurrogate2Entry;
import iot.jcypher.domain.mapping.surrogate.InnerClassSurrogate;
import iot.jcypher.domain.mapping.surrogate.ListEntriesUpdater;
import iot.jcypher.domain.mapping.surrogate.MapEntry;
import iot.jcypher.domain.mapping.surrogate.MapEntryUpdater;
import iot.jcypher.domain.mapping.surrogate.ObservableList;
import iot.jcypher.domain.mapping.surrogate.Surrogate2ListEntry;
import iot.jcypher.domain.mapping.surrogate.Surrogate2MapEntry;
import iot.jcypher.domainquery.DomainQuery;
import iot.jcypher.domainquery.GDomainQuery;
import iot.jcypher.domainquery.InternalAccess;
import iot.jcypher.domainquery.QueryLoader;
import iot.jcypher.domainquery.QueryPersistor;
import iot.jcypher.domainquery.internal.QueryRecorder;
import iot.jcypher.domainquery.internal.ReplayedQueryContext;
import iot.jcypher.graph.GrAccess;
import iot.jcypher.graph.GrLabel;
import iot.jcypher.graph.GrNode;
import iot.jcypher.graph.GrProperty;
import iot.jcypher.graph.GrPropertyContainer;
import iot.jcypher.graph.GrRelation;
import iot.jcypher.graph.Graph;
import iot.jcypher.graph.internal.LockUtil;
import iot.jcypher.query.JcQuery;
import iot.jcypher.query.JcQueryResult;
import iot.jcypher.query.api.APIObject;
import iot.jcypher.query.api.IClause;
import iot.jcypher.query.api.collection.DoConcat;
import iot.jcypher.query.api.collection.EachDoConcat;
import iot.jcypher.query.api.modify.ModifyTerminal;
import iot.jcypher.query.api.pattern.Node;
import iot.jcypher.query.api.returns.RSortable;
import iot.jcypher.query.factories.clause.CASE;
import iot.jcypher.query.factories.clause.DO;
import iot.jcypher.query.factories.clause.ELSE;
import iot.jcypher.query.factories.clause.END;
import iot.jcypher.query.factories.clause.FOR_EACH;
import iot.jcypher.query.factories.clause.MATCH;
import iot.jcypher.query.factories.clause.MERGE;
import iot.jcypher.query.factories.clause.NATIVE;
import iot.jcypher.query.factories.clause.ON_CREATE;
import iot.jcypher.query.factories.clause.OPTIONAL_MATCH;
import iot.jcypher.query.factories.clause.RETURN;
import iot.jcypher.query.factories.clause.SEPARATE;
import iot.jcypher.query.factories.clause.START;
import iot.jcypher.query.factories.clause.WHEN;
import iot.jcypher.query.factories.clause.WHERE;
import iot.jcypher.query.factories.clause.WITH;
import iot.jcypher.query.factories.xpression.C;
import iot.jcypher.query.result.JcError;
import iot.jcypher.query.result.JcResultException;
import iot.jcypher.query.values.JcNode;
import iot.jcypher.query.values.JcNumber;
import iot.jcypher.query.values.JcRelation;
import iot.jcypher.query.values.JcValue;
import iot.jcypher.query.writer.Format;
import iot.jcypher.transaction.ITransaction;
import iot.jcypher.transaction.internal.AbstractTransaction;
import iot.jcypher.util.QueriesPrintObserver;
import iot.jcypher.util.Util;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DomainAccess
implements IDomainAccess,
IIntDomainAccess {
    private DomainAccessHandler domainAccessHandler;
    private InternalDomainAccess internalDomainAccess;
    private GenericDomainAccess genericDomainAccess;
    private static ThreadLocal<QExecution> qExecution = new ThreadLocal();

    public DomainAccess(IDBAccess dbAccess, String domainName, IDomainAccess.DomainLabelUse domainLabelUse) {
        this.domainAccessHandler = new DomainAccessHandler(dbAccess, domainName, domainLabelUse);
    }

    @Override
    public List<JcError> store(Object domainObject) {
        ArrayList<Object> domainObjects = new ArrayList<Object>();
        domainObjects.add(domainObject);
        return this.store(domainObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JcError> store(List<?> domainObjects) {
        List<JcError> ret = null;
        String pLab = this.domainAccessHandler.setDomainLabel();
        ITransaction txToClose = null;
        try {
            if (this.domainAccessHandler.lockingStrategy == Locking.OPTIMISTIC && this.domainAccessHandler.dbAccess.getTX() == null) {
                txToClose = this.beginTX();
            }
            ret = this.domainAccessHandler.store(domainObjects);
        }
        finally {
            CurrentDomain.setDomainLabel(pLab);
            if (txToClose != null) {
                if (ret == null) {
                    ret = new ArrayList<JcError>();
                }
                ret.addAll(txToClose.close());
            }
        }
        return ret;
    }

    @Override
    public <T> T loadById(Class<T> domainObjectClass, int resolutionDepth, long id) {
        long[] ids = new long[]{id};
        List<T> ret = this.loadByIds(domainObjectClass, resolutionDepth, ids);
        return ret.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> loadByIds(Class<T> domainObjectClass, int resolutionDepth, long ... ids) {
        List<T> ret;
        String pLab = this.domainAccessHandler.setDomainLabel();
        try {
            ret = this.domainAccessHandler.loadByIds(domainObjectClass, null, resolutionDepth, ids);
        }
        finally {
            CurrentDomain.setDomainLabel(pLab);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> loadByType(Class<T> domainObjectClass, int resolutionDepth, int offset, int count) {
        List<T> ret;
        String pLab = this.domainAccessHandler.setDomainLabel();
        try {
            ret = this.domainAccessHandler.loadByType(domainObjectClass, resolutionDepth, offset, count);
        }
        finally {
            CurrentDomain.setDomainLabel(pLab);
        }
        return ret;
    }

    @Override
    public SyncInfo getSyncInfo(Object domainObject) {
        ArrayList<Object> domainObjects = new ArrayList<Object>(1);
        domainObjects.add(domainObject);
        List<SyncInfo> ret = this.domainAccessHandler.getSyncInfos(domainObjects);
        return ret.get(0);
    }

    @Override
    public List<SyncInfo> getSyncInfos(List<Object> domainObjects) {
        return this.domainAccessHandler.getSyncInfos(domainObjects);
    }

    @Override
    public long numberOfInstancesOf(Class<?> type) {
        ArrayList types = new ArrayList(1);
        types.add(type);
        List<Long> ret = this.numberOfInstancesOf(types);
        return ret.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> numberOfInstancesOf(List<Class<?>> types) {
        List<Long> ret;
        String pLab = this.domainAccessHandler.setDomainLabel();
        try {
            ret = this.domainAccessHandler.numberOfInstancesOf(types);
        }
        finally {
            CurrentDomain.setDomainLabel(pLab);
        }
        return ret;
    }

    @Override
    public DomainQuery createQuery() {
        DomainQuery ret = new DomainQuery(this);
        QueryRecorder.recordCreateQuery(ret);
        InternalAccess.recordQuery(ret, QueryRecorder.getRecordedQuery(ret));
        return ret;
    }

    @Override
    public List<String> getStoredQueryNames() {
        return this.domainAccessHandler.getStoredQueryNames();
    }

    @Override
    public QueryPersistor createQueryPersistor(DomainQuery query) {
        return InternalAccess.createQueryPersistor(query, this);
    }

    @Override
    public QueryLoader<DomainQuery> createQueryLoader(String queryName) {
        return InternalAccess.createQueryLoader(queryName, this);
    }

    private DomainQuery createRecordedQuery(ReplayedQueryContext rqc, boolean doRecord) {
        DomainQuery ret = new DomainQuery(this);
        QueryRecorder.recordCreateQuery(ret);
        if (doRecord) {
            InternalAccess.recordQuery(ret, QueryRecorder.getRecordedQuery(ret));
        }
        InternalAccess.replayQuery(ret, rqc);
        return ret;
    }

    @Override
    public InternalDomainAccess getInternalDomainAccess() {
        if (this.internalDomainAccess == null) {
            this.internalDomainAccess = new InternalDomainAccess();
        }
        return this.internalDomainAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITransaction beginTX() {
        ITransaction ret = this.domainAccessHandler.dbAccess.beginTX();
        ((AbstractTransaction)ret).setIntDomainAccess(this);
        DomainAccessHandler domainAccessHandler = this.domainAccessHandler;
        synchronized (domainAccessHandler) {
            DomainState ds = this.domainAccessHandler.domainState.createCopy();
            this.domainAccessHandler.transactionState.set(ds);
            this.domainAccessHandler.domainModel.beginTx();
        }
        return ret;
    }

    @Override
    public IDomainAccess setLockingStrategy(Locking locking) {
        this.domainAccessHandler.lockingStrategy = locking;
        return this;
    }

    @Override
    public IGenericDomainAccess getGenericDomainAccess() {
        if (this.genericDomainAccess == null) {
            this.genericDomainAccess = new GenericDomainAccess();
        }
        return this.genericDomainAccess;
    }

    public class InternalDomainAccess {
        private Object syncObject;

        private InternalDomainAccess() {
        }

        public CompoundObjectType getFieldComponentType(String classField) {
            DomainInfo di = DomainAccess.this.domainAccessHandler.loadDomainInfoIfNeeded();
            return di.getFieldComponentType(classField);
        }

        public CompoundObjectType getConcreteFieldType(String classField) {
            DomainInfo di = DomainAccess.this.domainAccessHandler.loadDomainInfoIfNeeded();
            return di.getConcreteFieldType(classField);
        }

        public void addFieldComponentType(String classField, Class<?> type) {
            DomainInfo di = DomainAccess.this.domainAccessHandler.getAvailableDomainInfo();
            di.addFieldComponentType(classField, type);
        }

        public void addConcreteFieldType(String classField, Class<?> type) {
            DomainInfo di = DomainAccess.this.domainAccessHandler.getAvailableDomainInfo();
            di.addConcreteFieldType(classField, type);
        }

        public DomainState getDomainState() {
            return DomainAccess.this.domainAccessHandler.getDomainState();
        }

        public ObjectMapping getObjectMappingFor(Class<?> domainObjectType) {
            DomainAccess.this.domainAccessHandler.updateMappingsIfNeeded();
            return DomainAccess.this.domainAccessHandler.getObjectMappingFor(domainObjectType);
        }

        public List<FieldMapping> getBackwardFieldMappings(String attribName, Class<?> domainObjectType) {
            FieldMapping fm;
            ArrayList<FieldMapping> ret = new ArrayList<FieldMapping>();
            List bwfs = DomainAccess.this.domainAccessHandler.domainInfo.getBackwardFields(domainObjectType);
            if (bwfs != null) {
                for (DomainInfo.BackwardField bwf : bwfs) {
                    if (!bwf.sourceFieldName.equals(attribName) || (fm = this.getObjectMappingFor(bwf.sourceClass).getFieldMappingForField(attribName)) == null) continue;
                    ret.add(fm);
                }
            }
            if ((bwfs = DomainAccess.this.domainAccessHandler.domainInfo.getBackwardComponentFields(domainObjectType)) != null) {
                for (DomainInfo.BackwardField bwf : bwfs) {
                    if (!this.isBackwardViaSurrogate(attribName, bwf) || (fm = this.getObjectMappingFor(bwf.sourceClass).getFieldMappingForField(bwf.sourceFieldName)) == null) continue;
                    ret.add(fm);
                }
            }
            return ret;
        }

        private boolean isBackwardViaSurrogate(String attribName, DomainInfo.BackwardField backwardField) {
            List bwfs = DomainAccess.this.domainAccessHandler.domainInfo.getBackwardFields(backwardField.sourceClass);
            if (bwfs != null) {
                for (DomainInfo.BackwardField bwf : bwfs) {
                    if (!bwf.sourceFieldName.equals(attribName)) continue;
                    return true;
                }
            }
            return false;
        }

        private void addBackwardFieldMappings(String attribName, Class<?> domainObjectType, List<FieldMapping> fms) {
            List bwfs = DomainAccess.this.domainAccessHandler.domainInfo.getBackwardFields(domainObjectType);
            if (bwfs != null) {
                for (DomainInfo.BackwardField bwf : bwfs) {
                    FieldMapping fm;
                    if (!bwf.sourceFieldName.equals(attribName) || (fm = this.getObjectMappingFor(bwf.sourceClass).getFieldMappingForField(attribName)) == null) continue;
                    fms.add(fm);
                }
            }
        }

        public List<Class<?>> getCompoundTypesFor(Class<?> domainObjectType) {
            return DomainAccess.this.domainAccessHandler.getCompoundTypesFor(domainObjectType);
        }

        public String getLabelForClass(Class<?> clazz) {
            DomainAccess.this.domainAccessHandler.updateMappingsIfNeeded();
            return DomainAccess.this.domainAccessHandler.domainInfo.getLabelForClass(clazz);
        }

        public Class<?> getClassForLabel(String label) {
            DomainAccess.this.domainAccessHandler.updateMappingsIfNeeded();
            return DomainAccess.this.domainAccessHandler.domainInfo.getClassForLabel(label);
        }

        public boolean existsLabel(String label) {
            DomainAccess.this.domainAccessHandler.updateMappingsIfNeeded();
            return DomainAccess.this.domainAccessHandler.domainInfo.getClassForLabel(label) != null;
        }

        public List<JcQueryResult> execute(List<JcQuery> queries) {
            return DomainAccess.this.domainAccessHandler.dbAccess.execute(queries);
        }

        public <T> List<T> loadByIds(Class<T> domainObjectClass, Map<Class<?>, List<Long>> type2IdsMap, int resolutionDepth, long ... ids) {
            return DomainAccess.this.domainAccessHandler.loadByIds(domainObjectClass, type2IdsMap, resolutionDepth, ids);
        }

        public void replace_Id2Object(InnerClassSurrogate surrogate, Object domainObject, long nodeId) {
            DomainAccess.this.domainAccessHandler.getDomainState().replace_Id2Object(surrogate, domainObject, nodeId);
        }

        public String setDomainLabel() {
            return DomainAccess.this.domainAccessHandler.setDomainLabel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transactionClosed(boolean failed, boolean domainInfoChanged, boolean noInfoNodeId) {
            DomainAccessHandler domainAccessHandler = DomainAccess.this.domainAccessHandler;
            synchronized (domainAccessHandler) {
                DomainState ds = (DomainState)DomainAccess.this.domainAccessHandler.transactionState.get();
                if (ds != null) {
                    DomainAccess.this.domainAccessHandler.transactionState.remove();
                    if (!failed) {
                        DomainAccess.this.domainAccessHandler.domainState = ds;
                    } else if (domainInfoChanged) {
                        DomainAccess.this.domainAccessHandler.domainInfo.setChanged(true);
                        if (noInfoNodeId) {
                            DomainAccess.this.domainAccessHandler.domainInfo.nodeId = -1L;
                        }
                    }
                }
                DomainAccess.this.domainAccessHandler.domainModel.closeTx(failed);
            }
        }

        public Class<?> getClassForName(String name) throws ClassNotFoundException {
            return DomainAccess.this.domainAccessHandler.domainModel.getClassForName(name);
        }

        public List<DomainObject> getGenericDomainObjects(List<?> objects) {
            return DomainAccess.this.genericDomainAccess.getDomainObjects(objects);
        }

        public DomainObject getGenericDomainObject(Object object) {
            return DomainAccess.this.genericDomainAccess.getDomainObject(object);
        }

        public void setQExecution(QExecution qExecution) {
            if (qExecution == null) {
                qExecution.remove();
            } else {
                qExecution.set(qExecution);
            }
        }

        public QExecution getQExecution() {
            return (QExecution)qExecution.get();
        }

        public void startReResolve() {
            DomainAccess.this.domainAccessHandler.reResolve.set(new ReResolve());
        }

        public void endReResolve() {
            DomainAccess.this.domainAccessHandler.reResolve.remove();
        }

        public void loadDomainInfoIfNeeded() {
            DomainAccess.this.domainAccessHandler.loadDomainInfoIfNeeded();
        }

        public DomainQuery createRecordedQuery(ReplayedQueryContext rqc, boolean doRecord) {
            return DomainAccess.this.createRecordedQuery(rqc, doRecord);
        }

        public GDomainQuery createRecordedGenQuery(ReplayedQueryContext rqc, boolean doRecord) {
            return ((GenericDomainAccess)DomainAccess.this.getGenericDomainAccess()).createRecordedQuery(rqc, doRecord);
        }

        public Object getSyncObject() {
            return this.syncObject;
        }

        public void setSyncObject(Object syncObject) {
            this.syncObject = syncObject;
        }

        public DomainModel getDomainModel() {
            return DomainAccess.this.domainAccessHandler.getDomainModel();
        }

        public String buildDomainLabel(String domainName) {
            String ret = domainName.replace('-', '_').replace(' ', '_');
            return ret;
        }

        public String getDomainLabel() {
            return DomainAccess.this.domainAccessHandler.getDomainLabel();
        }

        public IDBAccess getDBAccess() {
            return ((DomainAccessHandler.DBAccessWrapper)DomainAccess.this.domainAccessHandler.dbAccess).delegate;
        }

        public String domainModelAsString() {
            return DomainAccess.this.domainAccessHandler.getDomainModel().asString();
        }

        public int getDomainInfoVersion() {
            if (DomainAccess.this.domainAccessHandler.domainInfo == null) {
                return -1;
            }
            return DomainAccess.this.domainAccessHandler.domainInfo.version;
        }

        public String nurseryAsString() {
            return DomainAccess.this.domainAccessHandler.domainModel.nurseryAsString();
        }
    }

    public static interface IRecursionExit {
        public void addRecursionExitObject(Object var1, int var2);
    }

    private class ReResolve {
        private Set<Object> reResolved = new HashSet<Object>();

        private ReResolve() {
        }
    }

    private class ExecContext {
        private Exec dInfo;
        private Exec dModel;

        private ExecContext() {
        }
    }

    private static enum Exec {
        INIT_LOADED,
        TRIED_STORE,
        RELOAD_STORE,
        RELOADED_STORE,
        RELOAD,
        RELOADED,
        STORE_VERSIONS;

    }

    private class SurrogateChangeLog {
        private Set<DomainState.IRelation> added = new HashSet<DomainState.IRelation>();
        private Set<DomainState.IRelation> removed = new HashSet<DomainState.IRelation>();

        private SurrogateChangeLog() {
        }

        private void applyChanges() {
            this.removed.removeAll(this.added);
            DomainState ds = DomainAccess.this.domainAccessHandler.getDomainState();
            for (DomainState.IRelation rel : this.added) {
                ds.getSurrogateState().addReference(rel);
            }
            for (DomainState.IRelation rel : this.removed) {
                ds.getSurrogateState().removeReference(rel);
            }
            ds.getSurrogateState().removeUnreferenced();
        }
    }

    private class DomainInfo {
        private boolean changed = false;
        private long nodeId;
        private Map<String, Class<?>> label2ClassMap;
        private Map<Class<?>, String> class2labelMap;
        private Map<String, CompoundObjectType> fieldComponentTypeMap;
        private Map<String, CompoundObjectType> concreteFieldTypeMap;
        private Map<Class<?>, List<BackwardField>> componentTypeBackward;
        private Map<Class<?>, List<BackwardField>> fieldTypeBackward;
        private boolean useDomainLabels;
        private int version;

        private DomainInfo(long nid) {
            this.nodeId = nid;
            this.label2ClassMap = new HashMap();
            this.class2labelMap = new HashMap();
            this.fieldComponentTypeMap = new HashMap<String, CompoundObjectType>();
            this.concreteFieldTypeMap = new HashMap<String, CompoundObjectType>();
            this.componentTypeBackward = new HashMap();
            this.fieldTypeBackward = new HashMap();
            this.useDomainLabels = false;
            this.version = -1;
        }

        private int getVersion() {
            return this.version;
        }

        private void initFrom(GrNode rInfo) {
            Class<?> clazz;
            String[] classes;
            String[] c2l;
            GrProperty prop = rInfo.getProperty("useDomainLabels");
            if (prop != null) {
                this.useDomainLabels = (Boolean)prop.getValue();
            }
            prop = rInfo.getProperty("label2ClassMap");
            List c2l_list = null;
            if (prop != null) {
                c2l_list = (List)prop.getValue();
            }
            prop = rInfo.getProperty("componentTypeMap");
            List compType_list = null;
            if (prop != null) {
                compType_list = (List)prop.getValue();
            }
            prop = rInfo.getProperty("fieldTypeMap");
            List concType_list = null;
            if (prop != null) {
                concType_list = (List)prop.getValue();
            }
            if (c2l_list != null) {
                for (String str : c2l_list) {
                    c2l = str.split("=");
                    try {
                        Class<?> clazz2 = DomainAccess.this.domainAccessHandler.domainModel.getClassForName(c2l[1]);
                        this.addClassLabel(clazz2, c2l[0]);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (compType_list != null) {
                for (String str : compType_list) {
                    c2l = str.split("=");
                    for (String cls : classes = c2l[1].split(", ")) {
                        try {
                            clazz = DomainAccess.this.domainAccessHandler.domainModel.getClassForName(cls);
                            this.addFieldComponentType(c2l[0], clazz);
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            if (concType_list != null) {
                for (String str : concType_list) {
                    c2l = str.split("=");
                    for (String cls : classes = c2l[1].split(", ")) {
                        try {
                            clazz = DomainAccess.this.domainAccessHandler.domainModel.getClassForName(cls);
                            this.addConcreteFieldType(c2l[0], clazz);
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            this.version = (prop = rInfo.getProperty("_i_version")) != null ? ((Number)prop.getValue()).intValue() : 0;
            prop = rInfo.getProperty("_m_version");
            if (prop != null) {
                DomainAccess.this.domainAccessHandler.domainModel.setVersion(((Number)prop.getValue()).intValue());
            } else {
                DomainAccess.this.domainAccessHandler.domainModel.setVersion(0);
            }
            this.setChanged(false);
        }

        private void updateFrom(DomainInfo dInfo) {
            CompoundObjectType cType;
            Iterator<CompoundObjectType> it3;
            for (Map.Entry<Class<?>, String> entry : dInfo.class2labelMap.entrySet()) {
                this.addClassLabel(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, CompoundObjectType> entry : dInfo.fieldComponentTypeMap.entrySet()) {
                it3 = entry.getValue().typeIterator();
                while (it3.hasNext()) {
                    cType = it3.next();
                    this.addFieldComponentType(entry.getKey(), cType.getType());
                }
            }
            for (Map.Entry<String, CompoundObjectType> entry : dInfo.concreteFieldTypeMap.entrySet()) {
                it3 = entry.getValue().typeIterator();
                while (it3.hasNext()) {
                    cType = it3.next();
                    this.addConcreteFieldType(entry.getKey(), cType.getType());
                }
            }
        }

        private boolean isChanged() {
            return this.changed;
        }

        private void setChanged(boolean changed) {
            if (!this.changed && changed) {
                ++this.version;
            }
            this.changed = changed;
        }

        private void graphUdated() {
            ITransaction tx;
            if (this.changed && (tx = DomainAccess.this.domainAccessHandler.dbAccess.getTX()) != null) {
                ((AbstractTransaction)tx).setDomainInfoChanged();
            }
            this.setChanged(false);
        }

        private void addClassLabel(Class<?> clazz, String label) {
            if (!this.class2labelMap.containsKey(clazz)) {
                this.class2labelMap.put(clazz, label);
                this.label2ClassMap.put(label, clazz);
                this.setChanged(true);
            }
        }

        private void addFieldComponentType(String classField, Class<?> clazz) {
            CompoundObjectType cType = this.fieldComponentTypeMap.get(classField);
            if (cType == null) {
                cType = new CompoundObjectType(clazz);
                this.fieldComponentTypeMap.put(classField, cType);
                this.setChanged(true);
            } else {
                boolean added = cType.addType(clazz);
                this.setChanged(this.changed || added);
            }
            BackwardField bwf = new BackwardField(classField);
            List<BackwardField> bwfs = this.componentTypeBackward.get(clazz);
            if (bwfs == null) {
                bwfs = new ArrayList<BackwardField>();
                this.componentTypeBackward.put(clazz, bwfs);
            }
            if (!bwfs.contains(bwf)) {
                bwfs.add(bwf);
            }
        }

        private CompoundObjectType getFieldComponentType(String classField) {
            return this.fieldComponentTypeMap.get(classField);
        }

        private List<BackwardField> getBackwardFields(Class<?> clazz) {
            return this.fieldTypeBackward.get(clazz);
        }

        private List<BackwardField> getBackwardComponentFields(Class<?> clazz) {
            return this.componentTypeBackward.get(clazz);
        }

        private void addConcreteFieldType(String classField, Class<?> clazz) {
            CompoundObjectType cType = this.concreteFieldTypeMap.get(classField);
            if (cType == null) {
                cType = new CompoundObjectType(clazz);
                this.concreteFieldTypeMap.put(classField, cType);
                this.setChanged(true);
            } else {
                boolean added = cType.addType(clazz);
                this.setChanged(this.changed || added);
            }
            BackwardField bwf = new BackwardField(classField);
            List<BackwardField> bwfs = this.fieldTypeBackward.get(clazz);
            if (bwfs == null) {
                bwfs = new ArrayList<BackwardField>();
                this.fieldTypeBackward.put(clazz, bwfs);
            }
            if (!bwfs.contains(bwf)) {
                bwfs.add(bwf);
            }
        }

        private CompoundObjectType getConcreteFieldType(String classField) {
            return this.concreteFieldTypeMap.get(classField);
        }

        private Class<?> getClassForLabel(String label) {
            return this.label2ClassMap.get(label);
        }

        private String getLabelForClass(Class<?> clazz) {
            return this.class2labelMap.get(clazz);
        }

        private Set<Class<?>> getAllStoredDomainClasses() {
            return this.class2labelMap.keySet();
        }

        private List<String> getLabel2ClassNameStringList() {
            ArrayList<String> ret = new ArrayList<String>(this.class2labelMap.size());
            for (Map.Entry<Class<?>, String> entry : this.class2labelMap.entrySet()) {
                StringBuilder sb = new StringBuilder();
                sb.append(entry.getValue());
                sb.append('=');
                sb.append(entry.getKey().getName());
                ret.add(sb.toString());
            }
            Collections.sort(ret);
            return ret;
        }

        private List<String> getFieldComponentTypeStringList() {
            ArrayList<String> ret = new ArrayList<String>(this.fieldComponentTypeMap.size());
            for (Map.Entry<String, CompoundObjectType> entry : this.fieldComponentTypeMap.entrySet()) {
                StringBuilder sb = new StringBuilder();
                sb.append(entry.getKey());
                sb.append('=');
                sb.append(entry.getValue().getTypeListString());
                ret.add(sb.toString());
            }
            Collections.sort(ret);
            return ret;
        }

        private List<String> getConcreteFieldTypeStringList() {
            ArrayList<String> ret = new ArrayList<String>(this.concreteFieldTypeMap.size());
            for (Map.Entry<String, CompoundObjectType> entry : this.concreteFieldTypeMap.entrySet()) {
                StringBuilder sb = new StringBuilder();
                sb.append(entry.getKey());
                sb.append('=');
                sb.append(entry.getValue().getTypeListString());
                ret.add(sb.toString());
            }
            Collections.sort(ret);
            return ret;
        }

        private class BackwardField {
            private Class<?> sourceClass;
            private String sourceFieldName;

            private BackwardField(String classField) {
                String[] clField = classField.split(DomainAccess.this.domainAccessHandler.regexClassfieldSep);
                try {
                    this.sourceClass = DomainAccess.this.domainAccessHandler.domainModel.getClassForName(clField[0]);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                this.sourceFieldName = clField[1];
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.sourceClass == null ? 0 : this.sourceClass.hashCode());
                result = 31 * result + (this.sourceFieldName == null ? 0 : this.sourceFieldName.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                BackwardField other = (BackwardField)obj;
                if (this.sourceClass == null ? other.sourceClass != null : !this.sourceClass.equals(other.sourceClass)) {
                    return false;
                }
                return !(this.sourceFieldName == null ? other.sourceFieldName != null : !this.sourceFieldName.equals(other.sourceFieldName));
            }
        }
    }

    private class QueryRelation2ResultRelation {
        private JcRelation queryRelation;
        private GrRelation resultRelation;
        private int version;

        private QueryRelation2ResultRelation() {
        }
    }

    private class QueryNode2ResultNode {
        private JcNode queryNode;
        private GrNode resultNode;
        private int version;

        private QueryNode2ResultNode() {
        }
    }

    private class DomRelation2ResultRelation {
        private DomainState.IRelation domRelation;
        private GrRelation resultRelation;

        private DomRelation2ResultRelation() {
        }
    }

    private class UpdateContext {
        private List<Object> domainObjects = new ArrayList<Object>();
        private List<DomainState.IRelation> relations = new ArrayList<DomainState.IRelation>();
        private List<DomainState.IRelation> relationsToRemove = new ArrayList<DomainState.IRelation>();
        private List<Object> domainObjectsToRemove = new ArrayList<Object>();
        private Map<Object, GrNode> domObj2Node;
        private List<DomRelation2ResultRelation> domRelation2Relations;
        private Map<Integer, QueryNode2ResultNode> nodeIndexMap;
        private Map<Integer, QueryRelation2ResultRelation> relationIndexMap;
        private boolean lockingErrors;
        private Graph graph;
        private SurrogateChangeLog surrogateChangeLog = new SurrogateChangeLog();

        private UpdateContext() {
        }
    }

    private static class PathElement {
        private Class<?> sourceType;
        private String fieldName;
        private int fieldIndex;
        private String propOrRelName;

        private PathElement(Class<?> sourceType) {
            this.sourceType = sourceType;
        }
    }

    private class ClosureQueryContext {
        private Class<?> domainObjectClass;
        private List<IClause> matchClauses;
        private Node currentMatchClause;
        private List<PathElement> path;
        private List<String> queryEndNodes;
        private List<String> recursionExitNodes;
        private int clauseRepetitionNumber;

        private ClosureQueryContext(Class<?> domainObjectClass) {
            this.domainObjectClass = domainObjectClass;
            this.path = new ArrayList<PathElement>();
            this.queryEndNodes = new ArrayList<String>();
            this.recursionExitNodes = new ArrayList<String>();
        }

        private void addMatchClause(IClause clause) {
            if (this.matchClauses == null) {
                this.matchClauses = new ArrayList<IClause>();
            }
            this.matchClauses.add(clause);
        }

        private PathElement getLastPathElement() {
            if (this.path.size() > 0) {
                return this.path.get(this.path.size() - 1);
            }
            return null;
        }

        private int getRecursionCount() {
            int count = 0;
            int sz = this.path.size();
            if (sz > 0) {
                PathElement peComp = this.path.get(sz - 1);
                for (int i = sz - 2; i >= 0; --i) {
                    PathElement pe = this.path.get(i);
                    if (!pe.sourceType.equals(peComp.sourceType) || !pe.propOrRelName.equals(peComp.propOrRelName)) continue;
                    ++count;
                }
            }
            return count;
        }

        private int getPathSize() {
            return this.path.size();
        }
    }

    private class FillModelContext<T>
    implements IRecursionExit {
        private JcQueryResult qResult;
        private Class<T> domainObjectClass;
        private T domainObject;
        private Object parentObject;
        private List<PathElement> path;
        private List<String> queryEndNodes;
        private List<String> recursionExitNodes;
        private int clauseRepetitionNumber;
        private int maxClauseRepetitionNumber;
        private boolean terminatesClause;
        private List<String> alreadyTested;
        private List<ResolvedDepth> recursionExitObjects;
        private List<IDeferred> deferredList;
        private SurrogateChangeLog surrogateChangeLog;
        private int maxResolutionDepth;
        private int currentDepth;
        private boolean resolveInnerClasses;

        private FillModelContext(Class<T> domainObjectClass, JcQueryResult qResult, List<String> queryEndNds, List<String> recursionExitNds, SurrogateChangeLog surrogateChangeLog, int maxResolutionDepth, int startDepth) {
            this.domainObjectClass = domainObjectClass;
            this.qResult = qResult;
            this.path = new ArrayList<PathElement>();
            this.queryEndNodes = queryEndNds;
            this.recursionExitNodes = recursionExitNds;
            this.clauseRepetitionNumber = 0;
            this.maxClauseRepetitionNumber = 0;
            this.terminatesClause = false;
            this.alreadyTested = new ArrayList<String>();
            this.recursionExitObjects = new ArrayList<ResolvedDepth>();
            this.deferredList = new ArrayList<IDeferred>();
            this.surrogateChangeLog = surrogateChangeLog;
            this.maxResolutionDepth = maxResolutionDepth;
            this.currentDepth = startDepth;
            this.resolveInnerClasses = false;
        }

        private PathElement getLastPathElement() {
            if (this.path.size() > 0) {
                return this.path.get(this.path.size() - 1);
            }
            return null;
        }

        private void setTerminatesClause(String nodeName) {
            this.terminatesClause = this.queryEndNodes.contains(nodeName);
        }

        private void updateMaxClauseRepetitionNumber() {
            if (this.terminatesClause) {
                ++this.maxClauseRepetitionNumber;
                this.terminatesClause = false;
            }
        }

        @Override
        public void addRecursionExitObject(Object obj, int resolvedDepth) {
            if (!this.contains(this.recursionExitObjects, obj)) {
                this.recursionExitObjects.add(new ResolvedDepth(obj, resolvedDepth));
            }
        }

        private void removeRecursionExitObject(Object obj) {
            int idx = -1;
            for (int i = 0; i < this.recursionExitObjects.size(); ++i) {
                if (!this.recursionExitObjects.get(i).domainObject.equals(obj)) continue;
                idx = i;
                break;
            }
            if (idx != -1) {
                this.recursionExitObjects.remove(idx);
            }
        }

        private boolean contains(List<ResolvedDepth> list, Object obj) {
            for (ResolvedDepth rd : list) {
                if (!rd.domainObject.equals(obj)) continue;
                return true;
            }
            return false;
        }

        private class ResolvedDepth {
            private Object domainObject;
            private int resolvedDepth;

            private ResolvedDepth(Object domainObject, int resolvedDepth) {
                this.domainObject = domainObject;
                this.resolvedDepth = resolvedDepth;
            }
        }
    }

    private class ClosureCalculator {
        private ClosureCalculator() {
        }

        private <T> void fillModel(FillModelContext<T> context) {
            Step step = new Step();
            step.fillModel(context, null, null, null, null);
        }

        private void calculateClosureQuery(ClosureQueryContext context) {
            boolean isDone = false;
            Step step = new Step();
            int idx = -1;
            while (!isDone) {
                context.clauseRepetitionNumber = ++idx;
                isDone = step.calculateQuery(null, context);
                if (context.currentMatchClause == null) continue;
                context.addMatchClause(context.currentMatchClause);
                context.currentMatchClause = null;
            }
        }

        private void calculateClosure(List<?> domainObjects, UpdateContext context) {
            for (Object domainObject : domainObjects) {
                this.recursiveCalculateClosure(domainObject, null, context, false);
            }
        }

        private void recursiveCalculateClosure(Object domainObject, FieldMapping parentField, UpdateContext context, boolean prepareToDelete) {
            if (!context.domainObjects.contains(domainObject)) {
                Collection surrColl;
                context.domainObjects.add(domainObject);
                if (domainObject instanceof Collection && (surrColl = (Collection)domainObject).getContent() != null) {
                    surrColl.setCollType(surrColl.getContent().getClass().getName());
                }
                ObjectMapping objectMapping = DomainAccess.this.domainAccessHandler.getObjectMappingFor(domainObject);
                Iterator<FieldMapping> it = objectMapping.fieldMappingsIterator();
                while (it.hasNext()) {
                    FieldMapping fm = DomainAccess.this.domainAccessHandler.modifyFieldMapping(it.next(), parentField);
                    Object obj = fm.getObjectNeedingRelation(domainObject);
                    if (obj != null && !prepareToDelete) {
                        if (obj instanceof java.util.Collection) {
                            java.util.Collection coll = (java.util.Collection)obj;
                            this.handleListArrayInClosureCalc(coll, null, domainObject, context, fm);
                            continue;
                        }
                        if (obj.getClass().isArray()) {
                            Object[] array = (Object[])obj;
                            this.handleListArrayInClosureCalc(null, array, domainObject, context, fm);
                            continue;
                        }
                        if (obj instanceof Map) {
                            Map map = (Map)obj;
                            this.handleMapInClosureCalc(map, domainObject, context, fm);
                            continue;
                        }
                        this.handleObjectInClosureCalc(obj, domainObject, context, fm);
                        continue;
                    }
                    obj = fm.getFieldValue(domainObject);
                    if (obj != null) {
                        MappingUtil.internalDomainAccess.get().addConcreteFieldType(fm.getClassFieldName(), obj.getClass());
                    }
                    if (!fm.needsRelation()) continue;
                    if (fm.getFieldKind() == FieldMapping.FieldKind.COLLECTION || fm.getFieldKind() == FieldMapping.FieldKind.MAP || fm.getFieldKind() == FieldMapping.FieldKind.ARRAY) {
                        List<IMapEntry> mapEntriesToRemove = this.handleKeyedRelationsModification(null, context, new DomainState.SourceFieldKey(domainObject, fm.getFieldName()), false);
                        this.removeObjectsIfNeeded(fm, context, mapEntriesToRemove);
                        continue;
                    }
                    DomainState.IRelation relat = DomainAccess.this.domainAccessHandler.getDomainState().findRelation(domainObject, fm.getPropertyOrRelationName());
                    if (relat == null) continue;
                    context.relationsToRemove.add(relat);
                    if (!(relat.getEnd() instanceof AbstractSurrogate)) continue;
                    context.surrogateChangeLog.removed.add(relat);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private void handleMapInClosureCalc(Map<Object, Object> map, Object domainObject, UpdateContext context, FieldMapping fm) {
            MapTerminator mapTerminator = null;
            String typ = fm.getPropertyOrRelationName();
            HashMap<DomainState.SourceField2TargetKey, List<DomainState.KeyedRelation>> keyedRelations = new HashMap<DomainState.SourceField2TargetKey, List<DomainState.KeyedRelation>>();
            ArrayList<IMapEntry> mapEntries = new ArrayList<IMapEntry>();
            ArrayList<Object> targetObjects = new ArrayList<Object>();
            String classField = fm.getClassFieldName();
            MappingUtil.internalDomainAccess.get().addConcreteFieldType(classField, map.getClass());
            boolean containsMapTerm = false;
            DomainState ds = DomainAccess.this.domainAccessHandler.getDomainState();
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                Object relationKey;
                Object target;
                void var16_16;
                Object val = entry.getValue();
                if (val instanceof Map) {
                    val = ds.getSurrogateState().getCreateSurrogateFor(val, iot.jcypher.domain.mapping.surrogate.Map.class);
                } else if (val instanceof java.util.Collection) {
                    val = ds.getSurrogateState().getCreateSurrogateFor(val, Collection.class);
                } else if (val.getClass().isArray()) {
                    val = ds.getSurrogateState().getCreateSurrogateFor(val, Array.class);
                }
                Object object = entry.getKey();
                if (object instanceof java.util.Collection) {
                    Collection collection = ds.getSurrogateState().getCreateSurrogateFor(object, Collection.class);
                } else if (object.getClass().isArray()) {
                    Array array = ds.getSurrogateState().getCreateSurrogateFor(object, Array.class);
                } else if (object instanceof Map) {
                    iot.jcypher.domain.mapping.surrogate.Map map2 = ds.getSurrogateState().getCreateSurrogateFor(object, iot.jcypher.domain.mapping.surrogate.Map.class);
                }
                boolean keyMapsToProperty = MappingUtil.mapsToProperty(var16_16.getClass());
                boolean valMapsToProperty = MappingUtil.mapsToProperty(val.getClass());
                if (keyMapsToProperty) {
                    if (valMapsToProperty) {
                        if (mapTerminator == null) {
                            mapTerminator = new MapTerminator(domainObject, fm.getFieldName());
                            mapEntries.add(mapTerminator);
                            containsMapTerm = true;
                        }
                        target = mapTerminator;
                    } else {
                        target = val;
                        targetObjects.add(target);
                    }
                    relationKey = entry.getKey();
                } else {
                    MapEntry mapEntry = new MapEntry(var16_16, val);
                    mapEntries.add(mapEntry);
                    target = mapEntry;
                    relationKey = 0;
                }
                DomainState.SourceField2TargetKey s2tKey = new DomainState.SourceField2TargetKey(domainObject, fm.getFieldName(), target);
                ArrayList<DomainState.KeyedRelation> relats = (ArrayList<DomainState.KeyedRelation>)keyedRelations.get(s2tKey);
                if (relats == null) {
                    relats = new ArrayList<DomainState.KeyedRelation>();
                    keyedRelations.put(s2tKey, relats);
                }
                DomainState.KeyedRelation keyedRelation = new DomainState.KeyedRelation(typ, relationKey, domainObject, target);
                if (valMapsToProperty && keyMapsToProperty) {
                    keyedRelation.setValue(val);
                }
                relats.add(keyedRelation);
                if (target instanceof iot.jcypher.domain.mapping.surrogate.Map) {
                    context.surrogateChangeLog.added.add(keyedRelation);
                }
                MappingUtil.internalDomainAccess.get().addFieldComponentType(fm.getClassFieldName(), target.getClass());
            }
            List<IMapEntry> mapEntriesToRemove = this.handleKeyedRelationsModification(keyedRelations, context, new DomainState.SourceFieldKey(domainObject, fm.getFieldName()), containsMapTerm);
            for (IMapEntry iMapEntry : mapEntries) {
                this.recursiveCalculateClosure(iMapEntry, fm, context, false);
            }
            for (Object e : targetObjects) {
                this.recursiveCalculateClosure(e, fm, context, false);
            }
            this.removeObjectsIfNeeded(fm, context, mapEntriesToRemove);
        }

        private void handleListArrayInClosureCalc(java.util.Collection<?> coll, Object[] array, Object domainObject, UpdateContext context, FieldMapping fm) {
            java.util.Collection<?> toIterate;
            String typ = fm.getPropertyOrRelationName();
            HashMap<DomainState.SourceField2TargetKey, List<DomainState.KeyedRelation>> keyedRelations = new HashMap<DomainState.SourceField2TargetKey, List<DomainState.KeyedRelation>>();
            ArrayList<Object> targetObjects = new ArrayList<Object>();
            String classField = fm.getClassFieldName();
            if (coll != null) {
                MappingUtil.internalDomainAccess.get().addConcreteFieldType(classField, coll.getClass());
                toIterate = coll;
            } else {
                MappingUtil.internalDomainAccess.get().addConcreteFieldType(classField, array.getClass());
                toIterate = Arrays.asList(array);
            }
            int idx = 0;
            Iterator<?> it = toIterate.iterator();
            DomainState ds = DomainAccess.this.domainAccessHandler.getDomainState();
            while (it.hasNext()) {
                Object elem = it.next();
                if (elem instanceof java.util.Collection) {
                    elem = ds.getSurrogateState().getCreateSurrogateFor(elem, Collection.class);
                } else if (elem.getClass().isArray()) {
                    elem = ds.getSurrogateState().getCreateSurrogateFor(elem, Array.class);
                } else if (elem instanceof Map) {
                    elem = ds.getSurrogateState().getCreateSurrogateFor(elem, iot.jcypher.domain.mapping.surrogate.Map.class);
                }
                DomainState.SourceField2TargetKey sourceField2TargetKey = new DomainState.SourceField2TargetKey(domainObject, fm.getFieldName(), elem);
                targetObjects.add(elem);
                ArrayList<DomainState.KeyedRelation> relats = (ArrayList<DomainState.KeyedRelation>)keyedRelations.get(sourceField2TargetKey);
                if (relats == null) {
                    relats = new ArrayList<DomainState.KeyedRelation>();
                    keyedRelations.put(sourceField2TargetKey, relats);
                }
                DomainState.KeyedRelation keyedRelation = new DomainState.KeyedRelation(typ, idx, domainObject, elem);
                relats.add(keyedRelation);
                if (elem instanceof Collection) {
                    context.surrogateChangeLog.added.add(keyedRelation);
                }
                MappingUtil.internalDomainAccess.get().addFieldComponentType(classField, elem.getClass());
                ++idx;
            }
            this.handleKeyedRelationsModification(keyedRelations, context, new DomainState.SourceFieldKey(domainObject, fm.getFieldName()), false);
            for (Object e : targetObjects) {
                this.recursiveCalculateClosure(e, fm, context, false);
            }
        }

        private void handleObjectInClosureCalc(Object relatedObject, Object domainObject, UpdateContext context, FieldMapping fm) {
            DomainState.IRelation relat = new DomainState.Relation(fm.getPropertyOrRelationName(), domainObject, relatedObject);
            DomainState ds = DomainAccess.this.domainAccessHandler.getDomainState();
            if (relatedObject instanceof AbstractSurrogate) {
                context.surrogateChangeLog.added.add(relat);
            }
            if (!ds.existsRelation(relat)) {
                context.relations.add(relat);
                relat = ds.findRelation(domainObject, fm.getPropertyOrRelationName());
                if (relat != null) {
                    context.relationsToRemove.add(relat);
                }
            }
            String classField = fm.getClassFieldName();
            MappingUtil.internalDomainAccess.get().addConcreteFieldType(classField, relatedObject.getClass());
            this.recursiveCalculateClosure(relatedObject, fm, context, false);
        }

        private List<IMapEntry> handleKeyedRelationsModification(Map<DomainState.SourceField2TargetKey, List<DomainState.KeyedRelation>> keyedRelations, UpdateContext context, DomainState.SourceFieldKey fieldKey, boolean containsMapTerm) {
            ArrayList<DomainState.KeyedRelation> allExistingRels = new ArrayList<DomainState.KeyedRelation>();
            DomainState ds = DomainAccess.this.domainAccessHandler.getDomainState();
            List<DomainState.KeyedRelation> allExist = ds.getKeyedRelations(fieldKey);
            if (allExist != null) {
                allExistingRels.addAll(allExist);
            }
            if (keyedRelations != null) {
                for (Map.Entry<DomainState.SourceField2TargetKey, List<DomainState.KeyedRelation>> entry : keyedRelations.entrySet()) {
                    List<DomainState.KeyedRelation> existingRels = ds.getKeyedRelations(entry.getKey());
                    RelationsToModify toModify = this.calculateKeyedRelationsToModify(entry.getValue(), existingRels, allExistingRels);
                    context.relations.addAll(toModify.toChange);
                    context.relations.addAll(toModify.toCreate);
                    context.relationsToRemove.addAll(toModify.toRemove);
                }
            }
            context.relationsToRemove.addAll(allExistingRels);
            ArrayList<IMapEntry> mapEntriesToRemove = new ArrayList<IMapEntry>();
            boolean mapTermAdded = false;
            for (DomainState.KeyedRelation kRel : allExistingRels) {
                Object end = kRel.getEnd();
                if (end instanceof MapEntry) {
                    if (mapEntriesToRemove.contains(end)) continue;
                    mapEntriesToRemove.add((MapEntry)end);
                    continue;
                }
                if (end instanceof MapTerminator) {
                    if (containsMapTerm || mapTermAdded) continue;
                    mapTermAdded = true;
                    mapEntriesToRemove.add((MapTerminator)end);
                    continue;
                }
                if (!(end instanceof AbstractSurrogate)) continue;
                context.surrogateChangeLog.removed.add(kRel);
            }
            return mapEntriesToRemove;
        }

        /*
         * WARNING - void declaration
         */
        private RelationsToModify calculateKeyedRelationsToModify(List<DomainState.KeyedRelation> actual, List<DomainState.KeyedRelation> existingInGraph, List<DomainState.KeyedRelation> allExistingInGraph) {
            ArrayList<DomainState.KeyedRelation> act = new ArrayList<DomainState.KeyedRelation>();
            act.addAll(actual);
            ArrayList<DomainState.KeyedRelation> existingOnes = new ArrayList<DomainState.KeyedRelation>();
            if (existingInGraph != null) {
                existingOnes.addAll(existingInGraph);
            }
            ArrayList<DomainState.KeyedRelation> unchanged = new ArrayList<DomainState.KeyedRelation>();
            block0: for (DomainState.KeyedRelation keyedRelation : existingOnes) {
                for (DomainState.KeyedRelation keyedRelation2 : act) {
                    if (!keyedRelation.equals(keyedRelation2)) continue;
                    unchanged.add(keyedRelation2);
                    continue block0;
                }
            }
            for (DomainState.KeyedRelation keyedRelation : unchanged) {
                act.remove(keyedRelation);
                existingOnes.remove(keyedRelation);
                allExistingInGraph.remove(keyedRelation);
            }
            int maxRemoveIndex = -1;
            ArrayList<DomainState.KeyedRelationToChange> arrayList = new ArrayList<DomainState.KeyedRelationToChange>();
            int idx = 0;
            for (DomainState.KeyedRelation iRel : act) {
                if (existingOnes.size() <= idx) break;
                arrayList.add(new DomainState.KeyedRelationToChange((DomainState.KeyedRelation)existingOnes.get(idx), iRel));
                maxRemoveIndex = idx++;
            }
            if (maxRemoveIndex != -1) {
                void var10_18;
                int n = maxRemoveIndex;
                while (var10_18 >= 0) {
                    DomainState.KeyedRelation removed = (DomainState.KeyedRelation)existingOnes.remove((int)var10_18);
                    act.remove((int)var10_18);
                    allExistingInGraph.remove(removed);
                    --var10_18;
                }
            }
            RelationsToModify relationsToModify = new RelationsToModify();
            relationsToModify.toChange = arrayList;
            relationsToModify.toCreate = act;
            relationsToModify.toRemove = existingOnes;
            allExistingInGraph.removeAll(existingOnes);
            return relationsToModify;
        }

        private void removeObjectsIfNeeded(FieldMapping parentField, UpdateContext context, List<IMapEntry> mapEntriesToRemove) {
            if (mapEntriesToRemove.size() > 0) {
                for (IMapEntry obj : mapEntriesToRemove) {
                    this.recursiveCalculateClosure(obj, parentField, context, true);
                    context.domainObjectsToRemove.add(obj);
                }
            }
        }

        private class Step {
            private int subPathIndex = -1;
            private Step next;

            private Step() {
            }

            private <T> void fillModel(FillModelContext<T> context, FieldMapping fm, String nodeName, String relationName, GrNode parentNode) {
                Class pureType;
                CompoundObjectType compoundType;
                DomainState ds = DomainAccess.this.domainAccessHandler.getDomainState();
                boolean resetInnerClassResolution = false;
                int prevClauseRepetitionNumber = ((FillModelContext)context).clauseRepetitionNumber;
                boolean isRoot = fm == null;
                String nnm = nodeName != null ? nodeName : this.buildNodeOrRelationName(((FillModelContext)context).path, "n_", ((FillModelContext)context).clauseRepetitionNumber);
                ((FillModelContext)context).setTerminatesClause(nnm);
                if (isRoot) {
                    compoundType = DomainAccess.this.domainAccessHandler.getCompoundTypeFor(((FillModelContext)context).domainObjectClass);
                } else {
                    String classFieldName = fm.getClassFieldName();
                    compoundType = MappingUtil.internalDomainAccess.get().getConcreteFieldType(classFieldName);
                }
                Class clazz = pureType = fm != null ? fm.getFieldType() : ((FillModelContext)context).domainObjectClass;
                if (compoundType != null) {
                    boolean maxDepthReached;
                    ((FillModelContext)context).path.add(new PathElement(pureType));
                    boolean resolveDeep = true;
                    boolean bl = maxDepthReached = ((FillModelContext)context).maxResolutionDepth >= 0 && ((FillModelContext)context).maxResolutionDepth == ((FillModelContext)context).currentDepth;
                    if (maxDepthReached) {
                        resolveDeep = false;
                    } else if (((FillModelContext)context).recursionExitNodes.contains(nnm)) {
                        resolveDeep = false;
                    }
                    FieldMapping.FieldKind fieldKind = fm != null ? fm.getFieldKind() : FieldMapping.FieldKind.SINGLE;
                    SurrogateContent surrogateContent = this.checkForSurrogates(context, fm, fieldKind, compoundType);
                    java.util.Collection collection = surrogateContent.collection;
                    Map map = surrogateContent.map;
                    List array = surrogateContent.array;
                    if (surrogateContent.compoundType != null) {
                        compoundType = surrogateContent.compoundType;
                    }
                    Iterator relationsIterator = null;
                    ArrayList<GrRelation> usedRelations = null;
                    GrNode actNode = null;
                    GrRelation actRelation = null;
                    boolean loopDone = true;
                    if (isRoot) {
                        JcNode n = new JcNode(nnm);
                        List<GrNode> nodeList = ((FillModelContext)context).qResult.resultOf(n);
                        if (nodeList.size() > 0) {
                            actNode = nodeList.get(0);
                            loopDone = false;
                        }
                    } else {
                        JcRelation r = new JcRelation(relationName);
                        LinkedHashSet<GrRelation> relationList = new LinkedHashSet<GrRelation>(((FillModelContext)context).qResult.resultOf(r));
                        relationsIterator = relationList.iterator();
                        if (relationsIterator.hasNext()) {
                            actRelation = (GrRelation)relationsIterator.next();
                            loopDone = false;
                        }
                        usedRelations = new ArrayList<GrRelation>();
                    }
                    Object domainObject = null;
                    if (!loopDone) {
                        int initialMaxClauseRepetitionNumber = ((FillModelContext)context).maxClauseRepetitionNumber;
                        while (!loopDone) {
                            if (!isRoot) {
                                actNode = null;
                                if (actRelation != null) {
                                    if (actRelation.getStartNode().getId() != parentNode.getId()) {
                                        if (relationsIterator.hasNext()) {
                                            actRelation = (GrRelation)relationsIterator.next();
                                            continue;
                                        }
                                        loopDone = true;
                                        continue;
                                    }
                                    actNode = actRelation.getEndNode();
                                    usedRelations.add(actRelation);
                                }
                            }
                            if (actNode != null) {
                                boolean performMapping = false;
                                boolean mapProperties = true;
                                domainObject = ds.getFrom_Id2ObjectMap(actNode.getId());
                                if (domainObject == null) {
                                    Class clazz2 = DomainAccess.this.domainAccessHandler.findClassToInstantiateFor(actNode);
                                    domainObject = clazz2.equals(MapTerminator.class) ? new MapTerminator(((FillModelContext)context).parentObject, fm.getFieldName()) : DomainAccess.this.domainAccessHandler.createInstance(clazz2);
                                    if (domainObject instanceof Array) {
                                        ((Array)domainObject).setSurrogateState(ds.getSurrogateState());
                                    }
                                    GrProperty prop = actNode.getProperty("_c_version_");
                                    int v = -1;
                                    if (prop != null) {
                                        v = ((Number)prop.getValue()).intValue();
                                    }
                                    ds.add_Id2Object(domainObject, actNode.getId(), v, resolveDeep ? ResolutionDepth.DEEP : ResolutionDepth.SHALLOW);
                                    if (domainObject instanceof InnerClassSurrogate) {
                                        ((InnerClassSurrogate)domainObject).setId2ObjectMapper(DomainAccess.this.getInternalDomainAccess());
                                        ((InnerClassSurrogate)domainObject).setNodeId(actNode.getId());
                                    }
                                    performMapping = true;
                                    if (!resolveDeep && !maxDepthReached) {
                                        if (!(domainObject instanceof InnerClassSurrogate)) {
                                            context.addRecursionExitObject(domainObject, ((FillModelContext)context).currentDepth);
                                        } else if (!((FillModelContext)context).resolveInnerClasses) {
                                            ((InnerClassSurrogate)domainObject).setRecursionExit(context);
                                            ((InnerClassSurrogate)domainObject).setActResolutionDepth(((FillModelContext)context).currentDepth);
                                            ((FillModelContext)context).resolveInnerClasses = true;
                                            resetInnerClassResolution = true;
                                        }
                                    }
                                } else {
                                    boolean forceMapProperties = this.handleReResolve(domainObject, ds);
                                    if (ds.getResolutionDepth(domainObject) != ResolutionDepth.DEEP) {
                                        boolean removed = false;
                                        if (maxDepthReached) {
                                            ((FillModelContext)context).removeRecursionExitObject(domainObject);
                                            removed = true;
                                        }
                                        if (resolveDeep) {
                                            performMapping = true;
                                            mapProperties = forceMapProperties;
                                            ds.getLoadInfoFrom_Object2IdMap(domainObject).setResolutionDepth(ResolutionDepth.DEEP);
                                            if (!removed) {
                                                ((FillModelContext)context).removeRecursionExitObject(domainObject);
                                            }
                                        } else if (!maxDepthReached) {
                                            if (!(domainObject instanceof InnerClassSurrogate)) {
                                                context.addRecursionExitObject(domainObject, ((FillModelContext)context).currentDepth);
                                            } else if (!((FillModelContext)context).resolveInnerClasses) {
                                                ((InnerClassSurrogate)domainObject).setRecursionExit(context);
                                                ((InnerClassSurrogate)domainObject).setActResolutionDepth(((FillModelContext)context).currentDepth);
                                                ((FillModelContext)context).resolveInnerClasses = true;
                                                resetInnerClassResolution = true;
                                            }
                                        }
                                    }
                                }
                                if (fm == null) {
                                    ((FillModelContext)context).domainObject = domainObject;
                                }
                                if (performMapping) {
                                    ((FillModelContext)context).maxClauseRepetitionNumber = initialMaxClauseRepetitionNumber;
                                    ObjectMapping objectMapping = DomainAccess.this.domainAccessHandler.getCompoundObjectMappingFor(compoundType, domainObject);
                                    Iterator<FieldMapping> it = objectMapping.fieldMappingsIterator();
                                    boolean hasComplexFields = false;
                                    int idx = 0;
                                    while (it.hasNext()) {
                                        FieldMapping fMap = DomainAccess.this.domainAccessHandler.modifyFieldMapping(it.next(), fm);
                                        ++idx;
                                        if (!objectMapping.shouldPerformFieldMapping(fMap)) {
                                            if (!fMap.needsRelation() || !resolveDeep) continue;
                                            this.calculateMaxClauseRepetitionNumber(context, fMap, idx);
                                            continue;
                                        }
                                        boolean mapped = false;
                                        if (fMap.needsRelationOrProperty()) {
                                            mapped = fMap.mapPropertyToField(domainObject, actNode);
                                        }
                                        if (fMap.needsRelation()) {
                                            String rnm;
                                            Object prevParent;
                                            hasComplexFields = true;
                                            if (!resolveDeep && !fMap.isInnerClassRefField() || mapped) continue;
                                            PathElement pe = ((FillModelContext)context).getLastPathElement();
                                            pe.fieldIndex = idx;
                                            ((FillModelContext)context).clauseRepetitionNumber = ((FillModelContext)context).maxClauseRepetitionNumber;
                                            pe.fieldName = fMap.getFieldName();
                                            pe.propOrRelName = fMap.getPropertyOrRelationName();
                                            pe.sourceType = fMap.getField().getDeclaringClass();
                                            String ndName = this.buildNodeOrRelationName(((FillModelContext)context).path, "n_", ((FillModelContext)context).clauseRepetitionNumber);
                                            boolean needToRepeat = false;
                                            if (this.isValidNodeName(ndName, context)) {
                                                prevParent = ((FillModelContext)context).parentObject;
                                                ((FillModelContext)context).parentObject = domainObject;
                                                rnm = this.buildNodeOrRelationName(((FillModelContext)context).path, "r_", ((FillModelContext)context).clauseRepetitionNumber);
                                                ((FillModelContext)context).currentDepth++;
                                                this.fillModel(context, fMap, ndName, rnm, actNode);
                                                ((FillModelContext)context).currentDepth--;
                                                ((FillModelContext)context).parentObject = prevParent;
                                            } else {
                                                needToRepeat = true;
                                            }
                                            ((FillModelContext)context).alreadyTested.clear();
                                            while (needToRepeat && this.morePathsToTest(context, fMap, idx)) {
                                                pe = ((FillModelContext)context).getLastPathElement();
                                                pe.fieldIndex = idx;
                                                ((FillModelContext)context).clauseRepetitionNumber = ((FillModelContext)context).maxClauseRepetitionNumber;
                                                pe.fieldName = fMap.getFieldName();
                                                pe.propOrRelName = fMap.getPropertyOrRelationName();
                                                pe.sourceType = fMap.getField().getDeclaringClass();
                                                ndName = this.buildNodeOrRelationName(((FillModelContext)context).path, "n_", ((FillModelContext)context).clauseRepetitionNumber);
                                                needToRepeat = false;
                                                if (this.isValidNodeName(ndName, context)) {
                                                    prevParent = ((FillModelContext)context).parentObject;
                                                    ((FillModelContext)context).parentObject = domainObject;
                                                    rnm = this.buildNodeOrRelationName(((FillModelContext)context).path, "r_", ((FillModelContext)context).clauseRepetitionNumber);
                                                    ((FillModelContext)context).currentDepth++;
                                                    this.fillModel(context, fMap, ndName, rnm, actNode);
                                                    ((FillModelContext)context).currentDepth--;
                                                    ((FillModelContext)context).parentObject = prevParent;
                                                    continue;
                                                }
                                                if (!this.moreClausesAvailable(ndName, context)) continue;
                                                needToRepeat = true;
                                            }
                                            ((FillModelContext)context).updateMaxClauseRepetitionNumber();
                                            continue;
                                        }
                                        if (!mapProperties || mapped) continue;
                                        fMap.mapPropertyToField(domainObject, actNode);
                                    }
                                    boolean removed = false;
                                    if (!hasComplexFields && !resolveDeep) {
                                        ((FillModelContext)context).removeRecursionExitObject(domainObject);
                                        removed = true;
                                        ds.getLoadInfoFrom_Object2IdMap(domainObject).setResolutionDepth(ResolutionDepth.DEEP);
                                    }
                                    if (maxDepthReached && !removed) {
                                        ((FillModelContext)context).removeRecursionExitObject(domainObject);
                                    }
                                }
                            }
                            if (relationsIterator == null) {
                                loopDone = true;
                                continue;
                            }
                            loopDone = !relationsIterator.hasNext();
                            if (loopDone) continue;
                            actRelation = (GrRelation)relationsIterator.next();
                        }
                        if (!isRoot) {
                            if (fieldKind == FieldMapping.FieldKind.COLLECTION) {
                                this.addCollectionRelations(context, usedRelations, collection, null, fm.getPropertyOrRelationName());
                                if (collection.isEmpty()) {
                                    fm.mapPropertyToField(((FillModelContext)context).parentObject, parentNode);
                                    domainObject = null;
                                } else {
                                    domainObject = collection;
                                }
                            } else if (fieldKind == FieldMapping.FieldKind.ARRAY) {
                                if (((FillModelContext)context).parentObject instanceof Array) {
                                    ((Array)((FillModelContext)context).parentObject).setSize(usedRelations.size());
                                }
                                this.addCollectionRelations(context, usedRelations, null, array, fm.getPropertyOrRelationName());
                                if (array.isEmpty()) {
                                    fm.mapPropertyToField(((FillModelContext)context).parentObject, parentNode);
                                    domainObject = null;
                                } else {
                                    domainObject = array;
                                }
                            } else if (fieldKind == FieldMapping.FieldKind.MAP) {
                                this.addMapRelations_FillMap(context, usedRelations, fm.getPropertyOrRelationName(), map);
                                if (map.isEmpty()) {
                                    fm.mapPropertyToField(((FillModelContext)context).parentObject, parentNode);
                                }
                                domainObject = null;
                            } else if (usedRelations.size() > 0) {
                                GrRelation rel = (GrRelation)usedRelations.get(0);
                                DomainState.Relation relat = new DomainState.Relation(fm.getPropertyOrRelationName(), ((FillModelContext)context).parentObject, domainObject);
                                GrProperty prop = rel.getProperty("_c_version_");
                                int v = -1;
                                if (prop != null) {
                                    v = ((Number)prop.getValue()).intValue();
                                }
                                ds.add_Id2Relation(relat, rel.getId(), v);
                                if (domainObject instanceof AbstractSurrogate) {
                                    ((FillModelContext)context).surrogateChangeLog.added.add(relat);
                                }
                            }
                            if (domainObject instanceof AbstractSurrogate) {
                                AbstractDeferred deferred = ((FillModelContext)context).parentObject instanceof MapEntry ? new Surrogate2MapEntry(fm.getFieldName(), (MapEntry)((FillModelContext)context).parentObject, (AbstractSurrogate)domainObject) : new Deferred2DO(fm, (AbstractSurrogate)domainObject, ((FillModelContext)context).parentObject);
                                ((FillModelContext)context).deferredList.add(deferred);
                                domainObject = null;
                            }
                            if (domainObject != null) {
                                fm.setFieldValue(((FillModelContext)context).parentObject, domainObject);
                            }
                        }
                    }
                    ((FillModelContext)context).path.remove(((FillModelContext)context).path.size() - 1);
                }
                ((FillModelContext)context).clauseRepetitionNumber = prevClauseRepetitionNumber;
                if (resetInnerClassResolution) {
                    ((FillModelContext)context).resolveInnerClasses = false;
                }
            }

            private boolean handleReResolve(Object domainObject, DomainState ds) {
                boolean ret = false;
                ReResolve rer = (ReResolve)DomainAccess.this.domainAccessHandler.reResolve.get();
                if (rer != null && !rer.reResolved.contains(domainObject)) {
                    rer.reResolved.add(domainObject);
                    DomainState.LoadInfo li = ds.getLoadInfoFrom_Object2IdMap(domainObject);
                    li.setResolutionDepth(ResolutionDepth.SHALLOW);
                    ret = true;
                }
                return ret;
            }

            private <T> SurrogateContent checkForSurrogates(FillModelContext<T> context, FieldMapping fm, FieldMapping.FieldKind fieldKind, CompoundObjectType compoundType) {
                SurrogateContent ret = new SurrogateContent();
                DomainState ds = DomainAccess.this.domainAccessHandler.getDomainState();
                if (fieldKind == FieldMapping.FieldKind.COLLECTION) {
                    if (((FillModelContext)context).parentObject instanceof Collection) {
                        ret.collection = (java.util.Collection)((Collection)((FillModelContext)context).parentObject).getContent();
                    }
                    String classFieldName = fm.getClassFieldName();
                    ret.compoundType = MappingUtil.internalDomainAccess.get().getFieldComponentType(classFieldName);
                    if (ret.collection == null) {
                        ret.collection = (java.util.Collection)DomainAccess.this.domainAccessHandler.createInstance(MappingUtil.internalDomainAccess.get().getConcreteFieldType(classFieldName).getType());
                        if (((FillModelContext)context).parentObject instanceof Collection) {
                            ((Collection)((FillModelContext)context).parentObject).setContent(ret.collection);
                            ds.getSurrogateState().addOriginal2Surrogate(ret.collection, (Collection)((FillModelContext)context).parentObject);
                        }
                    }
                } else if (fieldKind == FieldMapping.FieldKind.ARRAY) {
                    if (((FillModelContext)context).parentObject instanceof Array) {
                        ret.array = ((Array)((FillModelContext)context).parentObject).getListContent();
                    }
                    String classFieldName = fm.getClassFieldName();
                    ret.compoundType = MappingUtil.internalDomainAccess.get().getFieldComponentType(classFieldName);
                    if (ret.array == null) {
                        ret.array = new ObservableList();
                        if (((FillModelContext)context).parentObject instanceof Array) {
                            ((Array)((FillModelContext)context).parentObject).setListContent(ret.array);
                        }
                    }
                } else if (fieldKind == FieldMapping.FieldKind.MAP) {
                    if (((FillModelContext)context).parentObject instanceof iot.jcypher.domain.mapping.surrogate.Map) {
                        ret.map = (Map)((iot.jcypher.domain.mapping.surrogate.Map)((FillModelContext)context).parentObject).getContent();
                    }
                    String classFieldName = fm.getClassFieldName();
                    ret.compoundType = MappingUtil.internalDomainAccess.get().getFieldComponentType(classFieldName);
                    if (ret.map == null) {
                        ret.map = (Map)DomainAccess.this.domainAccessHandler.createInstance(MappingUtil.internalDomainAccess.get().getConcreteFieldType(classFieldName).getType());
                        if (((FillModelContext)context).parentObject instanceof iot.jcypher.domain.mapping.surrogate.Map) {
                            ((iot.jcypher.domain.mapping.surrogate.Map)((FillModelContext)context).parentObject).setContent(ret.map);
                            ds.getSurrogateState().addOriginal2Surrogate(ret.map, (iot.jcypher.domain.mapping.surrogate.Map)((FillModelContext)context).parentObject);
                        }
                    }
                }
                return ret;
            }

            private <T> void addCollectionRelations(FillModelContext<T> context, List<GrRelation> relList, java.util.Collection coll, List<Object> array, String relType) {
                Iterator<GrRelation> rit = relList.iterator();
                ArrayList<DomainState.KeyedRelation> toResort = new ArrayList<DomainState.KeyedRelation>();
                ListEntriesUpdater listUpdater = null;
                long prevIndex = -1L;
                boolean needResort = false;
                DomainState ds = null;
                while (rit.hasNext()) {
                    if (ds == null) {
                        ds = DomainAccess.this.domainAccessHandler.getDomainState();
                    }
                    GrRelation rel = rit.next();
                    Object domainObject = ds.getFrom_Id2ObjectMap(rel.getEndNode().getId());
                    GrProperty prop = rel.getProperty("key");
                    int idx = (Integer)MappingUtil.convertFromProperty(prop.getValue(), Integer.class);
                    if ((long)idx <= prevIndex) {
                        needResort = true;
                    }
                    prevIndex = idx;
                    DomainState.KeyedRelation irel = new DomainState.KeyedRelation(relType, idx, ((FillModelContext)context).parentObject, domainObject);
                    prop = rel.getProperty("_c_version_");
                    int v = -1;
                    if (prop != null) {
                        v = ((Number)prop.getValue()).intValue();
                    }
                    ds.add_Id2Relation(irel, rel.getId(), v);
                    boolean fillList = true;
                    if (domainObject instanceof AbstractSurrogate) {
                        if (listUpdater == null) {
                            listUpdater = new ListEntriesUpdater(coll != null ? coll : array);
                            ((FillModelContext)context).deferredList.add(listUpdater);
                        }
                        Surrogate2ListEntry deferred = new Surrogate2ListEntry(idx, listUpdater, (AbstractSurrogate)domainObject);
                        ((FillModelContext)context).deferredList.add(deferred);
                        fillList = false;
                    }
                    if (!fillList) continue;
                    toResort.add(irel);
                }
                if (needResort) {
                    Collections.sort(toResort, new Comparator<DomainState.KeyedRelation>(){

                        @Override
                        public int compare(DomainState.KeyedRelation o1, DomainState.KeyedRelation o2) {
                            return Integer.compare((Integer)o1.getKey(), (Integer)o2.getKey());
                        }
                    });
                }
                for (DomainState.KeyedRelation irel : toResort) {
                    if (coll != null) {
                        if (coll.contains(irel.getEnd())) continue;
                        coll.add(irel.getEnd());
                        continue;
                    }
                    if (array.contains(irel.getEnd())) continue;
                    array.add(irel.getEnd());
                }
            }

            private <T> void addMapRelations_FillMap(FillModelContext<T> context, List<GrRelation> relList, String relType, Map<Object, Object> map) {
                try {
                    Object start = ((FillModelContext)context).parentObject;
                    HashMap<Long, Boolean> handledRelations = new HashMap<Long, Boolean>();
                    Iterator<GrRelation> rit = relList.iterator();
                    DomainState ds = null;
                    while (rit.hasNext()) {
                        GrRelation rel;
                        long relId;
                        if (ds == null) {
                            ds = DomainAccess.this.domainAccessHandler.getDomainState();
                        }
                        if (handledRelations.get(relId = (rel = rit.next()).getId()) != null) continue;
                        handledRelations.put(relId, Boolean.TRUE);
                        Object end = ds.getFrom_Id2ObjectMap(rel.getEndNode().getId());
                        GrProperty prop = rel.getProperty("key");
                        GrProperty typeProp = rel.getProperty("keyType");
                        Object key = MappingUtil.convertFromProperty(prop.getValue(), DomainAccess.this.domainAccessHandler.domainModel.getClassForName(typeProp.getValue().toString()));
                        DomainState.KeyedRelation irel = new DomainState.KeyedRelation(relType, key, start, end);
                        Object val = null;
                        prop = rel.getProperty("value");
                        if (prop != null) {
                            typeProp = rel.getProperty("valueType");
                            val = MappingUtil.convertFromProperty(prop.getValue(), DomainAccess.this.domainAccessHandler.domainModel.getClassForName(typeProp.getValue().toString()));
                            irel.setValue(val);
                        }
                        prop = rel.getProperty("_c_version_");
                        int v = -1;
                        if (prop != null) {
                            v = ((Number)prop.getValue()).intValue();
                        }
                        ds.add_Id2Relation(irel, relId, v);
                        boolean fillMap = true;
                        if (end instanceof MapEntry) {
                            MapEntryUpdater deferred = new MapEntryUpdater((MapEntry)end, map);
                            ((FillModelContext)context).deferredList.add(deferred);
                            fillMap = false;
                        } else if (!(end instanceof MapTerminator) && (val = end) instanceof AbstractSurrogate) {
                            MapEntry me = new MapEntry(key, null);
                            AbstractDeferred deferred = new MapEntryUpdater(me, map);
                            ((FillModelContext)context).deferredList.add(deferred);
                            deferred = new Surrogate2MapEntry("value", me, (AbstractSurrogate)val);
                            ((FillModelContext)context).deferredList.add(deferred);
                            fillMap = false;
                        }
                        if (!fillMap) continue;
                        map.put(key, val);
                    }
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }

            private <T> boolean isValidNodeName(String nodeName, FillModelContext<T> context) {
                for (String endNode : ((FillModelContext)context).queryEndNodes) {
                    if (endNode.indexOf(nodeName) != 0) continue;
                    return true;
                }
                return false;
            }

            private <T> boolean moreClausesAvailable(String nodeName, FillModelContext<T> context) {
                int idx2;
                int idx1 = nodeName.indexOf(95) + 1;
                String clauseNum = nodeName.substring(idx1, idx2 = nodeName.indexOf(95, idx1));
                return Integer.parseInt(clauseNum) < ((FillModelContext)context).queryEndNodes.size() - 1;
            }

            private <T> void calculateMaxClauseRepetitionNumber(FillModelContext<T> context, FieldMapping fMap, int fieldIndex) {
                String toCompare = this.pathToTest(context, fMap, fieldIndex);
                int increment = 0;
                for (String nodeName : ((FillModelContext)context).queryEndNodes) {
                    int idx;
                    String other;
                    if (((FillModelContext)context).alreadyTested.contains(nodeName) || (other = nodeName.substring((idx = nodeName.indexOf(95, nodeName.indexOf(95) + 1)) + 1)).indexOf(toCompare) != 0) continue;
                    ++increment;
                }
                ((FillModelContext)context).maxClauseRepetitionNumber = ((FillModelContext)context).maxClauseRepetitionNumber + increment;
            }

            private <T> boolean morePathsToTest(FillModelContext<T> context, FieldMapping fMap, int fieldIndex) {
                String toCompare = this.pathToTest(context, fMap, fieldIndex);
                boolean goOn = false;
                for (String nodeName : ((FillModelContext)context).queryEndNodes) {
                    int idx;
                    String other;
                    if (!goOn && !((FillModelContext)context).alreadyTested.contains(nodeName)) {
                        goOn = true;
                    }
                    if (!goOn || (other = nodeName.substring((idx = nodeName.indexOf(95, nodeName.indexOf(95) + 1)) + 1)).indexOf(toCompare) != 0) continue;
                    ((FillModelContext)context).alreadyTested.add(nodeName);
                    ((FillModelContext)context).maxClauseRepetitionNumber++;
                    return true;
                }
                return false;
            }

            private <T> String pathToTest(FillModelContext<T> context, FieldMapping fMap, int fieldIndex) {
                PathElement pe = ((FillModelContext)context).getLastPathElement();
                pe.fieldIndex = fieldIndex;
                ((FillModelContext)context).clauseRepetitionNumber = ((FillModelContext)context).maxClauseRepetitionNumber;
                pe.fieldName = fMap.getFieldName();
                pe.propOrRelName = fMap.getPropertyOrRelationName();
                pe.sourceType = fMap.getField().getDeclaringClass();
                String nnm = this.buildNodeOrRelationName(((FillModelContext)context).path, "n_", ((FillModelContext)context).clauseRepetitionNumber);
                int idx = nnm.indexOf(95, nnm.indexOf(95) + 1);
                return nnm.substring(idx + 1);
            }

            private boolean calculateQuery(FieldMapping fm, ClosureQueryContext context) {
                Class pureType;
                CompoundObjectType compoundType;
                boolean ret = true;
                if (fm == null) {
                    Class domClass = context.domainObjectClass;
                    compoundType = DomainAccess.this.domainAccessHandler.getCompoundTypeFor(domClass);
                } else {
                    String classFieldName = fm.getClassFieldName();
                    compoundType = MappingUtil.internalDomainAccess.get().getConcreteFieldType(classFieldName);
                }
                Class clazz = pureType = fm != null ? fm.getFieldType() : context.domainObjectClass;
                if (fm != null) {
                    this.addToQuery(fm, context);
                }
                boolean resolveDeep = true;
                boolean walkedToIndex = this.subPathIndex == -1;
                boolean subPathWalked = false;
                if (walkedToIndex) {
                    if (context.getPathSize() >= DomainAccess.this.domainAccessHandler.maxPathSize) {
                        resolveDeep = false;
                    }
                    if (fm != null) {
                        subPathWalked = true;
                    }
                }
                context.path.add(new PathElement(pureType));
                boolean isCollection = java.util.Collection.class.isAssignableFrom(pureType);
                boolean isMap = Map.class.isAssignableFrom(pureType);
                if (isCollection || isMap) {
                    compoundType = MappingUtil.internalDomainAccess.get().getFieldComponentType(fm.getClassFieldName());
                }
                boolean terminatesClause = true;
                if (compoundType != null) {
                    ObjectMapping objectMapping = DomainAccess.this.domainAccessHandler.getCompoundObjectMappingFor(compoundType, null);
                    Iterator<FieldMapping> it = objectMapping.fieldMappingsIterator();
                    int idx = 0;
                    while (it.hasNext()) {
                        FieldMapping fMap = DomainAccess.this.domainAccessHandler.modifyFieldMapping(it.next(), fm);
                        ++idx;
                        if (!walkedToIndex) {
                            if (idx != this.subPathIndex) continue;
                            walkedToIndex = true;
                        }
                        if (!fMap.needsRelation() || !resolveDeep && !fMap.isInnerClassRefField()) continue;
                        boolean needToComeBack = false;
                        if (!subPathWalked) {
                            terminatesClause = false;
                            if (this.next == null) {
                                this.next = new Step();
                            }
                            PathElement pe = context.getLastPathElement();
                            pe.fieldIndex = idx;
                            pe.fieldName = fMap.getFieldName();
                            pe.propOrRelName = fMap.getPropertyOrRelationName();
                            pe.sourceType = fMap.getField().getDeclaringClass();
                            boolean isDone = this.next.calculateQuery(fMap, context);
                            if (!isDone) {
                                needToComeBack = true;
                            } else {
                                this.next = null;
                                subPathWalked = true;
                            }
                        } else {
                            needToComeBack = true;
                        }
                        if (!needToComeBack) continue;
                        this.subPathIndex = idx;
                        ret = false;
                        break;
                    }
                }
                context.path.remove(context.path.size() - 1);
                if (!resolveDeep || terminatesClause) {
                    String nm = this.buildNodeOrRelationName(context.path, "n_", context.clauseRepetitionNumber);
                    context.queryEndNodes.add(nm);
                    if (!resolveDeep) {
                        context.recursionExitNodes.add(nm);
                    }
                }
                return ret;
            }

            private void addToQuery(FieldMapping fm, ClosureQueryContext context) {
                JcNode n;
                if (context.currentMatchClause == null) {
                    n = new JcNode("n_".concat(String.valueOf(0)));
                    context.currentMatchClause = OPTIONAL_MATCH.node(n);
                    if (context.matchClauses != null && context.matchClauses.size() > 0) {
                        context.matchClauses.add(SEPARATE.nextClause());
                    }
                }
                n = new JcNode(this.buildNodeOrRelationName(context.path, "n_", context.clauseRepetitionNumber));
                JcRelation r = new JcRelation(this.buildNodeOrRelationName(context.path, "r_", context.clauseRepetitionNumber));
                context.currentMatchClause.relation(r).out().type(fm.getPropertyOrRelationName()).node(n);
            }

            private String buildNodeOrRelationName(List<PathElement> path, String prefix, int clauseNumber) {
                StringBuilder sb = new StringBuilder();
                sb.append(prefix);
                if (path.size() > 0) {
                    sb.append(clauseNumber);
                    sb.append('_');
                    for (int i = 0; i < path.size(); ++i) {
                        if (i > 0) {
                            sb.append('_');
                        }
                        sb.append(path.get(i).fieldIndex);
                    }
                } else {
                    sb.append(0);
                }
                return sb.toString();
            }

            private class SurrogateContent {
                private java.util.Collection<Object> collection;
                private Map<Object, Object> map;
                private List<Object> array;
                private CompoundObjectType compoundType;

                private SurrogateContent() {
                }
            }
        }

        private class RelationsToModify {
            private List<DomainState.KeyedRelation> toCreate;
            private List<DomainState.KeyedRelation> toRemove;
            private List<DomainState.KeyedRelationToChange> toChange;

            private RelationsToModify() {
            }
        }
    }

    public class DomainAccessHandler {
        private String regexClassfieldSep = "\\".concat("|");
        private static final String NodePrefix = "n_";
        private static final String RelationPrefix = "r_";
        private static final String DomainInfoNodeLabel = "DomainInfo";
        private static final String DomainInfoNameProperty = "name";
        private static final String DomainInfoLabel2ClassProperty = "label2ClassMap";
        private static final String DomainInfoFieldComponentTypeProperty = "componentTypeMap";
        private static final String DomainInfoConcreteFieldTypeProperty = "fieldTypeMap";
        private static final String DomainInfoUseDomainLabelProperty = "useDomainLabels";
        private static final String DomainInfoVersionProperty = "_i_version";
        private static final String DomainInfoModelVersionProperty = "_m_version";
        private static final String KeyProperty = "key";
        private static final String ValueProperty = "value";
        private static final String KeyTypeProperty = "keyType";
        private static final String ValueTypeProperty = "valueType";
        private String domainName;
        private String domainLabel;
        private int maxRecursionCount = 1;
        private int maxPathSize = 2;
        private IDBAccess dbAccess;
        private DomainState domainState;
        private ThreadLocal<DomainState> transactionState;
        private ThreadLocal<ReResolve> reResolve;
        private Locking lockingStrategy;
        private Map<Class<?>, ObjectMapping> mappings;
        private Map<Class<?>, CompoundObjectType> type2CompoundTypeMap;
        private DomainInfo domainInfo;
        private DomainModel domainModel;
        private IDomainAccess.DomainLabelUse domainLabelUse;

        private DomainAccessHandler(IDBAccess dbAccess, String domainName, IDomainAccess.DomainLabelUse du) {
            this.domainLabelUse = du;
            this.domainName = domainName;
            this.dbAccess = new DBAccessWrapper(dbAccess);
            this.domainState = new DomainState();
            this.mappings = new HashMap();
            this.type2CompoundTypeMap = new HashMap();
            this.transactionState = new ThreadLocal();
            this.reResolve = new ThreadLocal();
            this.lockingStrategy = Locking.NONE;
            this.domainModel = iot.jcypher.domain.genericmodel.internal.InternalAccess.createDomainModel(this.domainName, this.getDomainLabel(), DomainAccess.this);
        }

        <T> List<T> loadByIds(Class<T> domainObjectClass, Map<Class<?>, List<Long>> type2IdsMap, int resolutionDepth, long ... ids) {
            ArrayList<Object> resultList = new ArrayList<Object>(ids.length);
            if (ids.length == 0) {
                return resultList;
            }
            InternalDomainAccess internalAccess = null;
            try {
                internalAccess = MappingUtil.internalDomainAccess.get();
                MappingUtil.internalDomainAccess.set(DomainAccess.this.getInternalDomainAccess());
                this.updateMappingsIfNeeded();
                Map<Class<?>, List<Long>> typeMap = type2IdsMap;
                if (typeMap == null) {
                    typeMap = this.queryConcreteTypes(ids);
                }
                for (Map.Entry<Class<?>, List<Long>> entry : typeMap.entrySet()) {
                    if (domainObjectClass != null && !domainObjectClass.isAssignableFrom(entry.getKey())) {
                        throw new RuntimeException("concrete type must be the same or a subtype of: " + domainObjectClass.getName());
                    }
                    ClosureQueryContext context = new ClosureQueryContext(entry.getKey());
                    new ClosureCalculator().calculateClosureQuery(context);
                    boolean repeat = context.matchClauses != null && context.matchClauses.size() > 0;
                    ArrayList<IdAndDepth> idList = new ArrayList<IdAndDepth>(entry.getValue().size());
                    for (Long id : entry.getValue()) {
                        idList.add(new IdAndDepth(id, 0));
                    }
                    if (repeat) {
                        this.loadByIdsWithMatches(entry.getKey(), context, null, null, idList, resolutionDepth);
                        continue;
                    }
                    this.loadByIdsSimple(entry.getKey(), idList);
                }
            }
            catch (Throwable e) {
                if (!(e instanceof RuntimeException)) {
                    throw new RuntimeException(e);
                }
                throw e;
            }
            finally {
                if (internalAccess != null) {
                    MappingUtil.internalDomainAccess.set(internalAccess);
                } else {
                    MappingUtil.internalDomainAccess.remove();
                }
            }
            for (long id : ids) {
                resultList.add(this.getDomainState().getFrom_Id2ObjectMap(id));
            }
            return resultList;
        }

        void loadDeep(List<FillModelContext.ResolvedDepth> objectsNotResolvedDeep, Set<IDeferred> deferredSet, SurrogateChangeLog surrogateChangeLog, int resolutionDepth) {
            HashMap byType = new HashMap();
            for (FillModelContext.ResolvedDepth notResolvedDeep : objectsNotResolvedDeep) {
                ArrayList<FillModelContext.ResolvedDepth> list = (ArrayList<FillModelContext.ResolvedDepth>)byType.get(notResolvedDeep.domainObject.getClass());
                if (list == null) {
                    list = new ArrayList<FillModelContext.ResolvedDepth>();
                    byType.put(notResolvedDeep.domainObject.getClass(), list);
                }
                list.add(notResolvedDeep);
            }
            for (Map.Entry entry : byType.entrySet()) {
                this.loadDeepByType((Class)entry.getKey(), (List)entry.getValue(), deferredSet, surrogateChangeLog, resolutionDepth);
            }
        }

        <T> List<T> loadByType(Class<T> domainObjectClass, int resolutionDepth, int offset, int count) {
            List<Object> lens;
            List<Object> offsets;
            ArrayList<JcQuery> queries;
            if (offset < 0) {
                throw new RuntimeException("offset must be >= 0");
            }
            List<Class<?>> typeList = this.getCompoundTypesFor(domainObjectClass);
            int numTypes = typeList.size();
            JcNode n = new JcNode("n");
            JcNumber num = new JcNumber("num");
            if (numTypes > 1 && (offset > 0 || count >= 0)) {
                queries = new ArrayList<JcQuery>(numTypes);
                for (Class<?> rawType : typeList) {
                    String string = this.domainInfo.getLabelForClass(rawType);
                    if (string == null) continue;
                    JcQuery query = new JcQuery();
                    query.setClauses(new IClause[]{MATCH.node(n).label(string), RETURN.count().value(n).AS(num)});
                    queries.add(query);
                }
                List<JcQueryResult> results = this.dbAccess.execute(queries);
                List<JcError> errors = Util.collectErrors(results);
                if (errors.size() > 0) {
                    throw new JcResultException(errors);
                }
                ArrayList<Integer> arrayList = new ArrayList<Integer>(results.size());
                for (JcQueryResult result : results) {
                    BigDecimal res = result.resultOf(num).get(0);
                    arrayList.add(res.intValue());
                }
                SkipLimitCalc.SkipsLimits slc = SkipLimitCalc.calcSkipsLimits(arrayList, offset, count);
                offsets = slc.getOffsets();
                lens = slc.getLengths();
            } else {
                offsets = new ArrayList<Integer>(numTypes);
                lens = new ArrayList<Integer>(numTypes);
                if (numTypes == 1) {
                    offsets.add(offset);
                    lens.add(count);
                } else {
                    for (int i = 0; i < numTypes; ++i) {
                        offsets.add(0);
                        lens.add(-1);
                    }
                }
            }
            queries = new ArrayList(numTypes);
            int idx = 0;
            for (Class clazz : typeList) {
                String nodeLabel = this.domainInfo.getLabelForClass(clazz);
                if (nodeLabel == null) continue;
                if ((Integer)lens.get(idx) != 0) {
                    JcQuery query = new JcQuery();
                    query.setClauses(new IClause[]{MATCH.node(n).label(nodeLabel), RETURN.value(n.id()).AS(num)});
                    queries.add(query);
                }
                ++idx;
            }
            ArrayList<Long> ids = new ArrayList<Long>();
            if (queries.size() > 0) {
                Util.printQueries(queries, QueriesPrintObserver.QueryToObserve.LOAD_BY_TYPE_QUERY, Format.PRETTY_1);
                List<JcQueryResult> list = this.dbAccess.execute(queries);
                List<JcError> errors = Util.collectErrors(list);
                if (errors.size() > 0) {
                    throw new JcResultException(errors);
                }
                idx = 0;
                int resIdx = 0;
                for (Class<?> rawType : typeList) {
                    String nodeLabel = this.domainInfo.getLabelForClass(rawType);
                    if (nodeLabel == null) continue;
                    if ((Integer)lens.get(idx) != 0) {
                        JcQueryResult result = list.get(resIdx);
                        List<BigDecimal> rList = result.resultOf(num);
                        int sz = (Integer)lens.get(idx) + (Integer)offsets.get(idx);
                        sz = sz == -1 ? rList.size() : (sz > rList.size() ? rList.size() : sz);
                        for (int i = ((Integer)offsets.get(idx)).intValue(); i < sz; ++i) {
                            ids.add(rList.get(i).longValue());
                        }
                        ++resIdx;
                    }
                    ++idx;
                }
            }
            long[] lArray = new long[ids.size()];
            for (int i = 0; i < ids.size(); ++i) {
                lArray[i] = (Long)ids.get(i);
            }
            return this.loadByIds(domainObjectClass, null, resolutionDepth, lArray);
        }

        <T> void loadDeepByType(Class<T> domainObjectClass, List<FillModelContext.ResolvedDepth> objectsNotResolvedDeep, Set<IDeferred> deferredSet, SurrogateChangeLog surrogateChangeLog, int resolutionDepth) {
            InternalDomainAccess internalAccess = null;
            ClosureQueryContext context = new ClosureQueryContext(domainObjectClass);
            ArrayList<IdAndDepth> idList = new ArrayList<IdAndDepth>(objectsNotResolvedDeep.size());
            for (int i = 0; i < objectsNotResolvedDeep.size(); ++i) {
                FillModelContext.ResolvedDepth resDepth = objectsNotResolvedDeep.get(i);
                idList.add(new IdAndDepth(this.getDomainState().getLoadInfoFrom_Object2IdMap(resDepth.domainObject).getId(), resDepth.resolvedDepth));
            }
            try {
                boolean repeat;
                internalAccess = MappingUtil.internalDomainAccess.get();
                MappingUtil.internalDomainAccess.set(DomainAccess.this.getInternalDomainAccess());
                this.updateMappingsIfNeeded();
                new ClosureCalculator().calculateClosureQuery(context);
                boolean bl = repeat = context.matchClauses != null && context.matchClauses.size() > 0;
                if (repeat) {
                    this.loadByIdsWithMatches(domainObjectClass, context, deferredSet, surrogateChangeLog, idList, resolutionDepth);
                } else {
                    this.loadByIdsSimple(domainObjectClass, idList);
                }
            }
            catch (Throwable e) {
                if (!(e instanceof RuntimeException)) {
                    throw new RuntimeException(e);
                }
                throw e;
            }
            finally {
                if (internalAccess != null) {
                    MappingUtil.internalDomainAccess.set(internalAccess);
                } else {
                    MappingUtil.internalDomainAccess.remove();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<JcError> store(List<?> domainObjects) {
            List<Object> errors;
            UpdateContext context;
            InternalDomainAccess internalAccess = null;
            try {
                internalAccess = MappingUtil.internalDomainAccess.get();
                MappingUtil.internalDomainAccess.set(DomainAccess.this.getInternalDomainAccess());
                context = this.updateLocalGraph(domainObjects);
            }
            finally {
                if (internalAccess != null) {
                    MappingUtil.internalDomainAccess.set(internalAccess);
                } else {
                    MappingUtil.internalDomainAccess.remove();
                }
            }
            if (context.lockingErrors) {
                errors = new ArrayList();
                JcError error = new JcError("JCypher.Locking", "Optimistic locking failed (an element was deleted by another client)", null);
                errors.add(error);
                ITransaction tx = this.dbAccess.getTX();
                if (tx != null) {
                    tx.failure();
                }
            } else {
                HashMap<Long, Integer> elementVersionsMap = null;
                if (this.lockingStrategy == Locking.OPTIMISTIC) {
                    if (context.nodeIndexMap != null || context.relationIndexMap != null) {
                        elementVersionsMap = new HashMap<Long, Integer>();
                    }
                    if (context.nodeIndexMap != null) {
                        for (QueryNode2ResultNode n2n : context.nodeIndexMap.values()) {
                            elementVersionsMap.put(n2n.resultNode.getId(), n2n.version);
                        }
                    }
                    if (context.relationIndexMap != null) {
                        for (Object r2r : context.relationIndexMap.values()) {
                            elementVersionsMap.put(((QueryRelation2ResultRelation)r2r).resultRelation.getId(), ((QueryRelation2ResultRelation)r2r).version);
                        }
                    }
                }
                errors = GrAccess.store(context.graph, elementVersionsMap);
                DomainState ds = this.getDomainState();
                if (errors.isEmpty()) {
                    for (DomainState.IRelation relat : context.relationsToRemove) {
                        ds.removeRelation(relat);
                    }
                    for (Map.Entry entry : context.domObj2Node.entrySet()) {
                        GrNode nd = (GrNode)entry.getValue();
                        GrProperty prop = nd.getProperty("_c_version_");
                        int v = -1;
                        if (prop != null) {
                            v = ((Number)prop.getValue()).intValue();
                        }
                        ds.add_Id2Object(entry.getKey(), nd.getId(), v, ResolutionDepth.DEEP);
                    }
                    for (DomRelation2ResultRelation d2r : context.domRelation2Relations) {
                        GrRelation rel = d2r.resultRelation;
                        GrProperty prop = rel.getProperty("_c_version_");
                        int v = -1;
                        if (prop != null) {
                            v = ((Number)prop.getValue()).intValue();
                        }
                        ds.add_Id2Relation(d2r.domRelation, rel.getId(), v);
                    }
                }
            }
            return errors;
        }

        List<SyncInfo> getSyncInfos(List<Object> domainObjects) {
            ArrayList<SyncInfo> ret = new ArrayList<SyncInfo>(domainObjects.size());
            for (Object obj : domainObjects) {
                DomainState.LoadInfo li = this.getDomainState().getLoadInfoFrom_Object2IdMap(obj);
                if (li != null) {
                    ret.add(new SyncInfo(li.getId(), li.getResolutionDepth()));
                    continue;
                }
                ret.add(new SyncInfo(-1L, null));
            }
            return ret;
        }

        List<Long> numberOfInstancesOf(List<Class<?>> types) {
            this.updateMappingsIfNeeded();
            ArrayList<Long> resultList = new ArrayList<Long>();
            ArrayList<Integer> cumulationList = new ArrayList<Integer>(types.size());
            ArrayList<JcQuery> queries = new ArrayList<JcQuery>();
            JcNode n = new JcNode("n");
            JcNumber num = new JcNumber("num");
            for (Class<?> type : types) {
                Iterator<CompoundObjectType> it = this.getCompoundTypeFor(type).typeIterator();
                int cumulation = 0;
                while (it.hasNext()) {
                    ++cumulation;
                    Class<?> rawType = it.next().getType();
                    String nodeLabel = this.domainInfo.getLabelForClass(rawType);
                    JcQuery query = new JcQuery();
                    query.setClauses(new IClause[]{MATCH.node(n).label(nodeLabel), RETURN.count().value(n).AS(num)});
                    queries.add(query);
                }
                cumulationList.add(cumulation);
            }
            List<JcQueryResult> results = this.dbAccess.execute(queries);
            List<JcError> errors = Util.collectErrors(results);
            if (errors.size() > 0) {
                throw new JcResultException(errors);
            }
            int idx = 0;
            for (int i = 0; i < cumulationList.size(); ++i) {
                long count = 0L;
                for (int cumulation = ((Integer)cumulationList.get(i)).intValue(); cumulation > 0; --cumulation) {
                    JcQueryResult result = results.get(idx);
                    BigDecimal res = result.resultOf(num).get(0);
                    count += res.longValue();
                    ++idx;
                }
                resultList.add(count);
            }
            return resultList;
        }

        List<String> getStoredQueryNames() {
            ArrayList<String> ret = new ArrayList<String>();
            IDBAccess dba = ((DBAccessWrapper)this.dbAccess).delegate;
            String qLabel = this.getDomainLabel().concat("_query");
            JcNode n = new JcNode("n");
            IClause[] clauses = new IClause[]{MATCH.node(n).label(qLabel), RETURN.value(n)};
            JcQuery q = new JcQuery();
            q.setClauses(clauses);
            JcQueryResult result = dba.execute(q);
            if (result.hasErrors()) {
                StringBuilder sb = new StringBuilder();
                Util.appendErrorList(Util.collectErrors(result), sb);
                throw new RuntimeException(sb.toString());
            }
            List<GrNode> lgn = result.resultOf(n);
            for (GrNode rn : lgn) {
                ret.add(rn.getProperty(DomainInfoNameProperty).getValue().toString());
            }
            return ret;
        }

        private synchronized DomainState getDomainState() {
            DomainState ds = this.transactionState.get();
            if (ds == null) {
                ds = this.domainState;
            }
            return ds;
        }

        private DomainModel getDomainModel() {
            this.loadDomainInfoIfNeeded();
            return this.domainModel;
        }

        private Map<Class<?>, List<Long>> queryConcreteTypes(long[] ids) {
            JcQuery query = new JcQuery();
            JcNode n = new JcNode("n");
            IClause[] clauses = new IClause[]{START.node(n).byId(ids), RETURN.value(n)};
            query.setClauses(clauses);
            if (this.dbAccess.getDBType() != DBType.REMOTE) {
                query.setExtractParams(false);
            }
            Util.printQuery(query, QueriesPrintObserver.QueryToObserve.QUERY_CONCRETE_TYPE, Format.PRETTY_1);
            JcQueryResult result = this.dbAccess.execute(query);
            List<JcError> errors = Util.collectErrors(result);
            if (errors.size() > 0) {
                throw new JcResultException(errors);
            }
            HashMap byType = new HashMap();
            DomainInfo di = this.loadDomainInfoIfNeeded();
            List<GrNode> nodes = result.resultOf(n);
            block0: for (GrNode node : nodes) {
                List<GrLabel> labels = node.getLabels();
                for (GrLabel label : labels) {
                    String lab = label.getName();
                    Class typ = di.getClassForLabel(lab);
                    if (typ == null) continue;
                    ArrayList<Long> list = (ArrayList<Long>)byType.get(typ);
                    if (list == null) {
                        list = new ArrayList<Long>();
                        byType.put(typ, list);
                    }
                    list.add(node.getId());
                    continue block0;
                }
            }
            return byType;
        }

        private void updateMappingsIfNeeded() {
            if (this.domainInfo == null) {
                this.loadDomainInfoIfNeeded();
            }
        }

        private UpdateContext updateLocalGraph(List<?> domainObjects) {
            Long id;
            int i;
            UpdateContext context = new UpdateContext();
            context.lockingErrors = false;
            new ClosureCalculator().calculateClosure(domainObjects, context);
            context.surrogateChangeLog.applyChanges();
            Graph graph = null;
            ArrayList<Node> clauses = null;
            ArrayList<Object> removeStartClauses = null;
            ArrayList<ModifyTerminal> removeClauses = null;
            DomainState ds = this.getDomainState();
            for (i = 0; i < context.domainObjects.size(); ++i) {
                Long id2;
                Object domainObject = context.domainObjects.get(i);
                DomainState.LoadInfo li = ds.getLoadInfoFrom_Object2IdMap(domainObject);
                Long l = id2 = li != null ? li.getId() : null;
                if (id2 == null) continue;
                JcNode n = new JcNode(NodePrefix.concat(String.valueOf(i)));
                QueryNode2ResultNode n2n = new QueryNode2ResultNode();
                n2n.queryNode = n;
                n2n.version = li.getVersion();
                if (context.nodeIndexMap == null) {
                    context.nodeIndexMap = new HashMap();
                }
                context.nodeIndexMap.put(new Integer(i), n2n);
                if (clauses == null) {
                    clauses = new ArrayList<Node>();
                }
                clauses.add(OPTIONAL_MATCH.node(n));
                clauses.add((Node)((Object)WHERE.valueOf(n.id()).EQUALS(Long.valueOf(id2))));
            }
            for (i = 0; i < context.relations.size(); ++i) {
                Long id3;
                DomainState.IRelation relat = (DomainState.IRelation)context.relations.get(i);
                DomainState.RelationLoadInfo rli = ds.getFrom_Relation2IdMap(relat);
                Long l = id3 = rli != null ? rli.getId() : null;
                if (id3 == null) continue;
                JcRelation r = new JcRelation(RelationPrefix.concat(String.valueOf(i)));
                QueryRelation2ResultRelation r2r = new QueryRelation2ResultRelation();
                r2r.queryRelation = r;
                r2r.version = rli.getVersion();
                if (context.relationIndexMap == null) {
                    context.relationIndexMap = new HashMap();
                }
                context.relationIndexMap.put(new Integer(i), r2r);
                clauses.add(OPTIONAL_MATCH.node().relation(r).out().node());
                clauses.add((Node)((Object)WHERE.valueOf(r.id()).EQUALS(Long.valueOf(id3))));
            }
            LockUtil.Removes removes = new LockUtil.Removes();
            if (context.relationsToRemove.size() > 0) {
                removeStartClauses = new ArrayList<Object>();
                removeClauses = new ArrayList<ModifyTerminal>();
                for (int i2 = 0; i2 < context.relationsToRemove.size(); ++i2) {
                    DomainState.IRelation relat = (DomainState.IRelation)context.relationsToRemove.get(i2);
                    DomainState.RelationLoadInfo rli = ds.getFrom_Relation2IdMap(relat);
                    id = rli.getId();
                    JcRelation r = new JcRelation(RelationPrefix.concat(String.valueOf(i2)));
                    removeStartClauses.add(OPTIONAL_MATCH.node().relation(r).out().node());
                    removeStartClauses.add(WHERE.valueOf(r.id()).EQUALS(Long.valueOf(id)));
                    if (this.lockingStrategy == Locking.OPTIMISTIC) {
                        LockUtil.calcRemoves(removes, r, rli.getVersion());
                    }
                    removeClauses.add(DO.DELETE(r));
                }
            }
            if (context.domainObjectsToRemove.size() > 0) {
                if (removeStartClauses == null) {
                    removeStartClauses = new ArrayList();
                    removeClauses = new ArrayList();
                }
                for (int i3 = 0; i3 < context.domainObjectsToRemove.size(); ++i3) {
                    Object dobj = context.domainObjectsToRemove.get(i3);
                    DomainState.LoadInfo li = ds.getLoadInfoFrom_Object2IdMap(dobj);
                    id = li.getId();
                    JcNode n = new JcNode(NodePrefix.concat(String.valueOf(i3)));
                    removeStartClauses.add(OPTIONAL_MATCH.node(n));
                    removeStartClauses.add(WHERE.valueOf(n.id()).EQUALS(Long.valueOf(id)));
                    if (this.lockingStrategy == Locking.OPTIMISTIC) {
                        LockUtil.calcRemoves(removes, n, li.getVersion());
                    }
                    removeClauses.add(DO.DELETE(n));
                }
            }
            if (removes.getWithClauses() != null) {
                JcNumber nSum = new JcNumber("sum");
                removes.getWithClauses().add((IClause)WITH.value(removes.getSum()).AS(nSum));
            }
            JcNumber nSum = null;
            if (clauses != null || removeStartClauses != null) {
                JcQueryResult result;
                JcQuery query;
                ArrayList<JcQuery> queries = new ArrayList<JcQuery>();
                if (clauses != null) {
                    clauses.add((Node)((Object)RETURN.ALL()));
                    IClause[] clausesArray = clauses.toArray(new IClause[clauses.size()]);
                    query = new JcQuery();
                    query.setClauses(clausesArray);
                    queries.add(query);
                }
                if (removeStartClauses != null) {
                    if (removes.getWithClauses() != null) {
                        removeStartClauses.addAll(removes.getWithClauses());
                        JcValue x = new JcValue("x");
                        nSum = new JcNumber("sum");
                        DoConcat clause = ((EachDoConcat)FOR_EACH.element(x).IN(C.CREATE(new IClause[]{CASE.result(), WHEN.valueOf(nSum).EQUALS(removes.getVersionSum()), NATIVE.cypher("[1]"), ELSE.perform(), NATIVE.cypher("[]"), END.caseXpr()}))).DO(removeClauses.toArray(new IClause[removeClauses.size()]));
                        removeStartClauses.add(clause);
                        removeStartClauses.add(RETURN.value(nSum));
                    } else {
                        removeStartClauses.addAll(removeClauses);
                    }
                    query = new JcQuery();
                    query.setClauses(removeStartClauses.toArray(new IClause[removeStartClauses.size()]));
                    queries.add(query);
                }
                Util.printQueries(queries, QueriesPrintObserver.QueryToObserve.CLOSURE_QUERY, Format.PRETTY_1);
                List<JcQueryResult> results = this.dbAccess.execute(queries);
                List<JcError> errors = Util.collectErrors(results);
                if (errors.size() > 0) {
                    throw new JcResultException(errors);
                }
                if (removeStartClauses != null && this.lockingStrategy == Locking.OPTIMISTIC) {
                    result = clauses != null ? results.get(1) : results.get(0);
                    List<BigDecimal> versionSums = result.resultOf(nSum);
                    if (versionSums.size() == 0 || versionSums.get(0) == null) {
                        context.lockingErrors = true;
                    } else if (versionSums.get(0).intValue() != removes.getVersionSum()) {
                        context.lockingErrors = true;
                    }
                }
                if (clauses != null) {
                    GrPropertyContainer res;
                    result = results.get(0);
                    graph = result.getGraph();
                    GrAccess.setDBAccess(this.dbAccess, graph);
                    if (context.nodeIndexMap != null) {
                        for (Map.Entry entry : context.nodeIndexMap.entrySet()) {
                            List<GrNode> nds = result.resultOf(((QueryNode2ResultNode)entry.getValue()).queryNode);
                            res = null;
                            if (nds.size() > 0) {
                                res = nds.get(0);
                            }
                            if (this.lockingStrategy == Locking.OPTIMISTIC && res == null) {
                                context.lockingErrors = true;
                            }
                            ((QueryNode2ResultNode)entry.getValue()).resultNode = res;
                        }
                    }
                    if (context.relationIndexMap != null) {
                        for (Map.Entry entry : context.relationIndexMap.entrySet()) {
                            List<GrRelation> rels = result.resultOf(((QueryRelation2ResultRelation)entry.getValue()).queryRelation);
                            res = null;
                            if (rels.size() > 0) {
                                res = rels.get(0);
                            }
                            if (this.lockingStrategy == Locking.OPTIMISTIC && res == null) {
                                context.lockingErrors = true;
                            }
                            ((QueryRelation2ResultRelation)entry.getValue()).resultRelation = (GrRelation)res;
                        }
                    }
                }
            }
            if (graph == null) {
                graph = Graph.create(this.dbAccess);
            }
            graph.setLockingStrategy(this.lockingStrategy);
            if (!context.lockingErrors) {
                int i4;
                context.domObj2Node = new HashMap(context.domainObjects.size());
                context.domRelation2Relations = new ArrayList();
                for (i4 = 0; i4 < context.domainObjects.size(); ++i4) {
                    GrNode rNode = null;
                    if (context.nodeIndexMap != null && context.nodeIndexMap.get(i4) != null) {
                        rNode = ((QueryNode2ResultNode)context.nodeIndexMap.get(i4)).resultNode;
                    }
                    if (rNode == null) {
                        rNode = graph.createNode();
                    }
                    context.domObj2Node.put(context.domainObjects.get(i4), rNode);
                    this.updateGraphFromObject(context.domainObjects.get(i4), rNode);
                }
                for (i4 = 0; i4 < context.relations.size(); ++i4) {
                    GrRelation rRelation = null;
                    if (context.relationIndexMap != null && context.relationIndexMap.get(i4) != null) {
                        rRelation = ((QueryRelation2ResultRelation)context.relationIndexMap.get(i4)).resultRelation;
                    }
                    if (rRelation == null) {
                        DomainState.IRelation relat = (DomainState.IRelation)context.relations.get(i4);
                        rRelation = graph.createRelation(relat.getType(), (GrNode)context.domObj2Node.get(relat.getStart()), (GrNode)context.domObj2Node.get(relat.getEnd()));
                        DomRelation2ResultRelation d2r = new DomRelation2ResultRelation();
                        d2r.domRelation = relat;
                        d2r.resultRelation = rRelation;
                        context.domRelation2Relations.add(d2r);
                    }
                    this.updateGraphFromRelation((DomainState.IRelation)context.relations.get(i4), rRelation);
                }
            }
            context.graph = graph;
            return context;
        }

        private <T> List<T> loadByIdsWithMatches(Class<T> domainObjectClass, ClosureQueryContext context, Set<IDeferred> deferredSet, SurrogateChangeLog surrogateChangeLog, List<IdAndDepth> idList, int resolutionDepth) {
            boolean isRoot;
            int i;
            ArrayList<Object> resultList = new ArrayList<Object>();
            Set<IDeferred> deferreds = deferredSet;
            String nm = NodePrefix.concat(String.valueOf(0));
            ArrayList<JcQuery> queries = new ArrayList<JcQuery>();
            HashMap id2QueryResult = new HashMap();
            ArrayList<Long> queryIds = new ArrayList<Long>();
            for (int i2 = 0; i2 < idList.size(); ++i2) {
                long id = idList.get(i2).id;
                JcQuery query = new JcQuery();
                JcNode n = new JcNode(nm);
                ArrayList<APIObject> clauses = new ArrayList<APIObject>();
                clauses.add(START.node(n).byId(id));
                clauses.addAll(context.matchClauses);
                clauses.add(RETURN.ALL());
                IClause[] clausesArray = clauses.toArray(new IClause[clauses.size()]);
                query.setClauses(clausesArray);
                queries.add(query);
                queryIds.add(id);
            }
            if (queries.size() > 0) {
                Util.printQueries(queries, QueriesPrintObserver.QueryToObserve.CLOSURE_QUERY, Format.PRETTY_1);
                List<JcQueryResult> results = this.dbAccess.execute(queries);
                List<JcError> errors = Util.collectErrors(results);
                if (errors.size() > 0) {
                    throw new JcResultException(errors);
                }
                for (i = 0; i < queries.size(); ++i) {
                    id2QueryResult.put(queryIds.get(i), results.get(i));
                }
            }
            if (deferreds == null) {
                isRoot = true;
                deferreds = new HashSet<IDeferred>();
                surrogateChangeLog = new SurrogateChangeLog();
            } else {
                isRoot = false;
            }
            ArrayList<FillModelContext.ResolvedDepth> objectsNotResolvedDeep = new ArrayList<FillModelContext.ResolvedDepth>();
            for (i = 0; i < idList.size(); ++i) {
                FillModelContext fContext = new FillModelContext(domainObjectClass, (JcQueryResult)id2QueryResult.get(idList.get(i).id), context.queryEndNodes, context.recursionExitNodes, surrogateChangeLog, resolutionDepth, idList.get(i).depth);
                new ClosureCalculator().fillModel(fContext);
                objectsNotResolvedDeep.addAll(fContext.recursionExitObjects);
                resultList.add(fContext.domainObject);
                deferreds.addAll(fContext.deferredList);
            }
            if (!objectsNotResolvedDeep.isEmpty()) {
                this.loadDeep(objectsNotResolvedDeep, deferreds, surrogateChangeLog, resolutionDepth);
            }
            if (isRoot) {
                this.buildDeferredResolutionTree(deferreds);
                this.handleLoops(deferreds);
                ArrayList<IDeferred> leafs = new ArrayList<IDeferred>();
                for (IDeferred deferred : deferreds) {
                    if (!deferred.isLeaf()) continue;
                    leafs.add(deferred);
                }
                this.resolveDeferreds(leafs.iterator());
                surrogateChangeLog.applyChanges();
            }
            return resultList;
        }

        private void handleLoops(Set<IDeferred> deferreds) {
            for (IDeferred deferred : deferreds) {
                if (!deferred.isRoot()) continue;
                deferred.breakLoops();
            }
        }

        private void resolveDeferreds(Iterator<IDeferred> it) {
            while (it.hasNext()) {
                IDeferred deferred = it.next();
                if (!deferred.isLeaf()) continue;
                deferred.performUpdate();
                this.resolveDeferreds(deferred.nextUp());
            }
        }

        private void buildDeferredResolutionTree(Set<IDeferred> deferreds) {
            for (IDeferred deferred : deferreds) {
                if (deferred instanceof ISurrogate2Entry) {
                    for (IDeferred def : deferreds) {
                        if (!(def instanceof IEntryUpdater) || !((ISurrogate2Entry)((Object)deferred)).entry2Update().equals(((IEntryUpdater)((Object)def)).entry2Update())) continue;
                        deferred.addNextUpInTree(def);
                    }
                    continue;
                }
                if (!(deferred instanceof IEntryUpdater)) continue;
                for (IDeferred def : deferreds) {
                    if (def instanceof ISurrogate2Entry) {
                        if (((IEntryUpdater)((Object)deferred)).objectToUpdate() != ((ISurrogate2Entry)((Object)def)).getSurrogate().objectToUpdate()) continue;
                        deferred.addNextUpInTree(def);
                        continue;
                    }
                    if (!(def instanceof Deferred2DO) || ((IEntryUpdater)((Object)deferred)).objectToUpdate() != ((Deferred2DO)def).getDeferred().objectToUpdate()) continue;
                    deferred.addNextUpInTree(def);
                }
            }
        }

        private <T> List<T> loadByIdsSimple(Class<T> domainObjectClass, List<IdAndDepth> idList) {
            ArrayList<T> resultList = new ArrayList<T>();
            ArrayList<APIObject> clauses = new ArrayList<APIObject>();
            HashMap<Long, JcNode> id2QueryNode = new HashMap<Long, JcNode>();
            HashMap<Long, Object> id2Object = new HashMap<Long, Object>();
            DomainState ds = this.getDomainState();
            for (int i = 0; i < idList.size(); ++i) {
                long id = idList.get(i).id;
                Object obj = ds.getFrom_Id2ObjectMap(id);
                if (obj != null) {
                    id2Object.put(id, obj);
                }
                JcNode n = new JcNode(NodePrefix.concat(String.valueOf(i)));
                id2QueryNode.put(id, n);
                clauses.add(START.node(n).byId(id));
            }
            JcQueryResult result = null;
            if (clauses.size() > 0) {
                clauses.add(RETURN.ALL());
                JcQuery query = new JcQuery();
                IClause[] clausesArray = clauses.toArray(new IClause[clauses.size()]);
                query.setClauses(clausesArray);
                result = this.dbAccess.execute(query);
                if (result.hasErrors()) {
                    List<JcError> errors = Util.collectErrors(result);
                    throw new JcResultException(errors);
                }
            }
            for (int i = 0; i < idList.size(); ++i) {
                long id = idList.get(i).id;
                Object obj = id2Object.get(id);
                GrNode rNode = result.resultOf((JcNode)id2QueryNode.get(id)).get(0);
                T resObj = this.createIfNeeded_MapProperties(domainObjectClass, rNode, obj);
                GrProperty prop = rNode.getProperty("_c_version_");
                int v = -1;
                if (prop != null) {
                    v = ((Number)prop.getValue()).intValue();
                }
                if (obj == null) {
                    ds.add_Id2Object(resObj, id, v, ResolutionDepth.DEEP);
                } else {
                    ds.getLoadInfoFrom_Object2IdMap(obj).setResolutionDepth(ResolutionDepth.DEEP).setVersion(v);
                }
                resultList.add(resObj);
            }
            return resultList;
        }

        private <T> T createIfNeeded_MapProperties(Class<T> domainObjectClass, GrNode rNode, T domObj) {
            Object domainObject = domObj;
            if (domainObject == null) {
                Class<?> clazz = this.findClassToInstantiateFor(rNode);
                if (clazz != null) {
                    if (!domainObjectClass.isAssignableFrom(clazz)) {
                        throw new RuntimeException(clazz.getName() + " cannot be assigned to domain object class: " + domainObjectClass.getName());
                    }
                } else {
                    throw new RuntimeException("node with label(s): " + rNode.getLabels() + " cannot be mapped to domain object class: " + domainObjectClass.getName());
                }
                Class<?> concreteClass = clazz;
                domainObject = this.createInstance(concreteClass);
            }
            ObjectMapping objectMapping = this.getObjectMappingFor(domainObject);
            objectMapping.mapPropertiesToObject(domainObject, rNode);
            return domainObject;
        }

        private Class<?> findClassToInstantiateFor(GrNode rNode) {
            Iterator<GrLabel> it = rNode.getLabels().iterator();
            while (it.hasNext()) {
                Class clazz = this.domainInfo.getClassForLabel(it.next().getName());
                if (clazz == null) continue;
                return clazz;
            }
            return null;
        }

        private void updateGraphFromObject(Object domainObject, GrNode rNode) {
            ObjectMapping objectMapping = this.mappings.get(domainObject.getClass());
            objectMapping.mapPropertiesFromObject(domainObject, rNode);
        }

        private void updateGraphFromRelation(DomainState.IRelation relat, GrRelation rRelation) {
            Object propValue;
            GrProperty prop;
            Object key = null;
            Object value = null;
            if (relat instanceof DomainState.KeyedRelation) {
                key = ((DomainState.KeyedRelation)relat).getKey();
                value = ((DomainState.KeyedRelation)relat).getValue();
            } else if (relat instanceof DomainState.KeyedRelationToChange) {
                key = ((DomainState.KeyedRelationToChange)relat).getNewOne().getKey();
                value = ((DomainState.KeyedRelationToChange)relat).getNewOne().getValue();
            }
            if (key != null) {
                prop = rRelation.getProperty(KeyProperty);
                if (prop != null) {
                    propValue = MappingUtil.convertFromProperty(prop.getValue(), key.getClass());
                    if (!key.equals(propValue)) {
                        prop.setValue(key);
                    }
                } else {
                    rRelation.addProperty(KeyProperty, key);
                }
                prop = rRelation.getProperty(KeyTypeProperty);
                if (prop != null) {
                    propValue = key.getClass().getName();
                    if (!prop.getValue().equals(propValue)) {
                        prop.setValue(propValue);
                    }
                } else {
                    rRelation.addProperty(KeyTypeProperty, key.getClass().getName());
                }
            }
            prop = rRelation.getProperty(ValueProperty);
            if (value != null) {
                if (prop != null) {
                    propValue = MappingUtil.convertFromProperty(prop.getValue(), value.getClass());
                    if (!value.equals(propValue)) {
                        prop.setValue(value);
                    }
                } else {
                    rRelation.addProperty(ValueProperty, value);
                }
                prop = rRelation.getProperty(ValueTypeProperty);
                if (prop != null) {
                    propValue = value.getClass().getName();
                    if (!prop.getValue().equals(propValue)) {
                        prop.setValue(propValue);
                    }
                } else {
                    rRelation.addProperty(ValueTypeProperty, value.getClass().getName());
                }
            } else {
                if (prop != null) {
                    prop.setValue(null);
                }
                if ((prop = rRelation.getProperty(ValueTypeProperty)) != null) {
                    prop.setValue(null);
                }
            }
        }

        private ObjectMapping getCompoundObjectMappingFor(CompoundObjectType cType, Object filter) {
            return new CompoundObjectMapping(cType, this.mappings, filter);
        }

        private ObjectMapping getObjectMappingFor(Object domainObject) {
            Class<?> clazz = domainObject.getClass();
            return this.getObjectMappingFor(clazz);
        }

        private ObjectMapping getObjectMappingFor(Class<?> clazz) {
            ObjectMapping objectMapping = this.mappings.get(clazz);
            if (objectMapping == null) {
                objectMapping = this.createObjectMappingFor(clazz);
                this.addObjectMappingForClass(clazz, objectMapping);
            }
            return objectMapping;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObjectMapping createObjectMappingFor(Class<?> clazz) {
            ObjectMapping ret;
            InternalDomainAccess internalAccess = null;
            try {
                internalAccess = MappingUtil.internalDomainAccess.get();
                MappingUtil.internalDomainAccess.set(DomainAccess.this.getInternalDomainAccess());
                ret = DefaultObjectMappingCreator.createObjectMapping(clazz, this.domainModel);
            }
            finally {
                if (internalAccess != null) {
                    MappingUtil.internalDomainAccess.set(internalAccess);
                } else {
                    MappingUtil.internalDomainAccess.remove();
                }
            }
            return ret;
        }

        private FieldMapping modifyFieldMapping(FieldMapping fm, FieldMapping parentField) {
            return fm;
        }

        private void addObjectMappingForClass(Class<?> domainObjectClass, ObjectMapping objectMapping) {
            this.mappings.put(domainObjectClass, objectMapping);
            this.updateCompoundTypeMapWith(domainObjectClass);
            this.getAvailableDomainInfo().addClassLabel(domainObjectClass, objectMapping.getNodeLabelMapping().getLabel());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DomainInfo loadDomainInfoIfNeeded() {
            DomainInfo ret;
            Object so = DomainAccess.this.getInternalDomainAccess().getSyncObject();
            if (so != null) {
                Object object = so;
                synchronized (object) {
                    ret = this.intLoadDomainInfoIfNeeded();
                }
            } else {
                ret = this.intLoadDomainInfoIfNeeded();
            }
            return ret;
        }

        private DomainInfo intLoadDomainInfoIfNeeded() {
            if (this.domainInfo == null) {
                ExecContext ctxt = new ExecContext();
                JcQuery query = ((DBAccessWrapper)this.dbAccess).createDomainInfoSyncQuery(ctxt);
                JcQueryResult result = ((DBAccessWrapper)this.dbAccess).delegate.execute(query);
                List<JcError> errors = Util.collectErrors(result);
                if (!errors.isEmpty()) {
                    throw new JcResultException(errors);
                }
                ((DBAccessWrapper)this.dbAccess).updateDomainInfo(result, ctxt);
                this.updateClassMapping(this.domainInfo);
            }
            return this.domainInfo;
        }

        private void updateClassMapping(DomainInfo di) {
            Set classes = di.getAllStoredDomainClasses();
            for (Class clazz : classes) {
                ObjectMapping objectMapping = this.mappings.get(clazz);
                if (objectMapping != null) continue;
                objectMapping = this.createObjectMappingFor(clazz);
                this.mappings.put(clazz, objectMapping);
                this.updateCompoundTypeMapWith(clazz);
            }
        }

        private DomainInfo getAvailableDomainInfo() {
            DomainInfo ret;
            if (this.domainInfo != null) {
                ret = this.domainInfo;
            } else {
                ret = ((DBAccessWrapper)this.dbAccess).temporaryDomainInfo;
                if (ret == null) {
                    ret = new DomainInfo(-1L);
                    ((DBAccessWrapper)this.dbAccess).temporaryDomainInfo = ret;
                }
            }
            return ret;
        }

        private String setDomainLabel() {
            boolean useLab = this.domainInfo == null ? (this.domainLabelUse == IDomainAccess.DomainLabelUse.AUTO ? this.loadDomainInfoIfNeeded().useDomainLabels : this.domainLabelUse == IDomainAccess.DomainLabelUse.ALWAYS) : this.domainInfo.useDomainLabels;
            String ret = CurrentDomain.label.get();
            if (useLab) {
                CurrentDomain.setDomainLabel(this.getDomainLabel());
            }
            return ret;
        }

        private String getDomainLabel() {
            if (this.domainLabel == null) {
                this.domainLabel = DomainAccess.this.getInternalDomainAccess().buildDomainLabel(this.domainName);
            }
            return this.domainLabel;
        }

        private CompoundObjectType getCompoundTypeFor(Class<?> clazz) {
            CompoundObjectType cType = this.type2CompoundTypeMap.get(clazz);
            if (cType == null) {
                cType = new CompoundObjectType(clazz);
                for (Class<?> typ : this.mappings.keySet()) {
                    if (!clazz.isAssignableFrom(typ)) continue;
                    cType.addType(typ);
                }
                this.type2CompoundTypeMap.put(clazz, cType);
            }
            return cType;
        }

        private void updateCompoundTypeMapWith(Class<?> clazz) {
            for (Map.Entry<Class<?>, CompoundObjectType> entry : this.type2CompoundTypeMap.entrySet()) {
                if (!entry.getKey().isAssignableFrom(clazz)) continue;
                entry.getValue().addType(clazz);
            }
        }

        private Object createInstance(Class<?> clazz) {
            InnerClassSurrogate ret = null;
            try {
                if (clazz.isMemberClass()) {
                    Constructor<?>[] constrs;
                    Class<?> eClass = clazz.getEnclosingClass();
                    Constructor<?> constr = null;
                    for (Constructor<?> c : constrs = clazz.getDeclaredConstructors()) {
                        Class<?>[] pTypes = c.getParameterTypes();
                        if (pTypes.length != 1 || !pTypes[0].equals(eClass)) continue;
                        constr = c;
                        break;
                    }
                    if (constr != null) {
                        ret = new InnerClassSurrogate(constr);
                    }
                }
                if (ret == null) {
                    ret = (InnerClassSurrogate)clazz.newInstance();
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        private List<Class<?>> getCompoundTypesFor(Class<?> domainObjectType) {
            this.updateMappingsIfNeeded();
            CompoundObjectType cType = this.getCompoundTypeFor(domainObjectType);
            List<Class<?>> typeList = cType.getTypes(true);
            Collections.sort(typeList, new Comparator<Class<?>>(){

                @Override
                public int compare(Class<?> o1, Class<?> o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            return typeList;
        }

        public class DBAccessWrapper
        implements IDBAccess {
            private IDBAccess delegate;
            private DomainInfo temporaryDomainInfo;

            private DBAccessWrapper(IDBAccess delegate) {
                this.delegate = delegate;
            }

            @Override
            public JcQueryResult execute(JcQuery query) {
                boolean reloaded;
                ExecContext ctxt = new ExecContext();
                QExecution qExec = (QExecution)qExecution.get();
                JcQuery infoQuery = this.createDomainInfoSyncQuery(ctxt);
                if (infoQuery != null) {
                    ArrayList<JcQuery> queries = new ArrayList<JcQuery>(2);
                    queries.add(query);
                    queries.add(infoQuery);
                    Util.printQueries(queries, QueriesPrintObserver.QueryToObserve.DOMAINACCESS_EXECUTE_INTERNAL, Format.PRETTY_1);
                    List<JcQueryResult> results = this.delegate.execute(queries);
                    List<JcError> errors = Util.collectErrors(results);
                    if (errors.isEmpty()) {
                        this.updateDomainInfo(results.get(1), ctxt);
                    }
                    if (qExec != null) {
                        qExec.setCheckedReloadModel(true);
                    }
                    return results.get(0);
                }
                ArrayList<JcQuery> queries = new ArrayList<JcQuery>();
                queries.add(query);
                boolean doCheck = false;
                if (qExec != null && qExec.geExecType().shouldCheckForReload() && !qExec.isCheckedReloadModel()) {
                    int[] versions = new int[]{DomainAccess.this.domainAccessHandler.domainInfo.version, DomainAccess.this.domainAccessHandler.domainModel.getVersion()};
                    queries.add(this.createCheckInfoVersionQuery(versions));
                    doCheck = true;
                }
                Util.printQueries(queries, QueriesPrintObserver.QueryToObserve.DOMAINACCESS_EXECUTE_INTERNAL, Format.PRETTY_1);
                List<JcQueryResult> results = this.delegate.execute(queries);
                if (doCheck && Util.collectErrors(results).isEmpty() && (reloaded = this.reloadInfo_ModelIfNeeded(results.get(1)))) {
                    JcQueryResult r = results.get(0);
                    JcError err = new JcError("_REPLAY_QUERY", null, null);
                    r.addGeneralError(err);
                }
                return results.get(0);
            }

            @Override
            public List<JcQueryResult> execute(List<JcQuery> queries) {
                boolean reloaded;
                List<JcQuery> extQueries;
                ExecContext ctxt = new ExecContext();
                QExecution qExec = (QExecution)qExecution.get();
                JcQuery infoQuery = this.createDomainInfoSyncQuery(ctxt);
                if (infoQuery != null) {
                    ArrayList<JcQuery> extQueries2 = new ArrayList<JcQuery>(queries.size() + 1);
                    extQueries2.addAll(queries);
                    extQueries2.add(infoQuery);
                    Util.printQueries(extQueries2, QueriesPrintObserver.QueryToObserve.DOMAINACCESS_EXECUTE_INTERNAL, Format.PRETTY_1);
                    List<JcQueryResult> results = this.delegate.execute(extQueries2);
                    List<JcError> errors = Util.collectErrors(results);
                    if (errors.isEmpty()) {
                        this.updateDomainInfo(results.get(queries.size()), ctxt);
                    }
                    if (qExec != null) {
                        qExec.setCheckedReloadModel(true);
                    }
                    return results.subList(0, queries.size());
                }
                boolean doCheck = false;
                if (qExec != null && qExec.geExecType().shouldCheckForReload() && !qExec.isCheckedReloadModel()) {
                    int[] versions = new int[]{DomainAccess.this.domainAccessHandler.domainInfo.version, DomainAccess.this.domainAccessHandler.domainModel.getVersion()};
                    extQueries = new ArrayList<JcQuery>(queries.size() + 1);
                    extQueries.addAll(queries);
                    extQueries.add(this.createCheckInfoVersionQuery(versions));
                    doCheck = true;
                } else {
                    extQueries = queries;
                }
                Util.printQueries(extQueries, QueriesPrintObserver.QueryToObserve.DOMAINACCESS_EXECUTE_INTERNAL, Format.PRETTY_1);
                List<JcQueryResult> results = this.delegate.execute(extQueries);
                if (doCheck && Util.collectErrors(results).isEmpty() && (reloaded = this.reloadInfo_ModelIfNeeded(results.get(results.size() - 1)))) {
                    JcQueryResult r = results.get(0);
                    JcError err = new JcError("_REPLAY_QUERY", null, null);
                    r.addGeneralError(err);
                }
                return results.subList(0, queries.size());
            }

            @Override
            public List<JcError> clearDatabase() {
                return this.delegate.clearDatabase();
            }

            @Override
            public boolean isDatabaseEmpty() {
                return this.delegate.isDatabaseEmpty();
            }

            @Override
            public ITransaction beginTX() {
                return this.delegate.beginTX();
            }

            @Override
            public ITransaction getTX() {
                return this.delegate.getTX();
            }

            @Override
            public DBType getDBType() {
                return this.delegate.getDBType();
            }

            @Override
            public IDBAccess removeShutdownHook() {
                this.delegate.removeShutdownHook();
                return this;
            }

            @Override
            public IDBAccess addShutdownHook() {
                this.delegate.addShutdownHook();
                return this;
            }

            @Override
            public void close() {
                this.delegate.close();
            }

            public IDBAccess getDelegate() {
                return this.delegate;
            }

            private void updateDomainInfo(JcQueryResult result, ExecContext context) {
                if (context.dInfo == Exec.INIT_LOADED) {
                    JcNode mdl = new JcNode("mdl");
                    List<GrNode> mdlInfos = result.resultOf(mdl);
                    DomainAccessHandler.this.domainModel.loadFrom(mdlInfos);
                    JcNode info = new JcNode("info");
                    List<GrNode> rInfos = result.resultOf(info);
                    GrNode rInfo = rInfos.get(0);
                    DomainInfo dInfo = new DomainInfo(rInfo.getId());
                    dInfo.initFrom(rInfo);
                    DomainAccessHandler.this.domainInfo = dInfo;
                    GrProperty prop = rInfo.getProperty(DomainAccessHandler.DomainInfoUseDomainLabelProperty);
                    if (prop == null) {
                        if (DomainAccessHandler.this.domainLabelUse == IDomainAccess.DomainLabelUse.AUTO) {
                            JcNumber infos = new JcNumber("infos");
                            List<BigDecimal> cInfos = result.resultOf(infos);
                            DomainAccessHandler.this.domainInfo.useDomainLabels = cInfos.get(0).intValue() > 1;
                        } else {
                            DomainAccessHandler.this.domainInfo.useDomainLabels = DomainAccessHandler.this.domainLabelUse == IDomainAccess.DomainLabelUse.ALWAYS;
                        }
                        if (DomainAccessHandler.this.domainInfo.useDomainLabels) {
                            DomainAccessHandler.this.domainInfo.setChanged(true);
                        }
                    }
                } else if (context.dInfo == Exec.TRIED_STORE || context.dModel == Exec.TRIED_STORE) {
                    int retDm;
                    JcNumber rDi = new JcNumber("retDi");
                    JcNumber rDm = new JcNumber("retDm");
                    int retDi = ((Number)result.resultOf(rDi).get(0)).intValue();
                    if (retDi + (retDm = ((Number)result.resultOf(rDm).get(0)).intValue()) == 0) {
                        if (context.dInfo == Exec.TRIED_STORE) {
                            DomainAccessHandler.this.domainInfo.graphUdated();
                        }
                        if (context.dModel == Exec.TRIED_STORE) {
                            int idx = 0;
                            for (DOType t : DomainAccessHandler.this.domainModel.getUnsaved()) {
                                JcNumber nid = new JcNumber("nid_".concat(String.valueOf(idx)));
                                BigDecimal rNid = result.resultOf(nid).get(0);
                                iot.jcypher.domain.genericmodel.InternalAccess.setNodeId(t, rNid.longValue());
                                ++idx;
                            }
                            DomainAccessHandler.this.domainModel.updatedToGraph();
                        }
                    } else {
                        DomainAccessHandler.this.domainModel.updatedToGraph();
                        ExecContext ctxt = new ExecContext();
                        if (retDi != 0) {
                            ctxt.dInfo = Exec.RELOAD_STORE;
                        }
                        if (retDm != 0) {
                            ctxt.dModel = Exec.RELOAD_STORE;
                        }
                        this.handleDomainInfo_Model(ctxt);
                    }
                } else if (context.dInfo == Exec.RELOADED_STORE || context.dModel == Exec.RELOADED_STORE) {
                    ExecContext ctxt = new ExecContext();
                    int v = 0;
                    if (context.dModel == Exec.RELOADED_STORE) {
                        JcNode mdl = new JcNode("mdl");
                        List<GrNode> mdlInfos = result.resultOf(mdl);
                        DomainAccessHandler.this.domainModel.mergeFrom(mdlInfos);
                        if (context.dInfo != Exec.RELOADED_STORE) {
                            JcNumber m_version = new JcNumber("mv");
                            v = result.resultOf(m_version).get(0).intValue();
                        } else {
                            JcNode info = new JcNode("info");
                            v = ((Number)result.resultOf(info).get(0).getProperty(DomainAccessHandler.DomainInfoModelVersionProperty).getValue()).intValue();
                        }
                        ++v;
                    }
                    if (context.dInfo == Exec.RELOADED_STORE) {
                        JcNode info = new JcNode("info");
                        GrNode rInfo = result.resultOf(info).get(0);
                        DomainInfo di = new DomainInfo(DomainAccessHandler.this.domainInfo.nodeId);
                        di.initFrom(rInfo);
                        DomainAccessHandler.this.domainInfo.updateFrom(di);
                        DomainAccessHandler.this.domainInfo.version = di.version + 1;
                        DomainAccessHandler.this.domainInfo.changed = true;
                        DomainAccessHandler.this.updateClassMapping(DomainAccessHandler.this.domainInfo);
                    } else {
                        ctxt.dInfo = Exec.STORE_VERSIONS;
                    }
                    if (context.dModel == Exec.RELOADED_STORE) {
                        DomainAccessHandler.this.domainModel.setVersion(v);
                    }
                    this.handleDomainInfo_Model(ctxt);
                } else if (context.dInfo == Exec.RELOADED || context.dModel == Exec.RELOADED) {
                    if (context.dModel == Exec.RELOADED) {
                        JcNode mdl = new JcNode("mdl");
                        List<GrNode> mdlInfos = result.resultOf(mdl);
                        DomainAccessHandler.this.domainModel.mergeFrom(mdlInfos);
                    }
                    if (context.dInfo == Exec.RELOADED) {
                        JcNode info = new JcNode("info");
                        GrNode rInfo = result.resultOf(info).get(0);
                        DomainInfo di = new DomainInfo(DomainAccessHandler.this.domainInfo.nodeId);
                        di.initFrom(rInfo);
                        DomainAccessHandler.this.domainInfo.updateFrom(di);
                        DomainAccessHandler.this.domainInfo.version = di.version;
                        DomainAccessHandler.this.domainInfo.changed = false;
                        DomainAccessHandler.this.updateClassMapping(DomainAccessHandler.this.domainInfo);
                    }
                }
                if (this.temporaryDomainInfo != null) {
                    DomainAccessHandler.this.domainInfo.updateFrom(this.temporaryDomainInfo);
                    this.temporaryDomainInfo = null;
                }
                this.handleDomainInfo_Model(null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private JcQuery createDomainInfoSyncQuery(ExecContext context) {
                JcQuery query = null;
                String pLab = CurrentDomain.label.get();
                CurrentDomain.setDomainLabel(null);
                try {
                    if (DomainAccessHandler.this.domainInfo == null) {
                        JcNode info = new JcNode("info");
                        JcNode infos = new JcNode("infs");
                        JcNode mdl = new JcNode("mdl");
                        query = new JcQuery();
                        query.setClauses(new IClause[]{(IClause)MERGE.node(info).label(DomainAccessHandler.DomainInfoNodeLabel).property(DomainAccessHandler.DomainInfoNameProperty).value(DomainAccessHandler.this.domainName), ON_CREATE.SET(info.property(DomainAccessHandler.DomainInfoVersionProperty)).to(0), ON_CREATE.SET(info.property(DomainAccessHandler.DomainInfoModelVersionProperty)).to(0), WITH.value(info), OPTIONAL_MATCH.node(infos).label(DomainAccessHandler.DomainInfoNodeLabel), SEPARATE.nextClause(), OPTIONAL_MATCH.node(mdl).label(DomainAccessHandler.this.domainModel.getTypeNodeName()), RETURN.value(info), RETURN.value(mdl), RETURN.count().value(infos).AS(new JcNumber("infos"))});
                        context.dInfo = Exec.INIT_LOADED;
                        context.dModel = Exec.INIT_LOADED;
                    } else if (context.dInfo == Exec.RELOAD || context.dModel == Exec.RELOAD) {
                        ArrayList<Object> clauses = new ArrayList<Object>();
                        ArrayList<RSortable> returnClauses = new ArrayList<RSortable>();
                        JcNode info = new JcNode("info");
                        if (context.dInfo == Exec.RELOAD) {
                            clauses.add(MERGE.node(info).label(DomainAccessHandler.DomainInfoNodeLabel).property(DomainAccessHandler.DomainInfoNameProperty).value(DomainAccessHandler.this.domainName));
                            clauses.add(ON_CREATE.SET(info.property(DomainAccessHandler.DomainInfoVersionProperty)).to(0));
                            clauses.add(ON_CREATE.SET(info.property(DomainAccessHandler.DomainInfoModelVersionProperty)).to(0));
                            returnClauses.add(RETURN.value(info));
                            context.dInfo = Exec.RELOADED;
                        }
                        if (context.dModel == Exec.RELOAD) {
                            JcNode mdl = new JcNode("mdl");
                            if (context.dInfo == Exec.RELOADED) {
                                clauses.add(WITH.value(info));
                            }
                            clauses.add(OPTIONAL_MATCH.node(mdl).label(DomainAccessHandler.this.domainModel.getTypeNodeName()));
                            returnClauses.add(RETURN.value(mdl));
                            context.dModel = Exec.RELOADED;
                        }
                        clauses.addAll(returnClauses);
                        query = new JcQuery();
                        query.setClauses(clauses.toArray(new IClause[clauses.size()]));
                    } else if (context.dInfo == Exec.RELOAD_STORE || context.dModel == Exec.RELOAD_STORE) {
                        ArrayList<IClause> clauses = new ArrayList<IClause>();
                        ArrayList<RSortable> returnClauses = new ArrayList<RSortable>();
                        if (context.dInfo == Exec.RELOAD_STORE) {
                            JcNode info = new JcNode("info");
                            clauses.addAll(this.createDomainInfoStartClause(info));
                            clauses.add(WITH.value(info));
                            returnClauses.add(RETURN.value(info));
                            context.dInfo = Exec.RELOADED_STORE;
                        }
                        if (context.dModel == Exec.RELOAD_STORE) {
                            JcNode mdl = new JcNode("mdl");
                            clauses.add(OPTIONAL_MATCH.node(mdl).label(DomainAccessHandler.this.domainModel.getTypeNodeName()));
                            returnClauses.add(RETURN.value(mdl));
                            if (context.dInfo != Exec.RELOADED_STORE) {
                                JcNode info = new JcNode("info");
                                JcNumber m_version = new JcNumber("mv");
                                clauses.add(0, WITH.value(info));
                                clauses.addAll(0, this.createDomainInfoStartClause(info));
                                returnClauses.add((RSortable)RETURN.value(info.property(DomainAccessHandler.DomainInfoModelVersionProperty)).AS(m_version));
                            }
                            context.dModel = Exec.RELOADED_STORE;
                        }
                        clauses.addAll(returnClauses);
                        query = new JcQuery();
                        query.setClauses(clauses.toArray(new IClause[clauses.size()]));
                    } else if (context.dInfo == Exec.STORE_VERSIONS) {
                        ArrayList<IClause> diClauses = new ArrayList<IClause>();
                        ArrayList<IClause> clauses = new ArrayList<IClause>();
                        ArrayList<IClause> diReturn = new ArrayList<IClause>();
                        int[] versions = this.createDomainInfoStoreClauses(diClauses);
                        this.createReturnCodeClauses(clauses, diReturn, versions);
                        clauses.addAll(diClauses);
                        clauses.addAll(diReturn);
                        query = new JcQuery();
                        query.setClauses(clauses.toArray(new IClause[clauses.size()]));
                        context.dInfo = Exec.TRIED_STORE;
                    } else if (DomainAccessHandler.this.domainInfo.isChanged() || DomainAccessHandler.this.domainModel.hasChanged()) {
                        ArrayList<IClause> diClauses = new ArrayList<IClause>();
                        ArrayList<IClause> diReturn = new ArrayList<IClause>();
                        List<IClause>[] dmClauses = null;
                        int[] versions = this.createDomainInfoStoreClauses(diClauses);
                        if (DomainAccessHandler.this.domainModel.hasChanged()) {
                            dmClauses = DomainAccessHandler.this.domainModel.getChangeClauses();
                        }
                        ArrayList<IClause> clauses = new ArrayList<IClause>();
                        this.createReturnCodeClauses(clauses, diReturn, versions);
                        if (dmClauses != null) {
                            clauses.addAll(dmClauses[0]);
                        }
                        clauses.addAll(diClauses);
                        clauses.addAll(diReturn);
                        if (dmClauses != null) {
                            clauses.addAll(dmClauses[1]);
                        }
                        query = new JcQuery();
                        query.setClauses(clauses.toArray(new IClause[clauses.size()]));
                        context.dInfo = Exec.TRIED_STORE;
                        if (dmClauses != null) {
                            context.dModel = Exec.TRIED_STORE;
                        }
                    }
                }
                finally {
                    CurrentDomain.setDomainLabel(pLab);
                }
                if (query != null) {
                    Util.printQuery(query, QueriesPrintObserver.QueryToObserve.DOMAIN_INFO, Format.PRETTY_1);
                }
                return query;
            }

            private void createReturnCodeClauses(List<IClause> clauses, List<IClause> diReturn, int[] versions) {
                JcNode info1 = new JcNode("info1");
                clauses.addAll(this.createDomainInfoStartClause(info1));
                JcNumber retDi = new JcNumber("retDi");
                JcNumber retDm = new JcNumber("retDm");
                clauses.add(WITH.collection(C.CREATE(new IClause[]{CASE.result(), WHEN.valueOf(info1.property(DomainAccessHandler.DomainInfoVersionProperty)).EQUALS(versions[0]), NATIVE.cypher("0"), ELSE.perform(), NATIVE.cypher("1"), END.caseXpr().AS(retDi)})));
                clauses.add(WITH.collection(C.CREATE(new IClause[]{CASE.result(), WHEN.valueOf(info1.property(DomainAccessHandler.DomainInfoModelVersionProperty)).EQUALS(versions[1]), NATIVE.cypher("0"), ELSE.perform(), NATIVE.cypher("1"), END.caseXpr().AS(retDm)})));
                diReturn.add(RETURN.value(retDi));
                diReturn.add(RETURN.value(retDm));
            }

            private int[] createDomainInfoStoreClauses(List<IClause> diClauses) {
                JcNode info = new JcNode("info");
                if (DomainAccessHandler.this.domainInfo.isChanged()) {
                    List class2LabelList = DomainAccessHandler.this.domainInfo.getLabel2ClassNameStringList();
                    List fieldComponentTypeList = DomainAccessHandler.this.domainInfo.getFieldComponentTypeStringList();
                    List concreteFieldTypeList = DomainAccessHandler.this.domainInfo.getConcreteFieldTypeStringList();
                    diClauses.add(DO.SET(info.property(DomainAccessHandler.DomainInfoLabel2ClassProperty)).to(class2LabelList));
                    diClauses.add(DO.SET(info.property(DomainAccessHandler.DomainInfoFieldComponentTypeProperty)).to(fieldComponentTypeList));
                    diClauses.add(DO.SET(info.property(DomainAccessHandler.DomainInfoConcreteFieldTypeProperty)).to(concreteFieldTypeList));
                    diClauses.add(DO.SET(info.property(DomainAccessHandler.DomainInfoUseDomainLabelProperty)).to(DomainAccessHandler.this.domainInfo.useDomainLabels));
                }
                diClauses.add(DO.SET(info.property(DomainAccessHandler.DomainInfoVersionProperty)).to(DomainAccessHandler.this.domainInfo.getVersion()));
                diClauses.add(DO.SET(info.property(DomainAccessHandler.DomainInfoModelVersionProperty)).to(DomainAccessHandler.this.domainModel.getVersion()));
                int i_version = DomainAccessHandler.this.domainInfo.getVersion();
                i_version = i_version > 0 ? i_version - 1 : i_version;
                int m_version = DomainAccessHandler.this.domainModel.getVersion();
                m_version = m_version > 0 ? m_version - 1 : m_version;
                IClause[] clausesArray = diClauses.toArray(new IClause[diClauses.size()]);
                diClauses.clear();
                diClauses.addAll(this.createDomainInfoStartClause(info));
                JcValue x = new JcValue("x");
                DoConcat clause = ((EachDoConcat)FOR_EACH.element(x).IN(C.CREATE(new IClause[]{CASE.result(), WHEN.valueOf(info.property(DomainAccessHandler.DomainInfoVersionProperty)).EQUALS(i_version).AND().valueOf(info.property(DomainAccessHandler.DomainInfoModelVersionProperty)).EQUALS(m_version), NATIVE.cypher("[1]"), ELSE.perform(), NATIVE.cypher("[]"), END.caseXpr()}))).DO(clausesArray);
                diClauses.add(clause);
                return new int[]{i_version, m_version};
            }

            private void handleDomainInfo_Model(ExecContext context) {
                ExecContext ctxt = context == null ? new ExecContext() : context;
                JcQuery query = this.createDomainInfoSyncQuery(ctxt);
                if (query != null) {
                    JcQueryResult uResult = this.delegate.execute(query);
                    List<JcError> errors = Util.collectErrors(uResult);
                    if (errors.isEmpty()) {
                        this.updateDomainInfo(uResult, ctxt);
                    } else {
                        throw new JcResultException(errors, "Error on update of Domain Info!");
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private List<IClause> createDomainInfoStartClause(JcNode info) {
                String pLab = CurrentDomain.label.get();
                CurrentDomain.setDomainLabel(null);
                ArrayList<IClause> ret = new ArrayList<IClause>();
                try {
                    ret.add((IClause)MERGE.node(info).label(DomainAccessHandler.DomainInfoNodeLabel).property(DomainAccessHandler.DomainInfoNameProperty).value(DomainAccessHandler.this.domainName));
                    ret.add(ON_CREATE.SET(info.property(DomainAccessHandler.DomainInfoVersionProperty)).to(0));
                    ret.add(ON_CREATE.SET(info.property(DomainAccessHandler.DomainInfoModelVersionProperty)).to(0));
                }
                finally {
                    CurrentDomain.setDomainLabel(pLab);
                }
                return ret;
            }

            private JcQuery createCheckInfoVersionQuery(int[] versions) {
                ArrayList<IClause> clauses = new ArrayList<IClause>();
                JcNode info1 = new JcNode("info1");
                clauses.addAll(this.createDomainInfoStartClause(info1));
                JcNumber retDi = new JcNumber("retDi");
                JcNumber retDm = new JcNumber("retDm");
                clauses.add(WITH.collection(C.CREATE(new IClause[]{CASE.result(), WHEN.valueOf(info1.property(DomainAccessHandler.DomainInfoVersionProperty)).EQUALS(versions[0]), NATIVE.cypher("0"), ELSE.perform(), NATIVE.cypher("1"), END.caseXpr().AS(retDi)})));
                clauses.add(WITH.collection(C.CREATE(new IClause[]{CASE.result(), WHEN.valueOf(info1.property(DomainAccessHandler.DomainInfoModelVersionProperty)).EQUALS(versions[1]), NATIVE.cypher("0"), ELSE.perform(), NATIVE.cypher("1"), END.caseXpr().AS(retDm)})));
                clauses.add(RETURN.value(retDi));
                clauses.add(RETURN.value(retDm));
                JcQuery query = new JcQuery();
                query.setClauses(clauses.toArray(new IClause[clauses.size()]));
                return query;
            }

            private boolean reloadInfo_ModelIfNeeded(JcQueryResult result) {
                int retDm;
                JcNumber rDi = new JcNumber("retDi");
                JcNumber rDm = new JcNumber("retDm");
                int retDi = ((Number)result.resultOf(rDi).get(0)).intValue();
                if (retDi + (retDm = ((Number)result.resultOf(rDm).get(0)).intValue()) == 0) {
                    return false;
                }
                ExecContext ctxt = new ExecContext();
                if (retDi > 0) {
                    ctxt.dInfo = Exec.RELOAD;
                }
                if (retDm > 0) {
                    ctxt.dModel = Exec.RELOAD;
                }
                this.handleDomainInfo_Model(ctxt);
                return true;
            }
        }

        private class IdAndDepth {
            private long id;
            private int depth;

            private IdAndDepth(long id, int depth) {
                this.id = id;
                this.depth = depth;
            }
        }
    }

    public class GenericDomainAccess
    implements IGenericDomainAccess,
    IIntDomainAccess {
        @Override
        public List<JcError> store(DomainObject domainObject) {
            List<JcError> ret = DomainAccess.this.store(iot.jcypher.domain.genericmodel.InternalAccess.getRawObject(domainObject));
            DomainState ds = DomainAccess.this.domainAccessHandler.getDomainState();
            DomainState.LoadInfo info = ds.getLoadInfoFrom_Object2IdMap(iot.jcypher.domain.genericmodel.InternalAccess.getRawObject(domainObject));
            info.setDomainObject(domainObject);
            DomainAccess.this.domainAccessHandler.domainModel.removeNurseryObject(iot.jcypher.domain.genericmodel.InternalAccess.getRawObject(domainObject));
            return ret;
        }

        @Override
        public List<JcError> store(List<DomainObject> domainObjects) {
            ArrayList<Object> domObjs = new ArrayList<Object>(domainObjects.size());
            for (DomainObject dobj : domainObjects) {
                domObjs.add(iot.jcypher.domain.genericmodel.InternalAccess.getRawObject(dobj));
            }
            List<JcError> ret = DomainAccess.this.store(domObjs);
            DomainState ds = DomainAccess.this.domainAccessHandler.getDomainState();
            for (DomainObject dobj : domainObjects) {
                DomainState.LoadInfo info = ds.getLoadInfoFrom_Object2IdMap(iot.jcypher.domain.genericmodel.InternalAccess.getRawObject(dobj));
                info.setDomainObject(dobj);
                DomainAccess.this.domainAccessHandler.domainModel.removeNurseryObject(iot.jcypher.domain.genericmodel.InternalAccess.getRawObject(dobj));
            }
            return ret;
        }

        @Override
        public List<DomainObject> loadByIds(String domainObjectClassName, int resolutionDepth, long ... ids) {
            List objs = DomainAccess.this.domainAccessHandler.loadByIds(null, null, resolutionDepth, ids);
            List<DomainObject> ret = this.getDomainObjects(objs);
            return ret;
        }

        @Override
        public DomainObject loadById(String domainObjectClassName, int resolutionDepth, long id) {
            long[] ids = new long[]{id};
            List<DomainObject> ret = this.loadByIds(domainObjectClassName, resolutionDepth, ids);
            return ret.get(0);
        }

        @Override
        public List<DomainObject> loadByType(String domainObjectClassName, int resolutionDepth, int offset, int count) {
            List<DomainObject> ret;
            try {
                DomainAccess.this.domainAccessHandler.updateMappingsIfNeeded();
                Class<?> clazz = DomainAccess.this.domainAccessHandler.domainModel.getClassForName(domainObjectClassName);
                List<?> objs = this.getDomainAccess().loadByType(clazz, resolutionDepth, offset, count);
                ret = this.getDomainObjects(objs);
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public IDomainAccess getDomainAccess() {
            return DomainAccess.this;
        }

        private List<DomainObject> getDomainObjects(List<?> objects) {
            ArrayList<DomainObject> ret = new ArrayList<DomainObject>(objects.size());
            DomainState ds = DomainAccess.this.domainAccessHandler.getDomainState();
            for (Object obj : objects) {
                DomainState.LoadInfo lInfo = ds.getLoadInfoFrom_Object2IdMap(obj);
                DomainObject dObj = lInfo.getDomainObject();
                if (dObj == null) {
                    dObj = DomainAccess.this.domainAccessHandler.domainModel.getCreateDomainObjectFor(obj);
                    lInfo.setDomainObject(dObj);
                }
                ret.add(dObj);
            }
            return ret;
        }

        private DomainObject getDomainObject(Object obj) {
            DomainState ds = DomainAccess.this.domainAccessHandler.getDomainState();
            DomainState.LoadInfo lInfo = ds.getLoadInfoFrom_Object2IdMap(obj);
            if (lInfo != null) {
                DomainObject dObj = lInfo.getDomainObject();
                if (dObj == null) {
                    dObj = DomainAccess.this.domainAccessHandler.domainModel.getCreateDomainObjectFor(obj);
                    lInfo.setDomainObject(dObj);
                }
                return dObj;
            }
            return null;
        }

        @Override
        public DOTypeBuilderFactory getTypeBuilderFactory() {
            return DomainAccess.this.domainAccessHandler.domainModel.getTypeBuilderFactory();
        }

        @Override
        public DOType getDomainObjectType(String typeName) {
            DomainAccess.this.domainAccessHandler.updateMappingsIfNeeded();
            return DomainAccess.this.domainAccessHandler.domainModel.getDOType(typeName);
        }

        @Override
        public List<SyncInfo> getSyncInfos(List<DomainObject> domainObjects) {
            ArrayList<Object> dobjs = new ArrayList<Object>(domainObjects.size());
            for (DomainObject dobj : domainObjects) {
                dobjs.add(iot.jcypher.domain.genericmodel.InternalAccess.getRawObject(dobj));
            }
            return DomainAccess.this.getSyncInfos(dobjs);
        }

        @Override
        public SyncInfo getSyncInfo(DomainObject domainObject) {
            return DomainAccess.this.getSyncInfo(iot.jcypher.domain.genericmodel.InternalAccess.getRawObject(domainObject));
        }

        @Override
        public long numberOfInstancesOf(String typeName) {
            try {
                DomainAccess.this.domainAccessHandler.updateMappingsIfNeeded();
                Class<?> typ = DomainAccess.this.domainAccessHandler.domainModel.getClassForName(typeName);
                return DomainAccess.this.numberOfInstancesOf(typ);
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }

        @Override
        public List<Long> numberOfInstancesOf(List<String> typeNames) {
            try {
                DomainAccess.this.domainAccessHandler.updateMappingsIfNeeded();
                ArrayList typs = new ArrayList(typeNames.size());
                for (String tn : typeNames) {
                    Class<?> typ = DomainAccess.this.domainAccessHandler.domainModel.getClassForName(tn);
                    typs.add(typ);
                }
                return DomainAccess.this.numberOfInstancesOf(typs);
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }

        @Override
        public GDomainQuery createQuery() {
            GDomainQuery ret = new GDomainQuery(DomainAccess.this);
            QueryRecorder.recordCreateQuery(ret);
            InternalAccess.recordQuery(ret, QueryRecorder.getRecordedQuery(ret));
            return ret;
        }

        @Override
        public List<String> getStoredQueryNames() {
            return DomainAccess.this.domainAccessHandler.getStoredQueryNames();
        }

        @Override
        public QueryPersistor createQueryPersistor(GDomainQuery query) {
            return InternalAccess.createQueryPersistor(query, this);
        }

        @Override
        public QueryLoader<GDomainQuery> createQueryLoader(String queryName) {
            return InternalAccess.createQueryLoader(queryName, this);
        }

        private GDomainQuery createRecordedQuery(ReplayedQueryContext rqc, boolean doRecord) {
            GDomainQuery ret = new GDomainQuery(DomainAccess.this);
            QueryRecorder.recordCreateQuery(ret);
            if (doRecord) {
                InternalAccess.recordQuery(ret, QueryRecorder.getRecordedQuery(ret));
            }
            InternalAccess.replayQuery(ret, rqc);
            return ret;
        }

        @Override
        public ITransaction beginTX() {
            return DomainAccess.this.beginTX();
        }

        @Override
        public IGenericDomainAccess setLockingStrategy(Locking locking) {
            DomainAccess.this.domainAccessHandler.lockingStrategy = locking;
            return this;
        }

        @Override
        public InternalDomainAccess getInternalDomainAccess() {
            return DomainAccess.this.getInternalDomainAccess();
        }
    }
}

