/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domain.mapping;

import iot.jcypher.domain.mapping.CompoundObjectType;
import iot.jcypher.domain.mapping.FieldMapping;
import iot.jcypher.domain.mapping.ObjectMapping;
import iot.jcypher.domain.mapping.surrogate.InnerClassSurrogate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class CompoundObjectMapping
extends ObjectMapping {
    private CompoundObjectType compoundObjectType;
    private Map<Class<?>, ObjectMapping> typeMappings;
    private HashSet<FieldMapping> fieldsToAccept;

    public CompoundObjectMapping(CompoundObjectType compoundObjectType, Map<Class<?>, ObjectMapping> typeMappings, Object toAccept) {
        this.compoundObjectType = compoundObjectType;
        this.typeMappings = typeMappings;
        if (toAccept != null) {
            Class<?> toAcc = toAccept.getClass();
            if (toAccept instanceof InnerClassSurrogate) {
                toAcc = ((InnerClassSurrogate)toAccept).getRealClass();
            }
            this.fieldsToAccept = new HashSet();
            Iterator<FieldMapping> it = typeMappings.get(toAcc).fieldMappingsIterator();
            while (it.hasNext()) {
                this.fieldsToAccept.add(it.next());
            }
        } else {
            this.fieldsToAccept = null;
        }
    }

    @Override
    public Iterator<FieldMapping> fieldMappingsIterator() {
        return new FieldMappingIterator();
    }

    @Override
    public boolean shouldPerformFieldMapping(FieldMapping fieldMapping) {
        return this.fieldsToAccept == null || this.fieldsToAccept.contains(fieldMapping);
    }

    @Override
    public FieldMapping getFieldMappingForField(String fieldName) {
        throw new RuntimeException("not suppported");
    }

    static /* synthetic */ CompoundObjectType access$000(CompoundObjectMapping x0) {
        return x0.compoundObjectType;
    }

    public class FieldMappingIterator
    implements Iterator<FieldMapping> {
        private HashSet<FieldMapping> fieldMappingsSet = new HashSet();
        private Iterator<CompoundObjectType> typeIterator = CompoundObjectMapping.access$000(CompoundObjectMapping.this).typeIterator();
        private Iterator<FieldMapping> currentTypeFieldIterator;
        private FieldMapping nextFieldMapping;

        @Override
        public boolean hasNext() {
            this.nextFieldMapping = null;
            if (this.currentTypeFieldIterator == null) {
                this.switchToNextType();
            }
            if (this.currentTypeFieldIterator != null) {
                while (this.currentTypeFieldIterator.hasNext()) {
                    FieldMapping next = this.currentTypeFieldIterator.next();
                    if (!this.fieldMappingsSet.add(next)) continue;
                    this.nextFieldMapping = next;
                    return true;
                }
                this.currentTypeFieldIterator = null;
                return this.hasNext();
            }
            return false;
        }

        @Override
        public FieldMapping next() {
            return this.nextFieldMapping;
        }

        @Override
        public void remove() {
            throw new RuntimeException("operation not supported");
        }

        private void switchToNextType() {
            while (this.typeIterator.hasNext()) {
                CompoundObjectType cType = this.typeIterator.next();
                Class<?> typ = cType.getType();
                ObjectMapping om = (ObjectMapping)CompoundObjectMapping.this.typeMappings.get(typ);
                if (om == null) continue;
                this.currentTypeFieldIterator = om.fieldMappingsIterator();
                return;
            }
            this.currentTypeFieldIterator = null;
        }
    }
}

