/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domain.mapping;

import iot.jcypher.domain.mapping.MappingUtil;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CompoundObjectType {
    public static final String SEPARATOR = ", ";
    private Class<?> type;
    private CType cType;
    private CompoundObjectType next;

    public CompoundObjectType(Class<?> type) {
        this.type = type;
        this.cType = MappingUtil.mapsToProperty(type) ? CType.SIMPLE : CType.COMPLEX;
    }

    public boolean addType(Class<?> typ) {
        CompoundObjectType nextOne;
        CompoundObjectType cur = null;
        Iterator<CompoundObjectType> it = this.typeIterator();
        while (it.hasNext()) {
            cur = it.next();
            if (!cur.type.equals(typ)) continue;
            return false;
        }
        cur.next = nextOne = new CompoundObjectType(typ);
        CType t = nextOne.cType;
        it = this.typeIterator();
        while (it.hasNext()) {
            cur = it.next();
            if (cur.cType == t) continue;
            cur.cType = CType.MIXED;
        }
        return true;
    }

    public Class<?> getType() {
        return this.type;
    }

    public List<Class<?>> getTypes(boolean noAbstractTypes) {
        ArrayList typeList = new ArrayList();
        this.addType(typeList, noAbstractTypes);
        return typeList;
    }

    public CType getCType() {
        return this.cType;
    }

    public Iterator<CompoundObjectType> typeIterator() {
        return new TypeIterator();
    }

    public String getTypeListString() {
        StringBuilder sb = new StringBuilder();
        Iterator<CompoundObjectType> it = this.typeIterator();
        int idx = 0;
        while (it.hasNext()) {
            if (idx > 0) {
                sb.append(SEPARATOR);
            }
            sb.append(it.next().type.getName());
            ++idx;
        }
        return sb.toString();
    }

    private void addType(List<Class<?>> typeList, boolean noAbstractTypes) {
        if (!noAbstractTypes || CompoundObjectType.isConcrete(this.type)) {
            typeList.add(this.type);
        }
        if (this.next != null) {
            this.next.addType(typeList, noAbstractTypes);
        }
    }

    public static boolean isConcrete(Class<?> typ) {
        return !typ.isInterface() && !Modifier.isAbstract(typ.getModifiers()) && !typ.equals(Object.class);
    }

    public static enum CType {
        SIMPLE,
        COMPLEX,
        MIXED;

    }

    public class TypeIterator
    implements Iterator<CompoundObjectType> {
        CompoundObjectType current;

        TypeIterator() {
            this.current = CompoundObjectType.this;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public CompoundObjectType next() {
            CompoundObjectType ctype = this.current;
            if (ctype != null) {
                this.current = ctype.next;
            }
            return ctype;
        }

        @Override
        public void remove() {
            throw new RuntimeException("operation not supported");
        }
    }
}

