/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domain.mapping.surrogate;

import iot.jcypher.domain.mapping.surrogate.IDeferred;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractDeferred
implements IDeferred {
    protected List<IDeferred> upInTree;
    protected List<IDeferred> downInTree = new ArrayList<IDeferred>();

    public AbstractDeferred() {
        this.upInTree = new ArrayList<IDeferred>();
    }

    @Override
    public boolean isLeaf() {
        return this.downInTree.isEmpty();
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public Iterator<IDeferred> nextUp() {
        return this.upInTree.iterator();
    }

    @Override
    public void addNextUpInTree(IDeferred deferred) {
        if (!this.upInTree.contains(deferred)) {
            this.upInTree.add(deferred);
            ((AbstractDeferred)deferred).addDownInTree(this);
        }
    }

    public void addDownInTree(IDeferred dit) {
        this.downInTree.add(dit);
    }

    @Override
    public void modifiedBy(IDeferred changer) {
        this.downInTree.remove(changer);
    }

    public void removeFromDownTree(IDeferred def) {
        this.downInTree.remove(def);
    }

    public void removeFromUpTree(IDeferred def) {
        this.upInTree.remove(def);
    }

    protected void modifyNextUp() {
        for (IDeferred def : this.upInTree) {
            def.modifiedBy(this);
        }
    }

    @Override
    public void breakLoops() {
        LoopContext context = new LoopContext();
        this.detectLoops(context);
    }

    private void detectLoops(LoopContext context) {
        context.addToPath(this);
        this.walkDown(context);
        context.removePathElement(this);
    }

    private void walkDown(LoopContext context) {
        int sz = this.downInTree.size();
        for (int i = sz - 1; i >= 0; --i) {
            IDeferred def = this.downInTree.get(i);
            IDeferred lpc = context.findLoopConnector(def);
            if (lpc != null) {
                this.removeFromDownTree(lpc);
                ((AbstractDeferred)lpc).removeFromUpTree(this);
                continue;
            }
            ((AbstractDeferred)def).detectLoops(context);
        }
    }

    private static class LoopContext {
        private List<IDeferred> path = new ArrayList<IDeferred>();

        private void addToPath(IDeferred deferred) {
            if (this.path.contains(deferred)) {
                throw new RuntimeException("error in add to path");
            }
            this.path.add(deferred);
        }

        private void removePathElement(IDeferred deferred) {
            int level = this.path.size() - 1;
            IDeferred def = this.path.remove(level);
            if (!deferred.equals(def)) {
                throw new RuntimeException("error in remove from path");
            }
        }

        private IDeferred findLoopConnector(IDeferred deferred) {
            for (IDeferred def : this.path) {
                if (!def.equals(deferred)) continue;
                return def;
            }
            return null;
        }
    }
}

