/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domain.mapping.surrogate;

import iot.jcypher.domain.mapping.DomainState;
import iot.jcypher.domain.mapping.surrogate.AbstractSurrogate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class SurrogateState {
    private Map<Surrogate_Key, ReferredSurrogate<?>> map2SurrogateMap = new HashMap();

    public SurrogateState createCopy(Map<DomainState.IRelation, DomainState.IRelation> copiedRels, DomainState ds) {
        SurrogateState ret = new SurrogateState();
        IdentityHashMap<Surrogate_Key, Surrogate_Key> copiedSurrks = new IdentityHashMap<Surrogate_Key, Surrogate_Key>();
        IdentityHashMap copiedRefSurrs = new IdentityHashMap();
        for (Map.Entry<Surrogate_Key, ReferredSurrogate<?>> entry : this.map2SurrogateMap.entrySet()) {
            ret.map2SurrogateMap.put(this.copySurrks(entry.getKey(), copiedSurrks), this.copyRefSurr(entry.getValue(), copiedRefSurrs, copiedRels, ds));
        }
        return ret;
    }

    private ReferredSurrogate<?> copyRefSurr(ReferredSurrogate<?> toCopy, Map<ReferredSurrogate<?>, ReferredSurrogate<?>> copiedRefSurrs, Map<DomainState.IRelation, DomainState.IRelation> copiedRels, DomainState ds) {
        ReferredSurrogate<Object> ret = copiedRefSurrs.get(toCopy);
        if (ret == null) {
            ret = new ReferredSurrogate<AbstractSurrogate>(((ReferredSurrogate)toCopy).surrogate);
            for (DomainState.IRelation rel : ((ReferredSurrogate)toCopy).references) {
                DomainState.IRelation crel = this.copyRelation(rel, copiedRels, ds);
                ((ReferredSurrogate)ret).references.add(crel);
            }
            copiedRefSurrs.put(toCopy, ret);
        }
        return ret;
    }

    private <T extends DomainState.IRelation> T copyRelation(T toCopy, Map<DomainState.IRelation, DomainState.IRelation> copiedRels, DomainState ds) {
        DomainState.IRelation crel = copiedRels.get(toCopy);
        if (crel == null) {
            crel = toCopy.createCopy(ds);
            copiedRels.put(toCopy, crel);
        }
        return (T)crel;
    }

    private Surrogate_Key copySurrks(Surrogate_Key toCopy, Map<Surrogate_Key, Surrogate_Key> copiedSurrks) {
        Surrogate_Key ret = copiedSurrks.get(toCopy);
        if (ret == null) {
            ret = new Surrogate_Key(toCopy.original);
            copiedSurrks.put(toCopy, ret);
        }
        return ret;
    }

    private <T extends AbstractSurrogate> void addOriginal2ReferredSurrogate(Object original, ReferredSurrogate<T> refMap) {
        this.map2SurrogateMap.put(new Surrogate_Key(original), refMap);
    }

    private ReferredSurrogate getReferredSurrogate(Object original) {
        return this.map2SurrogateMap.get(new Surrogate_Key(original));
    }

    public <T extends AbstractSurrogate> void addOriginal2Surrogate(Object original, T surrogate) {
        ReferredSurrogate<T> refSurrogate = this.getReferredSurrogate(original);
        if (refSurrogate != null && refSurrogate.getSurrogate() != surrogate) {
            throw new RuntimeException("error existing surrogate map");
        }
        if (refSurrogate == null) {
            refSurrogate = new ReferredSurrogate<T>(surrogate);
            this.addOriginal2ReferredSurrogate(original, refSurrogate);
        }
    }

    public <T extends AbstractSurrogate> T getCreateSurrogateFor(Object original, Class<T> surrogateClass) {
        ReferredSurrogate<AbstractSurrogate> refSurrogate = this.getReferredSurrogate(original);
        if (refSurrogate == null) {
            refSurrogate = new ReferredSurrogate<AbstractSurrogate>(AbstractSurrogate.createSurrogate(original));
            this.addOriginal2ReferredSurrogate(original, refSurrogate);
        }
        return refSurrogate.getSurrogate();
    }

    public void addReference(DomainState.IRelation ref) {
        ReferredSurrogate refSurrogate;
        Object target = ref.getEnd();
        if (target instanceof AbstractSurrogate && (refSurrogate = this.getReferredSurrogate(((AbstractSurrogate)target).getContent())) != null) {
            refSurrogate.addReference(ref);
        }
    }

    public void removeReference(DomainState.IRelation ref) {
        ReferredSurrogate refSurrogate;
        Object target = ref.getEnd();
        if (target instanceof AbstractSurrogate && (refSurrogate = this.getReferredSurrogate(((AbstractSurrogate)target).getContent())) != null) {
            refSurrogate.removeReference(ref);
        }
    }

    public void removeUnreferenced() {
        ArrayList<Surrogate_Key> toRemove = new ArrayList<Surrogate_Key>();
        for (Map.Entry<Surrogate_Key, ReferredSurrogate<?>> entry : this.map2SurrogateMap.entrySet()) {
            if (entry.getValue().getReferenceCount() != 0) continue;
            toRemove.add(entry.getKey());
        }
        for (Surrogate_Key k : toRemove) {
            this.map2SurrogateMap.remove(k);
        }
    }

    public int size() {
        return this.map2SurrogateMap.size();
    }

    public static class ReferredSurrogate<T extends AbstractSurrogate> {
        private T surrogate;
        private List<DomainState.IRelation> references;

        public ReferredSurrogate(T surrogate) {
            this.surrogate = surrogate;
            this.references = new ArrayList<DomainState.IRelation>();
        }

        public T getSurrogate() {
            return this.surrogate;
        }

        public void addReference(DomainState.IRelation reference) {
            if (!this.references.contains(reference)) {
                this.references.add(reference);
            }
        }

        public void removeReference(DomainState.IRelation reference) {
            this.references.remove(reference);
        }

        public int getReferenceCount() {
            return this.references.size();
        }
    }

    public static class Surrogate_Key {
        private Object original;

        private Surrogate_Key(Object org) {
            this.original = org;
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Surrogate_Key)) {
                return false;
            }
            Surrogate_Key e = (Surrogate_Key)o;
            Object k1 = this.original;
            Object k2 = e.original;
            return k1 == k2;
        }

        public final int hashCode() {
            if (this.original instanceof Map) {
                return 0;
            }
            return 1;
        }
    }
}

