/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domainquery;

import iot.jcypher.domainquery.AbstractDomainQuery;
import iot.jcypher.domainquery.InternalAccess;
import iot.jcypher.domainquery.api.APIAccess;
import iot.jcypher.domainquery.api.DomainObjectMatch;
import iot.jcypher.domainquery.internal.QueryRecorder;

public class CountQueryResult {
    private AbstractDomainQuery domainQuery;

    CountQueryResult(AbstractDomainQuery domainQuery) {
        this.domainQuery = domainQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countOf(DomainObjectMatch<?> match) {
        long ret;
        Object so = InternalAccess.getQueryExecutor(this.domainQuery).getMappingInfo().getInternalDomainAccess().getSyncObject();
        if (so != null) {
            Object object = so;
            synchronized (object) {
                ret = this.intCountOf(match);
            }
        } else {
            ret = this.intCountOf(match);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long intCountOf(DomainObjectMatch<?> match) {
        long ret;
        if (this.domainQuery.getQueryExecutor().hasBeenReplayed()) {
            ret = this.domainQuery.getQueryExecutor().getReplayedCountResult(match);
        } else {
            Boolean br_old = QueryRecorder.blockRecording.get();
            try {
                QueryRecorder.blockRecording.set(Boolean.TRUE);
                DomainObjectMatch<?> delegate = APIAccess.getDelegate(match);
                ret = delegate != null ? this.domainQuery.getQueryExecutor().getCountResult(delegate) : this.domainQuery.getQueryExecutor().getCountResult(match);
            }
            finally {
                QueryRecorder.blockRecording.set(br_old);
            }
        }
        return ret;
    }

    AbstractDomainQuery getDomainQuery() {
        return this.domainQuery;
    }
}

