/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domainquery;

import iot.jcypher.database.IDBAccess;
import iot.jcypher.domain.IDomainAccess;
import iot.jcypher.domain.IGenericDomainAccess;
import iot.jcypher.domain.internal.IIntDomainAccess;
import iot.jcypher.domainquery.AbstractDomainQuery;
import iot.jcypher.domainquery.InternalAccess;
import iot.jcypher.domainquery.QueryMemento;
import iot.jcypher.domainquery.api.APIAccess;
import iot.jcypher.domainquery.api.DomainObjectMatch;
import iot.jcypher.domainquery.internal.JSONConverter;
import iot.jcypher.domainquery.internal.QueryExecutor;
import iot.jcypher.domainquery.internal.RecordedQuery;
import iot.jcypher.domainquery.internal.RecordedQueryPlayer;
import iot.jcypher.domainquery.internal.ReplayedQueryContext;
import iot.jcypher.graph.GrNode;
import iot.jcypher.query.JcQuery;
import iot.jcypher.query.JcQueryResult;
import iot.jcypher.query.api.IClause;
import iot.jcypher.query.factories.clause.MATCH;
import iot.jcypher.query.factories.clause.RETURN;
import iot.jcypher.query.values.JcNode;
import iot.jcypher.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class QueryLoader<T> {
    private Object domainAccess;
    private String queryName;
    private ReplayedQueryContext replayedQueryContext;

    QueryLoader(String qName, Object domAccess) {
        this.queryName = qName;
        this.domainAccess = domAccess;
    }

    public T load() {
        QueryMemento qm = this.loadMemento();
        if (qm != null) {
            RecordedQuery rq = new JSONConverter().fromJSON(qm.getQueryJSON());
            RecordedQueryPlayer qp = new RecordedQueryPlayer(true);
            AbstractDomainQuery q = this.isGeneric() ? qp.replayGenericQuery(rq, (IGenericDomainAccess)this.domainAccess) : qp.replayQuery(rq, (IDomainAccess)this.domainAccess);
            this.replayedQueryContext = ((AbstractDomainQuery)q).getReplayedQueryContext();
            QueryExecutor qe = InternalAccess.getQueryExecutor(q);
            qe.queryCreationCompleted(true);
            return (T)q;
        }
        return null;
    }

    public QueryMemento loadMemento() {
        IDBAccess dbAccess = ((IIntDomainAccess)this.domainAccess).getInternalDomainAccess().getDBAccess();
        String qLabel = ((IIntDomainAccess)this.domainAccess).getInternalDomainAccess().getDomainLabel().concat("_query");
        JcNode n = new JcNode("n");
        IClause[] clauses = new IClause[]{(IClause)MATCH.node(n).label(qLabel).property("name").value(this.queryName), RETURN.value(n)};
        JcQuery q = new JcQuery();
        q.setClauses(clauses);
        JcQueryResult result = dbAccess.execute(q);
        if (result.hasErrors()) {
            StringBuilder sb = new StringBuilder();
            Util.appendErrorList(Util.collectErrors(result), sb);
            throw new RuntimeException(sb.toString());
        }
        List<GrNode> lgn = result.resultOf(n);
        if (lgn.size() > 0) {
            GrNode gn = lgn.get(0);
            String qJava = gn.getProperty("queryJava").getValue().toString();
            String qJSON = gn.getProperty("queryJSON").getValue().toString();
            QueryMemento qm = new QueryMemento(qJava, qJSON);
            return qm;
        }
        return null;
    }

    public List<String> getAugmentedDOMNames() {
        List<String> dNames;
        if (this.replayedQueryContext.getRecordedQuery().getAugmentations() != null) {
            dNames = new ArrayList<String>(this.replayedQueryContext.getRecordedQuery().getAugmentations().values());
            Collections.sort(dNames);
        } else {
            dNames = Collections.emptyList();
        }
        return dNames;
    }

    public List<String> getInternalDOMNames() {
        ArrayList<String> dNames = new ArrayList<String>(this.replayedQueryContext.getId2DomainObjectMatch().keySet());
        Collections.sort(dNames);
        return dNames;
    }

    public DomainObjectMatch<?> getDomainObjectMatch(String name) {
        DomainObjectMatch<?> ret = null;
        if (this.replayedQueryContext.getRecordedQuery().getAugmentations() != null) {
            for (Map.Entry<String, String> entry : this.replayedQueryContext.getRecordedQuery().getAugmentations().entrySet()) {
                if (!entry.getValue().equals(name)) continue;
                ret = this.replayedQueryContext.getById(entry.getKey());
                break;
            }
        }
        if (ret == null) {
            ret = this.replayedQueryContext.getById(name);
        }
        return ret;
    }

    public <E> DomainObjectMatch<E> getDomainObjectMatch(String name, Class<E> type) {
        DomainObjectMatch<?> dom = this.getDomainObjectMatch(name);
        Class<?> typ = APIAccess.getDomainObjectType(dom);
        if (!type.isAssignableFrom(typ)) {
            throw new ClassCastException();
        }
        return dom;
    }

    private boolean isGeneric() {
        return this.domainAccess instanceof IGenericDomainAccess;
    }
}

