/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domainquery;

import iot.jcypher.database.IDBAccess;
import iot.jcypher.domain.internal.IIntDomainAccess;
import iot.jcypher.domainquery.AbstractDomainQuery;
import iot.jcypher.domainquery.InternalAccess;
import iot.jcypher.domainquery.QueryMemento;
import iot.jcypher.domainquery.api.APIAccess;
import iot.jcypher.domainquery.api.DomainObjectMatch;
import iot.jcypher.domainquery.internal.JSONConverter;
import iot.jcypher.domainquery.internal.QueryRecorder;
import iot.jcypher.domainquery.internal.RecordedQuery;
import iot.jcypher.query.JcQuery;
import iot.jcypher.query.JcQueryResult;
import iot.jcypher.query.api.IClause;
import iot.jcypher.query.factories.clause.DO;
import iot.jcypher.query.factories.clause.MERGE;
import iot.jcypher.query.values.JcNode;
import iot.jcypher.query.writer.Format;
import iot.jcypher.util.Util;
import java.util.HashMap;
import java.util.Map;

public class QueryPersistor {
    public static final String Q_LABEL_POSTFIX = "_query";
    public static final String PROP_NAME = "name";
    static final String PROP_Q_JSON = "queryJSON";
    static final String PROP_Q_JAVA = "queryJava";
    private AbstractDomainQuery query;
    private Object domainAccess;
    private Map<DomainObjectMatch<?>, String> augmentations;
    private Format prettyFormat;

    QueryPersistor(AbstractDomainQuery query, Object domAccess) {
        this.query = query;
        this.domainAccess = domAccess;
        this.prettyFormat = Format.NONE;
    }

    public QueryMemento createMemento() {
        RecordedQuery rq = this.query.getRecordedQuery();
        if (this.augmentations != null) {
            Map<Object, String> domMap = InternalAccess.getRecordedQueryObjects(this.query);
            HashMap<String, String> augments = new HashMap<String, String>();
            for (Map.Entry<DomainObjectMatch<?>, String> entry : this.augmentations.entrySet()) {
                DomainObjectMatch<?> dom = entry.getKey();
                DomainObjectMatch<?> delegate = APIAccess.getDelegate(dom);
                if (delegate != null) {
                    dom = delegate;
                }
                augments.put(domMap.get(dom), entry.getValue());
            }
            rq.setAugmentations(augments);
        }
        QueryMemento ret = new QueryMemento(rq.toString(), new JSONConverter().setPrettyFormat(this.prettyFormat).toJSON(rq));
        return ret;
    }

    public void storeAs(String queryName) {
        QueryRecorder.queryCompleted(this.query);
        QueryMemento qm = this.createMemento();
        IDBAccess dbAccess = ((IIntDomainAccess)this.domainAccess).getInternalDomainAccess().getDBAccess();
        String qLabel = ((IIntDomainAccess)this.domainAccess).getInternalDomainAccess().getDomainLabel().concat(Q_LABEL_POSTFIX);
        JcNode n = new JcNode("n");
        IClause[] clauses = new IClause[]{(IClause)MERGE.node(n).label(qLabel).property(PROP_NAME).value(queryName), DO.SET(n.property(PROP_Q_JAVA)).to(qm.getQueryJava()), DO.SET(n.property(PROP_Q_JSON)).to(qm.getQueryJSON())};
        JcQuery q = new JcQuery();
        q.setClauses(clauses);
        JcQueryResult result = dbAccess.execute(q);
        if (result.hasErrors()) {
            StringBuilder sb = new StringBuilder();
            Util.appendErrorList(Util.collectErrors(result), sb);
            throw new RuntimeException(sb.toString());
        }
    }

    public QueryPersistor augment(DomainObjectMatch<?> domainObjectMatch, String as) {
        if (this.augmentations == null) {
            this.augmentations = new HashMap();
        }
        this.augmentations.put(domainObjectMatch, as);
        return this;
    }

    public QueryPersistor setPrettyFormat(Format prettyFormat) {
        this.prettyFormat = prettyFormat;
        return this;
    }
}

