/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domainquery.api;

import iot.jcypher.domain.genericmodel.DomainObject;
import iot.jcypher.domain.internal.DomainAccess;
import iot.jcypher.domain.mapping.FieldMapping;
import iot.jcypher.domain.mapping.MappingUtil;
import iot.jcypher.domainquery.api.APIAccess;
import iot.jcypher.domainquery.api.Count;
import iot.jcypher.domainquery.api.IPredicateOperand1;
import iot.jcypher.domainquery.ast.UnionExpression;
import iot.jcypher.domainquery.internal.QueryExecutor;
import iot.jcypher.domainquery.internal.QueryRecorder;
import iot.jcypher.query.values.JcBoolean;
import iot.jcypher.query.values.JcCollection;
import iot.jcypher.query.values.JcNode;
import iot.jcypher.query.values.JcNumber;
import iot.jcypher.query.values.JcProperty;
import iot.jcypher.query.values.JcString;
import iot.jcypher.query.values.JcValue;
import iot.jcypher.query.values.ValueAccess;
import java.util.ArrayList;
import java.util.List;

public class DomainObjectMatch<T>
implements IPredicateOperand1 {
    private static final String separator = "_";
    private static final String msg_1 = "attributes used in WHERE clauses must be of simple type. Not true for attribute [";
    private DomainObjectMatch<?> delegate;
    private DomainObjectMatch<?> traversalSource;
    private List<DomainObjectMatch<?>> collectExpressionOwner;
    private Class<T> domainObjectType;
    private String baseNodeName;
    private List<JcNode> nodes;
    private List<Class<?>> typeList;
    private QueryExecutor.MappingInfo mappingInfo;
    private int pageOffset;
    private int pageLength;
    private boolean pageChanged;
    private boolean partOfReturn;
    private UnionExpression unionExpression;

    DomainObjectMatch(Class<T> targetType, int num, QueryExecutor.MappingInfo mappingInfo) {
        this.domainObjectType = targetType;
        this.mappingInfo = mappingInfo;
        this.pageLength = -1;
        this.pageOffset = 0;
        this.pageChanged = false;
        this.partOfReturn = true;
        this.init(num);
    }

    DomainObjectMatch(Class<T> targetType, DomainObjectMatch<?> delegate) {
        if (targetType != DomainObject.class) {
            throw new RuntimeException("targetType must be DomainObject.class");
        }
        this.delegate = delegate;
        this.domainObjectType = targetType;
    }

    private void init(int num) {
        this.baseNodeName = "n_".concat(String.valueOf(num));
        this.typeList = this.mappingInfo.getCompoundTypesFor(this.domainObjectType);
        this.nodes = new ArrayList<JcNode>(this.typeList.size());
        for (int i = 0; i < this.typeList.size(); ++i) {
            this.nodes.add(new JcNode(this.baseNodeName.concat(separator).concat(String.valueOf(i))));
        }
    }

    public Count COUNT() {
        if (this.delegate != null) {
            return this.delegate.COUNT();
        }
        Count ret = APIAccess.createCount(this);
        QueryRecorder.recordInvocationNoConcat(this, "COUNT", ret, new Object[0]);
        return ret;
    }

    public JcProperty atttribute(String name) {
        if (this.delegate != null) {
            return this.delegate.atttribute(name);
        }
        JcProperty ret = this.checkField_getJcVal(name, JcProperty.class);
        QueryRecorder.recordInvocationReplace(this, ret, "atttribute");
        return ret;
    }

    public JcString stringAtttribute(String name) {
        if (this.delegate != null) {
            return this.delegate.stringAtttribute(name);
        }
        JcString ret = this.checkField_getJcVal(name, JcString.class);
        QueryRecorder.recordInvocationReplace(this, ret, "stringAtttribute");
        return ret;
    }

    public JcNumber numberAtttribute(String name) {
        if (this.delegate != null) {
            return this.delegate.numberAtttribute(name);
        }
        JcNumber ret = this.checkField_getJcVal(name, JcNumber.class);
        QueryRecorder.recordInvocationReplace(this, ret, "numberAtttribute");
        return ret;
    }

    public JcBoolean booleanAtttribute(String name) {
        if (this.delegate != null) {
            return this.delegate.booleanAtttribute(name);
        }
        JcBoolean ret = this.checkField_getJcVal(name, JcBoolean.class);
        QueryRecorder.recordInvocationReplace(this, ret, "booleanAtttribute");
        return ret;
    }

    public JcCollection collectionAtttribute(String name) {
        if (this.delegate != null) {
            return this.delegate.collectionAtttribute(name);
        }
        JcCollection ret = this.checkField_getJcVal(name, JcCollection.class);
        QueryRecorder.recordInvocationReplace(this, ret, "collectionAtttribute");
        return ret;
    }

    public void setPage(int offset, int length) {
        if (this.delegate != null) {
            this.delegate.setPage(offset, length);
        } else {
            boolean changed;
            boolean bl = changed = this.pageOffset != offset || this.pageLength != length;
            if (changed) {
                this.pageOffset = offset;
                this.pageLength = length;
                this.pageChanged = true;
            }
        }
        QueryRecorder.recordInvocation(this, "setPage", Void.TYPE, QueryRecorder.literal(offset), QueryRecorder.literal(length));
    }

    Class<T> getDomainObjectType() {
        return this.domainObjectType;
    }

    List<JcNode> getNodes() {
        return this.nodes;
    }

    List<Class<?>> getTypeList() {
        return this.typeList;
    }

    QueryExecutor.MappingInfo getMappingInfo() {
        return this.mappingInfo;
    }

    String getBaseNodeName() {
        return this.baseNodeName;
    }

    boolean isPageChanged() {
        return this.pageChanged;
    }

    void setPageChanged(boolean pageChanged) {
        this.pageChanged = pageChanged;
    }

    int getPageOffset() {
        return this.pageOffset;
    }

    int getPageLength() {
        return this.pageLength;
    }

    boolean isPartOfReturn() {
        return this.partOfReturn;
    }

    void setPartOfReturn(boolean partOfReturn) {
        this.partOfReturn = partOfReturn;
    }

    Class<?> getTypeForNodeName(String nodeName) {
        int idx = -1;
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (!ValueAccess.getName(this.nodes.get(i)).equals(nodeName)) continue;
            idx = i;
            break;
        }
        if (idx != -1) {
            return this.typeList.get(idx);
        }
        return null;
    }

    private String getPropertyOrRelationName(FieldMapping fm) {
        if (fm != null) {
            return fm.getPropertyOrRelationName();
        }
        return null;
    }

    DomainObjectMatch<?> getTraversalSource() {
        return this.traversalSource;
    }

    void setTraversalSource(DomainObjectMatch<?> traversalSource) {
        this.traversalSource = traversalSource;
    }

    UnionExpression getUnionExpression() {
        return this.unionExpression;
    }

    void setUnionExpression(UnionExpression unionExpression) {
        this.unionExpression = unionExpression;
    }

    List<DomainObjectMatch<?>> getCollectExpressionOwner() {
        return this.collectExpressionOwner;
    }

    void addCollectExpressionOwner(DomainObjectMatch<?> dom) {
        if (this.collectExpressionOwner == null) {
            this.collectExpressionOwner = new ArrayList();
        }
        if (!this.collectExpressionOwner.contains(dom)) {
            this.collectExpressionOwner.add(dom);
        }
    }

    JcValue getCloneOf(JcValue val) {
        String nm = ValueAccess.getName(val);
        return (JcValue)this.checkField_getJcVal(nm, val.getClass());
    }

    DomainObjectMatch<T> create(int num, QueryExecutor.MappingInfo mappingInf) {
        return new DomainObjectMatch<T>(this.domainObjectType, num, mappingInf);
    }

    DomainObjectMatch<?> getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needsRelation(FieldMapping fm) {
        boolean ret;
        DomainAccess.InternalDomainAccess internalAccess = null;
        try {
            internalAccess = MappingUtil.internalDomainAccess.get();
            MappingUtil.internalDomainAccess.set(this.mappingInfo.getInternalDomainAccess());
            ret = fm.needsRelation();
        }
        finally {
            if (internalAccess != null) {
                MappingUtil.internalDomainAccess.set(internalAccess);
            } else {
                MappingUtil.internalDomainAccess.remove();
            }
        }
        return ret;
    }

    private <E> E checkField_getJcVal(String name, Class<E> attributeType) {
        JcValue ret = null;
        ArrayList<JcNode> validFor = new ArrayList<JcNode>();
        for (int i = 0; i < this.typeList.size(); ++i) {
            FieldMapping fm = this.mappingInfo.getFieldMapping(name, this.typeList.get(i));
            if (fm == null) continue;
            if (this.needsRelation(fm)) {
                throw new RuntimeException(msg_1 + name + "] " + "in domain object type: [" + this.domainObjectType.getName() + "]");
            }
            validFor.add(this.nodes.get(i));
            if (ret != null) continue;
            String propName = this.getPropertyOrRelationName(fm);
            JcNode n = this.nodes.get(i);
            ValueAccess.setHint(n, "dom", this);
            if (attributeType.equals(JcProperty.class)) {
                ret = n.property(propName);
            } else if (attributeType.equals(JcString.class)) {
                ret = n.stringProperty(propName);
            } else if (attributeType.equals(JcBoolean.class)) {
                ret = n.booleanProperty(propName);
            } else if (attributeType.equals(JcNumber.class)) {
                ret = n.numberProperty(propName);
            } else if (attributeType.equals(JcCollection.class)) {
                ret = n.collectionProperty(propName);
            }
            ValueAccess.setHint(ret, "vn", validFor);
            ValueAccess.setHint(ret, "dom", this);
        }
        if (ret == null) {
            throw new RuntimeException("attribute: [" + name + "] does not exist " + "in domain object type: [" + this.domainObjectType.getName() + "]");
        }
        return (E)ret;
    }
}

