/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domainquery.api;

import iot.jcypher.domain.genericmodel.DomainObject;
import iot.jcypher.domainquery.AbstractDomainQuery;
import iot.jcypher.domainquery.InternalAccess;
import iot.jcypher.domainquery.api.APIAccess;
import iot.jcypher.domainquery.api.APIObject;
import iot.jcypher.domainquery.api.Count;
import iot.jcypher.domainquery.api.DomainObjectMatch;
import iot.jcypher.domainquery.api.IPredicateOperand1;
import iot.jcypher.domainquery.api.TerminalResult;
import iot.jcypher.domainquery.ast.ConcatenateExpression;
import iot.jcypher.domainquery.ast.IASTObject;
import iot.jcypher.domainquery.ast.PredicateExpression;
import iot.jcypher.domainquery.ast.SelectExpression;
import iot.jcypher.domainquery.ast.UnionExpression;
import iot.jcypher.domainquery.internal.QueryRecorder;
import iot.jcypher.query.values.JcValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Select<T>
extends APIObject {
    private AbstractDomainQuery.IntAccess intAccess;

    Select(SelectExpression<T> se, AbstractDomainQuery.IntAccess ia) {
        this.astObject = se;
        this.intAccess = ia;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainObjectMatch<T> ELEMENTS(TerminalResult ... where) {
        DomainObjectMatch<?> delegate;
        DomainObjectMatch<?> match;
        SelectExpression<T> se = this.getSelectExpression();
        DomainObjectMatch<?> selDom = APIAccess.createDomainObjectMatch(se.getStart().getDomainObjectType(), se.getQueryExecutor().getDomainObjectMatches().size(), se.getQueryExecutor().getMappingInfo());
        this.handleUnionExpressions(se);
        se.getQueryExecutor().getDomainObjectMatches().add(selDom);
        se.resetAstObjectsContainer();
        se.setEnd(selDom);
        if (se.isReject()) {
            Boolean br_old = QueryRecorder.blockRecording.get();
            try {
                QueryRecorder.blockRecording.set(Boolean.TRUE);
                APIAccess.setPartOfReturn(selDom, false);
                AbstractDomainQuery q = se.getDomainQuery();
                DomainObjectMatch<?> rejectDom = InternalAccess.createMatch(q, se.getStart().getDomainObjectType());
                q.WHERE(rejectDom).IN(se.getStart());
                q.WHERE(rejectDom).NOT().IN(selDom);
                selDom = rejectDom;
            }
            finally {
                QueryRecorder.blockRecording.set(br_old);
            }
        }
        DomainObjectMatch<Object> ret = se.getStartType().equals(DomainObject.class) ? APIAccess.createDomainObjectMatch(se.getStartType(), selDom) : selDom;
        Object[] placeHolders = null;
        if (where != null) {
            placeHolders = new QueryRecorder.PlaceHolder[where.length];
            for (int i = 0; i < where.length; ++i) {
                placeHolders[i] = QueryRecorder.placeHolder(where[i]);
            }
        }
        DomainObjectMatch<?> domainObjectMatch = match = (delegate = APIAccess.getDelegate(ret)) != null ? delegate : ret;
        if (placeHolders != null) {
            QueryRecorder.recordStackedAssignment(this, "ELEMENTS", match, placeHolders);
        } else {
            QueryRecorder.recordStackedAssignment(this, "ELEMENTS", match, new Object[0]);
        }
        return ret;
    }

    private SelectExpression<T> getSelectExpression() {
        return (SelectExpression)this.astObject;
    }

    private void handleUnionExpressions(SelectExpression<T> se) {
        for (int i = se.getAstObjects().size() - 1; i >= 0; --i) {
            UnionExpression ue;
            DomainObjectMatch<?> dom;
            IASTObject astObj = se.getAstObjects().get(i);
            if (!(astObj instanceof PredicateExpression)) continue;
            PredicateExpression pe = (PredicateExpression)astObj;
            IPredicateOperand1 v1 = pe.getValue_1();
            if (v1 instanceof DomainObjectMatch) {
                dom = (DomainObjectMatch<?>)v1;
                if (APIAccess.getUnionExpression(dom) == null) continue;
                ue = APIAccess.getUnionExpression(dom);
                ArrayList<IASTObject> replacements = new ArrayList<IASTObject>();
                List<IASTObject> astObjs = this.collectAdditionalXprs(se, ue);
                int idx = 0;
                List<IASTObject> xprs = this.intAccess.getQueryExecutor().getExpressionsFor(dom, astObjs);
                for (DomainObjectMatch<?> src : ue.getSources()) {
                    PredicateExpression cpe = pe.createCopy();
                    cpe.setValue_1(src);
                    if (idx > 0 && ue.isUnion()) {
                        ConcatenateExpression ce = new ConcatenateExpression(ConcatenateExpression.Concatenator.OR);
                        replacements.add(ce);
                    }
                    if (xprs.size() > 0) {
                        replacements.add(new ConcatenateExpression(ConcatenateExpression.Concatenator.BR_OPEN));
                    }
                    this.addAdditionalXprs(xprs, replacements, src, dom, false);
                    replacements.add(cpe);
                    if (xprs.size() > 0) {
                        replacements.add(new ConcatenateExpression(ConcatenateExpression.Concatenator.BR_CLOSE));
                    }
                    ++idx;
                }
                se.replaceAstObject(i, replacements);
                continue;
            }
            if (!(v1 instanceof Count) || APIAccess.getUnionExpression(dom = APIAccess.getDomainObjectMatch((Count)v1)) == null) continue;
            ue = APIAccess.getUnionExpression(dom);
            List<IASTObject> astObjs = this.collectAdditionalXprs(se, ue);
            List<IASTObject> xprs = this.intAccess.getQueryExecutor().getExpressionsFor(dom, astObjs);
            ArrayList<IASTObject> additions = new ArrayList<IASTObject>();
            for (DomainObjectMatch<?> src : ue.getSources()) {
                this.addAdditionalXprs(xprs, additions, src, dom, true);
                se.addTraversalResult(src);
            }
            se.addAstObjects(additions);
        }
    }

    private List<IASTObject> collectAdditionalXprs(SelectExpression<T> se, UnionExpression ue) {
        ArrayList<IASTObject> ret = new ArrayList<IASTObject>();
        List<IASTObject> complete = this.intAccess.getQueryExecutor().getAstObjects();
        boolean add = false;
        for (IASTObject ao : complete) {
            if (ao == se) break;
            if (add) {
                ret.add(ao);
            }
            if (ao != ue.getLastOfUnionBase()) continue;
            add = true;
        }
        return ret;
    }

    private void addAdditionalXprs(List<IASTObject> xprs, List<IASTObject> addTo, DomainObjectMatch<?> src, DomainObjectMatch<?> old, boolean partOfCount) {
        Iterator<IASTObject> iterator = xprs.iterator();
        while (iterator.hasNext()) {
            IASTObject astObj;
            IASTObject toAdd = astObj = iterator.next();
            if (astObj instanceof PredicateExpression) {
                PredicateExpression pe = (PredicateExpression)astObj;
                PredicateExpression cpe = pe.createCopy();
                cpe.setPartOfCount(partOfCount);
                IPredicateOperand1 v1 = cpe.getValue_1();
                if (v1 instanceof JcValue) {
                    JcValue v = APIAccess.getCloneOf(src, (JcValue)v1);
                    cpe.setValue_1(v);
                    cpe.setInCollectionExpression(true);
                }
                toAdd = cpe;
            }
            addTo.add(toAdd);
        }
    }
}

