/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domainquery.ast;

import iot.jcypher.domain.mapping.MappingUtil;
import iot.jcypher.domainquery.api.APIAccess;
import iot.jcypher.domainquery.api.Count;
import iot.jcypher.domainquery.api.DomainObjectMatch;
import iot.jcypher.domainquery.api.IPredicateOperand1;
import iot.jcypher.domainquery.ast.IASTObject;
import iot.jcypher.domainquery.ast.SelectExpression;
import iot.jcypher.domainquery.internal.IASTObjectsContainer;
import iot.jcypher.query.values.ValueAccess;
import iot.jcypher.query.values.ValueElement;
import java.util.Date;

public class PredicateExpression
implements IASTObject {
    private IPredicateOperand1 value_1;
    private Operator operator;
    private Object value_2;
    private int negationCount;
    private boolean inCollectionExpression;
    private boolean partOfCount;

    public PredicateExpression(IPredicateOperand1 value_1, IASTObjectsContainer astObjectsContainer) {
        this.value_1 = value_1;
        this.negationCount = 0;
        this.inCollectionExpression = astObjectsContainer instanceof SelectExpression;
    }

    public PredicateExpression(IPredicateOperand1 value_1, boolean inColl) {
        this.value_1 = value_1;
        this.negationCount = 0;
        this.inCollectionExpression = inColl;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public DomainObjectMatch<?> getStartDOM() {
        if (this.value_1 instanceof DomainObjectMatch) {
            return (DomainObjectMatch)this.value_1;
        }
        if (this.value_1 instanceof Count) {
            return APIAccess.getDomainObjectMatch((Count)this.value_1);
        }
        return (DomainObjectMatch)ValueAccess.getAnyHint((ValueElement)this.value_1, "dom");
    }

    public IPredicateOperand1 getValue_1() {
        return this.value_1;
    }

    public void setValue_1(IPredicateOperand1 value_1) {
        this.value_1 = value_1;
    }

    public Object getValue_2() {
        return this.value_2;
    }

    public void setValue_2(Object value_2) {
        this.value_2 = value_2 instanceof Date ? Long.valueOf(MappingUtil.dateToLong((Date)value_2)) : value_2;
    }

    public void addNegation() {
        ++this.negationCount;
    }

    public int getNegationCount() {
        return this.negationCount;
    }

    public boolean isInCollectionExpression() {
        return this.inCollectionExpression;
    }

    public void setInCollectionExpression(boolean inCollectionExpression) {
        this.inCollectionExpression = inCollectionExpression;
    }

    public boolean isPartOfCount() {
        return this.partOfCount;
    }

    public void setPartOfCount(boolean partOfCount) {
        this.partOfCount = partOfCount;
    }

    public PredicateExpression createCopy() {
        PredicateExpression ret = new PredicateExpression(this.value_1, this.inCollectionExpression);
        ret.negationCount = this.negationCount;
        ret.operator = this.operator;
        ret.value_2 = this.value_2;
        return ret;
    }

    public String toString() {
        return "[" + (Object)((Object)this.operator) + "]";
    }

    public static enum Operator {
        EQUALS,
        NOT,
        LT,
        GT,
        LTE,
        GTE,
        LIKE,
        IN,
        CONTAINS,
        IS_NULL,
        STARTS_WITH,
        ENDS_WITH,
        CONTAINS_STRING;

    }
}

