/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domainquery.ast;

import iot.jcypher.domainquery.api.APIAccess;
import iot.jcypher.domainquery.api.DomainObjectMatch;
import iot.jcypher.domainquery.ast.IASTObject;
import iot.jcypher.domainquery.internal.QueryExecutor;
import java.util.ArrayList;
import java.util.List;

public class TraversalExpression
implements IASTObject {
    private QueryExecutor queryExecutor;
    private DomainObjectMatch<?> start;
    private DomainObjectMatch<?> end;
    private List<Step> steps;

    public TraversalExpression(DomainObjectMatch<?> start, QueryExecutor queryExecutor) {
        this.start = start;
        this.steps = new ArrayList<Step>();
        this.queryExecutor = queryExecutor;
    }

    public void step(String attributeName, int direction) {
        this.steps.add(new Step(direction, attributeName));
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void setEnd(DomainObjectMatch<?> end) {
        this.end = end;
        APIAccess.setTraversalSource(this.end, this.start);
    }

    public DomainObjectMatch<?> getEnd() {
        return this.end;
    }

    public DomainObjectMatch<?> getStart() {
        return this.start;
    }

    public QueryExecutor getQueryExecutor() {
        return this.queryExecutor;
    }

    public class Step {
        private int direction;
        private String attributeName;
        @Deprecated
        private boolean isCollection = false;
        private int minDistance;
        private int maxDistance;

        private Step(int direction, String attributeName) {
            this.direction = direction;
            this.attributeName = attributeName;
            this.minDistance = 1;
            this.maxDistance = 1;
        }

        public Step createStep(int direction, String attributeName) {
            return new Step(direction, attributeName);
        }

        public boolean isCollection() {
            return this.isCollection;
        }

        public void setCollection(boolean isCollection) {
            this.isCollection = isCollection;
        }

        public int getDirection() {
            return this.direction;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public int getMinDistance() {
            return this.minDistance;
        }

        public void setMinDistance(int minDistance) {
            this.minDistance = minDistance;
        }

        public int getMaxDistance() {
            return this.maxDistance;
        }

        public void setMaxDistance(int maxDistance) {
            this.maxDistance = maxDistance;
        }
    }
}

