/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domainquery.ast;

import iot.jcypher.domainquery.api.APIAccess;
import iot.jcypher.domainquery.api.DomainObjectMatch;
import iot.jcypher.domainquery.ast.IASTObject;
import java.util.ArrayList;
import java.util.List;

public class UnionExpression
implements IASTObject {
    private DomainObjectMatch<?> result;
    private List<DomainObjectMatch<?>> sources;
    private boolean union;
    private IASTObject lastOfUnionBase;

    public UnionExpression(boolean union) {
        this.union = union;
        this.sources = new ArrayList();
    }

    public DomainObjectMatch<?> getResult() {
        return this.result;
    }

    public void setResult(DomainObjectMatch<?> result) {
        this.result = result;
    }

    public List<DomainObjectMatch<?>> getSources() {
        return this.sources;
    }

    public DomainObjectMatch<?> getCommonTraversalSource() {
        DomainObjectMatch<?> travSource = null;
        boolean idx = false;
        for (DomainObjectMatch<?> dom : this.sources) {
            DomainObjectMatch<?> ts = APIAccess.getTraversalSource(dom);
            if (!idx) {
                travSource = ts;
                continue;
            }
            if (ts == travSource) continue;
            travSource = null;
        }
        return travSource;
    }

    public boolean isUnion() {
        return this.union;
    }

    public IASTObject getLastOfUnionBase() {
        return this.lastOfUnionBase;
    }

    public void setLastOfUnionBase(IASTObject lastOfUnionBase) {
        this.lastOfUnionBase = lastOfUnionBase;
    }

    public boolean isLastOfSources(DomainObjectMatch<?> dom) {
        int sz = this.sources.size();
        return sz > 0 && dom.equals(this.sources.get(sz - 1));
    }
}

