/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domainquery.internal;

import iot.jcypher.domainquery.ast.Parameter;
import iot.jcypher.domainquery.internal.ConversionUtil;
import iot.jcypher.domainquery.internal.RecordedQuery;
import iot.jcypher.query.writer.Format;
import iot.jcypher.query.writer.JSONWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;

public class JSONConverter {
    private static final String TYPE_KEY = "type";
    private static final String ON_OBJECT_KEY = "onObjectRef";
    private static final String RETURN_OBJECT_KEY = "returnObjectRef";
    private static final String METHOD_KEY = "method";
    private static final String STATEMENTS = "statements";
    private static final String INVOCATION = "Invocation";
    private static final String ASSIGNMENT = "Assignment";
    private static final String LITERAL = "Literal";
    private static final String PARAM = "Parameter";
    private static final String PARAM_NAME = "paramName";
    private static final String REFERENCE = "Reference";
    private static final String PARAMETERS = "parameters";
    private static final String AUGMENTATIONS = "augmentations";
    private static final String GENERIC = "generic";
    private static final String LITERAL_TYPE = "LiteralType";
    private static final String LITERAL_VALUE = "LiteralValue";
    private static final String REF_ID = "refId";
    private static final String REF_TYPE = "RefType";
    private static final String REF_VALUE = "RefValue";
    private static final String DO_MATCH_REF = "DOMatchRef";
    private static final String REF = "ref";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String ARRAY_PREF = "Array(";
    private static final String ARRAY_POST = ")";
    private Format prettyFormat = Format.NONE;

    public String toJSON(RecordedQuery query) {
        JsonGenerator generator;
        StringWriter sw = new StringWriter();
        if (this.prettyFormat != Format.NONE) {
            JsonGeneratorFactory gf = JSONWriter.getPrettyGeneratorFactory();
            generator = gf.createGenerator((Writer)sw);
        } else {
            generator = Json.createGenerator((Writer)sw);
        }
        generator.writeStartObject();
        this.writeQuery(query, generator);
        generator.writeEnd();
        generator.flush();
        return sw.toString();
    }

    public RecordedQuery fromJSON(String json) {
        RecordedQuery ret = new RecordedQuery(false);
        StringReader sr = new StringReader(json);
        JsonReader reader = Json.createReader((Reader)sr);
        JsonObject jsonResult = reader.readObject();
        ret.setGeneric(jsonResult.getBoolean(GENERIC));
        JsonArray augmentations = jsonResult.getJsonArray(AUGMENTATIONS);
        if (augmentations != null) {
            HashMap<String, String> augs = new HashMap<String, String>();
            for (JsonObject a : augmentations) {
                augs.put(a.getString(KEY), a.getString(VALUE));
            }
            ret.setAugmentations(augs);
        }
        JsonArray statements = jsonResult.getJsonArray(STATEMENTS);
        for (JsonValue s : statements) {
            this.readStatement(s, ret.getStatements(), ret);
        }
        return ret;
    }

    void readStatement(JsonValue s, List<RecordedQuery.Statement> statements, RecordedQuery rq) {
        RecordedQuery.Statement statement = null;
        if (s instanceof JsonObject) {
            JsonObject jobj = (JsonObject)s;
            String typ = jobj.getString(TYPE_KEY);
            if (ASSIGNMENT.equals(typ) || INVOCATION.equals(typ)) {
                JsonArray params = jobj.getJsonArray(PARAMETERS);
                ArrayList<RecordedQuery.Statement> parameters = new ArrayList<RecordedQuery.Statement>();
                for (JsonValue v : params) {
                    this.readStatement(v, parameters, rq);
                }
                statement = ASSIGNMENT.equals(typ) ? rq.createStatement(RecordedQuery.Assignment.class) : rq.createStatement(RecordedQuery.Invocation.class);
                RecordedQuery.Invocation inv = (RecordedQuery.Invocation)statement;
                inv.setParams(parameters);
                inv.setOnObjectRef(jobj.getString(ON_OBJECT_KEY));
                inv.setMethod(jobj.getString(METHOD_KEY));
                inv.setReturnObjectRef(jobj.getString(RETURN_OBJECT_KEY));
            } else if (LITERAL.equals(typ) || PARAM.equals(typ)) {
                boolean isParam = PARAM.equals(typ);
                statement = rq.createStatement(RecordedQuery.Literal.class);
                String lTyp = jobj.getString(LITERAL_TYPE);
                JsonValue jsVal = (JsonValue)jobj.get((Object)LITERAL_VALUE);
                Object val = ConversionUtil.fromJSON(lTyp, jsVal);
                if (isParam) {
                    String pName = jobj.getString(PARAM_NAME);
                    Parameter param = rq.getCreateParameter(pName);
                    param.setValue(val);
                    val = param;
                }
                ((RecordedQuery.Literal)statement).setValue(val);
            } else if (REFERENCE.equals(typ)) {
                statement = rq.createStatement(RecordedQuery.Reference.class);
                ((RecordedQuery.Reference)statement).setRefId(jobj.getString(REF_ID));
                String rTyp = jobj.getString(REF_TYPE);
                String rVal = jobj.getString(REF_VALUE);
                Object val = ConversionUtil.from(rTyp, rVal);
                ((RecordedQuery.Reference)statement).setValue(val);
            } else if (DO_MATCH_REF.equals(typ)) {
                statement = rq.createStatement(RecordedQuery.DOMatchRef.class);
                ((RecordedQuery.DOMatchRef)statement).setRef(jobj.getString(REF));
            }
        }
        if (statement != null) {
            statements.add(statement);
        }
    }

    private void writeQuery(RecordedQuery query, JsonGenerator generator) {
        generator.write(GENERIC, query.isGeneric());
        if (query.getAugmentations() != null) {
            generator.writeStartArray(AUGMENTATIONS);
            for (Map.Entry<String, String> entry : query.getAugmentations().entrySet()) {
                generator.writeStartObject();
                generator.write(KEY, entry.getKey());
                generator.write(VALUE, entry.getValue());
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        generator.writeStartArray(STATEMENTS);
        for (RecordedQuery.Statement s : query.getStatements()) {
            this.writeStatement(s, generator);
        }
        generator.writeEnd();
    }

    private void writeStatement(RecordedQuery.Statement statement, JsonGenerator generator) {
        generator.writeStartObject();
        if (statement instanceof RecordedQuery.Invocation) {
            RecordedQuery.Invocation inv = (RecordedQuery.Invocation)statement;
            if (statement instanceof RecordedQuery.Assignment) {
                generator.write(TYPE_KEY, ASSIGNMENT);
            } else {
                generator.write(TYPE_KEY, INVOCATION);
            }
            generator.write(ON_OBJECT_KEY, inv.getOnObjectRef());
            generator.write(METHOD_KEY, inv.getMethod());
            generator.write(RETURN_OBJECT_KEY, inv.getReturnObjectRef());
            generator.writeStartArray(PARAMETERS);
            for (RecordedQuery.Statement s : inv.getParams()) {
                this.writeStatement(s, generator);
            }
            generator.writeEnd();
        } else if (statement instanceof RecordedQuery.Literal) {
            Object val = ((RecordedQuery.Literal)statement).getRawValue();
            this.writeLiteral(val, generator);
        } else if (statement instanceof RecordedQuery.Reference) {
            RecordedQuery.Reference ref = (RecordedQuery.Reference)statement;
            generator.write(TYPE_KEY, REFERENCE);
            generator.write(REF_ID, ref.getRefId());
            Object val = ref.getValue();
            if (val != null) {
                generator.write(REF_TYPE, val.getClass().getName());
                generator.write(REF_VALUE, val.toString());
            }
        } else if (statement instanceof RecordedQuery.DOMatchRef) {
            generator.write(TYPE_KEY, DO_MATCH_REF);
            generator.write(REF, ((RecordedQuery.DOMatchRef)statement).getRef());
        }
        generator.writeEnd();
    }

    private void writeLiteral(Object val, JsonGenerator generator) {
        boolean isParam = val instanceof Parameter;
        if (isParam) {
            generator.write(TYPE_KEY, PARAM);
            generator.write(PARAM_NAME, ((Parameter)val).getName());
            val = ((Parameter)val).getValue();
        } else {
            generator.write(TYPE_KEY, LITERAL);
        }
        if (val != null) {
            boolean isColl = Collection.class.isAssignableFrom(val.getClass());
            boolean isArray = val.getClass().isArray();
            if (isArray) {
                StringBuilder sb = new StringBuilder();
                sb.append(ARRAY_PREF);
                sb.append(val.getClass().getComponentType().getName());
                sb.append(ARRAY_POST);
                generator.write(LITERAL_TYPE, sb.toString());
            } else {
                generator.write(LITERAL_TYPE, val.getClass().getName());
            }
            if (isArray || isColl) {
                generator.writeStartArray(LITERAL_VALUE);
                if (isColl) {
                    Iterator it = ((Collection)val).iterator();
                    while (it.hasNext()) {
                        generator.writeStartObject();
                        this.writeLiteral(it.next(), generator);
                        generator.writeEnd();
                    }
                } else {
                    for (int i = 0; i < Array.getLength(val); ++i) {
                        generator.writeStartObject();
                        this.writeLiteral(Array.get(val, i), generator);
                        generator.writeEnd();
                    }
                }
                generator.writeEnd();
            } else {
                generator.write(LITERAL_VALUE, val.toString());
            }
        }
    }

    public JSONConverter setPrettyFormat(Format prettyFormat) {
        this.prettyFormat = prettyFormat;
        return this;
    }
}

