/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domainquery.internal;

import iot.jcypher.concurrency.QExecution;
import iot.jcypher.domain.IDomainAccess;
import iot.jcypher.domain.SyncInfo;
import iot.jcypher.domain.internal.CurrentDomain;
import iot.jcypher.domain.internal.DomainAccess;
import iot.jcypher.domain.internal.IIntDomainAccess;
import iot.jcypher.domain.internal.SkipLimitCalc;
import iot.jcypher.domain.mapping.CompoundObjectType;
import iot.jcypher.domain.mapping.FieldMapping;
import iot.jcypher.domain.mapping.MappingUtil;
import iot.jcypher.domain.mapping.ObjectMapping;
import iot.jcypher.domain.mapping.surrogate.Array;
import iot.jcypher.domain.mapping.surrogate.Collection;
import iot.jcypher.domainquery.AbstractDomainQuery;
import iot.jcypher.domainquery.CountQueryResult;
import iot.jcypher.domainquery.DomainQueryResult;
import iot.jcypher.domainquery.InternalAccess;
import iot.jcypher.domainquery.api.APIAccess;
import iot.jcypher.domainquery.api.Count;
import iot.jcypher.domainquery.api.DomainObjectMatch;
import iot.jcypher.domainquery.api.IPredicateOperand1;
import iot.jcypher.domainquery.ast.CollectExpression;
import iot.jcypher.domainquery.ast.ConcatenateExpression;
import iot.jcypher.domainquery.ast.FromPreviousQueryExpression;
import iot.jcypher.domainquery.ast.IASTObject;
import iot.jcypher.domainquery.ast.OrderExpression;
import iot.jcypher.domainquery.ast.Parameter;
import iot.jcypher.domainquery.ast.PredicateExpression;
import iot.jcypher.domainquery.ast.SelectExpression;
import iot.jcypher.domainquery.ast.TraversalExpression;
import iot.jcypher.domainquery.ast.UnionExpression;
import iot.jcypher.domainquery.internal.IASTObjectsContainer;
import iot.jcypher.domainquery.internal.QueryRecorder;
import iot.jcypher.domainquery.internal.RecordedQuery;
import iot.jcypher.domainquery.internal.RecordedQueryPlayer;
import iot.jcypher.domainquery.internal.ReplayedQueryContext;
import iot.jcypher.domainquery.internal.Settings;
import iot.jcypher.query.JcQuery;
import iot.jcypher.query.JcQueryResult;
import iot.jcypher.query.api.APIObject;
import iot.jcypher.query.api.APIObjectAccess;
import iot.jcypher.query.api.IClause;
import iot.jcypher.query.api.collection.CWhere;
import iot.jcypher.query.api.collection.ICollectExpression;
import iot.jcypher.query.api.pattern.Node;
import iot.jcypher.query.api.pattern.Relation;
import iot.jcypher.query.api.predicate.BooleanOperation;
import iot.jcypher.query.api.predicate.Concat;
import iot.jcypher.query.api.predicate.Concatenator;
import iot.jcypher.query.api.predicate.PFactory;
import iot.jcypher.query.api.returns.RSortable;
import iot.jcypher.query.ast.predicate.BooleanValue;
import iot.jcypher.query.ast.predicate.IPredicateHolder;
import iot.jcypher.query.ast.returns.ReturnElement;
import iot.jcypher.query.ast.returns.ReturnExpression;
import iot.jcypher.query.factories.clause.OPTIONAL_MATCH;
import iot.jcypher.query.factories.clause.RETURN;
import iot.jcypher.query.factories.clause.SEPARATE;
import iot.jcypher.query.factories.clause.START;
import iot.jcypher.query.factories.clause.WHERE;
import iot.jcypher.query.factories.clause.WITH;
import iot.jcypher.query.factories.xpression.C;
import iot.jcypher.query.factories.xpression.I;
import iot.jcypher.query.result.JcError;
import iot.jcypher.query.result.JcResultException;
import iot.jcypher.query.values.JcCollection;
import iot.jcypher.query.values.JcNode;
import iot.jcypher.query.values.JcNumber;
import iot.jcypher.query.values.JcPath;
import iot.jcypher.query.values.JcPrimitive;
import iot.jcypher.query.values.JcValue;
import iot.jcypher.query.values.ValueAccess;
import iot.jcypher.query.values.ValueElement;
import iot.jcypher.query.writer.Format;
import iot.jcypher.util.QueriesPrintObserver;
import iot.jcypher.util.Util;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QueryExecutor
implements IASTObjectsContainer {
    private static final String idPrefix = "id_";
    private static final String countPrefix = "cnt_";
    private static final String tmpNodePostPrefix = "_t";
    private static final String collNodePostPrefix = "_c";
    private static final String countXprPostPrefix = "_cnt";
    private static final String collectNodePostfix = "_col";
    private static final char separator = '_';
    private IDomainAccess domainAccess;
    private List<IASTObject> astObjects;
    private List<OrderExpression> orders;
    private List<DomainObjectMatch<?>> domainObjectMatches;
    private Map<String, Parameter> parameters;
    private MappingInfo mappingInfo;
    private QueryContext queryResult;
    private QueryContext countResult;
    private RecordedQueryContext recordedQueryContext;
    private ReplayedQueryContext replayedQueryContext;

    public QueryExecutor(IDomainAccess domainAccess) {
        this.domainAccess = domainAccess;
        this.astObjects = new ArrayList<IASTObject>();
        this.domainObjectMatches = new ArrayList();
        this.parameters = new HashMap<String, Parameter>();
    }

    @Override
    public void addAstObject(IASTObject astObj) {
        this.astObjects.add(astObj);
    }

    public List<IASTObject> getAstObjects() {
        return this.astObjects;
    }

    public OrderExpression getOrderFor(DomainObjectMatch<?> dom) {
        if (this.orders == null) {
            this.orders = new ArrayList<OrderExpression>();
        }
        OrderExpression ret = null;
        for (OrderExpression oe : this.orders) {
            if (!oe.getObjectMatch().equals(dom)) continue;
            ret = oe;
            break;
        }
        if (ret == null) {
            ret = new OrderExpression(dom);
            this.orders.add(ret);
        }
        return ret;
    }

    public List<DomainObjectMatch<?>> getDomainObjectMatches() {
        return this.domainObjectMatches;
    }

    public Parameter parameter(String name) {
        Parameter param = this.parameters.get(name);
        if (param == null) {
            param = new Parameter(name);
            this.parameters.put(name, param);
        }
        return param;
    }

    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }

    public void addParameter(Parameter param) {
        this.parameters.put(param.getName(), param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        boolean doReplay;
        QExecution myQExec;
        block11: {
            if (this.hasBeenReplayed()) {
                if (this.recordedQueryContext.queryResult == null) {
                    this.recordedQueryContext.queryResult = InternalAccess.getDomainQuery(this.recordedQueryContext.countResult).execute();
                }
                return;
            }
            String pLab = ((IIntDomainAccess)((Object)this.domainAccess)).getInternalDomainAccess().setDomainLabel();
            QExecution qExec = ((IIntDomainAccess)((Object)this.domainAccess)).getInternalDomainAccess().getQExecution();
            myQExec = null;
            doReplay = false;
            if (qExec == null) {
                myQExec = new QExecution(QExecution.ExecType.execute);
                ((IIntDomainAccess)((Object)this.domainAccess)).getInternalDomainAccess().setQExecution(myQExec);
            }
            try {
                this.executeInternal(false);
            }
            catch (RuntimeException e) {
                if (myQExec != null && this.isReplayQuery(e)) {
                    doReplay = true;
                    break block11;
                }
                throw e;
            }
            finally {
                CurrentDomain.setDomainLabel(pLab);
                if (qExec == null) {
                    ((IIntDomainAccess)((Object)this.domainAccess)).getInternalDomainAccess().setQExecution(null);
                }
            }
        }
        if (doReplay) {
            this.replayQuery(myQExec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCount() {
        boolean doReplay;
        QExecution myQExec;
        block11: {
            if (this.hasBeenReplayed()) {
                if (this.recordedQueryContext.countResult == null) {
                    this.recordedQueryContext.countResult = InternalAccess.getDomainQuery(this.recordedQueryContext.queryResult).executeCount();
                }
                return;
            }
            String pLab = ((IIntDomainAccess)((Object)this.domainAccess)).getInternalDomainAccess().setDomainLabel();
            QExecution qExec = ((IIntDomainAccess)((Object)this.domainAccess)).getInternalDomainAccess().getQExecution();
            myQExec = null;
            doReplay = false;
            if (qExec == null) {
                myQExec = new QExecution(QExecution.ExecType.executeCount);
                ((IIntDomainAccess)((Object)this.domainAccess)).getInternalDomainAccess().setQExecution(myQExec);
            }
            try {
                this.executeInternal(true);
            }
            catch (RuntimeException e) {
                if (myQExec != null && this.isReplayQuery(e)) {
                    doReplay = true;
                    break block11;
                }
                throw e;
            }
            finally {
                CurrentDomain.setDomainLabel(pLab);
                if (qExec == null) {
                    ((IIntDomainAccess)((Object)this.domainAccess)).getInternalDomainAccess().setQExecution(null);
                }
            }
        }
        if (doReplay) {
            this.replayQuery(myQExec);
        }
    }

    public boolean hasBeenReplayed() {
        if (this.recordedQueryContext != null) {
            return this.recordedQueryContext.queryResult != null || this.recordedQueryContext.countResult != null;
        }
        return false;
    }

    private void replayQuery(QExecution myQExec) {
        if (this.recordedQueryContext != null) {
            RecordedQueryPlayer qp = new RecordedQueryPlayer();
            AbstractDomainQuery q = this.recordedQueryContext.recordedQuery.isGeneric() ? qp.replayGenericQuery(this.recordedQueryContext.recordedQuery, this.domainAccess.getGenericDomainAccess()) : qp.replayQuery(this.recordedQueryContext.recordedQuery, this.domainAccess);
            if (myQExec.geExecType() == QExecution.ExecType.execute) {
                this.recordedQueryContext.queryResult = q.execute();
            } else if (myQExec.geExecType() == QExecution.ExecType.executeCount) {
                this.recordedQueryContext.countResult = q.executeCount();
            }
        }
    }

    private boolean isReplayQuery(Throwable e) {
        if (e instanceof JcResultException) {
            List<JcError> errs = ((JcResultException)e).getErrors();
            for (JcError err : errs) {
                if (!err.getCodeOrType().equals("_REPLAY_QUERY")) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInternal(boolean execCount) {
        if (this.recordedQueryContext != null) {
            this.recordedQueryContext.queryCompleted();
        }
        Boolean br_old = QueryRecorder.blockRecording.get();
        try {
            QueryRecorder.blockRecording.set(Boolean.TRUE);
            QueryContext context = new QueryContext(execCount);
            QueryBuilder qb = new QueryBuilder();
            List<JcQuery> queries = qb.buildQueries(context);
            Util.printQueries(queries, execCount ? QueriesPrintObserver.QueryToObserve.COUNT_QUERY : QueriesPrintObserver.QueryToObserve.DOM_QUERY, Format.PRETTY_1);
            List<JcQueryResult> results = ((IIntDomainAccess)((Object)this.domainAccess)).getInternalDomainAccess().execute(queries);
            List<JcError> errors = Util.collectErrors(results);
            if (errors.size() > 0) {
                QueryRecorder.blockRecording.set(br_old);
                throw new JcResultException(errors);
            }
            if (context.execCount) {
                qb.extractCounts(results, context.resultsPerType);
                this.countResult = context;
            } else {
                qb.extractUniqueIds(results, context.resultsPerType);
                context.queryExecuted();
                this.queryResult = context;
            }
        }
        finally {
            QueryRecorder.blockRecording.set(br_old);
        }
    }

    public MappingInfo getMappingInfo() {
        if (this.mappingInfo == null) {
            this.mappingInfo = new MappingInfo();
        }
        return this.mappingInfo;
    }

    public List<IASTObject> getExpressionsFor(DomainObjectMatch<?> dom, List<IASTObject> astObjs) {
        QueryBuilder.ExpressionsPerDOM xpds = new QueryBuilder().buildExpressionsPerDOM(dom, astObjs, 0);
        return xpds.xPressions;
    }

    public <T> List<T> loadResult(DomainObjectMatch<T> match) {
        if (APIAccess.isPageChanged(match)) {
            this.execute();
        }
        if (this.queryResult == null) {
            throw new RuntimeException("query was not executed, call execute() on DomainQuery");
        }
        List resPerTypeList = (List)this.queryResult.resultsMap.get(match);
        if (resPerTypeList == null) {
            throw new RuntimeException("DomainObjectMatch was not defined in this query");
        }
        HashMap type2IdsMap = new HashMap();
        ArrayList allIds = new ArrayList();
        List<Object> ret = null;
        for (QueryContext.ResultsPerType resPerType : resPerTypeList) {
            if (resPerType.jcPrimitive != null) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                if (resPerType.simpleValues == null) continue;
                ret.addAll(resPerType.simpleValues);
                continue;
            }
            ArrayList ids = (ArrayList)type2IdsMap.get(resPerType.type);
            boolean addList = false;
            if (ids == null) {
                ids = new ArrayList();
                addList = true;
            }
            ids.addAll(resPerType.ids);
            allIds.addAll(resPerType.ids);
            if (ids.isEmpty()) {
                addList = false;
            }
            if (!addList) continue;
            type2IdsMap.put(resPerType.type, ids);
        }
        if (ret == null) {
            long[] idsArray = new long[allIds.size()];
            for (int i = 0; i < allIds.size(); ++i) {
                idsArray[i] = (Long)allIds.get(i);
            }
            ret = ((IIntDomainAccess)((Object)this.domainAccess)).getInternalDomainAccess().loadByIds(APIAccess.getDomainObjectType(match), type2IdsMap, -1, idsArray);
        }
        return ret;
    }

    public <T> List<T> loadReplayedResult(DomainObjectMatch<T> match) {
        DomainObjectMatch matching = this.recordedQueryContext.findMatchingTo(match);
        List ret = this.recordedQueryContext.queryResult.resultOf(matching, true);
        return ret;
    }

    public long getCountResult(DomainObjectMatch<?> match) {
        long res = 0L;
        if (this.countResult == null) {
            throw new RuntimeException("query was not executed, call executeCount() on DomainQuery");
        }
        List resPerTypeList = (List)this.countResult.resultsMap.get(match);
        if (resPerTypeList == null) {
            throw new RuntimeException("DomainObjectMatch was not defined in this query");
        }
        for (QueryContext.ResultsPerType resPerType : resPerTypeList) {
            res += resPerType.count;
        }
        return res;
    }

    public long getReplayedCountResult(DomainObjectMatch<?> match) {
        DomainObjectMatch matching = this.recordedQueryContext.findMatchingTo(match);
        return this.recordedQueryContext.countResult.countOf(matching);
    }

    private List<Long> getIdsFor(DomainObjectMatch<?> match, Class<?> type) {
        if (APIAccess.isPageChanged(match)) {
            this.execute();
        }
        if (this.queryResult == null) {
            throw new RuntimeException("query was not executed, call execute() on DomainQuery");
        }
        List resPerTypeList = (List)this.queryResult.resultsMap.get(match);
        if (resPerTypeList == null) {
            throw new RuntimeException("DomainObjectMatch was not defined in this query");
        }
        ArrayList<Long> allIds = new ArrayList<Long>();
        for (QueryContext.ResultsPerType resPerType : resPerTypeList) {
            if (resPerType.type != type || resPerType.jcPrimitive != null) continue;
            allIds.addAll(resPerType.ids);
            break;
        }
        return allIds;
    }

    public QueryContext getQueryResult() {
        return this.queryResult;
    }

    private QueryContext loadCountResultIfNeeded() {
        if (this.countResult == null) {
            this.executeCount();
        }
        return this.countResult;
    }

    public void recordQuery(RecordedQuery rq, AbstractDomainQuery q) {
        this.recordedQueryContext = new RecordedQueryContext(rq, rq != null ? QueryRecorder.getQueriesPerThread() : null, q);
    }

    public void replayQuery(ReplayedQueryContext rqc) {
        this.replayedQueryContext = rqc;
    }

    public ReplayedQueryContext getReplayedQueryContext() {
        return this.replayedQueryContext;
    }

    public RecordedQuery getRecordedQuery() {
        if (this.recordedQueryContext != null) {
            return this.recordedQueryContext.recordedQuery;
        }
        return null;
    }

    public Map<Object, String> getRecordedQueryObjects() {
        if (this.recordedQueryContext != null) {
            if (this.recordedQueryContext.object2IdMap != null) {
                return this.recordedQueryContext.object2IdMap;
            }
            return this.recordedQueryContext.queriesPerThread.getDOM2IdMap(this.recordedQueryContext.domainQuery);
        }
        return null;
    }

    public boolean queryCreationCompleted(boolean deleteReplayedQueryContext) {
        boolean compl = false;
        if (this.recordedQueryContext != null) {
            this.recordedQueryContext.queryCompleted();
            compl = true;
        }
        if (deleteReplayedQueryContext) {
            this.replayedQueryContext = null;
        }
        return compl;
    }

    protected void finalize() throws Throwable {
        if (this.recordedQueryContext != null) {
            this.recordedQueryContext.queryCompleted();
        }
        super.finalize();
    }

    public class MappingInfo {
        private MappingInfo() {
        }

        public ObjectMapping getObjectMappingFor(Class<?> domainObjectType) {
            return ((IIntDomainAccess)((Object)QueryExecutor.this.domainAccess)).getInternalDomainAccess().getObjectMappingFor(domainObjectType);
        }

        public FieldMapping getFieldMapping(String attribName, Class<?> domainObjectType) {
            return this.getObjectMappingFor(domainObjectType).getFieldMappingForField(attribName);
        }

        public List<FieldMapping> getBackwardFieldMappings(String attribName, Class<?> domainObjectType) {
            return ((IIntDomainAccess)((Object)QueryExecutor.this.domainAccess)).getInternalDomainAccess().getBackwardFieldMappings(attribName, domainObjectType);
        }

        public List<Class<?>> getCompoundTypesFor(Class<?> domainObjectType) {
            return ((IIntDomainAccess)((Object)QueryExecutor.this.domainAccess)).getInternalDomainAccess().getCompoundTypesFor(domainObjectType);
        }

        public String getLabelForClass(Class<?> clazz) {
            return ((IIntDomainAccess)((Object)QueryExecutor.this.domainAccess)).getInternalDomainAccess().getLabelForClass(clazz);
        }

        public Class<?> getClassForLabel(String label) {
            return ((IIntDomainAccess)((Object)QueryExecutor.this.domainAccess)).getInternalDomainAccess().getClassForLabel(label);
        }

        public QueryExecutor getQueryExecutor() {
            return QueryExecutor.this;
        }

        public DomainAccess.InternalDomainAccess getInternalDomainAccess() {
            return ((IIntDomainAccess)((Object)QueryExecutor.this.domainAccess)).getInternalDomainAccess();
        }
    }

    private class RecordedQueryContext {
        private RecordedQuery recordedQuery;
        private QueryRecorder.QueriesPerThread queriesPerThread;
        private AbstractDomainQuery domainQuery;
        private Map<Object, String> object2IdMap;
        private DomainQueryResult queryResult;
        private CountQueryResult countResult;

        private RecordedQueryContext(RecordedQuery recordedQuery, QueryRecorder.QueriesPerThread queriesPerThread, AbstractDomainQuery q) {
            this.recordedQuery = recordedQuery;
            this.queriesPerThread = queriesPerThread;
            this.domainQuery = q;
        }

        private void queryCompleted() {
            if (this.queriesPerThread != null) {
                if (this.object2IdMap == null) {
                    this.object2IdMap = this.queriesPerThread.getDOM2IdMap(this.domainQuery);
                }
                this.queriesPerThread.queryCompleted(this.domainQuery);
            }
        }

        private DomainObjectMatch<?> findMatchingTo(DomainObjectMatch<?> dom) {
            DomainObjectMatch<?> om = APIAccess.getDelegate(dom);
            if (om == null) {
                om = dom;
            }
            String oid = this.object2IdMap.get(om);
            ReplayedQueryContext rctxt = InternalAccess.getQueryExecutor(this.getReplayedQuery()).getReplayedQueryContext();
            DomainObjectMatch<?> match = rctxt.getById(oid);
            return match;
        }

        private AbstractDomainQuery getReplayedQuery() {
            if (this.queryResult != null) {
                return InternalAccess.getDomainQuery(this.queryResult);
            }
            if (this.countResult != null) {
                return InternalAccess.getDomainQuery(this.countResult);
            }
            return null;
        }
    }

    private static enum State {
        INIT,
        HAS_XPRESSION;

    }

    private class QueryContext {
        private List<ResultsPerType> resultsPerType = new ArrayList<ResultsPerType>();
        private Map<DomainObjectMatch<?>, List<ResultsPerType>> resultsMap = new HashMap();
        private boolean execCount;

        private QueryContext(boolean execCount) {
            this.execCount = execCount;
        }

        private ResultsPerType addFor(QueryBuilder.ClausesPerType cpt, boolean isCountQuery) {
            DomainObjectMatch dom = cpt.domainObjectMatch;
            Class type = cpt.domainObjectType;
            List<ResultsPerType> resPerTypeList = this.resultsMap.get(dom);
            if (resPerTypeList == null) {
                resPerTypeList = new ArrayList<ResultsPerType>();
                this.resultsMap.put(dom, resPerTypeList);
            }
            ResultsPerType resPerType = null;
            for (ResultsPerType rpt : resPerTypeList) {
                if (!rpt.type.equals(type)) continue;
                resPerType = rpt;
                break;
            }
            if (resPerType == null) {
                String pref = isCountQuery ? QueryExecutor.countPrefix : QueryExecutor.idPrefix;
                resPerType = new ResultsPerType(type, ValueAccess.getName(cpt.node), cpt.getJcNumber(pref));
                resPerTypeList.add(resPerType);
            }
            return resPerType;
        }

        private void addEmptyFor(QueryBuilder.ClausesPerType cpt) {
            DomainObjectMatch dom = cpt.domainObjectMatch;
            List<ResultsPerType> resPerTypeList = this.resultsMap.get(dom);
            if (resPerTypeList == null) {
                resPerTypeList = new ArrayList<ResultsPerType>();
                this.resultsMap.put(dom, resPerTypeList);
            }
        }

        private void queryExecuted() {
            for (Map.Entry<DomainObjectMatch<?>, List<ResultsPerType>> entry : this.resultsMap.entrySet()) {
                APIAccess.setPageChanged(entry.getKey(), false);
            }
        }

        private class ResultsPerType {
            private Class<?> type;
            private JcPrimitive jcPrimitive;
            private JcNumber jcNumber;
            private List<Long> ids;
            private List<Object> simpleValues;
            private long count;
            private int queryIndex;

            private ResultsPerType(Class<?> type, String retName, JcNumber num) {
                this.type = type;
                this.jcNumber = num;
                this.count = 0L;
                this.queryIndex = 0;
                this.jcPrimitive = MappingUtil.fromType(type, retName);
            }
        }
    }

    private class QueryBuilder {
        private ClauseBuilder clauseBuilder = new ClauseBuilder();

        private QueryBuilder() {
        }

        List<JcQuery> buildQueries(QueryContext context) {
            ArrayList<ClausesPerType> clausesPerTypeList = new ArrayList<ClausesPerType>();
            List<ExpressionsPerDOM> xpressionsPerDom = new ArrayList<ExpressionsPerDOM>();
            for (DomainObjectMatch dom : QueryExecutor.this.domainObjectMatches) {
                ExpressionsPerDOM xpd = this.buildExpressionsPerDOM(dom, QueryExecutor.this.astObjects, 0);
                if (xpd == null) continue;
                xpressionsPerDom.add(xpd);
            }
            xpressionsPerDom = this.orderByDependencies(xpressionsPerDom);
            ClauseBuilderContext cbContext = new ClauseBuilderContext(new ArrayList());
            for (ExpressionsPerDOM xpd : xpressionsPerDom) {
                clausesPerTypeList.addAll(this.clauseBuilder.buildClausesFor(xpd, cbContext, context.execCount));
            }
            return this.buildQueriesInt(clausesPerTypeList, context, cbContext);
        }

        private ExpressionsPerDOM buildExpressionsPerDOM(DomainObjectMatch<?> dom, List<IASTObject> astObjs, int mode) {
            ExpressionsPerDOM ret = null;
            StateContext stateContext = this.findXpressionsFor(dom, astObjs, mode);
            if (stateContext.state == State.HAS_XPRESSION) {
                ret = new ExpressionsPerDOM(dom, stateContext.candidates, stateContext.dependencies);
            } else if (stateContext.state == State.INIT) {
                stateContext.candidates.clear();
                ret = new ExpressionsPerDOM(dom, stateContext.candidates, stateContext.dependencies);
            }
            return ret;
        }

        private List<JcQuery> buildQueriesInt(List<ClausesPerType> clausesPerTypeList, QueryContext context, ClauseBuilderContext cbContext) {
            ArrayList<JcQuery> ret = new ArrayList<JcQuery>();
            int queryIndex = -1;
            int startIdx = 0;
            while (startIdx < clausesPerTypeList.size()) {
                int i;
                ++queryIndex;
                ArrayList<IClause> clauses = new ArrayList<IClause>();
                ArrayList<ClausesPerType> toReturn = new ArrayList<ClausesPerType>();
                ArrayList<ClausesPerType> added = new ArrayList<ClausesPerType>();
                OrderClausesHolder orderClausesHolder = new OrderClausesHolder();
                boolean lastIsWith = false;
                for (i = startIdx; i < clausesPerTypeList.size(); ++i) {
                    ClausesPerType cpt = clausesPerTypeList.get(i);
                    if (cpt.collectionClauses != null) {
                        cpt.clauses = null;
                    }
                    if (cpt.valid) {
                        boolean startNewQueryAfterThis = false;
                        if (!context.execCount) {
                            if (cpt.needDistinctQuery()) {
                                if (i > startIdx) {
                                    startIdx = i;
                                    break;
                                }
                                orderClausesHolder.checkForOrdeClause(cpt);
                                orderClausesHolder.whereNot = WHERE.NOT().valueOf(cpt.node).IS_NULL();
                                startIdx = i + 1;
                                startNewQueryAfterThis = true;
                            } else {
                                orderClausesHolder.checkForOrdeClause(cpt);
                            }
                        }
                        if (cpt.startCountSelectXpr && i > startIdx) {
                            startIdx = i;
                            break;
                        }
                        cpt.addDependencyClauses(clauses, added, orderClausesHolder, cbContext, context.execCount);
                        clauses.addAll(cpt.getClauses(added));
                        if (APIAccess.isPartOfReturn(cpt.domainObjectMatch)) {
                            toReturn.add(cpt);
                            QueryContext.ResultsPerType resPerType = context.addFor(cpt, context.execCount);
                            context.resultsPerType.add(resPerType);
                            resPerType.queryIndex = queryIndex;
                        }
                        added.add(cpt);
                        lastIsWith = cpt.lastIsWith;
                        if (!startNewQueryAfterThis) continue;
                        break;
                    }
                    context.addEmptyFor(cpt);
                }
                if (i == clausesPerTypeList.size()) {
                    startIdx = i;
                }
                List<IClause> returnClauses = this.buildReturnClauses(toReturn, context.execCount);
                orderClausesHolder.addClauses(clauses, lastIsWith, toReturn);
                clauses.addAll(returnClauses);
                IClause[] clausesArray = clauses.toArray(new IClause[clauses.size()]);
                JcQuery query = new JcQuery();
                query.setClauses(clausesArray);
                ret.add(query);
            }
            return ret;
        }

        private List<IClause> buildReturnClauses(List<ClausesPerType> toReturn, boolean isCountQuery) {
            ArrayList<IClause> ret = new ArrayList<IClause>();
            int idx = 0;
            for (ClausesPerType cpt : toReturn) {
                RSortable returnClause;
                JcNode n = cpt.node;
                if (isCountQuery) {
                    returnClause = (RSortable)RETURN.count().DISTINCT().value(n).AS(this.getJcNumber(QueryExecutor.countPrefix, n));
                } else {
                    returnClause = cpt.isCollectExpression ? (idx == 0 ? RETURN.DISTINCT().value(cpt.node) : RETURN.value(cpt.node)) : (idx == 0 ? (RSortable)RETURN.DISTINCT().value(n.id()).AS(this.getJcNumber(QueryExecutor.idPrefix, n)) : (RSortable)RETURN.value(n.id()).AS(this.getJcNumber(QueryExecutor.idPrefix, n)));
                    if (cpt.pageOffset > 0) {
                        returnClause = (RSortable)returnClause.SKIP(cpt.pageOffset);
                    }
                    if (cpt.pageLength >= 0) {
                        returnClause = (RSortable)returnClause.LIMIT(cpt.pageLength);
                    }
                }
                ret.add(returnClause);
                ++idx;
            }
            return ret;
        }

        void extractUniqueIds(List<JcQueryResult> results, List<QueryContext.ResultsPerType> resultsPerTypeList) {
            LinkedHashSet<Long> uniqueIds = new LinkedHashSet<Long>();
            LinkedHashSet<Object> simpleVals = new LinkedHashSet<Object>();
            for (QueryContext.ResultsPerType resPerType : resultsPerTypeList) {
                uniqueIds.clear();
                simpleVals.clear();
                JcQueryResult result = results.get(resPerType.queryIndex);
                if (MappingUtil.isSimpleType(resPerType.type)) {
                    this.flatten(result.resultOf(resPerType.jcPrimitive), simpleVals);
                    resPerType.simpleValues = new ArrayList();
                    resPerType.simpleValues.addAll(simpleVals);
                    continue;
                }
                List<BigDecimal> idList = result.resultOf(resPerType.jcNumber);
                for (BigDecimal bd : idList) {
                    if (bd == null) continue;
                    uniqueIds.add(bd.longValue());
                }
                resPerType.ids = new ArrayList();
                resPerType.ids.addAll(uniqueIds);
            }
        }

        private void flatten(List<?> resultOf, Set<Object> simpleVals) {
            for (Object elem : resultOf) {
                if (elem instanceof List) {
                    simpleVals.addAll((java.util.Collection)elem);
                    continue;
                }
                simpleVals.add(elem);
            }
        }

        void extractCounts(List<JcQueryResult> results, List<QueryContext.ResultsPerType> resultsPerTypeList) {
            for (QueryContext.ResultsPerType resPerType : resultsPerTypeList) {
                JcQueryResult result = results.get(resPerType.queryIndex);
                List<BigDecimal> count = result.resultOf(resPerType.jcNumber);
                resPerType.count = count.get(0).longValue();
            }
        }

        private List<OrderExpression.OrderBy> getOrderExpressionsFor(ClausesPerType cpt) {
            ArrayList<OrderExpression.OrderBy> ret = null;
            OrderExpression oe = QueryExecutor.this.getOrderFor(cpt.domainObjectMatch);
            if (oe != null) {
                List<OrderExpression.OrderBy> ocs = oe.getOrderCriterias();
                for (OrderExpression.OrderBy ob : ocs) {
                    String attribName = ob.getAttributeName();
                    FieldMapping fm = QueryExecutor.this.getMappingInfo().getFieldMapping(attribName, cpt.domainObjectType);
                    if (fm == null) continue;
                    if (ret == null) {
                        ret = new ArrayList<OrderExpression.OrderBy>();
                    }
                    ret.add(ob);
                }
            }
            return ret;
        }

        private List<ExpressionsPerDOM> orderByDependencies(List<ExpressionsPerDOM> xpressionsPerDom) {
            ArrayList<ExpressionsPerDOM> ordered = new ArrayList<ExpressionsPerDOM>(xpressionsPerDom.size());
            ArrayList<ExpressionsPerDOM> tryingToAdd = new ArrayList<ExpressionsPerDOM>(xpressionsPerDom.size());
            for (ExpressionsPerDOM xpd : xpressionsPerDom) {
                this.addRecursive(xpd, xpressionsPerDom, ordered, tryingToAdd);
            }
            return ordered;
        }

        private void addRecursive(ExpressionsPerDOM add, List<ExpressionsPerDOM> xpressionsPerDom, List<ExpressionsPerDOM> ordered, List<ExpressionsPerDOM> tryingToAdd) {
            if (tryingToAdd.contains(add)) {
                throw new RuntimeException("circular dependencies in WHERE clauses");
            }
            for (ExpressionsPerDOM xp : tryingToAdd) {
                xp.addDependencies(add.flattenedDependencies);
                xp.addDependency(add);
            }
            if (add.dependencies == null || add.dependencies.isEmpty()) {
                if (!ordered.contains(add)) {
                    ordered.add(add);
                }
            } else if (!ordered.contains(add)) {
                tryingToAdd.add(add);
                for (DomainObjectMatch dom : add.dependencies) {
                    ExpressionsPerDOM xpd = this.getXprPerDom(dom, xpressionsPerDom);
                    this.addRecursive(xpd, xpressionsPerDom, ordered, tryingToAdd);
                }
                tryingToAdd.remove(add);
                ordered.add(add);
            }
        }

        private ExpressionsPerDOM getXprPerDom(DomainObjectMatch<?> dom, List<ExpressionsPerDOM> xpressionsPerDom) {
            for (ExpressionsPerDOM xpd : xpressionsPerDom) {
                if (!xpd.domainObjectMatch.equals(dom)) continue;
                return xpd;
            }
            return null;
        }

        private SkipLimitCalc.SkipsLimits calcSkipsLimits(DomainObjectMatch<?> dom, int offset, int len) {
            QueryContext cRes = QueryExecutor.this.loadCountResultIfNeeded();
            List rpts = (List)cRes.resultsMap.get(dom);
            ArrayList<Integer> counts = new ArrayList<Integer>(rpts.size());
            for (QueryContext.ResultsPerType rpt : rpts) {
                counts.add((int)rpt.count);
            }
            SkipLimitCalc.SkipsLimits slc = SkipLimitCalc.calcSkipsLimits(counts, offset, len);
            return slc;
        }

        private void testValidInOperation(PredicateExpression.Operator op, int paramPosition, PredicateExpression pred) {
            Object value;
            if (pred.getValue_1() instanceof Count && !pred.isInCollectionExpression()) {
                throw new RuntimeException("'COUNT' operation on a DomainObjectMatch is only valid within a collection expression");
            }
            if (op == PredicateExpression.Operator.CONTAINS) {
                if (pred.getValue_1() instanceof Count) {
                    throw new RuntimeException("'CONTAINS' cannot be applied to COUNT on DomainObject(s)");
                }
                if (!(pred.getValue_1() instanceof JcCollection || pred.isInCollectionExpression() && pred.getValue_1() instanceof DomainObjectMatch && pred.getValue_2() instanceof DomainObjectMatch)) {
                    if (!(pred.getValue_1() instanceof ValueElement)) {
                        throw new RuntimeException("'CONTAINS' operation on two DomainObjectMatch(es) is only valid within a collection expression");
                    }
                    throw new RuntimeException("'CONTAINS' operation can only be performed on a 'Collection Attribute'.\nUse .collectionAttribute() on the DomainObjectMatch to access the attribute for the 'CONTAINS' operation!");
                }
                return;
            }
            if (paramPosition == 1) {
                IPredicateOperand1 value2 = pred.getValue_1();
                if (value2 instanceof DomainObjectMatch && op != PredicateExpression.Operator.IN && op != PredicateExpression.Operator.IS_NULL) {
                    throw new RuntimeException("invalid parameter 1 in WHERE clause [" + op.name() + "]");
                }
            } else if (paramPosition == 2 && (value = pred.getValue_2()) instanceof DomainObjectMatch && op != PredicateExpression.Operator.IN) {
                throw new RuntimeException("invalid parameter 2 in WHERE clause [" + op.name() + "]");
            }
        }

        private List<JcNode> collectNodes(DomainObjectMatch<?> dom, List<String> validNodes, Class<?> resultType) {
            ArrayList<JcNode> ret = new ArrayList<JcNode>();
            if (resultType != null) {
                String nnm;
                JcNode n = APIAccess.getNodeForType(dom, resultType);
                if (n != null && validNodes.contains(nnm = ValueAccess.getName(n))) {
                    ret.add(n);
                }
            } else {
                List<JcNode> nodes = APIAccess.getNodes(dom);
                for (JcNode n : nodes) {
                    String nnm = ValueAccess.getName(n);
                    if (!validNodes.contains(nnm)) continue;
                    ret.add(n);
                }
            }
            return ret;
        }

        private List<Object> buildAllInstances(ValueElement ve, List<String> validNodes) {
            ArrayList<Object> ret = new ArrayList<Object>();
            List validFor = null;
            if (ve != null) {
                ValueElement first = ValueAccess.findFirst(ve);
                if (first instanceof JcNode) {
                    Object hint;
                    String nodeName = ValueAccess.getName((JcNode)first);
                    if (validNodes.contains(nodeName)) {
                        ret.add(ve);
                    }
                    if (validFor == null && (hint = ValueAccess.getAnyHint(ve, "vn")) instanceof List) {
                        validFor = (List)hint;
                    }
                    for (JcNode n : validFor) {
                        String nnm = ValueAccess.getName(n);
                        if (nodeName.equals(nnm) || !validNodes.contains(nnm)) continue;
                        ret.add(this.cloneVe(ve, first, n));
                    }
                } else {
                    ret.add(ve);
                }
            }
            return ret;
        }

        private ValueElement testAndCloneIfNeeded(ValueElement ve, ClausesPerType clausesPerType) {
            ValueElement first;
            ValueElement ret = ve;
            if (ve != null && (first = ValueAccess.findFirst(ve)) instanceof JcNode) {
                this.testValidForType((JcNode)first, ve, clausesPerType);
                if (clausesPerType.valid) {
                    if (!ValueAccess.getName((JcNode)first).equals(ValueAccess.getName(clausesPerType.node))) {
                        ret = this.cloneVe(ve, first, clausesPerType.node);
                    }
                } else {
                    ret = null;
                }
            }
            return ret;
        }

        private ValueElement cloneVe(ValueElement ve, ValueElement first, ValueElement newFirst) {
            ValueElement ret = ve;
            ValueElement prev = ve;
            ValueElement nextCloned = null;
            while (prev != first) {
                ValueElement cloned = ValueAccess.cloneShallow(prev);
                if (nextCloned != null) {
                    ValueAccess.setPredecessor(nextCloned, cloned);
                } else {
                    ret = cloned;
                }
                nextCloned = cloned;
                prev = ValueAccess.getPredecessor(prev);
            }
            if (nextCloned != null) {
                ValueAccess.setPredecessor(nextCloned, newFirst);
            } else {
                ret = newFirst;
            }
            return ret;
        }

        private void testValidForType(JcNode first, ValueElement ve, ClausesPerType clausesPerType) {
            if (ve == first) {
                clausesPerType.oneValid = true;
                return;
            }
            if (clausesPerType.previousOr || !Settings.strict) {
                clausesPerType.oneValid = true;
                return;
            }
            Object hint = ValueAccess.getAnyHint(ve, "vn");
            if (hint instanceof List) {
                List validFor = (List)hint;
                String nm = ValueAccess.getName(clausesPerType.node);
                for (JcNode n : validFor) {
                    if (!nm.startsWith(ValueAccess.getName(n))) continue;
                    clausesPerType.oneValid = true;
                    return;
                }
            }
            clausesPerType.testForNextIsOr = true;
        }

        private StateContext findXpressionsFor(DomainObjectMatch<?> dom, List<IASTObject> astObjs, int mode) {
            String baseNodeName = APIAccess.getBaseNodeName(dom);
            StateContext context = new StateContext(baseNodeName);
            for (int i = 0; i < astObjs.size(); ++i) {
                IASTObject astObj = astObjs.get(i);
                this.testXpressionFor(dom, baseNodeName, astObj, context, mode);
            }
            if (context.blockCount != 0) {
                throw new RuntimeException("bracket close mismatch");
            }
            if (context.state == State.HAS_XPRESSION) {
                this.removeEmptyBlocks(context.candidates);
            }
            return context;
        }

        private void removeEmptyBlocks(List<IASTObject> candidates) {
            int i;
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            ArrayList<Integer> orsToRemove = new ArrayList<Integer>();
            ArrayList<Integer> candidatesIndices = new ArrayList<Integer>();
            HashMap<Integer, Integer> bracketToOr = new HashMap<Integer, Integer>();
            int orIndexToTest = -1;
            boolean orMaybeValid = false;
            for (int i2 = 0; i2 < candidates.size(); ++i2) {
                IASTObject astObj = candidates.get(i2);
                if (astObj instanceof ConcatenateExpression) {
                    ConcatenateExpression.Concatenator concat = ((ConcatenateExpression)astObj).getConcatenator();
                    if (concat == ConcatenateExpression.Concatenator.BR_OPEN) {
                        if (orIndexToTest != -1) {
                            bracketToOr.put(i2, orIndexToTest);
                        }
                        orIndexToTest = -1;
                        candidatesIndices.add(i2);
                        orMaybeValid = false;
                        continue;
                    }
                    if (concat == ConcatenateExpression.Concatenator.BR_CLOSE) {
                        if (candidatesIndices.size() > 0) {
                            Integer idx = (Integer)candidatesIndices.remove(candidatesIndices.size() - 1);
                            Integer orIdx = (Integer)bracketToOr.get(idx);
                            orIndexToTest = orIdx != null ? orIdx : -1;
                            for (int j = toRemove.size() - 1; j >= 0; --j) {
                                if (idx >= (Integer)toRemove.get(j)) continue;
                                toRemove.remove(j);
                            }
                            toRemove.add(idx);
                            toRemove.add(i2);
                            continue;
                        }
                        orMaybeValid = true;
                        if (orIndexToTest != -1) {
                            orsToRemove.add(orIndexToTest);
                        }
                        orIndexToTest = -1;
                        continue;
                    }
                    if (concat != ConcatenateExpression.Concatenator.OR) continue;
                    if (!orMaybeValid) {
                        orsToRemove.add(i2);
                        continue;
                    }
                    orIndexToTest = i2;
                    orMaybeValid = false;
                    continue;
                }
                candidatesIndices.clear();
                orMaybeValid = true;
                orIndexToTest = -1;
            }
            if (orIndexToTest != -1) {
                orsToRemove.add(orIndexToTest);
            }
            int prevCloseIndex = -1;
            for (i = toRemove.size() - 1; i >= 0; --i) {
                int idx = (Integer)toRemove.get(i);
                if (prevCloseIndex == -1) {
                    candidates.remove(idx);
                } else {
                    for (int j = prevCloseIndex - 1; j >= idx; --j) {
                        candidates.remove(j);
                    }
                    int adjust = prevCloseIndex - idx + 1;
                    for (int j = orsToRemove.size() - 1; j >= 0; --j) {
                        int oidx = (Integer)orsToRemove.get(j);
                        if (oidx > idx && oidx < prevCloseIndex) {
                            orsToRemove.remove(j);
                            continue;
                        }
                        if (oidx <= prevCloseIndex) continue;
                        orsToRemove.set(j, oidx - adjust);
                    }
                }
                prevCloseIndex = prevCloseIndex == -1 ? idx : -1;
            }
            Collections.sort(orsToRemove);
            for (i = orsToRemove.size() - 1; i >= 0; --i) {
                int idx = (Integer)orsToRemove.get(i);
                candidates.remove(idx);
            }
        }

        private void testXpressionFor(DomainObjectMatch<?> dom, String baseNodeName, IASTObject astObj, StateContext context, int mode) {
            FromPreviousQueryExpression fpe;
            if (astObj instanceof PredicateExpression) {
                String nodeName_2;
                PredicateExpression pred = (PredicateExpression)astObj;
                boolean isXpr = false;
                IPredicateOperand1 val1 = pred.getValue_1();
                String nodeName_1 = this.getNodeName(val1);
                int orRemoveState = 0;
                boolean isCount = val1 instanceof Count;
                if (mode == 0 || isCount && mode == 2 || !isCount && mode == 1) {
                    DomainObjectMatch<?> udom;
                    if (isCount && APIAccess.isPartOfUnionExpression(udom = APIAccess.getDomainObjectMatch((Count)val1), dom)) {
                        nodeName_1 = APIAccess.getBaseNodeName(dom);
                    }
                    if (nodeName_1 != null && nodeName_1.indexOf(baseNodeName) == 0) {
                        if (context.orToAdd != null) {
                            context.candidates.add(context.orToAdd);
                        }
                        context.candidates.add(astObj);
                        isXpr = true;
                        context.state = State.HAS_XPRESSION;
                        orRemoveState = -1;
                    }
                }
                if (isXpr && (nodeName_2 = this.getNodeName(pred.getValue_2())) != null && nodeName_2.indexOf(baseNodeName) < 0) {
                    context.addDependency(nodeName_2);
                }
                context.orRemoveState = orRemoveState;
                context.orToAdd = null;
            } else if (astObj instanceof ConcatenateExpression) {
                boolean isOr = false;
                int orRemoveState = -1;
                ConcatenateExpression conc = (ConcatenateExpression)astObj;
                if (conc.getConcatenator() == ConcatenateExpression.Concatenator.BR_OPEN) {
                    context.blockCount++;
                    if (context.orToAdd != null) {
                        context.candidates.add(context.orToAdd);
                    }
                } else if (conc.getConcatenator() == ConcatenateExpression.Concatenator.BR_CLOSE) {
                    if (context.blockCount <= 0) {
                        throw new RuntimeException("bracket close mismatch");
                    }
                    context.blockCount--;
                } else if (conc.getConcatenator() == ConcatenateExpression.Concatenator.OR) {
                    orRemoveState = context.orRemoveState;
                    isOr = true;
                }
                context.orToAdd = null;
                if (orRemoveState != 0) {
                    if (isOr) {
                        context.orToAdd = astObj;
                    } else {
                        context.candidates.add(astObj);
                    }
                }
                context.orRemoveState = orRemoveState;
            } else if (astObj instanceof TraversalExpression) {
                TraversalExpression te = (TraversalExpression)astObj;
                String bName = APIAccess.getBaseNodeName(te.getEnd());
                if (baseNodeName.equals(bName)) {
                    context.candidates.add(astObj);
                    context.state = State.HAS_XPRESSION;
                    bName = APIAccess.getBaseNodeName(te.getStart());
                    context.addDependency(bName);
                }
            } else if (astObj instanceof SelectExpression) {
                SelectExpression se = (SelectExpression)astObj;
                String bName = APIAccess.getBaseNodeName(se.getEnd());
                if (baseNodeName.equals(bName)) {
                    context.candidates.add(astObj);
                    context.state = State.HAS_XPRESSION;
                    bName = APIAccess.getBaseNodeName(se.getStart());
                    context.addDependency(bName);
                    for (IASTObject ao : se.getAstObjects()) {
                        if (!(ao instanceof PredicateExpression)) continue;
                        PredicateExpression pred = (PredicateExpression)ao;
                        context.addDependency(this.getNodeName(pred.getValue_1()));
                        context.addDependency(this.getNodeName(pred.getValue_2()));
                    }
                }
            } else if (astObj instanceof CollectExpression) {
                CollectExpression ce = (CollectExpression)astObj;
                String bName = APIAccess.getBaseNodeName(ce.getEnd());
                if (baseNodeName.equals(bName)) {
                    context.candidates.add(astObj);
                    context.state = State.HAS_XPRESSION;
                    bName = APIAccess.getBaseNodeName(ce.getStartDOM());
                    context.addDependency(bName);
                }
            } else if (astObj instanceof FromPreviousQueryExpression && (fpe = (FromPreviousQueryExpression)astObj).getActualMatch() == dom) {
                context.candidates.add(astObj);
                context.state = State.HAS_XPRESSION;
            }
        }

        private String getNodeName(Object value) {
            if (value instanceof ValueElement) {
                ValueElement ve = (ValueElement)value;
                ValueElement first = ValueAccess.findFirst(ve);
                if (first instanceof JcNode) {
                    return ValueAccess.getName((JcNode)first);
                }
            } else {
                if (value instanceof DomainObjectMatch) {
                    return APIAccess.getBaseNodeName((DomainObjectMatch)value);
                }
                if (value instanceof Count) {
                    return APIAccess.getBaseNodeName(APIAccess.getDomainObjectMatch((Count)value));
                }
            }
            return null;
        }

        private JcNumber getJcNumber(String prefix, JcNode n) {
            String nm = ValueAccess.getName(n);
            nm = nm.substring("n_".length());
            nm = prefix.concat(nm);
            return new JcNumber(nm);
        }

        private class ExpressionsPerDOM {
            private DomainObjectMatch<?> domainObjectMatch;
            private List<IASTObject> xPressions;
            private List<DomainObjectMatch<?>> dependencies;
            private List<ExpressionsPerDOM> flattenedDependencies;
            private List<ClausesPerType> clausesPerTypes;

            private ExpressionsPerDOM(DomainObjectMatch<?> domainObjectMatch, List<IASTObject> xPressions, List<String> deps) {
                this.domainObjectMatch = domainObjectMatch;
                this.xPressions = xPressions;
                if (deps != null) {
                    this.dependencies = new ArrayList(deps.size());
                    block0: for (String nn : deps) {
                        for (DomainObjectMatch dom : QueryExecutor.this.domainObjectMatches) {
                            if (!APIAccess.getBaseNodeName(dom).equals(nn)) continue;
                            this.dependencies.add(dom);
                            continue block0;
                        }
                    }
                }
            }

            private void addDependencies(List<ExpressionsPerDOM> xpds) {
                if (xpds != null) {
                    if (this.flattenedDependencies == null) {
                        this.flattenedDependencies = new ArrayList<ExpressionsPerDOM>();
                        this.flattenedDependencies.addAll(xpds);
                    } else {
                        for (ExpressionsPerDOM xpd : xpds) {
                            if (this.flattenedDependencies.contains(xpd)) continue;
                            this.flattenedDependencies.add(xpd);
                        }
                    }
                }
            }

            private void addDependency(ExpressionsPerDOM xpd) {
                if (this.flattenedDependencies == null) {
                    this.flattenedDependencies = new ArrayList<ExpressionsPerDOM>();
                }
                this.flattenedDependencies.add(xpd);
            }
        }

        private class ClausesPerType {
            private DomainObjectMatch<?> domainObjectMatch;
            private JcNode node;
            private Class<?> domainObjectType;
            private boolean valid;
            private boolean oneValid;
            private boolean previousOr;
            private boolean testForNextIsOr;
            private int pageOffset;
            private int pageLength;
            private List<IClause> clauses;
            private ExpressionsPerDOM expressionsPerDOM;
            private Concat concat = null;
            private Concatenator concatenator = null;
            private List<IClause> traversalClauses;
            private List<IClause> collectionClauses;
            private List<Long> startIds;
            private boolean lastIsWith;
            private boolean isCollectExpression;
            private boolean startCountSelectXpr;
            private List<Integer> withClausesAddIdxs;
            private boolean closeBracket;

            private ClausesPerType(JcNode node, DomainObjectMatch<?> dom, Class<?> type) {
                this.node = node;
                this.domainObjectMatch = dom;
                this.domainObjectType = type;
                this.valid = true;
                this.oneValid = false;
                this.previousOr = false;
                this.testForNextIsOr = false;
                this.closeBracket = false;
                this.startCountSelectXpr = false;
                this.isCollectExpression = false;
                this.lastIsWith = false;
            }

            private boolean needDistinctQuery() {
                return this.pageOffset > 0 || this.pageLength >= 0;
            }

            private JcNumber getJcNumber(String prefix) {
                return QueryBuilder.this.getJcNumber(prefix, this.node);
            }

            private List<IClause> getClauses(List<ClausesPerType> added) {
                if (this.clauses == null && this.valid) {
                    this.clauses = new ArrayList<IClause>();
                    if (this.traversalClauses != null) {
                        IClause cl;
                        if (this.concatenator != null && (cl = this.traversalClauses.get(this.traversalClauses.size() - 1)) instanceof Concatenator) {
                            this.traversalClauses.remove(this.traversalClauses.size() - 1);
                        }
                        this.clauses.addAll(this.traversalClauses);
                        this.traversalClauses = null;
                    } else if (this.collectionClauses != null) {
                        int offset = this.clauses.size();
                        this.clauses.addAll(this.collectionClauses);
                        if (this.withClausesAddIdxs != null) {
                            for (int idx : this.withClausesAddIdxs) {
                                for (ClausesPerType cpt : added) {
                                    this.clauses.add(idx + offset, WITH.value(cpt.node));
                                }
                            }
                        }
                    } else {
                        String nodeLabel = QueryExecutor.this.getMappingInfo().getLabelForClass(this.domainObjectType);
                        if (this.startIds != null) {
                            long[] sids = new long[this.startIds.size()];
                            for (int i = 0; i < this.startIds.size(); ++i) {
                                sids[i] = this.startIds.get(i);
                            }
                            this.clauses.add(START.node(this.node).byId(sids));
                        } else {
                            this.clauses.add(OPTIONAL_MATCH.node(this.node).label(nodeLabel));
                        }
                    }
                    if (this.concatenator != null) {
                        this.clauses.add(this.closeBracket ? this.concatenator.BR_CLOSE() : this.concatenator);
                    } else {
                        this.clauses.add(SEPARATE.nextClause());
                    }
                }
                return this.clauses;
            }

            private void addClausesTo(List<IClause> clauses, List<ClausesPerType> added) {
                List<IClause> mcs = this.getClauses(added);
                if (mcs != null) {
                    clauses.addAll(mcs);
                }
            }

            private void addDependencyClauses(List<IClause> clauses, List<ClausesPerType> added, OrderClausesHolder withClausesHolder, ClauseBuilderContext cbContext, boolean isCountQuery) {
                if (this.expressionsPerDOM.flattenedDependencies != null) {
                    for (ExpressionsPerDOM xpd : this.expressionsPerDOM.flattenedDependencies) {
                        List<DomainObjectMatch<?>> collOwner = APIAccess.getCollectExpressionOwner(xpd.domainObjectMatch);
                        boolean addExpressions = collOwner == null || !collOwner.contains(this.domainObjectMatch);
                        for (ClausesPerType cpt : xpd.clausesPerTypes) {
                            if (!cbContext.isNodeValid(cpt.node) || added.contains(cpt) || !addExpressions) continue;
                            if (!isCountQuery) {
                                withClausesHolder.checkForOrdeClause(cpt);
                            }
                            cpt.addClausesTo(clauses, added);
                            added.add(cpt);
                        }
                    }
                }
            }

            private boolean isValidDependency(String vn, List<String> depBases) {
                for (String bnm : depBases) {
                    if (!vn.startsWith(bnm)) continue;
                    return true;
                }
                return false;
            }
        }

        private class StateContext {
            private State state = State.INIT;
            private int blockCount = 0;
            private String baseNodeName;
            private List<IASTObject> candidates = new ArrayList<IASTObject>();
            private List<String> dependencies;
            private int orRemoveState = -1;
            private IASTObject orToAdd;

            private StateContext(String bndNm) {
                this.baseNodeName = bndNm;
            }

            private void addDependency(String nodeName) {
                if (nodeName != null) {
                    String nn = nodeName;
                    if (this.dependencies == null) {
                        this.dependencies = new ArrayList<String>();
                    }
                    int idx = nodeName.indexOf(95);
                    if ((idx = nodeName.indexOf(95, idx + 1)) >= 0) {
                        nn = nodeName.substring(0, idx);
                    }
                    if (!nn.equals(this.baseNodeName) && !this.dependencies.contains(nn)) {
                        this.dependencies.add(nn);
                    }
                }
            }
        }

        private class ClauseBuilderContext {
            private int stepClausesCount = 0;
            private List<String> validNodes;
            private Map<DomainObjectMatch<?>, Map<DomainObjectMatch<?>, TraversalResultPerTypes>> travClausesPerCollectXpr;

            private ClauseBuilderContext(List<String> validNodes) {
                this.validNodes = validNodes;
            }

            private void addCountFor(DomainObjectMatch<?> collOwner, DomainObjectMatch<?> travOwner, String startNodeName, JcNode endNd) {
                TraversalResultPerTypes travResPerTypes = this.getTraversalResultPerTypes(collOwner, travOwner, true);
                travResPerTypes.addCount(startNodeName, endNd);
            }

            private List<JcNode> getCountsFor(DomainObjectMatch<?> collOwner, DomainObjectMatch<?> travOwner, String startNodeName) {
                UnionExpression ue = APIAccess.getUnionExpression(travOwner);
                if (ue != null) {
                    ArrayList<JcNode> ret = new ArrayList<JcNode>();
                    for (DomainObjectMatch<?> dom : ue.getSources()) {
                        List cf;
                        TraversalResultPerTypes travResPerTypes = this.getTraversalResultPerTypes(collOwner, dom, false);
                        if (travResPerTypes == null || (cf = travResPerTypes.getCountsFor(startNodeName)) == null) continue;
                        ret.addAll(travResPerTypes.getCountsFor(startNodeName));
                    }
                    return ret;
                }
                TraversalResultPerTypes travResPerTypes = this.getTraversalResultPerTypes(collOwner, travOwner, false);
                if (travResPerTypes != null) {
                    return travResPerTypes.getCountsFor(startNodeName);
                }
                return null;
            }

            private void addTravClausesPerColl(DomainObjectMatch<?> collOwner, DomainObjectMatch<?> travOwner, Class<?> travOwnerType, ClauseBuilder.TraversalResult travResult) {
                TraversalResultPerTypes travResPerTypes = this.getTraversalResultPerTypes(collOwner, travOwner, true);
                travResPerTypes.addTravResult(travOwnerType, travResult);
            }

            private TraversalResultPerTypes getTraversalResultPerTypes(DomainObjectMatch<?> collOwner, DomainObjectMatch<?> travOwner, boolean doCreate) {
                TraversalResultPerTypes travResPerTypes;
                Map<DomainObjectMatch<?>, TraversalResultPerTypes> travResOwnerMap;
                if (this.travClausesPerCollectXpr == null) {
                    if (!doCreate) {
                        return null;
                    }
                    this.travClausesPerCollectXpr = new HashMap();
                }
                if ((travResOwnerMap = this.travClausesPerCollectXpr.get(collOwner)) == null) {
                    if (!doCreate) {
                        return null;
                    }
                    travResOwnerMap = new HashMap();
                    this.travClausesPerCollectXpr.put(collOwner, travResOwnerMap);
                }
                if ((travResPerTypes = travResOwnerMap.get(travOwner)) == null) {
                    if (!doCreate) {
                        return null;
                    }
                    travResPerTypes = new TraversalResultPerTypes();
                    travResOwnerMap.put(travOwner, travResPerTypes);
                }
                return travResPerTypes;
            }

            private ClauseBuilder.TraversalResult getTravResult(DomainObjectMatch<?> collOwner, DomainObjectMatch<?> travOwner, Class<?> travOwnerType) {
                TraversalResultPerTypes travResPerTypes = this.getTraversalResultPerTypes(collOwner, travOwner, false);
                if (travResPerTypes != null) {
                    return travResPerTypes.getTravResult(travOwnerType);
                }
                return null;
            }

            private boolean isNodeValid(JcNode nd) {
                String ndName = ValueAccess.getName(nd);
                for (String n : this.validNodes) {
                    if (!n.equals(ndName)) continue;
                    return true;
                }
                return false;
            }

            private List<JcNode> filterValidNodes(List<JcNode> nds) {
                ArrayList<JcNode> ret = new ArrayList<JcNode>();
                for (JcNode n : nds) {
                    if (!this.isNodeValid(n)) continue;
                    ret.add(n);
                }
                return ret;
            }

            private class TraversalResultPerTypes {
                private Map<Class<?>, ClauseBuilder.TraversalResult> travResultsPerType;
                private Map<String, List<JcNode>> startNode2CountMap;

                private TraversalResultPerTypes() {
                }

                private void addCount(String startNodeName, JcNode endNode) {
                    List<JcNode> endNodes;
                    if (this.startNode2CountMap == null) {
                        this.startNode2CountMap = new HashMap<String, List<JcNode>>();
                    }
                    if ((endNodes = this.startNode2CountMap.get(startNodeName)) == null) {
                        endNodes = new ArrayList<JcNode>();
                        this.startNode2CountMap.put(startNodeName, endNodes);
                    }
                    endNodes.add(endNode);
                }

                private List<JcNode> getCountsFor(String startNodeName) {
                    if (this.startNode2CountMap != null) {
                        return this.startNode2CountMap.get(startNodeName);
                    }
                    return null;
                }

                private void addTravResult(Class<?> travOwnerType, ClauseBuilder.TraversalResult traversalresult) {
                    if (this.travResultsPerType == null) {
                        this.travResultsPerType = new HashMap();
                    }
                    this.travResultsPerType.put(travOwnerType, traversalresult);
                }

                private ClauseBuilder.TraversalResult getTravResult(Class<?> travOwnerType) {
                    if (this.travResultsPerType != null) {
                        return this.travResultsPerType.get(travOwnerType);
                    }
                    return null;
                }
            }
        }

        private class ClauseBuilder {
            private ClauseBuilder() {
            }

            private List<ClausesPerType> buildClausesFor(ExpressionsPerDOM xpd, ClauseBuilderContext cbContext, boolean calcCounts) {
                List<Object> lens;
                List<Object> offsets;
                int len;
                DomainObjectMatch dom = xpd.domainObjectMatch;
                List xpressionsForDom = xpd.xPressions;
                ArrayList<ClausesPerType> clausesPerTypeList = new ArrayList<ClausesPerType>();
                List<JcNode> nodes = APIAccess.getNodes(dom);
                List<Class<?>> typeList = APIAccess.getTypeList(dom);
                int numTypes = typeList.size();
                int offset = calcCounts ? 0 : APIAccess.getPageOffset(dom);
                int n = len = calcCounts ? -1 : APIAccess.getPageLength(dom);
                if (numTypes > 1 && (offset > 0 || len >= 0) && APIAccess.isPageChanged(dom)) {
                    SkipLimitCalc.SkipsLimits slc = QueryBuilder.this.calcSkipsLimits(dom, offset, len);
                    offsets = slc.getOffsets();
                    lens = slc.getLengths();
                } else {
                    offsets = new ArrayList<Integer>(numTypes);
                    lens = new ArrayList(numTypes);
                    if (numTypes == 1) {
                        offsets.add(offset);
                        lens.add(len);
                    } else {
                        for (int i = 0; i < numTypes; ++i) {
                            offsets.add(0);
                            lens.add(-1);
                        }
                    }
                }
                int idx = 0;
                for (JcNode n2 : nodes) {
                    ClausesPerType cpt = new ClausesPerType(n2, dom, typeList.get(idx));
                    cpt.expressionsPerDOM = xpd;
                    cpt.pageOffset = (Integer)offsets.get(idx);
                    cpt.pageLength = (Integer)lens.get(idx);
                    clausesPerTypeList.add(cpt);
                    ++idx;
                }
                cbContext.stepClausesCount = 0;
                for (IASTObject astObj : xpressionsForDom) {
                    for (ClausesPerType clausePerType : clausesPerTypeList) {
                        if (!clausePerType.valid) continue;
                        List<TraversalResult> travResults = this.forCollectionOwnersOf(clausePerType.domainObjectMatch, clausePerType.domainObjectType, cbContext);
                        this.addClause(astObj, clausePerType, cbContext);
                        if (travResults == null) continue;
                        for (TraversalResult tr : travResults) {
                            for (ClausesPerType cpt : tr.getClausesPerTypeList()) {
                                if (cpt.concatenator == null && cpt.concat == null) {
                                    cpt.concat = WHERE.BR_OPEN();
                                }
                                this.addClause(astObj, cpt, cbContext);
                            }
                        }
                    }
                }
                for (ClausesPerType clausePerType : clausesPerTypeList) {
                    if (!clausePerType.valid) continue;
                    if (clausePerType.testForNextIsOr && !clausePerType.oneValid) {
                        clausePerType.valid = false;
                        continue;
                    }
                    String nm = ValueAccess.getName(clausePerType.node);
                    cbContext.validNodes.add(nm);
                }
                xpd.clausesPerTypes = clausesPerTypeList;
                return clausesPerTypeList;
            }

            private List<TraversalResult> forCollectionOwnersOf(DomainObjectMatch<?> travOwner, Class<?> travOwnerType, ClauseBuilderContext cbContext) {
                List<DomainObjectMatch<?>> collOwners = APIAccess.getCollectExpressionOwner(travOwner);
                if (collOwners != null) {
                    ArrayList<TraversalResult> ret = new ArrayList<TraversalResult>();
                    for (DomainObjectMatch<?> collOwner : collOwners) {
                        TraversalResult tr = cbContext.getTravResult(collOwner, travOwner, travOwnerType);
                        if (tr == null) continue;
                        ret.add(tr);
                    }
                    return ret;
                }
                return null;
            }

            private void addClause(IASTObject astObj, ClausesPerType clausePerType, ClauseBuilderContext cbContext) {
                if (clausePerType.collectionClauses != null && !clausePerType.closeBracket) {
                    clausePerType.concat = clausePerType.concatenator.AND().BR_OPEN();
                    clausePerType.concatenator = null;
                    clausePerType.closeBracket = true;
                }
                if (astObj instanceof ConcatenateExpression) {
                    ConcatenateExpression conc = (ConcatenateExpression)astObj;
                    if (conc.getConcatenator() == ConcatenateExpression.Concatenator.BR_OPEN) {
                        if (clausePerType.concatenator == null) {
                            if (clausePerType.concat == null) {
                                if (clausePerType.traversalClauses != null) {
                                    this.initTraversalConcat(clausePerType);
                                } else {
                                    clausePerType.concat = WHERE.BR_OPEN();
                                }
                                clausePerType.previousOr = false;
                            } else {
                                clausePerType.concat = clausePerType.concat.BR_OPEN();
                            }
                        } else {
                            clausePerType.concat = clausePerType.concatenator.AND().BR_OPEN();
                            clausePerType.concatenator = null;
                            clausePerType.previousOr = false;
                        }
                        if (clausePerType.testForNextIsOr) {
                            clausePerType.valid = false;
                        }
                    } else if (conc.getConcatenator() == ConcatenateExpression.Concatenator.BR_CLOSE) {
                        if (clausePerType.concatenator == null) {
                            throw new RuntimeException("illegal statement: " + conc.getConcatenator().name());
                        }
                        clausePerType.concatenator = clausePerType.concatenator.BR_CLOSE();
                        clausePerType.previousOr = false;
                    } else if (conc.getConcatenator() == ConcatenateExpression.Concatenator.OR) {
                        if (clausePerType.concatenator == null) {
                            throw new RuntimeException("illegal statement: " + conc.getConcatenator().name());
                        }
                        clausePerType.concat = clausePerType.concatenator.OR();
                        clausePerType.previousOr = true;
                        clausePerType.testForNextIsOr = false;
                        clausePerType.concatenator = null;
                    }
                } else if (astObj instanceof PredicateExpression) {
                    if (clausePerType.testForNextIsOr) {
                        clausePerType.valid = false;
                        return;
                    }
                    PredicateExpression pred = (PredicateExpression)astObj;
                    if (clausePerType.traversalClauses != null && clausePerType.concat == null) {
                        this.initTraversalConcat(clausePerType);
                    }
                    Concat concat_1 = clausePerType.concat;
                    if (clausePerType.concatenator != null) {
                        concat_1 = clausePerType.concatenator.AND();
                        clausePerType.previousOr = false;
                    }
                    clausePerType.concatenator = this.buildPredicateExpression(pred, concat_1, clausePerType, cbContext);
                } else if (astObj instanceof TraversalExpression) {
                    clausePerType.traversalClauses = this.createTraversalClauses(clausePerType.node, clausePerType, (TraversalExpression)astObj, cbContext, false, null).getAllClauses();
                    List<DomainObjectMatch<?>> collXOwner = APIAccess.getCollectExpressionOwner(((TraversalExpression)astObj).getEnd());
                    if (collXOwner != null) {
                        for (DomainObjectMatch<?> dom : collXOwner) {
                            String nnm = ValueAccess.getName(clausePerType.node).concat(QueryExecutor.collNodePostPrefix).concat(APIAccess.getBaseNodeName(dom));
                            TraversalResult travResult = this.createTraversalClauses(new JcNode(nnm), clausePerType, (TraversalExpression)astObj, cbContext, true, dom);
                            cbContext.addTravClausesPerColl(dom, clausePerType.domainObjectMatch, clausePerType.domainObjectType, travResult);
                        }
                    }
                } else if (astObj instanceof SelectExpression) {
                    this.createAddSelectClauses(clausePerType, (SelectExpression)astObj, cbContext);
                } else if (astObj instanceof CollectExpression) {
                    this.createCollectClauses(clausePerType, (CollectExpression)astObj, cbContext);
                } else if (astObj instanceof FromPreviousQueryExpression) {
                    this.createFromPrevQueryClauses(clausePerType, (FromPreviousQueryExpression)astObj, cbContext);
                }
            }

            private void initTraversalConcat(ClausesPerType cpt) {
                IClause cl = (IClause)cpt.traversalClauses.get(cpt.traversalClauses.size() - 1);
                if (cl instanceof Concatenator) {
                    cpt.concat = ((Concatenator)cl).AND().BR_OPEN();
                    cpt.closeBracket = true;
                }
            }

            private Concatenator buildPredicateExpression(PredicateExpression pred, Concat concat, ClausesPerType clausesPerType, ClauseBuilderContext cbContext) {
                Concatenator ret = null;
                int neg = pred.getNegationCount();
                Concat concat_1 = null;
                PredicateExpression.Operator op = pred.getOperator();
                ValueElement val_1 = null;
                IPredicateOperand1 v_1 = pred.getValue_1();
                QueryBuilder.this.testValidInOperation(op, 1, pred);
                if (v_1 instanceof ValueElement) {
                    val_1 = QueryBuilder.this.testAndCloneIfNeeded((ValueElement)v_1, clausesPerType);
                } else if (v_1 instanceof DomainObjectMatch || v_1 instanceof Count) {
                    val_1 = clausesPerType.node;
                }
                if (val_1 != null) {
                    Object val_2 = pred.getValue_2();
                    if (val_2 instanceof Parameter) {
                        val_2 = ((Parameter)val_2).getValue();
                    }
                    QueryBuilder.this.testValidInOperation(op, 2, pred);
                    boolean val2IsDom = false;
                    List val_2s = null;
                    if (val_2 instanceof IPredicateOperand1) {
                        if (val_2 instanceof DomainObjectMatch) {
                            val2IsDom = true;
                            val_2s = new ArrayList();
                            val_2s.add(QueryBuilder.this.collectNodes((DomainObjectMatch)val_2, cbContext.validNodes, clausesPerType.domainObjectType));
                        } else {
                            val_2s = QueryBuilder.this.buildAllInstances((ValueElement)val_2, cbContext.validNodes);
                        }
                    } else if (val_2 != null) {
                        val_2s = new ArrayList<Object>();
                        val_2s.add(val_2);
                    }
                    int cnt = val_2s != null ? val_2s.size() : 1;
                    boolean negate = false;
                    if (val2IsDom && neg > 0) {
                        --neg;
                        negate = true;
                    }
                    int i = neg;
                    while (neg > 0) {
                        concat_1 = i == neg ? (concat == null ? (Concat)WHERE.NOT() : (Concat)concat.NOT()) : (Concat)concat_1.NOT();
                        --neg;
                    }
                    if (concat_1 == null) {
                        concat_1 = concat;
                    }
                    if (cnt > 1 || val2IsDom) {
                        concat_1 = concat_1 != null ? concat_1.BR_OPEN() : WHERE.BR_OPEN();
                    }
                    BooleanOperation booleanOp = !val2IsDom ? (concat_1 == null ? WHERE.valueOf(val_1) : concat_1.valueOf(val_1)) : null;
                    for (i = 0; i < cnt; ++i) {
                        if (val_2s != null) {
                            val_2 = val_2s.get(i);
                        }
                        if (op == PredicateExpression.Operator.EQUALS) {
                            ret = booleanOp.EQUALS(val_2);
                        } else if (op == PredicateExpression.Operator.GT) {
                            ret = booleanOp.GT(val_2);
                        } else if (op == PredicateExpression.Operator.GTE) {
                            ret = booleanOp.GTE(val_2);
                        } else if (op == PredicateExpression.Operator.IN) {
                            ret = val2IsDom ? this.createWhereIn(concat_1, val_1, (List)val_2, negate) : booleanOp.IN_list(new Object[]{val_2});
                        } else if (op == PredicateExpression.Operator.CONTAINS) {
                            ret = val2IsDom ? this.createWhereIn(concat_1, val_1, (List)val_2, negate) : this.createContains(concat_1, (JcCollection)val_1, (Object[])val_2, negate);
                        } else if (op == PredicateExpression.Operator.IS_NULL) {
                            ret = booleanOp.IS_NULL();
                        } else if (op == PredicateExpression.Operator.LIKE) {
                            ret = booleanOp.REGEX(val_2.toString());
                        } else if (op == PredicateExpression.Operator.LT) {
                            ret = booleanOp.LT(val_2);
                        } else if (op == PredicateExpression.Operator.LTE) {
                            ret = booleanOp.LTE(val_2);
                        } else if (op == PredicateExpression.Operator.STARTS_WITH) {
                            ret = booleanOp.STARTS_WITH(val_2.toString());
                        } else if (op == PredicateExpression.Operator.ENDS_WITH) {
                            ret = booleanOp.ENDS_WITH(val_2.toString());
                        } else if (op == PredicateExpression.Operator.CONTAINS_STRING) {
                            ret = booleanOp.CONTAINS(val_2.toString());
                        }
                        if (i >= cnt - 1) continue;
                        booleanOp = ret.OR().valueOf(val_1);
                    }
                    if (cnt > 1) {
                        ret = ret.BR_CLOSE();
                    }
                } else {
                    clausesPerType.valid = false;
                }
                return ret;
            }

            private Concatenator createContains(Concat concat, JcCollection val_1, Object[] val_2, boolean negate) {
                JcValue x = new JcValue("x");
                Concatenator fx = null;
                if (val_2.length == 1) {
                    fx = concat != null ? concat.holdsTrue(((CWhere)I.forAny(x).IN(val_1)).WHERE().valueOf(x).EQUALS(val_2[0])) : WHERE.holdsTrue(((CWhere)I.forAny(x).IN(val_1)).WHERE().valueOf(x).EQUALS(val_2[0]));
                } else if (val_2.length > 1) {
                    Concat concat_1 = concat != null ? concat.BR_OPEN() : WHERE.BR_OPEN();
                    for (int i = 0; i < val_2.length; ++i) {
                        fx = fx == null ? concat_1.holdsTrue(((CWhere)I.forAny(x).IN(val_1)).WHERE().valueOf(x).EQUALS(val_2[i])) : fx.AND().holdsTrue(((CWhere)I.forAny(x).IN(val_1)).WHERE().valueOf(x).EQUALS(val_2[i]));
                    }
                    fx = fx.BR_CLOSE();
                }
                return fx;
            }

            private Concatenator createWhereIn(Concat concat, ValueElement val_1, List<JcNode> val_2, boolean not) {
                Concatenator booleanOp = null;
                Concat concat_1 = concat;
                if (val_2.isEmpty()) {
                    iot.jcypher.query.ast.predicate.PredicateExpression px = (iot.jcypher.query.ast.predicate.PredicateExpression)APIObjectAccess.getAstNode(concat_1);
                    IPredicateHolder ph = px.getLastPredicateHolder();
                    BooleanValue bv = new BooleanValue(false);
                    ph.setPredicate(bv);
                    booleanOp = PFactory.createConcatenator((iot.jcypher.query.ast.predicate.PredicateExpression)ph).BR_CLOSE();
                } else {
                    int idx = 0;
                    for (JcNode n : val_2) {
                        if (idx == 0 && val_2.size() > 1) {
                            concat_1 = concat_1.BR_OPEN();
                        }
                        if (not) {
                            booleanOp = idx == 0 ? concat_1.valueOf(n).IS_NULL().OR().NOT().valueOf(val_1).IN_list(new Object[]{n}).BR_CLOSE() : booleanOp.AND().BR_OPEN().valueOf(n).IS_NULL().OR().NOT().valueOf(val_1).IN_list(new Object[]{n}).BR_CLOSE();
                        } else if (idx == 0) {
                            booleanOp = concat_1.NOT().valueOf(n).IS_NULL().AND().valueOf(val_1).IN_list(new Object[]{n}).BR_CLOSE();
                        } else {
                            booleanOp.OR().BR_OPEN().NOT().valueOf(n).IS_NULL().AND().valueOf(val_1).IN_list(new Object[]{n}).BR_CLOSE();
                        }
                        if (idx == val_2.size() - 1 && val_2.size() > 1) {
                            booleanOp = booleanOp.BR_CLOSE();
                        }
                        ++idx;
                    }
                }
                return booleanOp;
            }

            private TraversalResult createTraversalClauses(JcNode origEndNode, ClausesPerType clausesPerType, TraversalExpression travEx, ClauseBuilderContext cbContext, boolean copy, DomainObjectMatch<?> collOwner) {
                TraversalResult ret = new TraversalResult();
                ret.expressionParts = new ArrayList();
                String startBName = APIAccess.getBaseNodeName(travEx.getStart());
                String endNodeLabel = QueryExecutor.this.getMappingInfo().getLabelForClass(clausesPerType.domainObjectType);
                String origEndNodeName = ValueAccess.getName(origEndNode);
                ArrayList<StepClause> stepCls = new ArrayList<StepClause>();
                for (String validNodeName : cbContext.validNodes) {
                    if (validNodeName.indexOf(startBName) != 0) continue;
                    int tmpNodeIdx = cbContext.stepClausesCount + stepCls.size();
                    List<StepClause> partStepCls = this.buildStepClauses(travEx, tmpNodeIdx, validNodeName, endNodeLabel, origEndNodeName, copy);
                    ArrayList<APIObject> part = new ArrayList<APIObject>();
                    for (StepClause sc : partStepCls) {
                        part.add(SEPARATE.nextClause());
                        part.add(sc.getTotalMatchNode());
                    }
                    ret.expressionParts.add(part);
                    stepCls.addAll(partStepCls);
                }
                cbContext.stepClausesCount = cbContext.stepClausesCount + stepCls.size();
                if (stepCls.size() == 1) {
                    StepClause sc = (StepClause)stepCls.get(0);
                    JcNode endNd = sc.getEndNode();
                    ValueAccess.setName(origEndNodeName, endNd);
                    if (sc.jcPath != null) {
                        ValueAccess.setName(this.pathFromNode(origEndNodeName), sc.jcPath);
                        String startNodeName = ValueAccess.getName(sc.startNode);
                        ret.addStartPath(startNodeName, sc.jcPath);
                        ret.getClausesPerTypeList().add(new ClausesPerType(endNd, clausesPerType.domainObjectMatch, clausesPerType.domainObjectType));
                        cbContext.addCountFor(collOwner, clausesPerType.domainObjectMatch, startNodeName, endNd);
                    }
                } else if (stepCls.size() > 1) {
                    ArrayList<JcNode> tempNodes = new ArrayList<JcNode>();
                    for (StepClause sc : stepCls) {
                        JcNode endNd = sc.getEndNode();
                        tempNodes.add(endNd);
                        if (sc.jcPath == null) continue;
                        ValueAccess.setName(this.pathFromNode(ValueAccess.getName(endNd)), sc.jcPath);
                        String startNodeName = ValueAccess.getName(sc.startNode);
                        ret.addStartPath(startNodeName, sc.jcPath);
                        ret.getClausesPerTypeList().add(new ClausesPerType(endNd, clausesPerType.domainObjectMatch, clausesPerType.domainObjectType));
                        cbContext.addCountFor(collOwner, clausesPerType.domainObjectMatch, startNodeName, endNd);
                    }
                    if (!copy) {
                        ArrayList<APIObject> part = new ArrayList<APIObject>();
                        part.add(SEPARATE.nextClause());
                        part.add(OPTIONAL_MATCH.node(origEndNode).label(endNodeLabel));
                        Concat concat = WHERE.BR_OPEN();
                        part.add(this.createWhereIn(concat, origEndNode, tempNodes, false));
                        ret.expressionParts.add(part);
                    }
                } else {
                    clausesPerType.valid = false;
                }
                return ret;
            }

            private void createFromPrevQueryClauses(ClausesPerType cpt, FromPreviousQueryExpression fpe, ClauseBuilderContext cbContext) {
                List<Long> ids = null;
                DomainObjectMatch<?> prev = fpe.getPreviousMatch();
                List<Object> prevobjs = fpe.getPreviousObjects();
                if (prev != null) {
                    QueryExecutor qexec = APIAccess.getMappingInfo(prev).getQueryExecutor();
                    QueryContext qContext = qexec.getQueryResult();
                    if (qContext == null) {
                        qexec.execute();
                    }
                    ids = qexec.getIdsFor(prev, cpt.domainObjectType);
                } else if (prevobjs != null) {
                    List<SyncInfo> syInfos = QueryExecutor.this.domainAccess.getSyncInfos(prevobjs);
                    ids = new ArrayList();
                    for (SyncInfo si : syInfos) {
                        long id = si.getId();
                        if (id == -1L) {
                            throw new RuntimeException("Object was not retrieved by the underlying IDomainAccess");
                        }
                        ids.add(id);
                    }
                }
                cpt.startIds = ids;
            }

            private void createCollectClauses(ClausesPerType cpt, CollectExpression collEx, ClauseBuilderContext cbContext) {
                List nodes;
                cpt.isCollectExpression = true;
                Object hint = ValueAccess.getAnyHint(collEx.getAttribute(), "vn");
                if (hint instanceof List) {
                    nodes = (List)hint;
                    nodes = cbContext.filterValidNodes(nodes);
                } else {
                    nodes = cbContext.filterValidNodes(APIAccess.getNodes(collEx.getStartDOM()));
                }
                if (nodes.size() > 0) {
                    JcNode unionNode;
                    ArrayList<APIObject> collectClauses = new ArrayList<APIObject>();
                    if (nodes.size() > 1) {
                        String unionName = APIAccess.getBaseNodeName(cpt.domainObjectMatch).concat(QueryExecutor.collectNodePostfix);
                        unionNode = new JcNode(unionName);
                        collectClauses.add(OPTIONAL_MATCH.node(unionNode));
                        collectClauses.add(this.createWhereIn(WHERE.BR_OPEN(), unionNode, nodes, false));
                    } else {
                        unionNode = (JcNode)nodes.get(0);
                    }
                    JcCollection unionColl = new JcCollection(ValueAccess.getName(unionNode));
                    String tempName = APIAccess.getBaseNodeName(cpt.domainObjectMatch).concat(QueryExecutor.tmpNodePostPrefix);
                    JcNode tempNode = new JcNode(tempName);
                    ValueElement first = ValueAccess.findFirst(collEx.getAttribute());
                    JcValue val = (JcValue)QueryBuilder.this.cloneVe(collEx.getAttribute(), first, tempNode);
                    collectClauses.add(WITH.collection((ICollectExpression)C.EXTRACT().valueOf(val).fromAll(tempNode).IN_list(new Object[]{unionColl})).AS(cpt.node));
                    cpt.withClausesAddIdxs = new ArrayList();
                    cpt.withClausesAddIdxs.add(collectClauses.size());
                    cpt.collectionClauses = collectClauses;
                    cpt.lastIsWith = true;
                } else {
                    cpt.valid = false;
                }
            }

            private void createAddSelectClauses(ClausesPerType cpt, SelectExpression<?> selEx, ClauseBuilderContext cbContext) {
                if (!cbContext.isNodeValid(APIAccess.getNodeForType(selEx.getStart(), cpt.domainObjectType))) {
                    cpt.valid = false;
                    return;
                }
                ArrayList<IClause> selectClauses = new ArrayList<IClause>();
                List<DomainObjectMatch<?>> travDOMs = selEx.getTraversalResults();
                HashMap<IASTObject, TraversalPathsPerDOM> astObject2TraversalPaths = new HashMap<IASTObject, TraversalPathsPerDOM>();
                ArrayList<IClause> countWithClauses = new ArrayList<IClause>();
                HashMap countIntersectsPerType = null;
                ArrayList<IClause> selfWithClauses = new ArrayList<IClause>();
                if (travDOMs != null) {
                    for (DomainObjectMatch<?> dom : travDOMs) {
                        int idx = 0;
                        ExpressionsPerDOM xpd = null;
                        ExpressionsPerDOM countXpd = null;
                        TraversalPathsPerDOM tpd = new TraversalPathsPerDOM();
                        List<Class<?>> typeList = APIAccess.getTypeList(dom);
                        for (int i = 0; i < typeList.size(); ++i) {
                            JcNode node = APIAccess.getNodes(dom).get(i);
                            if (!cbContext.isNodeValid(node)) continue;
                            Class<?> clazz = typeList.get(i);
                            TraversalResult travResult = cbContext.getTravResult(cpt.domainObjectMatch, dom, clazz);
                            if (travResult == null) {
                                CountIntersectsPerType cipt;
                                UnionExpression ue = APIAccess.getUnionExpression(dom);
                                if (ue.isUnion()) continue;
                                if (countIntersectsPerType == null) {
                                    countIntersectsPerType = new HashMap();
                                }
                                if ((cipt = (CountIntersectsPerType)countIntersectsPerType.get(clazz)) == null) {
                                    cipt = new CountIntersectsPerType();
                                    countIntersectsPerType.put(clazz, cipt);
                                }
                                cipt.intersection = ue;
                                cipt.buildIntersection = new ArrayList();
                                cipt.intersectionDom = dom;
                                cipt.countNodes = new ArrayList();
                                continue;
                            }
                            if (travResult.expressionsPerDOM == null) {
                                CountIntersectsPerType cipt;
                                travResult.countIntersectsPerType = countIntersectsPerType;
                                if (xpd == null) {
                                    xpd = QueryBuilder.this.buildExpressionsPerDOM(dom, selEx.getAstObjects(), 1);
                                }
                                if (countXpd == null) {
                                    countXpd = QueryBuilder.this.buildExpressionsPerDOM(dom, selEx.getAstObjects(), 2);
                                }
                                boolean isCount = false;
                                if (countXpd != null && countXpd.xPressions.size() > 0) {
                                    cpt.startCountSelectXpr = true;
                                    isCount = true;
                                }
                                travResult.expressionsPerDOM = xpd;
                                travResult.countExpressionsPerDOM = countXpd;
                                tpd.addAll(travResult.getStartPathMap());
                                int idx2 = 0;
                                for (List part : travResult.expressionParts) {
                                    if (part.isEmpty()) continue;
                                    ClausesPerType iCpt = (ClausesPerType)travResult.clausesPerTypeList.get(idx2);
                                    if (dom != iCpt.domainObjectMatch) {
                                        throw new RuntimeException("internal error");
                                    }
                                    boolean bracket = false;
                                    if (iCpt.concatenator != null) {
                                        iCpt.concat = iCpt.concatenator.BR_CLOSE().AND().BR_OPEN();
                                        iCpt.concatenator = null;
                                        bracket = true;
                                    } else {
                                        iCpt.concat = WHERE.BR_OPEN();
                                    }
                                    boolean needPath = false;
                                    for (IASTObject ao : xpd.xPressions) {
                                        if (ao instanceof PredicateExpression) {
                                            needPath = true;
                                            PredicateExpression pred = (PredicateExpression)ao;
                                            IPredicateOperand1 val1 = pred.getValue_1();
                                            if (val1 instanceof ValueElement) {
                                                ValueElement ve = (ValueElement)val1;
                                                ve = QueryBuilder.this.cloneVe(ve, ValueAccess.findFirst(ve), iCpt.node);
                                                pred.setValue_1(ve);
                                            }
                                        }
                                        this.addClause(ao, iCpt, cbContext);
                                        if (idx != 0) continue;
                                        astObject2TraversalPaths.put(ao, tpd);
                                    }
                                    if (needPath) {
                                        JcPath p = new JcPath(this.pathFromNode(ValueAccess.getName(iCpt.node)));
                                        countWithClauses.add(WITH.value(p));
                                    }
                                    if (bracket) {
                                        iCpt.concatenator = iCpt.concatenator.BR_CLOSE();
                                    }
                                    ++idx;
                                    ++idx2;
                                    selectClauses.addAll(part);
                                    if (iCpt.concatenator != null) {
                                        selectClauses.add(iCpt.concatenator);
                                    }
                                    selectClauses.add(SEPARATE.nextClause());
                                    for (IASTObject ao : countXpd.xPressions) {
                                        boolean c_i;
                                        if (!(ao instanceof PredicateExpression)) continue;
                                        boolean bl = c_i = isCount && countIntersectsPerType != null && countIntersectsPerType.get(clazz) != null;
                                        if (c_i) {
                                            ((CountIntersectsPerType)countIntersectsPerType.get(clazz)).buildIntersection.add(iCpt);
                                        }
                                        this.addCountWithClause(iCpt.node, countWithClauses, selfWithClauses, selectClauses, cpt, c_i);
                                    }
                                }
                                CountIntersectsPerType countIntersectsPerType2 = cipt = countIntersectsPerType != null ? (CountIntersectsPerType)countIntersectsPerType.get(clazz) : null;
                                if (!isCount || cipt == null || !cipt.intersection.isLastOfSources(dom)) continue;
                                cipt.countNodes = this.addIntersectionInCount(cipt.intersectionDom, clazz, selectClauses, cipt.buildIntersection, countWithClauses, cpt, cipt.countNodes);
                                continue;
                            }
                            countIntersectsPerType = travResult.countIntersectsPerType;
                            tpd.addAll(travResult.getStartPathMap());
                            for (IASTObject ao : travResult.expressionsPerDOM.xPressions) {
                                astObject2TraversalPaths.put(ao, tpd);
                            }
                        }
                    }
                }
                String nodeLabel = QueryExecutor.this.getMappingInfo().getLabelForClass(cpt.domainObjectType);
                selectClauses.add(OPTIONAL_MATCH.node(cpt.node).label(nodeLabel));
                Concat concat = WHERE.BR_OPEN();
                ArrayList<JcNode> nds = new ArrayList<JcNode>();
                JcNode nd = APIAccess.getNodeForType(selEx.getStart(), cpt.domainObjectType);
                if (cbContext.isNodeValid(nd)) {
                    nds.add(nd);
                }
                cpt.concatenator = this.createWhereIn(concat, cpt.node, nds, false);
                cbContext.stepClausesCount = 0;
                int scope = -1;
                ArrayList<IASTObject> pendingBrOpen = new ArrayList<IASTObject>();
                ArrayList<IASTObject> pendingBrClose = new ArrayList<IASTObject>();
                IASTObject pendingOr = null;
                if (selEx.getAstObjects().size() > 1) {
                    this.addClause(new ConcatenateExpression(ConcatenateExpression.Concatenator.BR_OPEN), cpt, cbContext);
                }
                for (IASTObject ao : selEx.getAstObjects()) {
                    TraversalPathsPerDOM tpd = (TraversalPathsPerDOM)astObject2TraversalPaths.get(ao);
                    if (tpd != null) {
                        if (ao instanceof PredicateExpression && ((PredicateExpression)ao).isPartOfCount() || tpd.consumed) continue;
                        tpd.consumed = true;
                        int oldScope = scope == 0 ? 4 : scope;
                        scope = this.handleScopeClose(oldScope, 0, cpt, cbContext, pendingBrClose);
                        pendingOr = this.handleScopeOpen(oldScope, 0, cpt, cbContext, pendingBrOpen, pendingOr);
                        this.addTraversalConstraints2Select(tpd, nds, cpt);
                        continue;
                    }
                    if (ao instanceof PredicateExpression && ((PredicateExpression)ao).getValue_1() instanceof Count) {
                        CountIntersectsPerType cipt;
                        List countNodes = null;
                        CountIntersectsPerType countIntersectsPerType3 = cipt = countIntersectsPerType != null ? (CountIntersectsPerType)countIntersectsPerType.get(cpt.domainObjectType) : null;
                        if (cipt != null) {
                            countNodes = cipt.countNodes;
                        }
                        if (countNodes == null) {
                            countNodes = cbContext.getCountsFor(cpt.domainObjectMatch, ((PredicateExpression)ao).getStartDOM(), ValueAccess.getName(nd));
                        }
                        int oldScope = scope;
                        scope = this.handleScopeClose(scope, 2, cpt, cbContext, pendingBrClose);
                        if ((pendingOr = this.handleScopeOpen(oldScope, 2, cpt, cbContext, pendingBrOpen, pendingOr)) != null) {
                            this.addClause(pendingOr, cpt, cbContext);
                            pendingOr = null;
                        }
                        if (countNodes.size() > 0) {
                            JcNumber prevNum = null;
                            for (JcNode n : countNodes) {
                                String alias = ValueAccess.getName(n).concat(QueryExecutor.countXprPostPrefix);
                                JcNumber num = new JcNumber(alias);
                                if (prevNum != null) {
                                    prevNum = prevNum.plus(num);
                                    continue;
                                }
                                prevNum = num;
                            }
                            PredicateExpression newPred = ((PredicateExpression)ao).createCopy();
                            newPred.setValue_1(prevNum);
                            this.addClause(newPred, cpt, cbContext);
                        } else {
                            cpt.concat = cpt.concat.BR_OPEN();
                            iot.jcypher.query.ast.predicate.PredicateExpression px = (iot.jcypher.query.ast.predicate.PredicateExpression)APIObjectAccess.getAstNode(cpt.concat);
                            BooleanValue bv = new BooleanValue(false);
                            px.setPredicate(bv);
                            cpt.concatenator = PFactory.createConcatenator(px).BR_CLOSE();
                        }
                    } else if (ao instanceof ConcatenateExpression) {
                        if (((ConcatenateExpression)ao).getConcatenator() == ConcatenateExpression.Concatenator.OR) {
                            pendingOr = ao;
                        } else if (((ConcatenateExpression)ao).getConcatenator() == ConcatenateExpression.Concatenator.BR_OPEN) {
                            pendingBrOpen.add(ao);
                        } else if (((ConcatenateExpression)ao).getConcatenator() == ConcatenateExpression.Concatenator.BR_CLOSE) {
                            pendingBrClose.add(ao);
                        }
                    } else if (ao instanceof PredicateExpression) {
                        int oldScope = scope;
                        scope = this.handleScopeClose(scope, 1, cpt, cbContext, pendingBrClose);
                        pendingOr = this.handleScopeOpen(oldScope, 1, cpt, cbContext, pendingBrOpen, pendingOr);
                        this.handleBrackets(cpt, cbContext, pendingBrClose);
                        if (pendingOr != null) {
                            this.addClause(pendingOr, cpt, cbContext);
                            pendingOr = null;
                        }
                        this.handleBrackets(cpt, cbContext, pendingBrOpen);
                        this.addClause(ao, cpt, cbContext);
                        cpt.testForNextIsOr = false;
                    }
                    if (cpt.valid) continue;
                    break;
                }
                if (cpt.concatenator == null) {
                    cpt.valid = false;
                    return;
                }
                this.handleScopeClose(scope, 3, cpt, cbContext, pendingBrClose);
                if (selEx.getAstObjects().size() > 1) {
                    this.addClause(new ConcatenateExpression(ConcatenateExpression.Concatenator.BR_CLOSE), cpt, cbContext);
                }
                cpt.collectionClauses = selectClauses;
            }

            private List<JcNode> addIntersectionInCount(DomainObjectMatch<?> intersectionDom, Class<?> clazz, List<IClause> clauses, List<ClausesPerType> buildIntersection, List<IClause> countWithClauses, ClausesPerType cpt, List<JcNode> counNodes) {
                List<JcNode> ret = counNodes;
                int idx3 = 0;
                Concatenator booleanOp = null;
                JcNode nd = APIAccess.getNodeForType(intersectionDom, clazz);
                String nnm = ValueAccess.getName(nd).concat(QueryExecutor.collNodePostPrefix).concat(APIAccess.getBaseNodeName(cpt.domainObjectMatch));
                nd = new JcNode(nnm);
                if (ret == null) {
                    ret = new ArrayList<JcNode>();
                }
                ret.add(nd);
                clauses.add(OPTIONAL_MATCH.node(nd));
                for (ClausesPerType intCpt : buildIntersection) {
                    JcNode n = intCpt.node;
                    booleanOp = idx3 == 0 ? WHERE.BR_OPEN().NOT().valueOf(n).IS_NULL().AND().valueOf(nd).IN_list(new Object[]{n}).BR_CLOSE() : booleanOp.AND().BR_OPEN().NOT().valueOf(n).IS_NULL().AND().valueOf(nd).IN_list(new Object[]{n}).BR_CLOSE();
                    ++idx3;
                }
                clauses.add(booleanOp);
                this.addCountWithClause(nd, countWithClauses, null, clauses, cpt, false);
                return ret;
            }

            private void handleBrackets(ClausesPerType cpt, ClauseBuilderContext cbContext, List<IASTObject> pendingBr) {
                if (!pendingBr.isEmpty()) {
                    for (IASTObject iao : pendingBr) {
                        this.addClause(iao, cpt, cbContext);
                    }
                    pendingBr.clear();
                }
            }

            private int handleScopeClose(int scope, int newScope, ClausesPerType cpt, ClauseBuilderContext cbContext, List<IASTObject> pendingBrClose) {
                if (scope != -1 && scope != newScope) {
                    if (!pendingBrClose.isEmpty()) {
                        for (IASTObject iao : pendingBrClose) {
                            this.addClause(iao, cpt, cbContext);
                        }
                        pendingBrClose.clear();
                    } else {
                        this.addClause(new ConcatenateExpression(ConcatenateExpression.Concatenator.BR_CLOSE), cpt, cbContext);
                    }
                }
                return newScope;
            }

            private IASTObject handleScopeOpen(int scope, int newScope, ClausesPerType cpt, ClauseBuilderContext cbContext, List<IASTObject> pendingBrOpen, IASTObject pendingOr) {
                if (scope != newScope) {
                    if (pendingOr != null) {
                        this.addClause(pendingOr, cpt, cbContext);
                    }
                    if (!pendingBrOpen.isEmpty()) {
                        for (IASTObject iao : pendingBrOpen) {
                            this.addClause(iao, cpt, cbContext);
                        }
                        pendingBrOpen.clear();
                    } else {
                        this.addClause(new ConcatenateExpression(ConcatenateExpression.Concatenator.BR_OPEN), cpt, cbContext);
                    }
                    return null;
                }
                return pendingOr;
            }

            private void addCountWithClause(JcNode n, List<IClause> countWithClauses, List<IClause> selfWithClauses, List<IClause> selectClauses, ClausesPerType cpt, boolean addSelf) {
                String nnm = ValueAccess.getName(n);
                String alias = nnm.concat(QueryExecutor.countXprPostPrefix);
                JcNumber num = new JcNumber(alias);
                selectClauses.add((IClause)WITH.count().DISTINCT().value(n).AS(num));
                if (addSelf) {
                    selectClauses.add(WITH.value(n));
                }
                selectClauses.addAll(countWithClauses);
                if (addSelf) {
                    selectClauses.addAll(selfWithClauses);
                }
                if (cpt.withClausesAddIdxs == null) {
                    cpt.withClausesAddIdxs = new ArrayList();
                }
                cpt.withClausesAddIdxs.add(0, selectClauses.size());
                countWithClauses.add(0, WITH.value(num));
                if (addSelf) {
                    selfWithClauses.add(WITH.value(n));
                }
            }

            private void addTraversalConstraints2Select(TraversalPathsPerDOM tpd, List<JcNode> startNds, ClausesPerType cpt) {
                List paths = tpd.getAllPaths(startNds);
                if (paths.size() > 0) {
                    cpt.oneValid = true;
                    boolean bracket = false;
                    if (cpt.concatenator != null) {
                        cpt.concat = cpt.concatenator.AND().BR_OPEN();
                        bracket = true;
                    }
                    int idx = 0;
                    for (JcPath path : paths) {
                        if (idx > 0) {
                            cpt.concatenator = cpt.concatenator.OR().valueOf(cpt.node).EQUALS(path.nodes().head());
                        } else {
                            cpt.concatenator = cpt.concat.valueOf(cpt.node).EQUALS(path.nodes().head());
                        }
                        ++idx;
                    }
                    if (bracket) {
                        cpt.concatenator = cpt.concatenator.BR_CLOSE();
                    }
                }
            }

            private List<StepClause> buildStepClauses(TraversalExpression travEx, int tmpNodeIdx, String startNodeName, String endNodeLabel, String origEndNodeName, boolean copy) {
                StepClause stepClause = new StepClause();
                stepClause.buildAll(travEx, tmpNodeIdx, startNodeName, endNodeLabel, origEndNodeName, copy);
                return this.filterValidClauses(stepClause.stepClauses);
            }

            private List<StepClause> filterValidClauses(List<StepClause> toFilter) {
                ArrayList<StepClause> ret = new ArrayList<StepClause>();
                for (StepClause sc : toFilter) {
                    if (sc.getTotalMatchNode() == null) continue;
                    boolean doAdd = true;
                    for (StepClause scRet : ret) {
                        if (!scRet.isSameAs(sc)) continue;
                        doAdd = false;
                        break;
                    }
                    if (!doAdd) continue;
                    ret.add(sc);
                }
                return ret;
            }

            private String pathFromNode(String nodeName) {
                return nodeName.replaceFirst("n_", "p_");
            }

            private class CloneInfo {
                private StepClause toClone;
                private StepClause cloneTo;

                private CloneInfo() {
                }

                private boolean stopCloning() {
                    return this.toClone == this.cloneTo;
                }
            }

            private class StepClause {
                private Node matchNode;
                private StepClause next;
                private StepClause previous;
                private List<FieldMapping> fieldMappings;
                private int fmIndex;
                private TraversalExpression traversalExpression;
                private TraversalExpression.Step step;
                private int stepIndex;
                private String originalEndNodeName;
                private String endNodeLabel;
                private JcPath jcPath;
                private JcNode startNode;
                private JcNode endNode;
                private List<StepClause> stepClauses;

                private StepClause() {
                }

                private void buildAll(TraversalExpression travEx, int tmpNodeIdx, String startNodeName, String endNodeLabel, String origEndNodeName, boolean copy) {
                    this.stepClauses = new ArrayList<StepClause>();
                    this.originalEndNodeName = origEndNodeName;
                    this.endNodeLabel = endNodeLabel;
                    this.traversalExpression = travEx;
                    this.buildFirst(tmpNodeIdx, startNodeName, copy);
                }

                private void buildFirst(int tmpNodeIdx, String startNodeName, boolean copy) {
                    this.stepClauses.add(this);
                    this.startNode = new JcNode(startNodeName);
                    if (copy) {
                        this.jcPath = new JcPath(ClauseBuilder.this.pathFromNode(this.originalEndNodeName));
                        this.matchNode = OPTIONAL_MATCH.path(this.jcPath).node(this.startNode);
                    } else {
                        this.matchNode = OPTIONAL_MATCH.node(this.startNode);
                    }
                    Class<?> typ = APIAccess.getTypeForNodeName(this.traversalExpression.getStart(), startNodeName);
                    boolean isList = typ.equals(Collection.class) || typ.equals(Array.class);
                    this.stepIndex = 0;
                    this.step = this.traversalExpression.getSteps().get(this.stepIndex);
                    ArrayList types = new ArrayList();
                    types.add(typ);
                    this.build(tmpNodeIdx, types, isList);
                }

                private void buildNext(int tmpNodeIdx, List<Class<?>> types, boolean isList, TraversalExpression.Step nextStep, int nextStepIndex) {
                    StepClause stpc;
                    this.next = stpc = new StepClause();
                    stpc.previous = this;
                    stpc.matchNode = this.matchNode;
                    stpc.endNodeLabel = this.endNodeLabel;
                    stpc.originalEndNodeName = this.originalEndNodeName;
                    stpc.traversalExpression = this.traversalExpression;
                    stpc.step = nextStep;
                    stpc.stepClauses = this.stepClauses;
                    stpc.stepIndex = nextStepIndex;
                    stpc.build(tmpNodeIdx, types, isList);
                }

                private void buildNextClone(int tmpNodeIdx, List<Class<?>> types, boolean isList, CloneInfo cloneInfo) {
                    StepClause stpc;
                    cloneInfo.toClone = ((CloneInfo)cloneInfo).toClone.next;
                    this.next = stpc = new StepClause();
                    stpc.previous = this;
                    stpc.matchNode = this.matchNode;
                    stpc.endNodeLabel = this.endNodeLabel;
                    stpc.originalEndNodeName = this.originalEndNodeName;
                    stpc.traversalExpression = this.traversalExpression;
                    stpc.stepClauses = this.stepClauses;
                    stpc.stepIndex = ((CloneInfo)cloneInfo).toClone.stepIndex;
                    stpc.step = ((CloneInfo)cloneInfo).toClone.step;
                    stpc.fieldMappings = ((CloneInfo)cloneInfo).toClone.fieldMappings;
                    stpc.fmIndex = ((CloneInfo)cloneInfo).toClone.fmIndex;
                    stpc.buildClone(tmpNodeIdx, cloneInfo, isList);
                }

                private void build(int tmpNodeIdx, List<Class<?>> types, boolean isList) {
                    ArrayList<FieldMapping> fms = null;
                    for (Class<?> t : types) {
                        if (this.step.getDirection() == 0) {
                            FieldMapping fm = QueryExecutor.this.getMappingInfo().getFieldMapping(this.step.getAttributeName(), t);
                            if (fm == null) continue;
                            if (fms == null) {
                                fms = new ArrayList();
                            }
                            fms.add(fm);
                            continue;
                        }
                        if (fms == null) {
                            fms = new ArrayList<FieldMapping>();
                        }
                        List<FieldMapping> fms_t = QueryExecutor.this.getMappingInfo().getBackwardFieldMappings(this.step.getAttributeName(), t);
                        for (FieldMapping f : fms_t) {
                            if (fms.contains(f)) continue;
                            fms.add(f);
                        }
                    }
                    boolean doBuild = false;
                    if (fms != null && !fms.isEmpty()) {
                        this.fieldMappings = fms;
                        this.fmIndex = 0;
                        doBuild = true;
                    } else {
                        this.matchNode = null;
                    }
                    if (doBuild) {
                        if (this.step.getDirection() == 0) {
                            this.buildStep(tmpNodeIdx, isList, null, true);
                        } else {
                            this.buildStep(tmpNodeIdx, isList, null, false);
                        }
                    }
                    if (this.fieldMappings != null && this.fmIndex < this.fieldMappings.size() - 1) {
                        this.cloneTraversal(this, tmpNodeIdx + 1);
                    }
                }

                private void buildStep(int tmpNodeIdx, boolean listOrArray, CloneInfo cloneInfo, boolean forward) {
                    ArrayList<Class<?>> types;
                    FieldMapping fm = this.fieldMappings.get(this.fmIndex);
                    Relation matchRel = this.matchNode.relation().type(fm.getPropertyOrRelationName());
                    matchRel = forward ? matchRel.out() : matchRel.in();
                    if (this.step.getMinDistance() != 1) {
                        matchRel = matchRel.minHops(this.step.getMinDistance());
                    }
                    if (this.step.getMaxDistance() != 1) {
                        matchRel = this.step.getMaxDistance() == -1 ? matchRel.maxHopsUnbound() : matchRel.maxHops(this.step.getMaxDistance());
                    }
                    CompoundObjectType cType = null;
                    Class<?> typ = forward ? ((cType = listOrArray ? QueryExecutor.this.getMappingInfo().getInternalDomainAccess().getFieldComponentType(fm.getClassFieldName()) : QueryExecutor.this.getMappingInfo().getInternalDomainAccess().getConcreteFieldType(fm.getClassFieldName())) != null ? cType.getType() : fm.getFieldType()) : fm.getField().getDeclaringClass();
                    boolean isList = typ.equals(Collection.class) || typ.equals(Array.class);
                    TraversalExpression.Step nextStep = null;
                    int nextStepIndex = this.stepIndex;
                    if (isList) {
                        nextStep = forward ? this.step.createStep(this.step.getDirection(), QueryExecutor.this.getMappingInfo().getObjectMappingFor(typ).fieldMappingsIterator().next().getPropertyOrRelationName()) : this.step.createStep(this.step.getDirection(), this.step.getAttributeName());
                        types = new ArrayList();
                        types.add(typ);
                    } else {
                        if (++nextStepIndex <= this.traversalExpression.getSteps().size() - 1) {
                            nextStep = this.traversalExpression.getSteps().get(nextStepIndex);
                        }
                        if (forward) {
                            if (cType != null) {
                                types = cType.getTypes(true);
                            } else if (CompoundObjectType.isConcrete(typ)) {
                                types = new ArrayList();
                                types.add(typ);
                            } else {
                                types = new ArrayList();
                            }
                        } else {
                            types = QueryExecutor.this.getMappingInfo().getCompoundTypesFor(typ);
                        }
                    }
                    if (nextStep == null) {
                        if (this.isValidEndNodeType(types)) {
                            this.endNode = new JcNode(this.originalEndNodeName.concat(QueryExecutor.tmpNodePostPrefix).concat(String.valueOf(tmpNodeIdx)));
                            StepClause first = this.getFirst();
                            if (first.jcPath != null) {
                                String npm = ValueAccess.getName(first.jcPath).concat(QueryExecutor.tmpNodePostPrefix).concat(String.valueOf(tmpNodeIdx));
                                ValueAccess.setName(npm, first.jcPath);
                            }
                            this.matchNode = matchRel.node(this.endNode).label(this.endNodeLabel);
                        } else {
                            this.matchNode = null;
                        }
                    } else {
                        this.matchNode = matchRel.node();
                        if (cloneInfo != null) {
                            this.buildNextClone(tmpNodeIdx, types, isList, cloneInfo);
                        } else {
                            this.buildNext(tmpNodeIdx, types, isList, nextStep, nextStepIndex);
                        }
                    }
                }

                private boolean isValidEndNodeType(List<Class<?>> types) {
                    for (Class<?> clazz : types) {
                        if (!this.endNodeLabel.equals(QueryExecutor.this.getMappingInfo().getLabelForClass(clazz))) continue;
                        return true;
                    }
                    return false;
                }

                private void cloneTraversal(StepClause cloneTo, int tmpNodeIdx) {
                    StepClause first = this.getFirst();
                    StepClause newFirst = new StepClause();
                    newFirst.stepClauses = first.stepClauses;
                    CloneInfo cloneInfo = new CloneInfo();
                    cloneInfo.toClone = first;
                    cloneInfo.cloneTo = cloneTo;
                    newFirst.cloneFirst(cloneInfo, tmpNodeIdx);
                }

                private void cloneFirst(CloneInfo cloneInfo, int tmpNodeIdx) {
                    this.stepClauses.add(this);
                    this.startNode = ((CloneInfo)cloneInfo).toClone.startNode;
                    this.jcPath = ((CloneInfo)cloneInfo).toClone.jcPath;
                    this.originalEndNodeName = ((CloneInfo)cloneInfo).toClone.originalEndNodeName;
                    this.endNodeLabel = ((CloneInfo)cloneInfo).toClone.endNodeLabel;
                    this.traversalExpression = ((CloneInfo)cloneInfo).toClone.traversalExpression;
                    this.matchNode = this.jcPath != null ? OPTIONAL_MATCH.path(this.jcPath).node(this.startNode) : OPTIONAL_MATCH.node(this.startNode);
                    Class<?> typ = APIAccess.getTypeForNodeName(this.traversalExpression.getStart(), ValueAccess.getName(this.startNode));
                    boolean isList = typ.equals(Collection.class) || typ.equals(Array.class);
                    this.stepIndex = ((CloneInfo)cloneInfo).toClone.stepIndex;
                    this.step = ((CloneInfo)cloneInfo).toClone.step;
                    this.fieldMappings = ((CloneInfo)cloneInfo).toClone.fieldMappings;
                    this.fmIndex = ((CloneInfo)cloneInfo).toClone.fmIndex;
                    this.buildClone(tmpNodeIdx, cloneInfo, isList);
                }

                private void buildClone(int tmpNodeIdx, CloneInfo cloneInfo, boolean isList) {
                    CloneInfo cli = cloneInfo;
                    if (cli.stopCloning()) {
                        ++this.fmIndex;
                        cli = null;
                    }
                    if (this.step.getDirection() == 0) {
                        this.buildStep(tmpNodeIdx, isList, cli, true);
                    } else {
                        this.buildStep(tmpNodeIdx, isList, cli, false);
                    }
                    if (this.fieldMappings != null && this.fmIndex < this.fieldMappings.size() - 1) {
                        this.cloneTraversal(this, tmpNodeIdx + 1);
                    }
                }

                private JcNode getEndNode() {
                    return this.getLast().endNode;
                }

                private Node getTotalMatchNode() {
                    return this.getLast().matchNode;
                }

                private StepClause getFirst() {
                    StepClause first = this;
                    while (first.previous != null) {
                        first = first.previous;
                    }
                    return first;
                }

                private StepClause getLast() {
                    StepClause last = this;
                    while (last.next != null) {
                        last = last.next;
                    }
                    return last;
                }

                private boolean isSameAs(StepClause toCompare) {
                    String oRelName;
                    String relName;
                    if (toCompare == null) {
                        return false;
                    }
                    if (!this.originalEndNodeName.equals(toCompare.originalEndNodeName)) {
                        return false;
                    }
                    if (this.startNode != null) {
                        if (toCompare.startNode == null) {
                            return false;
                        }
                        if (!ValueAccess.getName(this.startNode).equals(ValueAccess.getName(toCompare.startNode))) {
                            return false;
                        }
                    } else if (toCompare.startNode != null) {
                        return false;
                    }
                    if (!(relName = this.getFieldMapping().getPropertyOrRelationName()).equals(oRelName = toCompare.getFieldMapping().getPropertyOrRelationName())) {
                        return false;
                    }
                    if (this.next != null) {
                        return this.next.isSameAs(toCompare.next);
                    }
                    return toCompare.next == null;
                }

                private FieldMapping getFieldMapping() {
                    if (this.fieldMappings != null) {
                        return this.fieldMappings.get(this.fmIndex);
                    }
                    return null;
                }
            }

            private class TraversalResult {
                private List<List<IClause>> expressionParts;
                private Map<String, List<JcPath>> startPathMap;
                private List<ClausesPerType> clausesPerTypeList;
                private ExpressionsPerDOM expressionsPerDOM;
                private ExpressionsPerDOM countExpressionsPerDOM;
                private Map<Class<?>, CountIntersectsPerType> countIntersectsPerType;

                private TraversalResult() {
                }

                private List<IClause> getAllClauses() {
                    ArrayList<IClause> ret = new ArrayList<IClause>();
                    for (List<IClause> cls : this.expressionParts) {
                        ret.addAll(cls);
                    }
                    return ret;
                }

                private Map<String, List<JcPath>> getStartPathMap() {
                    if (this.startPathMap == null) {
                        this.startPathMap = new HashMap<String, List<JcPath>>();
                    }
                    return this.startPathMap;
                }

                private void addStartPath(String startNodeName, JcPath startPath) {
                    List<JcPath> pths = this.getStartPathMap().get(startNodeName);
                    if (pths == null) {
                        pths = new ArrayList<JcPath>();
                        this.getStartPathMap().put(startNodeName, pths);
                    }
                    pths.add(startPath);
                }

                private List<ClausesPerType> getClausesPerTypeList() {
                    if (this.clausesPerTypeList == null) {
                        this.clausesPerTypeList = new ArrayList<ClausesPerType>();
                    }
                    return this.clausesPerTypeList;
                }
            }

            private class TraversalPathsPerDOM {
                private Map<String, List<JcPath>> pathMap = new HashMap<String, List<JcPath>>();
                private boolean consumed = false;

                private TraversalPathsPerDOM() {
                }

                private void addAll(Map<String, List<JcPath>> pMap) {
                    for (Map.Entry<String, List<JcPath>> entry : pMap.entrySet()) {
                        List<JcPath> pths = this.pathMap.get(entry.getKey());
                        if (pths == null) {
                            pths = new ArrayList<JcPath>();
                            this.pathMap.put(entry.getKey(), pths);
                        }
                        pths.addAll((java.util.Collection<JcPath>)entry.getValue());
                    }
                }

                private List<JcPath> getAllPaths(List<JcNode> nodes) {
                    ArrayList<JcPath> ret = new ArrayList<JcPath>();
                    for (JcNode n : nodes) {
                        List<JcPath> pths = this.pathMap.get(ValueAccess.getName(n));
                        if (pths == null) continue;
                        ret.addAll(pths);
                    }
                    return ret;
                }
            }

            private class CountIntersectsPerType {
                private UnionExpression intersection;
                private List<ClausesPerType> buildIntersection;
                private DomainObjectMatch<?> intersectionDom;
                private List<JcNode> countNodes;

                private CountIntersectsPerType() {
                }
            }
        }

        private class OrderClausesHolder {
            private List<ClausesPerType> toOrder;
            private IClause whereNot;

            private OrderClausesHolder() {
            }

            private void checkForOrdeClause(ClausesPerType cpt) {
                if (QueryBuilder.this.getOrderExpressionsFor(cpt) != null) {
                    if (this.toOrder == null) {
                        this.toOrder = new ArrayList<ClausesPerType>();
                    }
                    this.toOrder.add(cpt);
                }
            }

            private void addClauses(List<IClause> addTo, boolean lastIsWith, List<ClausesPerType> withToAdd) {
                if (!(this.toOrder == null && this.whereNot == null || lastIsWith)) {
                    for (ClausesPerType cpt : withToAdd) {
                        addTo.add(WITH.value(cpt.node));
                    }
                }
                if (this.toOrder != null) {
                    for (ClausesPerType cpt : this.toOrder) {
                        List ocs = QueryBuilder.this.getOrderExpressionsFor(cpt);
                        int idx = this.indexOfOrderClause(cpt, addTo);
                        if (idx == -1) continue;
                        RSortable orderClause = (RSortable)addTo.get(idx);
                        for (OrderExpression.OrderBy ob : ocs) {
                            if (ob.getDirection() == 0) {
                                orderClause = orderClause.ORDER_BY(ob.getAttributeName());
                                continue;
                            }
                            orderClause = orderClause.ORDER_BY_DESC(ob.getAttributeName());
                        }
                        addTo.set(idx, orderClause);
                    }
                }
                if (this.whereNot != null) {
                    addTo.add(this.whereNot);
                }
            }

            private int indexOfOrderClause(ClausesPerType cpt, List<IClause> clauses) {
                IClause clause;
                for (int strt = clauses.size() - 1; strt >= 0 && clauses.get(strt) instanceof SEPARATE; --strt) {
                }
                int idx = -1;
                for (int i = strt; i >= 0 && (clause = clauses.get(i)) instanceof RSortable; --i) {
                    JcValue elem;
                    ReturnExpression rexp = (ReturnExpression)APIObjectAccess.getAstNode((APIObject)((Object)clause));
                    if (rexp.getAlias() != null && ValueAccess.isSame(rexp.getAlias(), cpt.node)) {
                        idx = i;
                        break;
                    }
                    if (!(rexp.getReturnValue() instanceof ReturnElement) || !ValueAccess.isSame(elem = ((ReturnElement)rexp.getReturnValue()).getElement(), cpt.node)) continue;
                    idx = i;
                    break;
                }
                return idx;
            }
        }
    }
}

