/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domainquery.internal;

import iot.jcypher.domainquery.AbstractDomainQuery;
import iot.jcypher.domainquery.GDomainQuery;
import iot.jcypher.domainquery.InternalAccess;
import iot.jcypher.domainquery.api.DomainObjectMatch;
import iot.jcypher.domainquery.internal.QueryExecutor;
import iot.jcypher.domainquery.internal.RecordedQuery;
import iot.jcypher.domainquery.internal.Settings;
import iot.jcypher.query.values.MathFunctions;
import iot.jcypher.query.values.ValueAccess;
import iot.jcypher.query.values.ValueElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QueryRecorder {
    public static final String QUERY_ID = "q";
    private static ThreadLocal<QueriesPerThread> queriesPerThread = new ThreadLocal();
    public static ThreadLocal<Boolean> blockRecording = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public static void recordStackedInvocation(Object on, String method, Object result, Object ... params) {
        if (blockRecording.get().booleanValue()) {
            return;
        }
        QueryRecorder.recordInvocation(false, true, false, on, method, result, params);
    }

    public static void recordStackedAssignment(Object on, String method, Object result, Object ... params) {
        if (blockRecording.get().booleanValue()) {
            return;
        }
        QueryRecorder.recordInvocation(true, true, false, on, method, result, params);
    }

    public static void recordInvocation(Object on, String method, Object result, Object ... params) {
        if (blockRecording.get().booleanValue()) {
            return;
        }
        QueryRecorder.recordInvocation(false, false, false, on, method, result, params);
    }

    public static void recordInvocationNoConcat(Object on, String method, Object result, Object ... params) {
        if (blockRecording.get().booleanValue()) {
            return;
        }
        QueryRecorder.recordInvocation(false, false, true, on, method, result, params);
    }

    public static void recordAssignment(Object on, String method, Object result, Object ... params) {
        if (blockRecording.get().booleanValue()) {
            return;
        }
        QueryRecorder.recordInvocation(true, false, false, on, method, result, params);
    }

    private static void recordInvocation(boolean assign, boolean subRoot, boolean noConcat, Object on, String method, Object result, Object ... params) {
        QueriesPerThread qpt = QueryRecorder.getCreateQueriesPerThread();
        RecQueryHolder rqh = null;
        if (noConcat) {
            rqh = QueryRecorder.createRecQueryHolder();
        } else if (on instanceof AbstractDomainQuery) {
            rqh = QueryRecorder.getRecQueryHolder((AbstractDomainQuery)on);
        } else {
            rqh = qpt.getHolderRef(on);
            if (rqh == null) {
                rqh = QueryRecorder.createRecQueryHolder();
            }
        }
        if (subRoot && rqh.root) {
            rqh.stackLastNStatements(assign, params == null ? 0 : params.length, on, method, result);
        } else {
            ArrayList<RecordedQuery.Statement> parameters = new ArrayList<RecordedQuery.Statement>(params.length);
            for (int i = 0; i < params.length; ++i) {
                Object val;
                Object param = params[i];
                if (param instanceof Literal) {
                    parameters.add(rqh.recordedQuery.literal(((Literal)param).value));
                    continue;
                }
                if (param instanceof PlaceHolder) {
                    val = ((PlaceHolder)param).value;
                    if (val instanceof DomainObjectMatch) {
                        String oid = (String)rqh.object2IdMap.get(val);
                        parameters.add(rqh.recordedQuery.doMatchRef(oid));
                        continue;
                    }
                    RecQueryHolder trqh = qpt.getHolderRef(val);
                    if (trqh != null) {
                        List<RecordedQuery.Statement> adopted = QueryRecorder.adoptStatements(trqh, rqh);
                        parameters.addAll(adopted);
                        qpt.removeHolderRef(val);
                        continue;
                    }
                    parameters.add(rqh.recordedQuery.literal(val));
                    continue;
                }
                if (!(param instanceof Reference)) continue;
                val = ((Reference)param).value;
                parameters.add(rqh.recordedQuery.reference(val, rqh.getNextRefId()));
            }
            rqh.recordInvocation(assign, on, method, result, parameters);
            qpt.putHolderRef(result, rqh);
            if (rqh.root) {
                qpt.removeFromQuery2HolderMap(rqh, null, false, null);
            }
        }
    }

    private static List<RecordedQuery.Statement> adoptStatements(RecQueryHolder from, RecQueryHolder to) {
        List<RecordedQuery.Statement> params = from.recordedQuery.getStatements();
        for (RecordedQuery.Statement s : params) {
            QueryRecorder.adoptStatement(from, to, s);
        }
        return params;
    }

    private static void adoptStatement(RecQueryHolder from, RecQueryHolder to, RecordedQuery.Statement s) {
        if (s instanceof RecordedQuery.Invocation) {
            String or = ((RecordedQuery.Invocation)s).getOnObjectRef();
            Object o = from.id2ObjectMap.get(or);
            String id = (String)to.object2IdMap.get(o);
            if (id == null) {
                id = to.getNextId();
                to.object2IdMap.put(o, id);
                to.id2ObjectMap.put(id, o);
            }
            ((RecordedQuery.Invocation)s).setOnObjectRef(id);
            or = ((RecordedQuery.Invocation)s).getReturnObjectRef();
            o = from.id2ObjectMap.get(or);
            id = (String)to.object2IdMap.get(o);
            if (id == null) {
                id = to.getNextId();
                to.object2IdMap.put(o, id);
                to.id2ObjectMap.put(id, o);
            }
            ((RecordedQuery.Invocation)s).setReturnObjectRef(id);
            QueriesPerThread qpt = QueryRecorder.getCreateQueriesPerThread();
            List<RecordedQuery.Statement> params = ((RecordedQuery.Invocation)s).getParams();
            for (RecordedQuery.Statement stmt : params) {
                RecQueryHolder nextFrom = qpt.getHolderForQuery(stmt.getRecordedQuery());
                if (nextFrom == null) continue;
                QueryRecorder.adoptStatement(nextFrom, to, stmt);
            }
        }
        to.addAdopted(from);
    }

    public static void recordInvocationConditional(ValueElement on, String method, Object result, Object ... params) {
        Object dom;
        if (blockRecording.get().booleanValue()) {
            return;
        }
        QueriesPerThread qpt = queriesPerThread.get();
        if (qpt != null && !qpt.isEmpty() && (dom = ValueAccess.getAnyHint(on, "dom")) != null) {
            QueryRecorder.recordInvocation(on, method, result, params);
        }
    }

    public static void recordInvocationConditional(MathFunctions on, String method, Object result, Object ... params) {
        Object dom;
        if (blockRecording.get().booleanValue()) {
            return;
        }
        QueriesPerThread qpt = queriesPerThread.get();
        if (qpt != null && !qpt.isEmpty() && (dom = ValueAccess.getAnyHint(ValueAccess.getArgument(on), "dom")) != null) {
            QueryRecorder.recordInvocation(on, method, result, params);
        }
    }

    public static void recordInvocationReplace(DomainObjectMatch<?> on, Object toReplace, String methodName) {
        if (blockRecording.get().booleanValue()) {
            return;
        }
        QueriesPerThread qpt = QueryRecorder.getCreateQueriesPerThread();
        RecQueryHolder trqh = qpt.getHolderRef(toReplace);
        RecQueryHolder rqh = qpt.getHolderRef(on);
        if (trqh != null) {
            List<RecordedQuery.Statement> stmts = trqh.recordedQuery.getStatements();
            for (RecordedQuery.Statement stmt : stmts) {
                if (!(stmt instanceof RecordedQuery.Invocation)) continue;
                String onId = (String)trqh.object2IdMap.get(on);
                if (onId == null) {
                    onId = trqh.getNextId();
                    trqh.object2IdMap.put(on, onId);
                    trqh.id2ObjectMap.put(onId, on);
                }
                ((RecordedQuery.Invocation)stmt).setOnObjectRef(onId);
                ((RecordedQuery.Invocation)stmt).setMethod(methodName);
            }
            if (rqh == null) {
                qpt.putHolderRef(on, trqh);
            } else {
                rqh.addReplaced(trqh);
            }
        }
    }

    public static void recordCreateQuery(AbstractDomainQuery query) {
        if (blockRecording.get().booleanValue()) {
            return;
        }
        RecordedQuery rq = new RecordedQuery(query instanceof GDomainQuery);
        RecQueryHolder rqh = new RecQueryHolder(rq);
        rqh.root = true;
        QueryRecorder.getCreateQueriesPerThread().put(query, rqh);
    }

    public static void queryCompleted(AbstractDomainQuery query) {
        QueriesPerThread qpt;
        if (blockRecording.get().booleanValue()) {
            return;
        }
        QueryExecutor qe = InternalAccess.getQueryExecutor(query);
        boolean done = qe.queryCreationCompleted(false);
        if (!done && (qpt = queriesPerThread.get()) != null) {
            qpt.queryCompleted(query);
        }
    }

    public static RecordedQuery getRecordedQuery(AbstractDomainQuery query) {
        if (blockRecording.get().booleanValue()) {
            return null;
        }
        RecQueryHolder rqh = QueryRecorder.getRecQueryHolder(query);
        if (rqh != null) {
            return rqh.recordedQuery;
        }
        return null;
    }

    public static Literal literal(Object value) {
        return new Literal(value);
    }

    public static PlaceHolder placeHolder(Object value) {
        return new PlaceHolder(value);
    }

    public static Reference reference(Object value) {
        return new Reference(value);
    }

    private static RecQueryHolder getRecQueryHolder(AbstractDomainQuery on) {
        QueriesPerThread qpt = QueryRecorder.getCreateQueriesPerThread();
        return qpt.get(on);
    }

    private static RecQueryHolder createRecQueryHolder() {
        RecQueryHolder rqh = new RecQueryHolder(new RecordedQuery(false));
        return rqh;
    }

    public static QueriesPerThread getCreateQueriesPerThread() {
        QueriesPerThread qpt = queriesPerThread.get();
        if (qpt == null) {
            qpt = new QueriesPerThread();
            queriesPerThread.set(qpt);
        }
        return qpt;
    }

    public static QueriesPerThread getQueriesPerThread() {
        return queriesPerThread.get();
    }

    public static class Reference {
        private Object value;

        public Reference(Object value) {
            this.value = value;
        }
    }

    public static class PlaceHolder {
        private Object value;

        public PlaceHolder(Object value) {
            this.value = value;
        }
    }

    public static class Literal {
        private Object value;

        public Literal(Object value) {
            this.value = value;
        }
    }

    private static class RecQueryHolder {
        private static final String idPrefix = "obj";
        private static final String refIdPrefix = "ref_";
        private boolean root;
        private RecordedQuery recordedQuery;
        private Map<Object, String> object2IdMap;
        private Map<String, Object> id2ObjectMap;
        private List<RecQueryHolder> adopted;
        private List<RecQueryHolder> replaced;
        private int lastId;
        private int lastRefId;

        private RecQueryHolder(RecordedQuery recordedQuery) {
            this.recordedQuery = recordedQuery;
            this.object2IdMap = new HashMap<Object, String>();
            this.id2ObjectMap = new HashMap<String, Object>();
            this.adopted = new ArrayList<RecQueryHolder>();
            this.replaced = new ArrayList<RecQueryHolder>();
            this.lastId = -1;
            this.lastRefId = -1;
            this.root = false;
        }

        private void recordInvocation(boolean assign, Object on, String method, Object result, List<RecordedQuery.Statement> parameters) {
            String[] ids = this.getIds(on, result);
            if (assign) {
                this.recordedQuery.addAssignment(ids[0], method, ids[1], parameters);
            } else {
                this.recordedQuery.addInvocation(ids[0], method, ids[1], parameters);
            }
        }

        private String getRefId(Object ref) {
            String refId = this.object2IdMap.get(ref);
            if (refId == null) {
                refId = this.getNextRefId();
                this.object2IdMap.put(ref, refId);
                this.id2ObjectMap.put(refId, ref);
            }
            return refId;
        }

        private String[] getIds(Object on, Object result) {
            String resId;
            String onId = this.object2IdMap.get(on);
            if (onId == null) {
                onId = on instanceof AbstractDomainQuery ? QueryRecorder.QUERY_ID : this.getNextId();
                this.object2IdMap.put(on, onId);
                this.id2ObjectMap.put(onId, on);
            }
            if ((resId = this.object2IdMap.get(result)) == null) {
                resId = this.getNextId();
                this.object2IdMap.put(result, resId);
                this.id2ObjectMap.put(resId, result);
            }
            return new String[]{onId, resId};
        }

        private String getNextId() {
            ++this.lastId;
            return idPrefix.concat(String.valueOf(this.lastId));
        }

        private String getNextRefId() {
            ++this.lastRefId;
            return refIdPrefix.concat(String.valueOf(this.lastRefId));
        }

        private void addAdopted(RecQueryHolder qh) {
            if (!this.adopted.contains(qh)) {
                this.adopted.add(qh);
            }
        }

        private void addReplaced(RecQueryHolder qh) {
            if (!this.replaced.contains(qh)) {
                this.replaced.add(qh);
            }
        }

        private boolean inReplaced(RecQueryHolder rqh) {
            int idx = this.replaced.indexOf(rqh);
            return idx >= 0;
        }

        private void stackLastNStatements(boolean assign, int n, Object on, String method, Object result) {
            ArrayList<RecordedQuery.Statement> stmts = new ArrayList<RecordedQuery.Statement>(n);
            if (n > 0) {
                int addOffs = 0;
                RecordedQuery.Statement stmt = null;
                RecordedQuery.Statement following = null;
                List<RecordedQuery.Statement> qstmts = this.recordedQuery.getStatements();
                int offs = qstmts.size() - 1;
                for (int i = 0; i < n + addOffs; ++i) {
                    stmt = qstmts.remove(offs - i);
                    stmts.add(0, stmt);
                    if (following instanceof RecordedQuery.Invocation && stmt instanceof RecordedQuery.Invocation && ((RecordedQuery.Invocation)following).getOnObjectRef().equals(((RecordedQuery.Invocation)stmt).getReturnObjectRef())) {
                        ++addOffs;
                    }
                    following = stmt;
                }
                offs = qstmts.size() - 1;
                while (offs >= 0) {
                    RecordedQuery.Statement prev = qstmts.get(offs);
                    boolean goOn = false;
                    if (prev instanceof RecordedQuery.Invocation && stmt instanceof RecordedQuery.Invocation && ((RecordedQuery.Invocation)stmt).getOnObjectRef().equals(((RecordedQuery.Invocation)prev).getReturnObjectRef())) {
                        qstmts.remove(offs);
                        stmts.add(0, prev);
                        stmt = prev;
                        --offs;
                        goOn = true;
                    }
                    if (goOn) continue;
                    break;
                }
            }
            String[] ids = this.getIds(on, result);
            if (assign) {
                this.recordedQuery.addAssignment(ids[0], method, ids[1], stmts);
            } else {
                this.recordedQuery.addInvocation(ids[0], method, ids[1], stmts);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.recordedQuery.toString());
            return sb.toString();
        }
    }

    public static class QueriesPerThread {
        private Map<AbstractDomainQuery, RecQueryHolder> queries = new HashMap<AbstractDomainQuery, RecQueryHolder>();
        private Map<Object, RecQueryHolder> recHolderRefs = new IdentityHashMap<Object, RecQueryHolder>();
        private Map<RecordedQuery, RecQueryHolder> query2HolderMap = new HashMap<RecordedQuery, RecQueryHolder>();

        private QueriesPerThread() {
        }

        private void put(AbstractDomainQuery key, RecQueryHolder value) {
            this.queries.put(key, value);
        }

        private RecQueryHolder get(AbstractDomainQuery key) {
            RecQueryHolder ret = this.queries.get(key);
            return ret;
        }

        private void putHolderRef(Object key, RecQueryHolder value) {
            this.recHolderRefs.put(key, value);
            this.query2HolderMap.put(value.recordedQuery, value);
        }

        private RecQueryHolder getHolderRef(Object key) {
            RecQueryHolder ret = this.recHolderRefs.get(key);
            return ret;
        }

        private RecQueryHolder getHolderForQuery(RecordedQuery key) {
            RecQueryHolder ret = this.query2HolderMap.get(key);
            return ret;
        }

        private RecQueryHolder removeHolderRef(Object key) {
            RecQueryHolder ret = this.recHolderRefs.remove(key);
            return ret;
        }

        private void removeFromQuery2HolderMap(RecQueryHolder rqh, RecQueryHolder par, boolean removeRoot, Set<RecQueryHolder> recursionSet) {
            if (recursionSet == null) {
                recursionSet = new HashSet<RecQueryHolder>();
            }
            recursionSet.add(rqh);
            if (!rqh.root || removeRoot) {
                this.query2HolderMap.remove(rqh.recordedQuery);
                if (par != null) {
                    par.adopted.remove(rqh);
                }
            }
            ArrayList adopted = new ArrayList();
            adopted.addAll(rqh.adopted);
            for (RecQueryHolder qh : adopted) {
                if (recursionSet.contains(qh)) continue;
                this.removeFromQuery2HolderMap(qh, rqh, removeRoot, recursionSet);
            }
        }

        private boolean isEmpty() {
            return this.queries.isEmpty();
        }

        public boolean isCleared() {
            if (Settings.TEST_MODE) {
                System.gc();
                System.runFinalization();
            }
            return this.queries.isEmpty() && this.recHolderRefs.isEmpty() && this.query2HolderMap.isEmpty();
        }

        public void queryCompleted(AbstractDomainQuery query) {
            RecQueryHolder rqh = this.queries.remove(query);
            if (rqh != null) {
                this.removeFromQuery2HolderMap(rqh, null, true, null);
                ArrayList<Object> toRemove = new ArrayList<Object>();
                for (Map.Entry<Object, RecQueryHolder> e : this.recHolderRefs.entrySet()) {
                    if (e.getValue() == rqh) {
                        toRemove.add(e.getKey());
                        continue;
                    }
                    if (!rqh.inReplaced(e.getValue())) continue;
                    toRemove.add(e.getKey());
                }
                for (Object e : toRemove) {
                    this.recHolderRefs.remove(e);
                }
            }
        }

        public Map<Object, String> getDOM2IdMap(AbstractDomainQuery q) {
            RecQueryHolder rqh = this.get(q);
            if (rqh != null) {
                ArrayList remove = new ArrayList();
                for (Object o : rqh.object2IdMap.keySet()) {
                    if (o instanceof DomainObjectMatch) continue;
                    remove.add(o);
                }
                for (Object o : remove) {
                    rqh.object2IdMap.remove(o);
                }
                return rqh.object2IdMap;
            }
            return null;
        }
    }
}

