/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domainquery.internal;

import iot.jcypher.domainquery.AbstractDomainQuery;
import iot.jcypher.domainquery.ast.Parameter;
import iot.jcypher.domainquery.internal.RecordedQueryToString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecordedQuery {
    private boolean generic;
    private Map<String, Parameter> parameters;
    private Map<String, String> augmentations;
    private List<Statement> statements;

    public <E extends AbstractDomainQuery> RecordedQuery(boolean generic) {
        this.generic = generic;
        this.statements = new ArrayList<Statement>();
    }

    public void addInvocation(String on, String method, String retObjectRef, List<Statement> params) {
        Invocation inv = new Invocation(on, method, retObjectRef, params);
        this.statements.add(inv);
    }

    public void addAssignment(String on, String method, String retObjectRef, List<Statement> params) {
        Assignment ass = new Assignment(on, method, retObjectRef, params);
        this.statements.add(ass);
    }

    public Literal literal(Object value) {
        return new Literal(value);
    }

    public Reference reference(Object value, String refId) {
        return new Reference(value, refId);
    }

    public DOMatchRef doMatchRef(String ref) {
        return new DOMatchRef(ref);
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public boolean isGeneric() {
        return this.generic;
    }

    public void setGeneric(boolean generic) {
        this.generic = generic;
    }

    public <T extends Statement> T createStatement(Class<T> type) {
        if (Assignment.class.equals(type)) {
            return (T)new Assignment();
        }
        if (Invocation.class.equals(type)) {
            return (T)new Invocation();
        }
        if (Literal.class.equals(type)) {
            return (T)new Literal();
        }
        if (Reference.class.equals(type)) {
            return (T)new Reference();
        }
        if (DOMatchRef.class.equals(type)) {
            return (T)new DOMatchRef();
        }
        return null;
    }

    public Map<String, String> getAugmentations() {
        return this.augmentations;
    }

    public void setAugmentations(Map<String, String> augmentations) {
        this.augmentations = augmentations;
    }

    Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    Parameter getCreateParameter(String name) {
        Parameter param;
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Parameter>();
        }
        if ((param = this.parameters.get(name)) == null) {
            param = new Parameter(name);
            this.parameters.put(name, param);
        }
        return param;
    }

    public String toString() {
        return RecordedQueryToString.queryToString(this);
    }

    public class Reference
    implements Statement {
        private Object value;
        private String refId;

        public Reference(Object value, String refId) {
            this.value = value;
            this.refId = refId;
        }

        private Reference() {
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public void setRefId(String refId) {
            this.refId = refId;
        }

        public String getRefId() {
            return this.refId;
        }

        @Override
        public String getHint() {
            return "_Reference_";
        }

        @Override
        public RecordedQuery getRecordedQuery() {
            return RecordedQuery.this;
        }
    }

    public class Literal
    implements Statement {
        private Object value;

        public Literal(Object value) {
            this.value = value;
        }

        private Literal() {
        }

        public Object getValue() {
            if (this.value instanceof Parameter) {
                return ((Parameter)this.value).getValue();
            }
            return this.value;
        }

        public Object getRawValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        @Override
        public String getHint() {
            if (this.value != null) {
                if (this.value instanceof Parameter) {
                    return "_QueryParameter_";
                }
                return this.value.toString();
            }
            return new String();
        }

        @Override
        public RecordedQuery getRecordedQuery() {
            return RecordedQuery.this;
        }
    }

    public class DOMatchRef
    implements Statement {
        private String ref;

        public DOMatchRef(String ref) {
            this.ref = ref;
        }

        private DOMatchRef() {
        }

        public String getRef() {
            return this.ref;
        }

        public void setRef(String ref) {
            this.ref = ref;
        }

        @Override
        public String getHint() {
            return this.ref;
        }

        @Override
        public RecordedQuery getRecordedQuery() {
            return RecordedQuery.this;
        }
    }

    public class Assignment
    extends Invocation {
        public Assignment(String onObjectRef, String method, String retObjectRef, List<Statement> params) {
            super(onObjectRef, method, retObjectRef, params);
        }

        private Assignment() {
        }
    }

    public class Invocation
    implements Statement {
        private String onObjectRef;
        private String method;
        private String returnObjectRef;
        private List<Statement> params;

        public Invocation(String onObjectRef, String method, String retObjectRef, List<Statement> params) {
            this.onObjectRef = onObjectRef;
            this.method = method;
            this.returnObjectRef = retObjectRef;
            this.params = params;
        }

        private Invocation() {
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public void setOnObjectRef(String onObjectRef) {
            this.onObjectRef = onObjectRef;
        }

        public String getOnObjectRef() {
            return this.onObjectRef;
        }

        public String getReturnObjectRef() {
            return this.returnObjectRef;
        }

        public void setReturnObjectRef(String returnObjectRef) {
            this.returnObjectRef = returnObjectRef;
        }

        public List<Statement> getParams() {
            return this.params;
        }

        public void setParams(List<Statement> params) {
            this.params = params;
        }

        @Override
        public String getHint() {
            return this.method;
        }

        @Override
        public RecordedQuery getRecordedQuery() {
            return RecordedQuery.this;
        }
    }

    public static interface Statement {
        public String getHint();

        public RecordedQuery getRecordedQuery();
    }
}

