/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domainquery.internal;

import iot.jcypher.domain.IDomainAccess;
import iot.jcypher.domain.IGenericDomainAccess;
import iot.jcypher.domain.internal.IIntDomainAccess;
import iot.jcypher.domainquery.DomainQuery;
import iot.jcypher.domainquery.GDomainQuery;
import iot.jcypher.domainquery.InternalAccess;
import iot.jcypher.domainquery.api.DomainObjectMatch;
import iot.jcypher.domainquery.ast.Parameter;
import iot.jcypher.domainquery.internal.QueryExecutor;
import iot.jcypher.domainquery.internal.QueryRecorder;
import iot.jcypher.domainquery.internal.RecordedQuery;
import iot.jcypher.domainquery.internal.ReplayedQueryContext;
import iot.jcypher.domainquery.internal.Settings;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecordedQueryPlayer {
    private Map<String, Object> id2ObjectMap;
    private ReplayedQueryContext replayedQueryContext;
    private boolean generic;
    private boolean createNew;

    public RecordedQueryPlayer() {
        this(false);
    }

    public RecordedQueryPlayer(boolean createNew) {
        this.createNew = createNew;
        this.id2ObjectMap = new HashMap<String, Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainQuery replayQuery(RecordedQuery recordedQuery, IDomainAccess domainAccess) {
        DomainQuery query;
        Boolean br_old = null;
        try {
            if (!Settings.TEST_MODE) {
                br_old = QueryRecorder.blockRecording.get();
                if (this.createNew) {
                    QueryRecorder.blockRecording.set(Boolean.FALSE);
                } else {
                    QueryRecorder.blockRecording.set(Boolean.TRUE);
                }
            }
            this.generic = false;
            this.replayedQueryContext = new ReplayedQueryContext(recordedQuery);
            query = ((IIntDomainAccess)((Object)domainAccess)).getInternalDomainAccess().createRecordedQuery(this.replayedQueryContext, this.createNew);
            this.id2ObjectMap.put("q", query);
            for (RecordedQuery.Statement stmt : recordedQuery.getStatements()) {
                this.replayStatement(stmt);
            }
            Map<String, Parameter> params = recordedQuery.getParameters();
            if (params != null) {
                QueryExecutor qe = InternalAccess.getQueryExecutor(query);
                for (Parameter param : params.values()) {
                    qe.addParameter(param);
                }
            }
        }
        finally {
            if (!Settings.TEST_MODE) {
                QueryRecorder.blockRecording.set(br_old);
            }
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GDomainQuery replayGenericQuery(RecordedQuery recordedQuery, IGenericDomainAccess domainAccess) {
        GDomainQuery query;
        Boolean br_old = null;
        try {
            if (!Settings.TEST_MODE) {
                br_old = QueryRecorder.blockRecording.get();
                if (this.createNew) {
                    QueryRecorder.blockRecording.set(Boolean.FALSE);
                } else {
                    QueryRecorder.blockRecording.set(Boolean.TRUE);
                }
            }
            this.generic = true;
            this.replayedQueryContext = new ReplayedQueryContext(recordedQuery);
            query = ((IIntDomainAccess)((Object)domainAccess)).getInternalDomainAccess().createRecordedGenQuery(this.replayedQueryContext, this.createNew);
            this.id2ObjectMap.put("q", query);
            for (RecordedQuery.Statement stmt : recordedQuery.getStatements()) {
                this.replayStatement(stmt);
            }
        }
        finally {
            if (!Settings.TEST_MODE) {
                QueryRecorder.blockRecording.set(br_old);
            }
        }
        return query;
    }

    private Object replayStatement(RecordedQuery.Statement stmt) {
        Object ret = null;
        if (stmt instanceof RecordedQuery.Literal) {
            ret = ((RecordedQuery.Literal)stmt).getValue();
        } else if (stmt instanceof RecordedQuery.Invocation) {
            ret = this.replayInvocation((RecordedQuery.Invocation)stmt);
        } else if (stmt instanceof RecordedQuery.DOMatchRef) {
            String oid = ((RecordedQuery.DOMatchRef)stmt).getRef();
            ret = this.id2ObjectMap.get(oid);
        } else if (stmt instanceof RecordedQuery.Reference) {
            ret = ((RecordedQuery.Reference)stmt).getValue();
            this.addToId2ObjectMap(((RecordedQuery.Reference)stmt).getRefId(), ret);
        }
        return ret;
    }

    private Object replayInvocation(RecordedQuery.Invocation invocation) {
        try {
            ArrayList<Object> params = new ArrayList<Object>(invocation.getParams().size());
            Class[] args = new Class[invocation.getParams().size()];
            int idx = 0;
            for (RecordedQuery.Statement stmt : invocation.getParams()) {
                Object param = this.replayStatement(stmt);
                params.add(param);
                args[idx] = param.getClass();
                ++idx;
            }
            args = this.concatParams(invocation.getParams(), params, args);
            Object on = this.id2ObjectMap.get(invocation.getOnObjectRef());
            Method mthd = this.findMethod(invocation.getMethod(), on, args, params);
            Object ret = mthd.invoke(on, params.toArray());
            this.addToId2ObjectMap(invocation.getReturnObjectRef(), ret);
            return ret;
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private Class<?>[] concatParams(List<RecordedQuery.Statement> params, List<Object> params2, Class<?>[] args) {
        RecordedQuery.Statement prev = null;
        boolean concatenated = false;
        int idx = 0;
        for (RecordedQuery.Statement param : params) {
            if (prev instanceof RecordedQuery.Invocation && param instanceof RecordedQuery.Invocation && ((RecordedQuery.Invocation)param).getOnObjectRef().equals(((RecordedQuery.Invocation)prev).getReturnObjectRef())) {
                params2.remove(--idx);
                concatenated = true;
            }
            prev = param;
            ++idx;
        }
        if (concatenated) {
            Class[] nArgs = new Class[params2.size()];
            for (int i = 0; i < params2.size(); ++i) {
                nArgs[i] = params2.get(i).getClass();
            }
            return nArgs;
        }
        return args;
    }

    private Method findMethod(String methodName, Object on, Class<?>[] args, List<Object> params) throws Throwable {
        Method ret;
        block25: {
            Class<?> cls;
            ret = null;
            String mthdName = methodName;
            if (methodName.equals("createMatch") && !this.generic) {
                args[0] = Class.class;
                cls = Class.forName(params.remove(0).toString());
                params.add(cls);
            } else if (methodName.equals("TO")) {
                if (!this.generic) {
                    args[0] = Class.class;
                    cls = Class.forName(params.remove(0).toString());
                    params.add(cls);
                } else {
                    mthdName = "TO_GENERIC";
                }
            } else if (methodName.equals("TO_GENERIC")) {
                if (!this.generic) {
                    args[0] = Class.class;
                    cls = Class.forName(params.remove(0).toString());
                    params.add(cls);
                    mthdName = "TO";
                }
            } else if (methodName.equals("AS")) {
                args[0] = Class.class;
                cls = Class.forName(params.remove(0).toString());
                params.add(cls);
            } else if (methodName.equals("createMatchFor") && !this.generic && args.length == 2) {
                args[1] = Class.class;
                cls = Class.forName(params.remove(1).toString());
                params.add(cls);
            }
            try {
                ret = on.getClass().getMethod(mthdName, args);
            }
            catch (NoSuchMethodException e) {
                Method[] mthds;
                for (Method mthd : mthds = on.getClass().getMethods()) {
                    if (!mthd.getName().equals(mthdName)) continue;
                    boolean matchVarTypes = false;
                    Class<?>[] types = mthd.getParameterTypes();
                    if ((types.length != args.length || types.length > 0 && types[types.length - 1].isArray()) && types.length > 0 && types[types.length - 1].isArray()) {
                        if (args.length == 0 && types.length == 1) {
                            matchVarTypes = true;
                        } else if (args.length > 0) {
                            if (types[types.length - 1].getComponentType().isAssignableFrom(args[args.length - 1])) {
                                matchVarTypes = true;
                            } else if (this.equalPrimitives(types[types.length - 1].getComponentType(), args[args.length - 1])) {
                                matchVarTypes = true;
                            }
                        }
                    }
                    if (matchVarTypes) {
                        int vparSize = params.size() - (types.length - 1);
                        Object paramsArray = Array.newInstance(types[types.length - 1].getComponentType(), vparSize);
                        for (int i = params.size() - 1; i >= types.length - 1; --i) {
                            int idx = i - (types.length - 1);
                            Array.set(paramsArray, idx, params.remove(i));
                        }
                        params.add(paramsArray);
                        ret = mthd;
                        break;
                    }
                    if (types.length != args.length) continue;
                    boolean same = true;
                    for (int i = 0; i < types.length; ++i) {
                        if (types[i].isAssignableFrom(args[i]) || this.equalPrimitives(types[i], args[i])) continue;
                        same = false;
                        break;
                    }
                    if (!same) continue;
                    ret = mthd;
                    break;
                }
                if (ret != null) break block25;
                throw e;
            }
        }
        return ret;
    }

    private boolean equalPrimitives(Class<?> prim1, Class<?> prim2) {
        if (prim1.isPrimitive()) {
            if (Integer.class == prim2) {
                return Integer.TYPE == prim1;
            }
            if (Long.class == prim2) {
                return Long.TYPE == prim1;
            }
            if (Short.class == prim2) {
                return Short.TYPE == prim1;
            }
            if (Float.class == prim2) {
                return Float.TYPE == prim1;
            }
            if (Double.class == prim2) {
                return Double.TYPE == prim1;
            }
            if (Boolean.class == prim2) {
                return Boolean.TYPE == prim1;
            }
        }
        return false;
    }

    private void addToId2ObjectMap(String id, Object value) {
        this.id2ObjectMap.put(id, value);
        if (value instanceof DomainObjectMatch) {
            this.replayedQueryContext.addDomainObjectMatch(id, (DomainObjectMatch)value);
        }
    }
}

