/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domainquery.internal;

import iot.jcypher.domainquery.internal.RecordedQuery;
import iot.jcypher.query.values.JcValue;
import iot.jcypher.query.values.ValueAccess;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class RecordedQueryToString {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS");

    public static String queryToString(RecordedQuery query) {
        Context context = new Context();
        context.augmentations = query.getAugmentations();
        context.sb.append(query.isGeneric() ? "Generic-DomainQuery" : "DomainQuery");
        context.sb.append("\n");
        List<RecordedQuery.Statement> stmts = query.getStatements();
        RecordedQueryToString.statementsToString(stmts, context);
        return context.sb.toString();
    }

    private static void statementsToString(List<RecordedQuery.Statement> statements, Context context) {
        RecordedQuery.Statement prev = null;
        for (int i = 0; i < statements.size(); ++i) {
            RecordedQuery.Statement s = statements.get(i);
            context.indent.calcBefore(s, context.callDepth);
            boolean separator = false;
            if (prev instanceof RecordedQuery.Invocation && !(prev instanceof RecordedQuery.Assignment) && s instanceof RecordedQuery.Invocation && ((RecordedQuery.Invocation)prev).getReturnObjectRef().equals(((RecordedQuery.Invocation)s).getOnObjectRef())) {
                context.sb.append('.');
                separator = true;
            }
            if (!separator) {
                if (prev != null) {
                    if (context.callDepth > 0) {
                        if (s instanceof RecordedQuery.Invocation && ((RecordedQuery.Invocation)s).getOnObjectRef().equals("q")) {
                            context.sb.append(",\n");
                            context.sb.append(context.indent.getIndent());
                        } else {
                            context.sb.append(", ");
                        }
                    } else {
                        context.sb.append(";\n");
                        context.sb.append(context.indent.getIndent());
                    }
                } else if (context.callDepth > 0 && s instanceof RecordedQuery.Invocation && ((RecordedQuery.Invocation)s).getOnObjectRef().equals("q")) {
                    context.sb.append('\n');
                    context.sb.append(context.indent.getIndent());
                }
                if (context.callDepth == 0) {
                    context.topStatementStart = context.sb.length();
                }
                RecordedQueryToString.statementToString(s, context);
            } else {
                RecordedQueryToString.callToString((RecordedQuery.Invocation)s, context);
            }
            context.indent.calcAfter(s, context.callDepth);
            if (context.callDepth == 0 && i == statements.size() - 1) {
                context.sb.append(';');
            }
            prev = s;
        }
    }

    private static void statementToString(RecordedQuery.Statement statement, Context context) {
        if (statement instanceof RecordedQuery.Literal) {
            if (((RecordedQuery.Literal)statement).getValue() != null) {
                PrimitiveWriter.writePrimitiveValue(((RecordedQuery.Literal)statement).getValue(), context.sb);
            } else {
                context.sb.append("null");
            }
        } else if (statement instanceof RecordedQuery.Invocation) {
            RecordedQueryToString.invocationToString((RecordedQuery.Invocation)statement, context);
        } else if (statement instanceof RecordedQuery.DOMatchRef) {
            context.sb.append(context.getAugmented(((RecordedQuery.DOMatchRef)statement).getRef()));
        } else if (statement instanceof RecordedQuery.Reference) {
            context.sb.append(((RecordedQuery.Reference)statement).getRefId());
        }
    }

    private static void invocationToString(RecordedQuery.Invocation invocation, Context context) {
        context.sb.append(context.getAugmented(invocation.getOnObjectRef()));
        context.sb.append('.');
        RecordedQueryToString.callToString(invocation, context);
    }

    private static void callToString(RecordedQuery.Invocation invocation, Context context) {
        context.sb.append(invocation.getMethod());
        context.sb.append('(');
        List<RecordedQuery.Statement> params = invocation.getParams();
        context.callDepth++;
        context.indent.increment();
        if (params != null) {
            RecordedQueryToString.statementsToString(params, context);
        }
        context.indent.decrement();
        context.callDepth--;
        context.sb.append(')');
        if (invocation instanceof RecordedQuery.Assignment) {
            context.sb.insert(context.topStatementStart, " = ");
            context.sb.insert(context.topStatementStart, context.getAugmented(invocation.getReturnObjectRef()));
        }
    }

    private static class PrimitiveWriter {
        private PrimitiveWriter() {
        }

        private static void writePrimitiveValue(Object val, StringBuilder sb) {
            if (val instanceof Number) {
                sb.append(val.toString());
            } else if (val instanceof Boolean) {
                sb.append(val.toString());
            } else if (val instanceof List) {
                List list = (List)val;
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    PrimitiveWriter.writePrimitiveValue(list.get(i), sb);
                }
            } else if (val.getClass().isArray()) {
                int len = Array.getLength(val);
                for (int i = 0; i < len; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    PrimitiveWriter.writePrimitiveValue(Array.get(val, i), sb);
                }
            } else if (val instanceof JcValue) {
                sb.append(ValueAccess.getName((JcValue)val));
            } else if (val instanceof Date) {
                sb.append(dateFormat.format((Date)val));
            } else {
                sb.append('\'');
                sb.append(val.toString());
                sb.append('\'');
            }
        }
    }

    private static class Context {
        private Indent indent = new Indent();
        private int callDepth = 0;
        private int topStatementStart;
        private Map<String, String> augmentations;
        private StringBuilder sb = new StringBuilder();

        private Context() {
        }

        private String getAugmented(String str) {
            String aug;
            if (this.augmentations != null && (aug = this.augmentations.get(str)) != null) {
                return aug;
            }
            return str;
        }
    }

    private static class Indent {
        private static final String BR_OPEN = "BR_OPEN";
        private static final String BR_CLOSE = "BR_CLOSE";
        private static final String IN = "   ";
        private int level = 0;
        private String indent = new String();

        private Indent() {
        }

        private String getIndent() {
            return this.indent;
        }

        private void calcBefore(RecordedQuery.Statement statement, int callDepth) {
            String hint = statement.getHint();
            if (BR_CLOSE.equals(hint) && this.level > 0) {
                --this.level;
                this.buildIndent();
            }
        }

        private void calcAfter(RecordedQuery.Statement statement, int callDepth) {
            String hint = statement.getHint();
            if (BR_OPEN.equals(hint)) {
                ++this.level;
                this.buildIndent();
            }
        }

        private void increment() {
            ++this.level;
            this.buildIndent();
        }

        private void decrement() {
            if (this.level > 0) {
                --this.level;
                this.buildIndent();
            }
        }

        private void buildIndent() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.level; ++i) {
                sb.append(IN);
            }
            this.indent = sb.toString();
        }
    }
}

