/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.graph;

import iot.jcypher.graph.GrAccess;
import iot.jcypher.graph.GrLabel;
import iot.jcypher.graph.GrPropertyContainer;
import iot.jcypher.graph.PersistableItemsContainer;
import iot.jcypher.graph.SyncState;
import iot.jcypher.graph.internal.GrId;
import iot.jcypher.query.result.util.ResultHandler;
import java.util.List;

public class GrNode
extends GrPropertyContainer {
    private LabelsContainer labelsContainer;

    GrNode(ResultHandler resultHandler, GrId id, int rowIdx) {
        super(resultHandler, id, rowIdx);
    }

    public List<GrLabel> getLabels() {
        return this.getLabelsContainer().getElements();
    }

    public GrLabel getLabel(String labelName) {
        for (GrLabel lab : this.getLabels()) {
            if (!lab.getName().equals(labelName)) continue;
            return lab;
        }
        return null;
    }

    public GrLabel addLabel(String name) {
        GrLabel lab = GrAccess.createLabel(name);
        return this.getLabelsContainer().addElement(lab);
    }

    @Override
    protected boolean testForSyncState() {
        if (super.testForSyncState()) {
            if (this.labelsContainer != null) {
                return this.labelsContainer.checkForSyncState();
            }
            return true;
        }
        return false;
    }

    private List<GrLabel> resolveLabels() {
        return this.resultHandler.getNodeLabels(this.getId(), this.rowIndex);
    }

    private boolean containslabel(List<GrLabel> list, GrLabel lab) {
        String nm = lab.getName();
        for (GrLabel l : list) {
            if (!l.getName().equals(nm)) continue;
            return true;
        }
        return false;
    }

    LabelsContainer getLabelsContainer() {
        if (this.labelsContainer == null) {
            this.labelsContainer = new LabelsContainer();
        }
        return this.labelsContainer;
    }

    @Override
    void setToSynchronized() {
        if (this.labelsContainer != null) {
            this.labelsContainer.setToSynchronized();
        }
        super.setToSynchronized();
        this.setSyncState(SyncState.SYNC);
    }

    private class LabelsContainer
    extends PersistableItemsContainer<GrLabel> {
        private LabelsContainer() {
        }

        @Override
        SyncState getContainerSyncState() {
            return GrNode.this.getSyncState();
        }

        @Override
        void setContainerSyncState(SyncState syncState) {
            GrNode.this.setSyncState(syncState);
        }

        @Override
        protected void fireContainerChanged(SyncState oldState, SyncState newState) {
            GrNode.this.fireChanged(oldState, newState);
        }

        @Override
        protected boolean checkContainerForSyncState() {
            return GrNode.this.testForSyncState();
        }

        @Override
        protected List<GrLabel> resolveElements() {
            return GrNode.this.resolveLabels();
        }

        @Override
        protected boolean containsElement(List<GrLabel> elems, GrLabel elem) {
            return GrNode.this.containslabel(elems, elem);
        }
    }
}

