/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.graph;

import iot.jcypher.graph.GrNode;
import iot.jcypher.graph.GrRelation;
import iot.jcypher.graph.internal.GrId;
import iot.jcypher.query.result.util.ResultHandler;
import java.util.ArrayList;
import java.util.List;

public class GrPath {
    private ResultHandler resultHandler;
    private int rowIndex;
    private GrId startNodeId;
    private GrId endNodeId;
    private List<GrId> relationIds;

    GrPath(ResultHandler resultHandler, GrId startNodeId, GrId endNodeId, List<GrId> relationIds, int rowIndex) {
        this.resultHandler = resultHandler;
        this.rowIndex = rowIndex;
        this.startNodeId = startNodeId;
        this.endNodeId = endNodeId;
        this.relationIds = relationIds;
    }

    public GrNode getStartNode() {
        return this.resultHandler.getNode(this.startNodeId, this.rowIndex);
    }

    public GrNode getEndNode() {
        return this.resultHandler.getNode(this.endNodeId, this.rowIndex);
    }

    public List<GrRelation> getRelations() {
        ArrayList<GrRelation> rels = new ArrayList<GrRelation>(this.relationIds.size());
        for (GrId rid : this.relationIds) {
            rels.add(this.resultHandler.getRelation(rid));
        }
        return rels;
    }

    public int getLength() {
        return this.relationIds.size();
    }
}

