/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.graph;

import iot.jcypher.graph.PersistableItem;
import iot.jcypher.graph.SyncState;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class GrProperty
extends PersistableItem {
    private String name;
    private Object value;

    GrProperty(String name) {
        this.name = name;
        this.syncState = SyncState.NEW;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        ArrayList<Object> val = value;
        if (val != null && val.getClass().isArray()) {
            int length = Array.getLength(val);
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < length; ++i) {
                Object arrayElement = Array.get(val, i);
                list.add(arrayElement);
            }
            val = list;
        }
        Object oldVal = this.value;
        this.value = val;
        if (oldVal != null && oldVal != this.value) {
            SyncState oldState = this.syncState;
            if (this.syncState == SyncState.SYNC) {
                this.syncState = SyncState.CHANGED;
            }
            if (oldState != this.syncState) {
                this.fireChanged(oldState, this.syncState);
            }
        }
    }

    @Override
    void setToSynchronized() {
        this.setSyncState(SyncState.SYNC);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Property: ");
        sb.append(this.name);
        sb.append(" = ");
        if (this.value != null) {
            sb.append(this.value);
        } else {
            sb.append("null");
        }
        return sb.toString();
    }
}

