/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.graph;

import iot.jcypher.graph.GrAccess;
import iot.jcypher.graph.GrElement;
import iot.jcypher.graph.GrNode;
import iot.jcypher.graph.GrProperty;
import iot.jcypher.graph.GrRelation;
import iot.jcypher.graph.Graph;
import iot.jcypher.graph.PersistableItemsContainer;
import iot.jcypher.graph.SyncState;
import iot.jcypher.graph.internal.GrId;
import iot.jcypher.query.result.util.ResultHandler;
import java.util.List;

public abstract class GrPropertyContainer
extends GrElement {
    private GrId id;
    private PropertiesContainer propertiesContainer;

    GrPropertyContainer(ResultHandler resultHandler, GrId id, int rowIdx) {
        super(resultHandler, rowIdx);
        this.id = id;
        this.syncState = SyncState.NEW;
    }

    GrId getGrId() {
        return this.id;
    }

    void setGrId(GrId grId) {
        this.id = grId;
    }

    public long getId() {
        return this.id.getId();
    }

    public List<GrProperty> getProperties() {
        return this.getPropertiesContainer().getElements();
    }

    public GrProperty getProperty(String propertyName) {
        for (GrProperty prop : this.getProperties()) {
            if (!prop.getName().equals(propertyName)) continue;
            return prop;
        }
        return null;
    }

    public GrProperty addProperty(String name, Object value) {
        GrProperty prop = GrAccess.createProperty(name);
        prop.setValue(value);
        return this.getPropertiesContainer().addElement(prop);
    }

    public Graph getGraph() {
        return this.resultHandler.getGraph();
    }

    PropertiesContainer getPropertiesContainer() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new PropertiesContainer();
        }
        return this.propertiesContainer;
    }

    private boolean containsProperty(List<GrProperty> list, GrProperty prop) {
        String nm = prop.getName();
        for (GrProperty p : list) {
            if (!p.getName().equals(nm)) continue;
            return true;
        }
        return false;
    }

    private List<GrProperty> resolveProperties() {
        if (this instanceof GrNode) {
            return this.resultHandler.getNodeProperties(this.id, this.rowIndex);
        }
        if (this instanceof GrRelation) {
            return this.resultHandler.getRelationProperties(this.id, this.rowIndex);
        }
        return null;
    }

    protected boolean testForSyncState() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.checkForSyncState();
        }
        return true;
    }

    @Override
    void setToSynchronized() {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.setToSynchronized();
        }
    }

    private class PropertiesContainer
    extends PersistableItemsContainer<GrProperty> {
        private PropertiesContainer() {
        }

        @Override
        SyncState getContainerSyncState() {
            return GrPropertyContainer.this.getSyncState();
        }

        @Override
        void setContainerSyncState(SyncState syncState) {
            GrPropertyContainer.this.setSyncState(syncState);
        }

        @Override
        protected void fireContainerChanged(SyncState oldState, SyncState newState) {
            GrPropertyContainer.this.fireChanged(oldState, newState);
        }

        @Override
        protected boolean checkContainerForSyncState() {
            return GrPropertyContainer.this.testForSyncState();
        }

        @Override
        protected List<GrProperty> resolveElements() {
            return GrPropertyContainer.this.resolveProperties();
        }

        @Override
        protected boolean containsElement(List<GrProperty> elems, GrProperty elem) {
            return GrPropertyContainer.this.containsProperty(elems, elem);
        }
    }
}

