/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.query;

import iot.jcypher.database.IDBAccess;
import iot.jcypher.graph.GrNode;
import iot.jcypher.graph.GrPath;
import iot.jcypher.graph.GrRelation;
import iot.jcypher.graph.Graph;
import iot.jcypher.query.LiteralMap;
import iot.jcypher.query.LiteralMapList;
import iot.jcypher.query.result.JcError;
import iot.jcypher.query.result.util.ResultHandler;
import iot.jcypher.query.values.JcBoolean;
import iot.jcypher.query.values.JcCollection;
import iot.jcypher.query.values.JcNode;
import iot.jcypher.query.values.JcNumber;
import iot.jcypher.query.values.JcPath;
import iot.jcypher.query.values.JcPrimitive;
import iot.jcypher.query.values.JcRelation;
import iot.jcypher.query.values.JcString;
import iot.jcypher.query.values.JcValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.neo4j.driver.v1.StatementResult;

public class JcQueryResult {
    private JsonObject jsonResult;
    private List<JcError> generalErrors;
    private List<JcError> dbErrors;
    private ResultHandler resultHandler;

    public JcQueryResult(JsonObject jsonResult, int queryIndex, IDBAccess dbAccess) {
        this.jsonResult = jsonResult;
        this.resultHandler = new ResultHandler(jsonResult, queryIndex, dbAccess);
    }

    public JcQueryResult(StatementResult statementResult, IDBAccess dbAccess) {
        this.resultHandler = new ResultHandler(statementResult, dbAccess);
    }

    public JsonObject getJsonResult() {
        return this.jsonResult;
    }

    public List<GrNode> resultOf(JcNode node) {
        return this.resultHandler.getNodes(node);
    }

    public List<GrRelation> resultOf(JcRelation relation) {
        return this.resultHandler.getRelations(relation);
    }

    public List<GrPath> resultOf(JcPath path) {
        return this.resultHandler.getPaths(path);
    }

    public List<BigDecimal> resultOf(JcNumber number) {
        return this.resultHandler.getNumbers(number);
    }

    public List<String> resultOf(JcString string) {
        return this.resultHandler.getStrings(string);
    }

    public List<Boolean> resultOf(JcBoolean bool) {
        return this.resultHandler.getBooleans(bool);
    }

    public List<List<?>> resultOf(JcCollection collection) {
        return this.resultHandler.getCollections(collection);
    }

    public List<?> resultOf(JcValue val) {
        return this.resultHandler.getObjects(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiteralMapList resultMapListOf(JcPrimitive ... key) {
        ArrayList results = new ArrayList();
        LiteralMapList ret = new LiteralMapList();
        int size = -1;
        ResultHandler.includeNullValues.set(Boolean.TRUE);
        try {
            for (JcPrimitive k : key) {
                List<?> r = this.resultOf(k);
                if (size == -1) {
                    size = r.size();
                }
                results.add(r);
                for (int i = 0; i < r.size(); ++i) {
                    LiteralMap map;
                    if (i > ret.size() - 1) {
                        map = new LiteralMap();
                        ret.add(map);
                    } else {
                        map = (LiteralMap)ret.get(i);
                    }
                    map.put(k, r.get(i));
                }
            }
        }
        finally {
            ResultHandler.includeNullValues.remove();
        }
        return ret;
    }

    public Graph getGraph() {
        return this.resultHandler.getGraph();
    }

    public List<JcError> getGeneralErrors() {
        if (this.generalErrors == null) {
            this.generalErrors = new ArrayList<JcError>();
        }
        return this.generalErrors;
    }

    public List<JcError> getDBErrors() {
        if (this.dbErrors == null) {
            this.dbErrors = new ArrayList<JcError>();
            JsonObject obj = this.getJsonResult();
            if (obj != null) {
                JsonArray errs = obj.getJsonArray("errors");
                int size = errs.size();
                for (int i = 0; i < size; ++i) {
                    JsonObject err = errs.getJsonObject(i);
                    String info = null;
                    if (err.containsKey((Object)"info")) {
                        info = err.getString("info");
                    }
                    this.dbErrors.add(new JcError(err.getString("code"), err.getString("message"), info));
                }
            }
        }
        return this.dbErrors;
    }

    public void addGeneralError(JcError generalError) {
        this.getGeneralErrors().add(generalError);
    }

    public boolean hasErrors() {
        return !this.getGeneralErrors().isEmpty() || !this.getDBErrors().isEmpty();
    }

    ResultHandler getResultHandler() {
        return this.resultHandler;
    }
}

