/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.query.api.collection;

import iot.jcypher.query.api.APIObject;
import iot.jcypher.query.api.APIObjectAccess;
import iot.jcypher.query.api.IClause;
import iot.jcypher.query.api.collection.CFrom;
import iot.jcypher.query.api.collection.CTerminal;
import iot.jcypher.query.api.collection.CWhere;
import iot.jcypher.query.api.collection.CollectFrom;
import iot.jcypher.query.api.collection.Collection;
import iot.jcypher.query.api.collection.EXProperty;
import iot.jcypher.query.api.collection.EachDoConcat;
import iot.jcypher.query.api.collection.ExtractExpression;
import iot.jcypher.query.api.collection.InCollection;
import iot.jcypher.query.api.collection.ReduceTo;
import iot.jcypher.query.ast.ASTNode;
import iot.jcypher.query.ast.collection.CollectExpression;
import iot.jcypher.query.ast.collection.CollectionSpec;
import iot.jcypher.query.ast.collection.DoEvalExpression;
import iot.jcypher.query.ast.collection.ExtractEvalExpression;
import iot.jcypher.query.ast.collection.PredicateEvalExpression;
import iot.jcypher.query.ast.collection.PredicateFunctionEvalExpression;
import iot.jcypher.query.ast.collection.PropertyEvalExpresssion;
import iot.jcypher.query.ast.collection.ReduceEvalExpression;
import iot.jcypher.query.ast.predicate.PredicateExpression;
import iot.jcypher.query.ast.predicate.PredicateFunction;
import iot.jcypher.query.values.JcCollection;
import iot.jcypher.query.values.JcValue;

public class CFactory {
    public static ExtractExpression EXTRACT() {
        CollectExpression collXpr = new CollectExpression();
        collXpr.setType(CollectExpression.CollectXpressionType.EXTRACT);
        collXpr.setEvalExpression(new ExtractEvalExpression());
        return new ExtractExpression(collXpr);
    }

    public static EXProperty<CollectFrom> COLLECT() {
        CollectExpression collXpr = new CollectExpression();
        collXpr.setType(CollectExpression.CollectXpressionType.COLLECT);
        collXpr.setEvalExpression(new PropertyEvalExpresssion());
        CollectFrom connector = new CollectFrom(collXpr);
        EXProperty<CollectFrom> ret = new EXProperty<CollectFrom>(collXpr, connector);
        return ret;
    }

    public static CFrom<CWhere> FILTER() {
        CollectExpression collXpr = new CollectExpression();
        collXpr.setType(CollectExpression.CollectXpressionType.FILTER);
        collXpr.setEvalExpression(new PredicateEvalExpression());
        CWhere connector = new CWhere(collXpr);
        CFrom<CWhere> ret = new CFrom<CWhere>(collXpr, connector);
        return ret;
    }

    public static CFrom<ReduceTo> REDUCE() {
        CollectExpression collXpr = new CollectExpression();
        collXpr.setType(CollectExpression.CollectXpressionType.REDUCE);
        collXpr.setEvalExpression(new ReduceEvalExpression());
        ReduceTo connector = new ReduceTo(collXpr);
        return new CFrom<ReduceTo>(collXpr, connector);
    }

    public static Collection TAIL() {
        CollectExpression collXpr = new CollectExpression();
        collXpr.setType(CollectExpression.CollectXpressionType.TAIL);
        Collection ret = new Collection(collXpr);
        return ret;
    }

    public static CTerminal CREATE(IClause[] clauses) {
        CollectExpression collXpr = new CollectExpression();
        collXpr.setType(CollectExpression.CollectXpressionType.CREATE);
        collXpr.setNestedClauses(clauses);
        CTerminal ret = new CTerminal(collXpr);
        return ret;
    }

    public static CTerminal TAIL(JcCollection collection) {
        CollectExpression collXpr = new CollectExpression();
        collXpr.setType(CollectExpression.CollectXpressionType.TAIL);
        CollectionSpec cs = new CollectionSpec(collection);
        collXpr.setCollectionToOperateOn(cs);
        CTerminal ret = new CTerminal(collXpr);
        return ret;
    }

    public static InCollection<CWhere> forAll(JcValue jcValue) {
        return CFactory.createFor(jcValue, PredicateFunction.PredicateFunctionType.ALL);
    }

    public static InCollection<CWhere> forAny(JcValue jcValue) {
        return CFactory.createFor(jcValue, PredicateFunction.PredicateFunctionType.ANY);
    }

    public static InCollection<CWhere> forSingle(JcValue jcValue) {
        return CFactory.createFor(jcValue, PredicateFunction.PredicateFunctionType.SINGLE);
    }

    public static InCollection<CWhere> forNone(JcValue jcValue) {
        return CFactory.createFor(jcValue, PredicateFunction.PredicateFunctionType.NONE);
    }

    public static InCollection<EachDoConcat> element(JcValue jcValue) {
        CollectExpression collXpr = new CollectExpression();
        collXpr.setType(CollectExpression.CollectXpressionType.FOREACH);
        DoEvalExpression doEval = new DoEvalExpression();
        collXpr.setEvalExpression(doEval);
        collXpr.setIterationVariable(jcValue);
        EachDoConcat edc = new EachDoConcat(collXpr);
        InCollection<EachDoConcat> inColl = new InCollection<EachDoConcat>(collXpr, edc);
        return inColl;
    }

    private static InCollection<CWhere> createFor(JcValue jcValue, PredicateFunction.PredicateFunctionType type) {
        CollectExpression collXpr = new CollectExpression();
        collXpr.setType(CollectExpression.CollectXpressionType.PREDICATE_FUNCTION);
        PredicateFunctionEvalExpression pfEval = new PredicateFunctionEvalExpression();
        pfEval.setType(type);
        collXpr.setEvalExpression(pfEval);
        collXpr.setIterationVariable(jcValue);
        CWhere cwhere = new CWhere(collXpr);
        InCollection<CWhere> inColl = new InCollection<CWhere>(collXpr, cwhere);
        return inColl;
    }

    public static CollectExpression getRootCollectExpression(APIObject obj) {
        CollectExpression ret = null;
        ASTNode xpr = APIObjectAccess.getAstNode(obj);
        if (xpr instanceof CollectExpression) {
            ret = (CollectExpression)xpr;
        } else if (xpr instanceof PredicateExpression) {
            for (PredicateExpression px = (PredicateExpression)xpr; px != null; px = px.getParent()) {
                CollectExpression collXpr = px.getContainingCollectExpression();
                if (collXpr == null) continue;
                ret = collXpr;
            }
        }
        if (ret != null) {
            CollectExpression par = ret.getParent();
            while (par != null) {
                ret = par;
                par = ret.getParent();
            }
        }
        return ret;
    }
}

