/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.query.api.pattern;

import iot.jcypher.query.api.pattern.Element;
import iot.jcypher.query.api.pattern.Node;
import iot.jcypher.query.ast.pattern.PatternExpression;
import iot.jcypher.query.ast.pattern.PatternNode;
import iot.jcypher.query.ast.pattern.PatternRelation;
import iot.jcypher.query.values.JcNode;

public class Relation
extends Element<Relation> {
    Relation(PatternExpression expression) {
        super(expression);
    }

    public Relation type(String type) {
        this.getPatternRelation().getTypes().add(type);
        return this;
    }

    public Relation type(Enum<?> type) {
        this.getPatternRelation().getTypes().add(type.name());
        return this;
    }

    public Node node() {
        return this.node(null);
    }

    public Node node(JcNode jcNode) {
        PatternExpression px = (PatternExpression)this.astNode;
        PatternNode pn = new PatternNode(jcNode);
        px.addElement(pn);
        Node ret = new Node(px);
        return ret;
    }

    public Relation in() {
        this.getPatternRelation().in();
        return this;
    }

    public Relation out() {
        this.getPatternRelation().out();
        return this;
    }

    public Relation minHops(int minHops) {
        this.getPatternRelation().minHops(minHops);
        return this;
    }

    public Relation maxHops(int maxHops) {
        this.getPatternRelation().maxHops(maxHops);
        return this;
    }

    public Relation maxHopsUnbound() {
        this.getPatternRelation().maxHopsUnbound();
        return this;
    }

    public Relation hopsUnbound() {
        this.getPatternRelation().hopsUnbound();
        return this;
    }

    public Relation hops(int hops) {
        this.getPatternRelation().hops(hops);
        return this;
    }

    private PatternRelation getPatternRelation() {
        PatternExpression px = (PatternExpression)this.astNode;
        return (PatternRelation)px.getLastElement();
    }
}

