/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.query.ast.pattern;

import iot.jcypher.query.ast.pattern.PatternElement;
import iot.jcypher.query.values.JcRelation;
import java.util.ArrayList;
import java.util.List;

public class PatternRelation
extends PatternElement {
    private List<String> types = new ArrayList<String>();
    private Direction direction = Direction.BOTH;
    private int minHops = 1;
    private int maxHops = 1;

    public PatternRelation(JcRelation jcRelation) {
        super(jcRelation);
    }

    public List<String> getTypes() {
        return this.types;
    }

    public void in() {
        this.direction = Direction.IN;
    }

    public void out() {
        this.direction = Direction.OUT;
    }

    public void minHops(int minHops) {
        this.minHops = minHops;
    }

    public void maxHops(int maxHops) {
        this.maxHops = maxHops;
    }

    public void maxHopsUnbound() {
        this.maxHops = -1;
    }

    public void hopsUnbound() {
        this.maxHops = -1;
        this.minHops = 0;
    }

    public void hops(int hops) {
        this.maxHops = hops;
        this.minHops = hops;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public int getMinHops() {
        return this.minHops;
    }

    public int getMaxHops() {
        return this.maxHops;
    }

    public static enum Direction {
        IN,
        OUT,
        BOTH;

    }
}

