/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.query.result.util;

import iot.jcypher.concurrency.Locking;
import iot.jcypher.database.IDBAccess;
import iot.jcypher.database.remote.BoltDBAccess;
import iot.jcypher.domain.internal.DomainAccess;
import iot.jcypher.graph.GrAccess;
import iot.jcypher.graph.GrLabel;
import iot.jcypher.graph.GrNode;
import iot.jcypher.graph.GrPath;
import iot.jcypher.graph.GrProperty;
import iot.jcypher.graph.GrPropertyContainer;
import iot.jcypher.graph.GrRelation;
import iot.jcypher.graph.Graph;
import iot.jcypher.graph.PersistableItem;
import iot.jcypher.graph.SyncState;
import iot.jcypher.graph.internal.ChangeListener;
import iot.jcypher.graph.internal.GrId;
import iot.jcypher.graph.internal.LocalId;
import iot.jcypher.graph.internal.LockUtil;
import iot.jcypher.query.JcQuery;
import iot.jcypher.query.JcQueryResult;
import iot.jcypher.query.api.IClause;
import iot.jcypher.query.api.collection.DoConcat;
import iot.jcypher.query.api.collection.EachDoConcat;
import iot.jcypher.query.api.modify.ModifyTerminal;
import iot.jcypher.query.api.pattern.Node;
import iot.jcypher.query.api.pattern.Relation;
import iot.jcypher.query.api.start.StartPoint;
import iot.jcypher.query.factories.clause.CASE;
import iot.jcypher.query.factories.clause.CREATE;
import iot.jcypher.query.factories.clause.DO;
import iot.jcypher.query.factories.clause.ELSE;
import iot.jcypher.query.factories.clause.END;
import iot.jcypher.query.factories.clause.FOR_EACH;
import iot.jcypher.query.factories.clause.NATIVE;
import iot.jcypher.query.factories.clause.OPTIONAL_MATCH;
import iot.jcypher.query.factories.clause.RETURN;
import iot.jcypher.query.factories.clause.START;
import iot.jcypher.query.factories.clause.WHEN;
import iot.jcypher.query.factories.clause.WHERE;
import iot.jcypher.query.factories.clause.WITH;
import iot.jcypher.query.factories.xpression.C;
import iot.jcypher.query.result.JcError;
import iot.jcypher.query.result.util.BoltContentHandler;
import iot.jcypher.query.result.util.JSONContentHandler;
import iot.jcypher.query.result.util.LocalIdBuilder;
import iot.jcypher.query.values.JcBoolean;
import iot.jcypher.query.values.JcCollection;
import iot.jcypher.query.values.JcElement;
import iot.jcypher.query.values.JcNode;
import iot.jcypher.query.values.JcNumber;
import iot.jcypher.query.values.JcPath;
import iot.jcypher.query.values.JcProperty;
import iot.jcypher.query.values.JcRelation;
import iot.jcypher.query.values.JcString;
import iot.jcypher.query.values.JcValue;
import iot.jcypher.query.values.ValueAccess;
import iot.jcypher.query.values.ValueWriter;
import iot.jcypher.query.writer.Format;
import iot.jcypher.query.writer.WriterContext;
import iot.jcypher.transaction.ITransaction;
import iot.jcypher.util.QueriesPrintObserver;
import iot.jcypher.util.ResultSettings;
import iot.jcypher.util.Util;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.json.JsonObject;
import org.neo4j.driver.internal.value.ListValue;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Value;

public class ResultHandler {
    public static final String lockVersionProperty = "_c_version_";
    public static ThreadLocal<Boolean> includeNullValues = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private AContentHandler contentHandler;
    private IDBAccess dbAccess;
    public static boolean writeVersion = true;
    private Graph graph;
    private Locking lockingStrategy;
    private LocalElements localElements;
    private NodeRelationListener nodeRelationListener;
    private Map<Long, GrNode> nodesById;
    private Map<Long, GrNode> changedNodesById;
    private Map<Long, GrRelation> relationsById;
    private Map<Long, GrRelation> changedRelationsById;
    private ElementVersions elementVersions;
    private Map<String, List<GrNode>> nodeColumns;
    private Map<String, List<GrRelation>> relationColumns;
    private Map<String, List<GrPath>> pathColumns;
    private Map<String, List> valueColumns;
    private List<String> unResolvedColumns;

    public ResultHandler(JsonObject jsonResult, int queryIndex, IDBAccess dbAccess) {
        this.init(dbAccess);
        this.contentHandler = new JSONContentHandler(jsonResult, queryIndex);
    }

    public ResultHandler(StatementResult statementResult, IDBAccess dbAccess) {
        this.init(dbAccess);
        this.contentHandler = new BoltContentHandler(statementResult, this);
    }

    public ResultHandler(IDBAccess dbAccess) {
        this.init(dbAccess);
        this.contentHandler = this.calcContentHandler(dbAccess);
    }

    private AContentHandler calcContentHandler(IDBAccess dba) {
        if (dba instanceof BoltDBAccess) {
            return new BoltContentHandler(null, this);
        }
        if (dba instanceof DomainAccess.DomainAccessHandler.DBAccessWrapper) {
            return this.calcContentHandler(((DomainAccess.DomainAccessHandler.DBAccessWrapper)dba).getDelegate());
        }
        return new JSONContentHandler(null, -1);
    }

    private void init(IDBAccess dbAccess) {
        this.dbAccess = dbAccess;
        this.lockingStrategy = Locking.NONE;
        this.localElements = new LocalElements();
        this.graph = GrAccess.createGraph(this);
        GrAccess.setGraphState(this.graph, SyncState.SYNC);
    }

    IDBAccess getDbAccess() {
        return this.dbAccess;
    }

    AContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setLockingStrategy(Locking lockingStrategy) {
        this.lockingStrategy = lockingStrategy;
    }

    public ITransaction createLockingTxIfNeeded() {
        ITransaction tx;
        if (this.lockingStrategy == Locking.OPTIMISTIC && (tx = this.dbAccess.getTX()) == null) {
            return this.dbAccess.beginTX();
        }
        return null;
    }

    public LocalElements getLocalElements() {
        return this.localElements;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public List<GrNode> getNodes(JcNode node) {
        String colKey = ValueAccess.getName(node);
        List<GrNode> nds = this.getNodes(colKey);
        nds = this.filterRemovedAndNullItems(nds);
        return Collections.unmodifiableList(nds);
    }

    private <T extends PersistableItem> List<T> filterRemovedAndNullItems(List<T> items) {
        ArrayList<PersistableItem> rItems = new ArrayList<PersistableItem>();
        for (PersistableItem item : items) {
            if (item == null) {
                if (!includeNullValues.get().booleanValue() && !ResultSettings.includeNullValuesAndDuplicates.get().booleanValue()) continue;
                rItems.add(item);
                continue;
            }
            if (GrAccess.getState(item) == SyncState.REMOVED) continue;
            rItems.add(item);
        }
        return rItems;
    }

    private List<GrNode> getNodes(String colKey) {
        List<GrNode> rNodes = this.getNodeColumns().get(colKey);
        if (rNodes == null) {
            rNodes = new ArrayList<GrNode>();
            Iterator<AContentHandler.RowOrRecord> it = this.contentHandler.getDataIterator();
            int rowIdx = -1;
            while (it.hasNext()) {
                ++rowIdx;
                AContentHandler.RowOrRecord roc = it.next();
                ElementInfo ei = roc.getElementInfo(colKey);
                GrNode rNode = null;
                if (!ei.isNull && (rNode = this.getNodesById().get(ei.id)) == null) {
                    rNode = GrAccess.createNode(this, new GrId(ei.id), rowIdx);
                    GrAccess.setState(rNode, SyncState.SYNC);
                    GrAccess.addChangeListener(this.getNodeRelationListener(), rNode);
                    this.getNodesById().put(ei.id, rNode);
                }
                if (!ResultSettings.includeNullValuesAndDuplicates.get().booleanValue() && rNodes.contains(rNode)) continue;
                rNodes.add(rNode);
            }
            this.getNodeColumns().put(colKey, rNodes);
            this.getUnresolvedColumns().remove(colKey);
        }
        return rNodes;
    }

    public List<GrRelation> getRelations(JcRelation relation) {
        String colKey = ValueAccess.getName(relation);
        List<GrRelation> rels = this.getRelations(colKey);
        rels = this.filterRemovedAndNullItems(rels);
        return Collections.unmodifiableList(rels);
    }

    private List<GrRelation> getRelations(String colKey) {
        List<GrRelation> rRelations = this.getRelationColumns().get(colKey);
        if (rRelations == null) {
            rRelations = new ArrayList<GrRelation>();
            Iterator<AContentHandler.RowOrRecord> it = this.contentHandler.getDataIterator();
            int rowIdx = -1;
            while (it.hasNext()) {
                ++rowIdx;
                AContentHandler.RowOrRecord roc = it.next();
                GrRelation rRelation = null;
                ElementInfo ei = roc.getElementInfo(colKey);
                if (!ei.isNull) {
                    RelationInfo ri = roc.getRelationInfo(colKey);
                    rRelation = this.getRelationsById().get(ei.id);
                    if (rRelation == null) {
                        rRelation = GrAccess.createRelation(this, new GrId(ei.id), new GrId(ri.startNodeId), new GrId(ri.endNodeId), rowIdx);
                        GrAccess.setState(rRelation, SyncState.SYNC);
                        GrAccess.addChangeListener(this.getNodeRelationListener(), rRelation);
                        this.getRelationsById().put(ei.id, rRelation);
                    }
                }
                if (!ResultSettings.includeNullValuesAndDuplicates.get().booleanValue() && rRelations.contains(rRelation)) continue;
                rRelations.add(rRelation);
            }
            this.getRelationColumns().put(colKey, rRelations);
            this.getUnresolvedColumns().remove(colKey);
        }
        return rRelations;
    }

    public List<GrPath> getPaths(JcPath path) {
        String colKey = ValueAccess.getName(path);
        List<GrPath> rPaths = this.getPathColumns().get(colKey);
        if (rPaths == null) {
            rPaths = new ArrayList<GrPath>();
            Iterator<AContentHandler.RowOrRecord> it = this.contentHandler.getDataIterator();
            int rowIdx = -1;
            while (it.hasNext()) {
                ++rowIdx;
                AContentHandler.RowOrRecord roc = it.next();
                PathInfo pinfo = roc.getPathInfo(colKey);
                if (pinfo != null) {
                    int sz = pinfo.relationIds.size();
                    ArrayList<GrId> relIds = new ArrayList<GrId>(sz);
                    long eid = pinfo.startNodeId;
                    for (int i = 0; i < sz; ++i) {
                        long rid = (Long)pinfo.relationIds.get(i);
                        GrRelation rRelation = this.getRelationsById().get(rid);
                        if (rRelation == null) {
                            long sid = eid;
                            eid = roc.gePathtNodeIdAt(pinfo, i + 1);
                            rRelation = GrAccess.createRelation(this, new GrId(rid), new GrId(sid), new GrId(eid), rowIdx);
                            GrAccess.setState(rRelation, SyncState.SYNC);
                            GrAccess.addChangeListener(this.getNodeRelationListener(), rRelation);
                            this.getRelationsById().put(rid, rRelation);
                        }
                        relIds.add(new GrId(rid));
                    }
                    GrPath rPath = GrAccess.createPath(this, new GrId(pinfo.startNodeId), new GrId(pinfo.endNodeId), relIds, rowIdx);
                    rPaths.add(rPath);
                    continue;
                }
                if (!ResultSettings.includeNullValuesAndDuplicates.get().booleanValue()) continue;
                rPaths.add(null);
            }
            this.getPathColumns().put(colKey, rPaths);
        }
        return Collections.unmodifiableList(rPaths);
    }

    public List<BigDecimal> getNumbers(JcNumber number) {
        return this.getValues(number);
    }

    public List<String> getStrings(JcString string) {
        return this.getValues(string);
    }

    public List<Boolean> getBooleans(JcBoolean bool) {
        return this.getValues(bool);
    }

    public List<List<?>> getCollections(JcCollection collection) {
        return this.getValues(collection);
    }

    public List<?> getObjects(JcValue val) {
        return this.getValues(val);
    }

    public GrNode getNode(GrId id, int rowIdx) {
        if (id instanceof LocalId) {
            return this.getLocalNode(id.getId());
        }
        return this.getNode(id.getId(), rowIdx);
    }

    private GrNode getLocalNode(long id) {
        return this.localElements.getNode(id);
    }

    private GrNode getNode(long id, int rowIdx) {
        GrNode rNode = this.getNodesById().get(id);
        if (rNode == null && this.getUnresolvedColumns().size() > 0) {
            ArrayList<String> ucols = new ArrayList<String>();
            ucols.addAll(this.getUnresolvedColumns());
            for (int i = 0; i < ucols.size(); ++i) {
                String colKey = (String)ucols.get(i);
                Iterator<AContentHandler.RowOrRecord> it = this.contentHandler.getDataIterator();
                boolean isNodeColumn = false;
                if (it.hasNext()) {
                    AContentHandler.RowOrRecord roc = it.next();
                    ElementInfo ei = roc.getElementInfo(colKey);
                    if (ei != null && !ei.isNull) {
                        if (ElemType.NODE == ei.type) {
                            isNodeColumn = true;
                        }
                    } else {
                        this.getUnresolvedColumns().remove(colKey);
                    }
                }
                if (!isNodeColumn) continue;
                this.getNodes(colKey);
                rNode = this.getNodesById().get(id);
                if (rNode == null) continue;
                return rNode;
            }
        }
        if (rNode == null) {
            rNode = GrAccess.createNode(this, new GrId(id), rowIdx);
            GrAccess.setState(rNode, SyncState.SYNC);
            GrAccess.addChangeListener(this.getNodeRelationListener(), rNode);
            this.getNodesById().put(id, rNode);
        }
        return rNode;
    }

    public GrRelation getRelation(GrId id) {
        if (id instanceof LocalId) {
            return this.getLocalRelation(id.getId());
        }
        return this.getRelationsById().get(id.getId());
    }

    private GrRelation getLocalRelation(long id) {
        return this.localElements.getRelation(id);
    }

    public String getRelationType(long relationId, int rowIndex) {
        return this.contentHandler.getRelationType(relationId, rowIndex);
    }

    public List<GrProperty> getNodeProperties(GrId nodeId, int rowIndex) {
        if (nodeId instanceof LocalId) {
            return new ArrayList<GrProperty>();
        }
        return this.getNodeProperties(nodeId.getId(), rowIndex);
    }

    private List<GrProperty> getNodeProperties(long nodeId, int rowIndex) {
        ArrayList<GrProperty> props = new ArrayList<GrProperty>();
        Iterator<AContentHandler.PropEntry> esIt = this.contentHandler.getPropertiesIterator(nodeId, rowIndex, ElemType.NODE);
        while (esIt.hasNext()) {
            AContentHandler.PropEntry entry = esIt.next();
            GrProperty prop = GrAccess.createProperty(entry.getPropName());
            prop.setValue(this.contentHandler.convertContentValue(entry.getPropValue()));
            GrAccess.setState(prop, SyncState.SYNC);
            props.add(prop);
        }
        return props;
    }

    public List<GrLabel> getNodeLabels(long nodeId, int rowIndex) {
        return this.contentHandler.getNodeLabels(nodeId, rowIndex);
    }

    public List<GrProperty> getRelationProperties(GrId relationId, int rowIndex) {
        if (relationId instanceof LocalId) {
            return new ArrayList<GrProperty>();
        }
        return this.getRelationProperties(relationId.getId(), rowIndex);
    }

    private List<GrProperty> getRelationProperties(long relationId, int rowIndex) {
        ArrayList<GrProperty> props = new ArrayList<GrProperty>();
        Iterator<AContentHandler.PropEntry> esIt = this.contentHandler.getPropertiesIterator(relationId, rowIndex, ElemType.RELATION);
        while (esIt.hasNext()) {
            AContentHandler.PropEntry entry = esIt.next();
            GrProperty prop = GrAccess.createProperty(entry.getPropName());
            prop.setValue(this.contentHandler.convertContentValue(entry.getPropValue()));
            GrAccess.setState(prop, SyncState.SYNC);
            props.add(prop);
        }
        return props;
    }

    private <T> List<T> getValues(JcValue jcValue) {
        String colKey;
        if (jcValue instanceof JcProperty) {
            WriterContext ctxt = new WriterContext();
            ValueWriter.toValueExpression(jcValue, ctxt, ctxt.buffer);
            colKey = ctxt.buffer.toString();
        } else {
            colKey = ValueAccess.getName(jcValue);
        }
        ArrayList vals = this.getValueColumns().get(colKey);
        if (vals == null) {
            vals = new ArrayList();
            Iterator<AContentHandler.RowOrRecord> it = this.contentHandler.getDataIterator();
            while (it.hasNext()) {
                AContentHandler.RowOrRecord roc = it.next();
                roc.addValue(colKey, vals);
            }
            this.getValueColumns().put(colKey, vals);
            this.getUnresolvedColumns().remove(colKey);
        }
        return vals;
    }

    private Map<String, List<GrNode>> getNodeColumns() {
        if (this.nodeColumns == null) {
            this.nodeColumns = new HashMap<String, List<GrNode>>();
        }
        return this.nodeColumns;
    }

    private Map<String, List<GrRelation>> getRelationColumns() {
        if (this.relationColumns == null) {
            this.relationColumns = new HashMap<String, List<GrRelation>>();
        }
        return this.relationColumns;
    }

    private Map<String, List<GrPath>> getPathColumns() {
        if (this.pathColumns == null) {
            this.pathColumns = new HashMap<String, List<GrPath>>();
        }
        return this.pathColumns;
    }

    private Map<String, List> getValueColumns() {
        if (this.valueColumns == null) {
            this.valueColumns = new HashMap<String, List>();
        }
        return this.valueColumns;
    }

    private Map<Long, GrNode> getNodesById() {
        if (this.nodesById == null) {
            this.nodesById = new HashMap<Long, GrNode>();
        }
        return this.nodesById;
    }

    private Map<Long, GrRelation> getRelationsById() {
        if (this.relationsById == null) {
            this.relationsById = new HashMap<Long, GrRelation>();
        }
        return this.relationsById;
    }

    private List<String> getUnresolvedColumns() {
        if (this.unResolvedColumns == null) {
            this.unResolvedColumns = new ArrayList<String>();
            this.unResolvedColumns.addAll(this.contentHandler.getColumns());
        }
        return this.unResolvedColumns;
    }

    private NodeRelationListener getNodeRelationListener() {
        if (this.nodeRelationListener == null) {
            this.nodeRelationListener = new NodeRelationListener();
        }
        return this.nodeRelationListener;
    }

    public List<JcError> store(Map<Long, Integer> elementVersionsMap) {
        HashMap<GrNode, JcNumber> createdNodeToIdMap = new HashMap<GrNode, JcNumber>();
        HashMap<GrRelation, JcNumber> createdRelationToIdMap = new HashMap<GrRelation, JcNumber>();
        List<ElemId2Query> elemIds2Query = this.createUpdateQueries(createdNodeToIdMap, createdRelationToIdMap, elementVersionsMap);
        HashMap<Long, Integer> elemId2ResultIndex = new HashMap<Long, Integer>();
        List<JcQuery> queries = this.collectQueries(elemIds2Query, elemId2ResultIndex);
        Util.printQueries(queries, QueriesPrintObserver.QueryToObserve.UPDATE_QUERY, Format.PRETTY_1);
        ArrayList<JcError> errors = new ArrayList<JcError>();
        if (queries.size() > 0) {
            List<JcQueryResult> results = this.dbAccess.execute(queries);
            errors.addAll(Util.collectErrors(results));
            if (errors.isEmpty()) {
                JcError error = this.checkLockingError(results, !createdNodeToIdMap.isEmpty() || !createdRelationToIdMap.isEmpty(), elemIds2Query);
                if (error != null) {
                    errors.add(error);
                    ITransaction tx = this.dbAccess.getTX();
                    if (tx != null) {
                        tx.failure();
                    }
                }
                this.handleSyncState(results, createdNodeToIdMap, createdRelationToIdMap, error != null, elemId2ResultIndex);
            }
        }
        return errors;
    }

    private List<JcQuery> collectQueries(List<ElemId2Query> elemIds2Query, Map<Long, Integer> elemId2ResultIndex) {
        ArrayList<JcQuery> ret = new ArrayList<JcQuery>(elemIds2Query.size());
        for (ElemId2Query e2q : elemIds2Query) {
            ret.add(e2q.query);
            if (e2q.elemId < 0L) continue;
            elemId2ResultIndex.put(e2q.elemId, e2q.queryIndex);
        }
        return ret;
    }

    private List<ElemId2Query> createUpdateQueries(Map<GrNode, JcNumber> createdNodeToIdMap, Map<GrRelation, JcNumber> createdRelationToIdMap, Map<Long, Integer> elementVersionsMap) {
        QueryBuilder queryBuilder = new QueryBuilder();
        List<ElemId2Query> elemIds2Query = queryBuilder.buildUpdateAndRemoveQueries(elementVersionsMap);
        JcQuery createQuery = queryBuilder.buildCreateQuery(createdNodeToIdMap, createdRelationToIdMap);
        if (createQuery != null) {
            elemIds2Query.add(new ElemId2Query(-1L, elemIds2Query.size(), createQuery));
        }
        return elemIds2Query;
    }

    private JcError checkLockingError(List<JcQueryResult> results, boolean hasCreateQuery, List<ElemId2Query> elemIds2Query) {
        JcError error = null;
        if (this.lockingStrategy == Locking.OPTIMISTIC) {
            JcNumber lockV = new JcNumber("lockV");
            JcNumber nSum = new JcNumber("sum");
            int to = hasCreateQuery ? results.size() - 1 : results.size();
            for (int i = 0; i < to; ++i) {
                List<BigDecimal> ires;
                ElemId2Query elemId2Query = elemIds2Query.get(i);
                if (elemId2Query.versionSum >= 0 && elemId2Query.elemId < 0L) {
                    ires = results.get(i).resultOf(nSum);
                    if (ires.size() > 0) {
                        if (((Number)ires.get(0)).intValue() == elemId2Query.versionSum) continue;
                        error = new JcError("JCypher.Locking", "Optimistic locking failed (an element was changed by another client)", null);
                        break;
                    }
                    error = new JcError("JCypher.Locking", "Optimistic locking failed (an element was deleted by another client)", null);
                    break;
                }
                ires = results.get(i).resultOf(lockV);
                if (ires.size() > 0) {
                    int res = ires.get(0).intValue();
                    if (res != -2) continue;
                    error = new JcError("JCypher.Locking", "Optimistic locking failed (an element was changed by another client)", "element id: " + elemId2Query.elemId);
                    break;
                }
                error = new JcError("JCypher.Locking", "Optimistic locking failed (an element was deleted by another client)", "element id: " + elemId2Query.elemId);
                break;
            }
        }
        return error;
    }

    private void handleSyncState(List<JcQueryResult> results, Map<GrNode, JcNumber> createdNodeToIdMap, Map<GrRelation, JcNumber> createdRelationToIdMap, boolean hasErrors, Map<Long, Integer> elemId2ResultIndex) {
        ArrayList<Long> toRemove = new ArrayList<Long>();
        for (Map.Entry<Long, GrNode> entry : this.getNodesById().entrySet()) {
            Integer n = elemId2ResultIndex.get(entry.getKey());
            this.checkRemovedSetSynchronized(toRemove, entry.getValue(), entry.getKey(), hasErrors, n != null ? results.get(n) : null);
        }
        for (Long l : toRemove) {
            this.getNodesById().remove(l);
        }
        this.changedNodesById = null;
        toRemove.clear();
        for (Map.Entry<Long, GrRelation> entry : this.getRelationsById().entrySet()) {
            Integer idx = elemId2ResultIndex.get(entry.getKey());
            this.checkRemovedSetSynchronized(toRemove, entry.getValue(), entry.getKey(), hasErrors, idx != null ? results.get(idx) : null);
        }
        for (Long id : toRemove) {
            this.getRelationsById().remove(id);
        }
        this.elementVersions = null;
        this.changedRelationsById = null;
        JcQueryResult jcQueryResult = results.get(results.size() - 1);
        for (Map.Entry<GrNode, JcNumber> entry : createdNodeToIdMap.entrySet()) {
            long id = this.exchangeGrId(entry.getKey(), entry.getValue(), jcQueryResult);
            GrAccess.setToSynchronized(entry.getKey());
            this.getNodesById().put(id, entry.getKey());
        }
        for (Map.Entry<GrRelation, JcNumber> entry : createdRelationToIdMap.entrySet()) {
            long id = this.exchangeGrId(entry.getKey(), entry.getValue(), jcQueryResult);
            GrAccess.setToSynchronized(entry.getKey());
            this.getRelationsById().put(id, entry.getKey());
        }
        this.localElements.clear();
        GrAccess.setGraphState(this.getGraph(), SyncState.SYNC);
    }

    private void checkRemovedSetSynchronized(List<Long> toRemove, PersistableItem item, Long id, boolean hasErrors, JcQueryResult qResult) {
        if (hasErrors) {
            Integer v;
            if (this.elementVersions != null && (v = item instanceof GrNode ? (Integer)this.elementVersions.nodeVersions.get(item) : (Integer)this.elementVersions.relationVersions.get(item)) != null) {
                GrProperty vprop = ((GrPropertyContainer)item).getProperty(lockVersionProperty);
                if (v == -1) {
                    vprop.remove();
                } else {
                    vprop.setValue(v);
                    GrAccess.setToSynchronized(vprop);
                }
            }
        } else {
            if (writeVersion && this.lockingStrategy != Locking.OPTIMISTIC && qResult != null) {
                JcNumber lockV = new JcNumber("lockV");
                GrProperty vprop = ((GrPropertyContainer)item).getProperty(lockVersionProperty);
                List<BigDecimal> lvr = qResult.resultOf(lockV);
                if (lvr.size() > 0) {
                    int ov;
                    int v = ((Number)lvr.get(0)).intValue();
                    if (v != (ov = ((Number)vprop.getValue()).intValue())) {
                        vprop.setValue(v);
                        GrAccess.setToSynchronized(vprop);
                    }
                } else {
                    vprop.setValue(((Number)vprop.getValue()).intValue() - 1);
                    GrAccess.setToSynchronized(vprop);
                }
            }
            if (GrAccess.getState(item) == SyncState.REMOVED) {
                toRemove.add(id);
            } else if (GrAccess.getState(item) != SyncState.SYNC) {
                GrAccess.setToSynchronized(item);
            }
        }
    }

    private long exchangeGrId(GrPropertyContainer pc, JcNumber jcId, JcQueryResult createResult) {
        List<BigDecimal> bdIds = createResult.resultOf(jcId);
        long id = bdIds.get(0).longValue();
        GrId grId = new GrId(id);
        GrAccess.setGrId(grId, pc);
        return id;
    }

    public void setDbAccess(IDBAccess dbAccess) {
        this.dbAccess = dbAccess;
    }

    public static abstract class AContentHandler {
        public abstract List<String> getColumns();

        public abstract int getColumnIndex(String var1);

        public abstract Iterator<RowOrRecord> getDataIterator();

        public abstract Object convertContentValue(Object var1);

        public abstract Iterator<PropEntry> getPropertiesIterator(long var1, int var3, ElemType var4);

        public abstract String getRelationType(long var1, int var3);

        public abstract List<GrLabel> getNodeLabels(long var1, int var3);

        public abstract class RowOrRecord {
            public abstract ElementInfo getElementInfo(String var1);

            public abstract RelationInfo getRelationInfo(String var1);

            public abstract PathInfo getPathInfo(String var1);

            public abstract long gePathtNodeIdAt(PathInfo var1, int var2);

            public abstract <T> void addValue(String var1, List<T> var2);
        }

        public static class PropEntry {
            private String propName;
            private Object propValue;

            public PropEntry(String propName, Object propValue) {
                this.propName = propName;
                this.propValue = propValue;
            }

            public String getPropName() {
                return this.propName;
            }

            public Object getPropValue() {
                return this.propValue;
            }
        }
    }

    public class LocalElements {
        private LocalIdBuilder nodeIdBuilder;
        private LocalIdBuilder relationIdBuilder;
        private Map<Long, GrNode> localNodesById;
        private Map<Long, GrRelation> localRelationsById;

        public GrNode createNode() {
            if (this.nodeIdBuilder == null) {
                this.nodeIdBuilder = new LocalIdBuilder();
            }
            LocalId lid = new LocalId(this.nodeIdBuilder.getId());
            GrNode node = GrAccess.createNode(ResultHandler.this, lid, -1);
            if (this.localNodesById == null) {
                this.localNodesById = new HashMap<Long, GrNode>();
            }
            GrAccess.addChangeListener(ResultHandler.this.getNodeRelationListener(), node);
            this.localNodesById.put(lid.getId(), node);
            GrAccess.notifyState(node);
            return node;
        }

        public GrRelation createRelation(String type, GrNode startNode, GrNode endNode) {
            if (this.relationIdBuilder == null) {
                this.relationIdBuilder = new LocalIdBuilder();
            }
            LocalId lid = new LocalId(this.relationIdBuilder.getId());
            GrRelation relation = GrAccess.createRelation(ResultHandler.this, (GrId)lid, GrAccess.getGrId(startNode), GrAccess.getGrId(endNode), type);
            if (this.localRelationsById == null) {
                this.localRelationsById = new HashMap<Long, GrRelation>();
            }
            GrAccess.addChangeListener(ResultHandler.this.getNodeRelationListener(), relation);
            this.localRelationsById.put(lid.getId(), relation);
            GrAccess.notifyState(relation);
            return relation;
        }

        private GrNode getNode(long id) {
            if (this.localNodesById != null) {
                return this.localNodesById.get(id);
            }
            return null;
        }

        private GrRelation getRelation(long id) {
            if (this.localRelationsById != null) {
                return this.localRelationsById.get(id);
            }
            return null;
        }

        private void removeNode(long id) {
            if (this.localNodesById != null) {
                this.localNodesById.remove(id);
            }
        }

        private void removeRelation(long id) {
            if (this.localRelationsById != null) {
                this.localRelationsById.remove(id);
            }
        }

        private List<GrNode> getLocalNodes() {
            ArrayList<GrNode> ret = new ArrayList<GrNode>();
            if (this.localNodesById != null) {
                for (GrNode node : this.localNodesById.values()) {
                    ret.add(node);
                }
            }
            return ret;
        }

        private List<GrRelation> getLocalRelations() {
            ArrayList<GrRelation> ret = new ArrayList<GrRelation>();
            if (this.localRelationsById != null) {
                for (GrRelation relation : this.localRelationsById.values()) {
                    ret.add(relation);
                }
            }
            return ret;
        }

        private void clear() {
            this.nodeIdBuilder = null;
            this.localNodesById = null;
            this.relationIdBuilder = null;
            this.localRelationsById = null;
        }

        public boolean isEmpty() {
            return !(this.localNodesById != null && this.localNodesById.size() != 0 || this.localRelationsById != null && this.localRelationsById.size() != 0);
        }
    }

    private class ElemId2Query {
        private long elemId;
        private int queryIndex;
        private int versionSum;
        private JcQuery query;

        private ElemId2Query(long elemId, int queryIndex, JcQuery query) {
            this.elemId = elemId;
            this.queryIndex = queryIndex;
            this.query = query;
            this.versionSum = -1;
        }
    }

    private class ElementVersions {
        private Map<GrPropertyContainer, Integer> nodeVersions = new HashMap<GrPropertyContainer, Integer>();
        private Map<GrPropertyContainer, Integer> relationVersions = new HashMap<GrPropertyContainer, Integer>();

        private ElementVersions() {
        }
    }

    private class QueryBuilder {
        private QueryBuilder() {
        }

        JcQuery buildCreateQuery(Map<GrNode, JcNumber> createdNodeToIdMap, Map<GrRelation, JcNumber> createdRelationToIdMap) {
            ArrayList<GrNode2JcNode> nodesToCreate = new ArrayList<GrNode2JcNode>();
            ArrayList<IClause> createNodeClauses = new ArrayList<IClause>();
            HashMap<GrNode, JcNode> localNodeMap = new HashMap<GrNode, JcNode>();
            for (GrNode node : ResultHandler.this.localElements.getLocalNodes()) {
                this.addCreateNodeClause(node, createNodeClauses, localNodeMap, nodesToCreate);
            }
            ArrayList<GrRelation2JcRelation> relationsToCreate = new ArrayList<GrRelation2JcRelation>();
            ArrayList<IClause> startNodeClauses = new ArrayList<IClause>();
            ArrayList<IClause> createRelationClauses = new ArrayList<IClause>();
            HashMap<GrNode, JcNode> dbNodeMap = new HashMap<GrNode, JcNode>();
            for (Iterator relation : ResultHandler.this.localElements.getLocalRelations()) {
                this.addCreateRelationClause((GrRelation)((Object)relation), createRelationClauses, localNodeMap, dbNodeMap, startNodeClauses, relationsToCreate);
            }
            ArrayList<IClause> clauses = startNodeClauses;
            clauses.addAll(createNodeClauses);
            clauses.addAll(createRelationClauses);
            for (GrNode2JcNode grn2jcn : nodesToCreate) {
                JcNumber nid = new JcNumber("NID_".concat(ValueAccess.getName(grn2jcn.jcNode)));
                createdNodeToIdMap.put(grn2jcn.grNode, nid);
                clauses.add((IClause)RETURN.value(grn2jcn.jcNode.id()).AS(nid));
            }
            for (GrRelation2JcRelation grr2jcr : relationsToCreate) {
                JcNumber rid = new JcNumber("RID_".concat(ValueAccess.getName(grr2jcr.jcRelation)));
                createdRelationToIdMap.put(grr2jcr.grRelation, rid);
                clauses.add((IClause)RETURN.value(grr2jcr.jcRelation.id()).AS(rid));
            }
            JcQuery ret = null;
            if (clauses.size() > 0) {
                IClause[] clausesArray = clauses.toArray(new IClause[clauses.size()]);
                ret = new JcQuery();
                ret.setClauses(clausesArray);
            }
            return ret;
        }

        List<ElemId2Query> buildUpdateAndRemoveQueries(Map<Long, Integer> elementVersionsMap) {
            ElemId2Query elemId2Query;
            ArrayList<ElemId2Query> ret = new ArrayList<ElemId2Query>();
            ArrayList<GrPropertyContainer> removedNodes = new ArrayList<GrPropertyContainer>();
            if (ResultHandler.this.changedNodesById != null) {
                for (GrNode node : ResultHandler.this.changedNodesById.values()) {
                    SyncState state = GrAccess.getState(node);
                    if (state == SyncState.CHANGED) {
                        ret.add(new ElemId2Query(node.getId(), ret.size(), this.buildChangedNodeOrRelationQuery(node, elementVersionsMap)));
                        continue;
                    }
                    if (state != SyncState.REMOVED) continue;
                    removedNodes.add(node);
                }
            }
            ArrayList<GrPropertyContainer> removedRelations = new ArrayList<GrPropertyContainer>();
            if (ResultHandler.this.changedRelationsById != null) {
                for (GrRelation relation : ResultHandler.this.changedRelationsById.values()) {
                    SyncState state = GrAccess.getState(relation);
                    if (state == SyncState.CHANGED) {
                        ret.add(new ElemId2Query(relation.getId(), ret.size(), this.buildChangedNodeOrRelationQuery(relation, elementVersionsMap)));
                        continue;
                    }
                    if (state != SyncState.REMOVED) continue;
                    removedRelations.add(relation);
                }
            }
            if (removedRelations.size() > 0) {
                elemId2Query = new ElemId2Query(-1L, ret.size(), null);
                this.buildRemovedNodeOrRelationQuery(removedRelations, elemId2Query);
                ret.add(elemId2Query);
            }
            if (removedNodes.size() > 0) {
                elemId2Query = new ElemId2Query(-1L, ret.size(), null);
                this.buildRemovedNodeOrRelationQuery(removedNodes, elemId2Query);
                ret.add(elemId2Query);
            }
            return ret;
        }

        private void addCreateNodeClause(GrNode node, List<IClause> clauses, Map<GrNode, JcNode> localNodeMap, List<GrNode2JcNode> nodesToCreate) {
            String nm = "ln_".concat(String.valueOf(clauses.size()));
            JcNode n = new JcNode(nm);
            nodesToCreate.add(new GrNode2JcNode(node, n));
            Node create = CREATE.node(n);
            for (GrLabel label : node.getLabels()) {
                create = create.label(label.getName());
            }
            for (GrProperty prop : node.getProperties()) {
                create = (Node)create.property(prop.getName()).value(prop.getValue());
            }
            if (writeVersion || ResultHandler.this.lockingStrategy == Locking.OPTIMISTIC) {
                create = (Node)create.property(ResultHandler.lockVersionProperty).value(0);
            }
            clauses.add(create);
            localNodeMap.put(node, n);
        }

        private void addCreateRelationClause(GrRelation relation, List<IClause> createRelationClauses, Map<GrNode, JcNode> localNodeMap, Map<GrNode, JcNode> dbNodeMap, List<IClause> startNodeClauses, List<GrRelation2JcRelation> relationsToCreate) {
            String nm = "lr_".concat(String.valueOf(createRelationClauses.size()));
            JcRelation r = new JcRelation(nm);
            relationsToCreate.add(new GrRelation2JcRelation(relation, r));
            GrNode sNode = relation.getStartNode();
            GrNode eNode = relation.getEndNode();
            JcNode sn = this.getNode(sNode, localNodeMap, dbNodeMap, startNodeClauses);
            JcNode en = this.getNode(eNode, localNodeMap, dbNodeMap, startNodeClauses);
            Relation create = CREATE.node(sn).relation(r).out();
            if (relation.getType() != null) {
                create = create.type(relation.getType());
            }
            for (GrProperty prop : relation.getProperties()) {
                create = (Relation)create.property(prop.getName()).value(prop.getValue());
            }
            if (writeVersion || ResultHandler.this.lockingStrategy == Locking.OPTIMISTIC) {
                create = (Relation)create.property(ResultHandler.lockVersionProperty).value(0);
            }
            createRelationClauses.add(create.node(en));
        }

        private JcNode getNode(GrNode grNode, Map<GrNode, JcNode> localNodeMap, Map<GrNode, JcNode> dbNodeMap, List<IClause> startNodeClauses) {
            JcNode n;
            GrId grId = GrAccess.getGrId(grNode);
            if (grId instanceof LocalId) {
                n = localNodeMap.get(grNode);
            } else {
                n = dbNodeMap.get(grNode);
                if (n == null) {
                    String nm = "rn_".concat(String.valueOf(startNodeClauses.size()));
                    n = new JcNode(nm);
                    StartPoint start = START.node(n).byId(grId.getId());
                    startNodeClauses.add(start);
                    dbNodeMap.put(grNode, n);
                }
            }
            return n;
        }

        private void buildRemovedNodeOrRelationQuery(List<GrPropertyContainer> elements, ElemId2Query elemId2Query) {
            ArrayList<Object> clauses = new ArrayList<Object>();
            ArrayList<ModifyTerminal> removeClauses = new ArrayList<ModifyTerminal>();
            ArrayList<String> elemNames = new ArrayList<String>(elements.size());
            for (int i = 0; i < elements.size(); ++i) {
                Object elem;
                String nm = "elem_".concat(String.valueOf(i));
                elemNames.add(nm);
                if (elements.get(0) instanceof GrNode) {
                    elem = new JcNode(nm);
                    clauses.add(OPTIONAL_MATCH.node((JcNode)elem));
                    clauses.add(WHERE.valueOf(((JcElement)elem).id()).EQUALS(elements.get(i).getId()));
                    continue;
                }
                if (!(elements.get(0) instanceof GrRelation)) continue;
                elem = new JcRelation(nm);
                clauses.add(OPTIONAL_MATCH.node().relation((JcRelation)elem).out().node());
                clauses.add(WHERE.valueOf(((JcElement)elem).id()).EQUALS(elements.get(i).getId()));
            }
            LockUtil.Removes removes = new LockUtil.Removes();
            int idx = 0;
            for (String nm : elemNames) {
                JcElement elem = null;
                if (elements.get(0) instanceof GrNode) {
                    elem = new JcNode(nm);
                } else if (elements.get(0) instanceof GrRelation) {
                    elem = new JcRelation(nm);
                }
                int nodeVersion = -1;
                GrProperty prop = elements.get(idx).getProperty(ResultHandler.lockVersionProperty);
                if (prop != null) {
                    nodeVersion = ((Number)prop.getValue()).intValue();
                }
                if (ResultHandler.this.lockingStrategy == Locking.OPTIMISTIC) {
                    LockUtil.calcRemoves(removes, elem, nodeVersion);
                }
                removeClauses.add(DO.DELETE(elem));
                ++idx;
            }
            if (removes.getWithClauses() != null) {
                JcNumber nSum = new JcNumber("sum");
                removes.getWithClauses().add((IClause)WITH.value(removes.getSum()).AS(nSum));
                clauses.addAll(removes.getWithClauses());
                JcValue x = new JcValue("x");
                DoConcat clause = ((EachDoConcat)FOR_EACH.element(x).IN(C.CREATE(new IClause[]{CASE.result(), WHEN.valueOf(nSum).EQUALS(removes.getVersionSum()), NATIVE.cypher("[1]"), ELSE.perform(), NATIVE.cypher("[]"), END.caseXpr()}))).DO(removeClauses.toArray(new IClause[removeClauses.size()]));
                clauses.add(clause);
                clauses.add(RETURN.value(nSum));
            } else {
                clauses.addAll(removeClauses);
            }
            IClause[] clausesArray = clauses.toArray(new IClause[clauses.size()]);
            JcQuery query = new JcQuery();
            query.setClauses(clausesArray);
            elemId2Query.versionSum = removes.getVersionSum();
            elemId2Query.query = query;
        }

        private JcQuery buildChangedNodeOrRelationQuery(GrPropertyContainer element, Map<Long, Integer> elementVersionsMap) {
            IClause[] clausesArray;
            int nodeVersion = -1;
            if (elementVersionsMap != null) {
                Integer v = elementVersionsMap.get(element.getId());
                if (v != null) {
                    nodeVersion = v;
                }
            } else {
                GrProperty prop = element.getProperty(ResultHandler.lockVersionProperty);
                if (prop != null) {
                    nodeVersion = ((Number)prop.getValue()).intValue();
                }
            }
            this.handleVersionProperty(element, nodeVersion);
            ArrayList<IClause> clauses = new ArrayList<IClause>();
            JcElement elem = null;
            if (element instanceof GrNode) {
                elem = new JcNode("elem");
            } else if (element instanceof GrRelation) {
                elem = new JcRelation("elem");
            }
            List<IClause> startClause = this.buildStartClause(element);
            clauses.addAll(this.buildChangedPropertiesClauses(element));
            if (writeVersion || ResultHandler.this.lockingStrategy == Locking.OPTIMISTIC) {
                clauses.add(DO.SET(elem.property(ResultHandler.lockVersionProperty)).byExpression(elem.numberProperty(ResultHandler.lockVersionProperty).plus(1)));
            }
            clauses.addAll(this.buildChangedLabelsClauses(element));
            JcNumber lockV = new JcNumber("lockV");
            if (ResultHandler.this.lockingStrategy == Locking.OPTIMISTIC && nodeVersion >= 0) {
                clausesArray = clauses.toArray(new IClause[clauses.size()]);
                clauses.clear();
                clauses.addAll(startClause);
                JcValue x = new JcValue("x");
                IClause clause = ((EachDoConcat)FOR_EACH.element(x).IN(C.CREATE(new IClause[]{CASE.result(), WHEN.valueOf(elem.property(ResultHandler.lockVersionProperty)).NOT_EQUALS(nodeVersion), NATIVE.cypher("[1]"), ELSE.perform(), NATIVE.cypher("[]"), END.caseXpr()}))).DO().SET(elem.property(ResultHandler.lockVersionProperty)).to(-2);
                clauses.add(clause);
                clause = ((EachDoConcat)FOR_EACH.element(x).IN(C.CREATE(new IClause[]{CASE.result(), WHEN.valueOf(elem.property(ResultHandler.lockVersionProperty)).EQUALS(nodeVersion), NATIVE.cypher("[1]"), ELSE.perform(), NATIVE.cypher("[]"), END.caseXpr()}))).DO(clausesArray);
                clauses.add(clause);
            } else {
                clauses.addAll(0, startClause);
            }
            if (writeVersion || ResultHandler.this.lockingStrategy == Locking.OPTIMISTIC) {
                JcNumber elemId = new JcNumber("elemId");
                clauses.add((IClause)RETURN.value(elem.property(ResultHandler.lockVersionProperty)).AS(lockV));
                clauses.add((IClause)RETURN.value(elem.id()).AS(elemId));
            }
            clausesArray = clauses.toArray(new IClause[clauses.size()]);
            JcQuery query = new JcQuery();
            query.setClauses(clausesArray);
            return query;
        }

        private Collection<? extends IClause> buildChangedLabelsClauses(GrPropertyContainer element) {
            ArrayList<ModifyTerminal> ret = new ArrayList<ModifyTerminal>();
            if (element instanceof GrNode) {
                GrNode node = (GrNode)element;
                List<GrLabel> modified = GrAccess.getModifiedLabels(node);
                for (GrLabel lab : modified) {
                    SyncState state = GrAccess.getState(lab);
                    JcNode elem = new JcNode("elem");
                    ModifyTerminal c = null;
                    if (state == SyncState.NEW) {
                        c = DO.SET(elem.label(lab.getName()));
                    } else if (state == SyncState.REMOVED) {
                        c = DO.REMOVE(elem.label(lab.getName()));
                    }
                    ret.add(c);
                }
            }
            return ret;
        }

        private Collection<? extends IClause> buildChangedPropertiesClauses(GrPropertyContainer element) {
            ArrayList<ModifyTerminal> ret = new ArrayList<ModifyTerminal>();
            List<GrProperty> modified = GrAccess.getModifiedProperties(element);
            for (GrProperty prop : modified) {
                if (prop.getName().equals(ResultHandler.lockVersionProperty)) continue;
                SyncState state = GrAccess.getState(prop);
                JcElement elem = null;
                elem = element instanceof GrNode ? new JcNode("elem") : new JcRelation("elem");
                IClause c = null;
                if (state == SyncState.CHANGED || state == SyncState.NEW) {
                    Object propValue = prop.getValue();
                    c = propValue != null ? (IClause)DO.SET(elem.property(prop.getName())).to(prop.getValue()) : DO.SET(elem.property(prop.getName())).toNull();
                } else if (state == SyncState.REMOVED) {
                    c = DO.REMOVE(elem.property(prop.getName()));
                }
                ret.add((ModifyTerminal)c);
            }
            return ret;
        }

        private List<IClause> buildStartClause(GrPropertyContainer element) {
            JcElement elem;
            ArrayList<IClause> ret = new ArrayList<IClause>();
            if (element instanceof GrNode) {
                elem = new JcNode("elem");
                ret.add(OPTIONAL_MATCH.node((JcNode)elem));
            } else {
                elem = new JcRelation("elem");
                ret.add(OPTIONAL_MATCH.node().relation((JcRelation)elem).out().node());
            }
            ret.add(WHERE.valueOf(elem.id()).EQUALS(element.getId()));
            return ret;
        }

        private void handleVersionProperty(GrPropertyContainer element, int curVersion) {
            if (writeVersion || ResultHandler.this.lockingStrategy == Locking.OPTIMISTIC) {
                if (ResultHandler.this.elementVersions == null) {
                    ResultHandler.this.elementVersions = new ElementVersions();
                }
                int oldVersion = curVersion;
                GrProperty prop = element.getProperty(ResultHandler.lockVersionProperty);
                if (prop != null) {
                    prop.setValue(oldVersion + 1);
                } else {
                    prop = element.addProperty(ResultHandler.lockVersionProperty, oldVersion + 1);
                }
                if (element instanceof GrNode) {
                    ResultHandler.this.elementVersions.nodeVersions.put(element, oldVersion);
                } else if (element instanceof GrRelation) {
                    ResultHandler.this.elementVersions.relationVersions.put(element, oldVersion);
                }
            }
        }

        private class GrRelation2JcRelation {
            private GrRelation grRelation;
            private JcRelation jcRelation;

            private GrRelation2JcRelation(GrRelation grRelation, JcRelation jcRelation) {
                this.grRelation = grRelation;
                this.jcRelation = jcRelation;
            }
        }

        private class GrNode2JcNode {
            private GrNode grNode;
            private JcNode jcNode;

            private GrNode2JcNode(GrNode grNode, JcNode jcNode) {
                this.grNode = grNode;
                this.jcNode = jcNode;
            }
        }
    }

    private class NodeRelationListener
    implements ChangeListener {
        private NodeRelationListener() {
        }

        @Override
        public void changed(Object theChanged, SyncState oldState, SyncState newState) {
            boolean possiblyReturnedToSync = false;
            if (newState == SyncState.CHANGED || newState == SyncState.REMOVED) {
                if (theChanged instanceof GrNode) {
                    if (ResultHandler.this.changedNodesById == null) {
                        ResultHandler.this.changedNodesById = new HashMap();
                    }
                    ResultHandler.this.changedNodesById.put(((GrNode)theChanged).getId(), (GrNode)theChanged);
                } else if (theChanged instanceof GrRelation) {
                    if (ResultHandler.this.changedRelationsById == null) {
                        ResultHandler.this.changedRelationsById = new HashMap();
                    }
                    ResultHandler.this.changedRelationsById.put(((GrRelation)theChanged).getId(), (GrRelation)theChanged);
                }
                if (GrAccess.getGraphState(ResultHandler.this.getGraph()) == SyncState.SYNC) {
                    GrAccess.setGraphState(ResultHandler.this.getGraph(), SyncState.CHANGED);
                }
            } else if (newState == SyncState.SYNC) {
                if (theChanged instanceof GrNode) {
                    if (ResultHandler.this.changedNodesById != null) {
                        ResultHandler.this.changedNodesById.remove(((GrNode)theChanged).getId());
                    }
                } else if (theChanged instanceof GrRelation && ResultHandler.this.changedRelationsById != null) {
                    ResultHandler.this.changedRelationsById.remove(((GrRelation)theChanged).getId());
                }
            } else if (newState == SyncState.NEW) {
                if (GrAccess.getGraphState(ResultHandler.this.getGraph()) == SyncState.SYNC) {
                    GrAccess.setGraphState(ResultHandler.this.getGraph(), SyncState.CHANGED);
                }
            } else if (newState == SyncState.NEW_REMOVED) {
                if (theChanged instanceof GrNode) {
                    ResultHandler.this.localElements.removeNode(((GrNode)theChanged).getId());
                } else if (theChanged instanceof GrRelation) {
                    ResultHandler.this.localElements.removeRelation(((GrRelation)theChanged).getId());
                }
            }
            if (!(newState != SyncState.SYNC && newState != SyncState.NEW_REMOVED || ResultHandler.this.changedNodesById != null && ResultHandler.this.changedNodesById.size() != 0 || ResultHandler.this.changedRelationsById != null && ResultHandler.this.changedRelationsById.size() != 0 || !ResultHandler.this.localElements.isEmpty())) {
                possiblyReturnedToSync = true;
            }
            if (possiblyReturnedToSync && GrAccess.getGraphState(ResultHandler.this.getGraph()) == SyncState.CHANGED) {
                GrAccess.setGraphState(ResultHandler.this.getGraph(), SyncState.SYNC);
            }
        }
    }

    public static class PathInfo {
        private long startNodeId;
        private long endNodeId;
        private List<Long> relationIds;
        private Object contentObject;

        public PathInfo(long startNodeId, long endNodeId, List<Long> relationIds, Object userObject) {
            this.startNodeId = startNodeId;
            this.endNodeId = endNodeId;
            this.relationIds = relationIds;
            this.contentObject = userObject;
        }

        public Object getContentObject() {
            return this.contentObject;
        }

        public void setContentObject(Object userObject) {
            this.contentObject = userObject;
        }
    }

    public static class RelationInfo {
        private long startNodeId;
        private long endNodeId;

        public static RelationInfo parse(String startString, String endString) {
            RelationInfo ret = new RelationInfo();
            ret.startNodeId = ret.parseId(startString);
            ret.endNodeId = ret.parseId(endString);
            return ret;
        }

        public static RelationInfo fromRecordValue(Value val) {
            String typName;
            if (val instanceof ListValue) {
                return RelationInfo.fromRecordValue(((ListValue)val).get(0));
            }
            RelationInfo ret = null;
            if (val != null && "RELATIONSHIP".equals(typName = val.type().name())) {
                ret = new RelationInfo();
                ret.startNodeId = val.asRelationship().startNodeId();
                ret.endNodeId = val.asRelationship().endNodeId();
            }
            return ret;
        }

        private long parseId(String str) {
            int lidx = str.lastIndexOf(47);
            return Long.parseLong(str.substring(lidx + 1));
        }
    }

    public static class ElementInfo {
        private long id;
        private ElemType type;
        private boolean isNull;

        public static ElementInfo parse(String selfString) {
            ElementInfo ret = new ElementInfo();
            ret.isNull = false;
            int lidx = selfString.lastIndexOf(47);
            ret.id = Long.parseLong(selfString.substring(lidx + 1));
            String preString = selfString.substring(0, lidx);
            String typeString = (lidx = preString.lastIndexOf(47)) != -1 ? preString.substring(lidx + 1) : preString;
            if ("node".equals(typeString)) {
                ret.type = ElemType.NODE;
            } else if ("relationship".equals(typeString)) {
                ret.type = ElemType.RELATION;
            }
            return ret;
        }

        public static ElementInfo fromRecordValue(Value val) {
            if (val instanceof ListValue) {
                return ElementInfo.fromRecordValue(((ListValue)val).get(0));
            }
            ElementInfo ret = null;
            if (val != null) {
                String typName = val.type().name();
                if ("NODE".equals(typName)) {
                    ret = new ElementInfo();
                    ret.isNull = false;
                    ret.id = val.asNode().id();
                    ret.type = ElemType.NODE;
                } else if ("RELATIONSHIP".equals(typName)) {
                    ret = new ElementInfo();
                    ret.isNull = false;
                    ret.id = val.asRelationship().id();
                    ret.type = ElemType.RELATION;
                } else if ("NULL".equals(typName)) {
                    ret = ElementInfo.nullElement();
                }
            }
            return ret;
        }

        public static ElementInfo nullElement() {
            ElementInfo ret = new ElementInfo();
            ret.isNull = true;
            return ret;
        }
    }

    public static enum ElemType {
        NODE,
        RELATION;

    }
}

