/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.query.writer;

import iot.jcypher.query.JcQueryParameter;
import iot.jcypher.query.writer.IQueryParam;
import iot.jcypher.query.writer.WriterContext;
import java.util.ArrayList;

public class QueryParam
implements IQueryParam {
    private String key;
    private Object value;
    private String orgName;

    public static QueryParam createParam(String name, Object value, WriterContext context) {
        QueryParam qp = new QueryParam();
        if (value instanceof JcQueryParameter) {
            qp.setKey(((JcQueryParameter)value).getName());
            context.doesHaveDSLParams();
        } else {
            qp.setKey(QueryParam.createNewParamKey(context));
        }
        qp.setValue(value);
        qp.setOrgName(name);
        return qp;
    }

    public static QueryParam createAddParam(String name, Object value, WriterContext context) {
        if (context.extractParams) {
            if (context.queryParams == null) {
                context.queryParams = new ArrayList<IQueryParam>();
            }
            QueryParam qp = QueryParam.createParam(name, value, context);
            context.queryParams.add(qp);
            return qp;
        }
        return null;
    }

    public static void setParamIndex(int idx, WriterContext context) {
        context.setParamIndex(idx);
    }

    public static int getParamIndex(WriterContext context) {
        return context.getParamIndex();
    }

    public static boolean isExtractParams(WriterContext context) {
        return context.extractParams;
    }

    public static void setExtractParams(boolean extractParams, WriterContext context) {
        context.extractParams = extractParams;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Object getValue() {
        if (this.value instanceof JcQueryParameter) {
            Object val = ((JcQueryParameter)this.value).getValue();
            if (val == null) {
                val = "NOT_SET";
            }
            return val;
        }
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    private static String createNewParamKey(WriterContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("param_");
        sb.append(context.getNextParamIndex());
        return sb.toString();
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.key);
        sb.append(": ");
        sb.append(this.value);
        sb.append(": ");
        sb.append(this.orgName);
        return sb.toString();
    }
}

