/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.transaction.internal;

import iot.jcypher.database.IDBAccess;
import iot.jcypher.domain.internal.IIntDomainAccess;
import iot.jcypher.transaction.ITransaction;

public abstract class AbstractTransaction
implements ITransaction {
    protected static final String ERR_CLOSED = "transaction has already been closed";
    protected static final String ERR_THREAD = "close() must be called from within the same thread which created this transaction";
    private IDBAccess dbAccess;
    private boolean closed;
    protected boolean failed;
    private IIntDomainAccess intDomainAccess;
    private boolean domainInfoChanged;
    private boolean noInfoNodeId;

    public AbstractTransaction(IDBAccess dbAccess) {
        this.dbAccess = dbAccess;
        this.failed = false;
        this.closed = false;
        this.domainInfoChanged = false;
        this.noInfoNodeId = false;
    }

    @Override
    public void failure() {
        this.failed = true;
    }

    protected IDBAccess getDBAccess() {
        return this.dbAccess;
    }

    protected boolean isMyThread() {
        return this.getDBAccess().getTX() == this;
    }

    protected void setClosed() {
        this.closed = true;
        if (this.intDomainAccess != null) {
            this.intDomainAccess.getInternalDomainAccess().transactionClosed(this.failed, this.domainInfoChanged, this.noInfoNodeId);
        }
        this.intDomainAccess = null;
        this.dbAccess = null;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public void setIntDomainAccess(IIntDomainAccess intDomainAccess) {
        this.intDomainAccess = intDomainAccess;
    }

    public void setDomainInfoChanged() {
        this.domainInfoChanged = true;
    }

    public void setNoInfoNodeId() {
        this.noInfoNodeId = true;
    }
}

