/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.util;

import iot.jcypher.util.MultiOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class QueriesPrintObserver {
    private static MultiOutputStream multiOutputStream = new MultiOutputStream();
    public static final PrintStream printStream = new PrintStream(multiOutputStream);
    private static Map<String, ContentToObserve> enabledQueries;

    public static ContentToObserve contentToObserve(QueryToObserve queryTitle) {
        if (enabledQueries != null) {
            return enabledQueries.get(queryTitle.getTitle());
        }
        return null;
    }

    public static void addToEnabledQueries(QueryToObserve queryTitle, ContentToObserve cto) {
        if (enabledQueries == null) {
            enabledQueries = new HashMap<String, ContentToObserve>();
        }
        enabledQueries.put(queryTitle.getTitle(), cto);
    }

    public static void removeFromEnabledQueries(QueryToObserve queryTitle) {
        if (enabledQueries != null) {
            enabledQueries.remove(queryTitle.getTitle());
        }
    }

    public static void removeAllEnabledQueries() {
        enabledQueries = null;
    }

    public static void addOutputStream(OutputStream out) {
        multiOutputStream.addDelegate(out);
    }

    public static void removeOutputStream(OutputStream out) {
        multiOutputStream.removeDelegate(out);
    }

    public static void removeAllOutputStreams() {
        multiOutputStream.removeAllDelegates();
    }

    public static enum QueryToObserve {
        DOMAIN_INFO("DOMAIN INFO"),
        DOM_QUERY("DOM QUERY"),
        COUNT_QUERY("COUNT QUERY"),
        CLOSURE_QUERY("CLOSURE"),
        UPDATE_QUERY("UPDATE"),
        QUERY_CONCRETE_TYPE("Query concrete type"),
        LOAD_BY_TYPE_QUERY("LOAD-BY-TYPE"),
        DOMAINACCESS_EXECUTE_INTERNAL("EXEC_INT");

        private String title;

        private QueryToObserve(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }
    }

    public static enum ContentToObserve {
        CYPHER,
        JSON,
        CYPHER_JSON;

    }
}

