/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.spring;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import net.javacrumbs.shedlock.core.LockManager;
import net.javacrumbs.shedlock.core.LockableRunnable;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;

@Deprecated(forRemoval=true)
public class LockableTaskScheduler
implements TaskScheduler,
DisposableBean {
    private final TaskScheduler taskScheduler;
    private final LockManager lockManager;

    public LockableTaskScheduler(TaskScheduler taskScheduler, LockManager lockManager) {
        this.taskScheduler = Objects.requireNonNull(taskScheduler);
        this.lockManager = Objects.requireNonNull(lockManager);
    }

    public @Nullable ScheduledFuture<?> schedule(Runnable task, Trigger trigger) {
        return this.taskScheduler.schedule(this.wrap(task), trigger);
    }

    public ScheduledFuture<?> schedule(Runnable task, Date startTime) {
        return this.taskScheduler.schedule(this.wrap(task), startTime);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Date startTime, long period) {
        return this.taskScheduler.scheduleAtFixedRate(this.wrap(task), startTime, period);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long period) {
        return this.taskScheduler.scheduleAtFixedRate(this.wrap(task), period);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Date startTime, long delay) {
        return this.taskScheduler.scheduleWithFixedDelay(this.wrap(task), startTime, delay);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long delay) {
        return this.taskScheduler.scheduleWithFixedDelay(this.wrap(task), delay);
    }

    public ScheduledFuture<?> schedule(Runnable task, Instant startTime) {
        return this.taskScheduler.schedule(this.wrap(task), startTime);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Instant startTime, Duration period) {
        return this.taskScheduler.scheduleAtFixedRate(this.wrap(task), startTime, period);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Duration period) {
        return this.taskScheduler.scheduleAtFixedRate(this.wrap(task), period);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Instant startTime, Duration delay) {
        return this.taskScheduler.scheduleWithFixedDelay(this.wrap(task), startTime, delay);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Duration delay) {
        return this.taskScheduler.scheduleWithFixedDelay(this.wrap(task), delay);
    }

    private Runnable wrap(Runnable task) {
        return new LockableRunnable(task, this.lockManager);
    }

    public void destroy() throws Exception {
        TaskScheduler taskScheduler = this.taskScheduler;
        if (taskScheduler instanceof DisposableBean) {
            DisposableBean disposableBean = (DisposableBean)taskScheduler;
            disposableBean.destroy();
        }
    }
}

