/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite;

import ch.qos.logback.core.spi.DeferredProcessingAware;
import java.util.Objects;
import net.logstash.logback.composite.AbstractFieldJsonProvider;
import net.logstash.logback.composite.JsonProviders;
import net.logstash.logback.composite.ObjectMapperAware;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.ObjectMapper;

public abstract class AbstractNestedJsonProvider<Event extends DeferredProcessingAware>
extends AbstractFieldJsonProvider<Event>
implements ObjectMapperAware {
    public static final String FIELD_NESTED = "nested";
    private JsonProviders<Event> jsonProviders = new JsonProviders();

    public AbstractNestedJsonProvider() {
        this.setFieldName(FIELD_NESTED);
    }

    @Override
    public void start() {
        this.getProviders().start();
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.getProviders().stop();
    }

    @Override
    public void writeTo(JsonGenerator generator, Event event) {
        generator.writeObjectPropertyStart(this.getFieldName());
        this.jsonProviders.writeTo(generator, event);
        generator.writeEndObject();
    }

    public JsonProviders<Event> getProviders() {
        return this.jsonProviders;
    }

    public void setProviders(JsonProviders<Event> jsonProviders) {
        this.jsonProviders = Objects.requireNonNull(jsonProviders);
    }

    @Override
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.getProviders().setObjectMapper(Objects.requireNonNull(objectMapper));
    }

    @Override
    public void prepareForDeferredProcessing(Event event) {
        super.prepareForDeferredProcessing(event);
        this.getProviders().prepareForDeferredProcessing(event);
    }
}

