/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite;

import tools.jackson.core.JsonParser;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.node.ObjectNode;

public class JsonReadingUtils {
    private JsonReadingUtils() {
    }

    public static JsonNode readFully(ObjectMapper objectMapper, String json) {
        if (json == null) {
            return null;
        }
        String trimmedJson = json.trim();
        try (JsonParser parser = objectMapper.createParser(trimmedJson);){
            JsonNode tree = (JsonNode)parser.readValueAsTree();
            if (parser.currentLocation().getCharOffset() < (long)trimmedJson.length()) {
                throw new StreamReadException(parser, "unexpected character");
            }
            JsonNode jsonNode = tree;
            return jsonNode;
        }
    }

    public static ObjectNode readFullyAsObjectNode(ObjectMapper objectMapper, String json) {
        JsonNode node = JsonReadingUtils.readFully(objectMapper, json);
        if (node != null && !(node instanceof ObjectNode)) {
            throw new StreamReadException(null, "expected a JSON object representation");
        }
        return (ObjectNode)node;
    }
}

