/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder.com.lmax.disruptor;

import net.logstash.logback.encoder.com.lmax.disruptor.EventFactory;
import net.logstash.logback.encoder.com.lmax.disruptor.RingBufferPad;
import net.logstash.logback.encoder.com.lmax.disruptor.Sequencer;

abstract class RingBufferFields<E>
extends RingBufferPad {
    private static final int BUFFER_PAD = 32;
    private final long indexMask;
    private final E[] entries;
    protected final int bufferSize;
    protected final Sequencer sequencer;

    RingBufferFields(EventFactory<E> eventFactory, Sequencer sequencer) {
        this.sequencer = sequencer;
        this.bufferSize = sequencer.getBufferSize();
        if (this.bufferSize < 1) {
            throw new IllegalArgumentException("bufferSize must not be less than 1");
        }
        if (Integer.bitCount(this.bufferSize) != 1) {
            throw new IllegalArgumentException("bufferSize must be a power of 2");
        }
        this.indexMask = this.bufferSize - 1;
        this.entries = new Object[this.bufferSize + 64];
        this.fill(eventFactory);
    }

    private void fill(EventFactory<E> eventFactory) {
        for (int i = 0; i < this.bufferSize; ++i) {
            this.entries[32 + i] = eventFactory.newInstance();
        }
    }

    protected final E elementAt(long sequence) {
        return this.entries[32 + (int)(sequence & this.indexMask)];
    }
}

