/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.mask;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import net.logstash.logback.mask.FieldMasker;
import net.logstash.logback.mask.ValueMasker;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.SerializableString;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.exc.JacksonIOException;
import tools.jackson.core.util.JsonGeneratorDelegate;

public class MaskingJsonGenerator
extends JsonGeneratorDelegate {
    public static final String MASK = "****";
    private final Collection<FieldMasker> fieldMaskers;
    private final Collection<ValueMasker> valueMaskers;
    private int maskDepth = 0;

    public MaskingJsonGenerator(JsonGenerator delegate, Collection<FieldMasker> fieldMaskers, Collection<ValueMasker> valueMaskers) {
        super(delegate, false);
        this.fieldMaskers = fieldMaskers == null ? Collections.emptyList() : fieldMaskers;
        this.valueMaskers = valueMaskers == null ? Collections.emptyList() : valueMaskers;
    }

    public JsonGenerator writeArray(int[] array, int offset, int length) {
        if (array == null) {
            throw new IllegalArgumentException("null array");
        }
        this._verifyOffsets(array.length, offset, length);
        this.writeStartArray(array, length);
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.writeNumber(array[i]);
        }
        this.writeEndArray();
        return this;
    }

    public JsonGenerator writeArray(long[] array, int offset, int length) {
        if (array == null) {
            throw new IllegalArgumentException("null array");
        }
        this._verifyOffsets(array.length, offset, length);
        this.writeStartArray(array, length);
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.writeNumber(array[i]);
        }
        this.writeEndArray();
        return this;
    }

    public JsonGenerator writeArray(double[] array, int offset, int length) {
        if (array == null) {
            throw new IllegalArgumentException("null array");
        }
        this._verifyOffsets(array.length, offset, length);
        this.writeStartArray(array, length);
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.writeNumber(array[i]);
        }
        this.writeEndArray();
        return this;
    }

    public JsonGenerator writeName(SerializableString name) {
        return this.writeName(() -> super.writeName(name));
    }

    public JsonGenerator writeName(String name) {
        return this.writeName(() -> super.writeName(name));
    }

    public JsonGenerator writePropertyId(long id) {
        return this.writeName(() -> super.writePropertyId(id));
    }

    private JsonGenerator writeName(Runnable doWriteFieldName) {
        if (this.maskingInProgress()) {
            this.decrementMaskDepth();
        }
        if (this.maskingInProgress()) {
            this.incrementMaskDepth();
        } else {
            doWriteFieldName.run();
            Object maskedValue = this.getMaskedValueForCurrentPath();
            if (maskedValue != null) {
                this.delegate.writePOJO(maskedValue);
                this.incrementMaskDepth();
            }
        }
        return this;
    }

    public JsonGenerator writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) {
        if (!this.maskingInProgress()) {
            super.writeBinary(b64variant, data, offset, len);
        }
        return this;
    }

    public JsonGenerator writeBinary(byte[] data) {
        if (!this.maskingInProgress()) {
            super.writeBinary(data);
        }
        return this;
    }

    public JsonGenerator writeBinary(byte[] data, int offset, int len) {
        if (!this.maskingInProgress()) {
            super.writeBinary(data, offset, len);
        }
        return this;
    }

    public int writeBinary(Base64Variant b64variant, InputStream data, int dataLength) {
        if (!this.maskingInProgress()) {
            return super.writeBinary(b64variant, data, dataLength);
        }
        return this.readAndDiscard(data);
    }

    public int writeBinary(InputStream data, int dataLength) {
        if (!this.maskingInProgress()) {
            return super.writeBinary(data, dataLength);
        }
        return this.readAndDiscard(data);
    }

    private int readAndDiscard(InputStream data) {
        try {
            int bytesRead = 0;
            while (data.read() != -1) {
                ++bytesRead;
            }
            return bytesRead;
        }
        catch (IOException e) {
            throw JacksonIOException.construct((IOException)e, (Closeable)((Object)this));
        }
    }

    public JsonGenerator writeBoolean(boolean state) {
        if (!this.maskingInProgress()) {
            super.writeBoolean(state);
        }
        return this;
    }

    public JsonGenerator writeEmbeddedObject(Object object) {
        if (!this.maskingInProgress()) {
            super.writeEmbeddedObject(object);
        }
        return this;
    }

    public JsonGenerator writeNull() {
        if (!this.maskingInProgress()) {
            super.writeNull();
        }
        return this;
    }

    public JsonGenerator writeNumber(BigDecimal v) {
        return this.writePotentiallyMaskedValue(v, () -> super.writeNumber(v));
    }

    public JsonGenerator writeNumber(BigInteger v) {
        return this.writePotentiallyMaskedValue(v, () -> super.writeNumber(v));
    }

    public JsonGenerator writeNumber(double v) {
        return this.writePotentiallyMaskedValue(v, () -> super.writeNumber(v));
    }

    public JsonGenerator writeNumber(float v) {
        return this.writePotentiallyMaskedValue(Float.valueOf(v), () -> super.writeNumber(v));
    }

    public JsonGenerator writeNumber(int v) {
        return this.writePotentiallyMaskedValue(v, () -> super.writeNumber(v));
    }

    public JsonGenerator writeNumber(short v) {
        return this.writePotentiallyMaskedValue(v, () -> super.writeNumber(v));
    }

    public JsonGenerator writeNumber(long v) {
        return this.writePotentiallyMaskedValue(v, () -> super.writeNumber(v));
    }

    public JsonGenerator writeNumber(String encodedValue) {
        return this.writePotentiallyMaskedValue(encodedValue, () -> super.writeNumber(encodedValue));
    }

    public JsonGenerator writeObjectId(Object id) {
        if (!this.maskingInProgress()) {
            super.writeObjectId(id);
        }
        return this;
    }

    public JsonGenerator writeObjectRef(Object id) {
        if (!this.maskingInProgress()) {
            super.writeObjectRef(id);
        }
        return this;
    }

    public JsonGenerator writeOmittedProperty(String fieldName) {
        if (!this.maskingInProgress()) {
            super.writeOmittedProperty(fieldName);
        }
        return this;
    }

    public JsonGenerator writeRaw(char c) {
        if (!this.maskingInProgress()) {
            super.writeRaw(c);
        }
        return this;
    }

    public JsonGenerator writeRaw(char[] text, int offset, int len) {
        if (!this.maskingInProgress()) {
            super.writeRaw(text, offset, len);
        }
        return this;
    }

    public JsonGenerator writeRaw(String text) {
        if (!this.maskingInProgress()) {
            super.writeRaw(text);
        }
        return this;
    }

    public JsonGenerator writeRaw(String text, int offset, int len) {
        if (!this.maskingInProgress()) {
            super.writeRaw(text, offset, len);
        }
        return this;
    }

    public JsonGenerator writeRaw(SerializableString raw) {
        if (!this.maskingInProgress()) {
            super.writeRaw(raw);
        }
        return this;
    }

    public JsonGenerator writeRawValue(String text) {
        if (!this.maskingInProgress()) {
            super.writeRawValue(text);
        }
        return this;
    }

    public JsonGenerator writeRawValue(String text, int offset, int len) {
        if (!this.maskingInProgress()) {
            super.writeRawValue(text, offset, len);
        }
        return this;
    }

    public JsonGenerator writeRawValue(char[] text, int offset, int len) {
        if (!this.maskingInProgress()) {
            super.writeRawValue(text, offset, len);
        }
        return this;
    }

    public JsonGenerator writeRawUTF8String(byte[] text, int offset, int length) {
        if (!this.maskingInProgress()) {
            super.writeRawUTF8String(text, offset, length);
        }
        return this;
    }

    public JsonGenerator writeStartArray() {
        if (!this.maskingInProgress()) {
            super.writeStartArray();
        }
        return this;
    }

    public JsonGenerator writeStartArray(Object forValue) {
        if (!this.maskingInProgress()) {
            super.writeStartArray(forValue);
        }
        return this;
    }

    public JsonGenerator writeStartArray(Object forValue, int size) {
        if (!this.maskingInProgress()) {
            super.writeStartArray(forValue, size);
        }
        return this;
    }

    public JsonGenerator writeStartObject() {
        if (!this.maskingInProgress()) {
            super.writeStartObject();
        } else {
            this.incrementMaskDepth();
        }
        return this;
    }

    public JsonGenerator writeStartObject(Object forValue) {
        if (!this.maskingInProgress()) {
            super.writeStartObject(forValue);
        } else {
            this.incrementMaskDepth();
        }
        return this;
    }

    public JsonGenerator writeStartObject(Object forValue, int size) {
        if (!this.maskingInProgress()) {
            super.writeStartObject(forValue, size);
        } else {
            this.incrementMaskDepth();
        }
        return this;
    }

    public JsonGenerator writeString(char[] text, int offset, int len) {
        return this.writePotentiallyMaskedValue(new String(text, offset, len), () -> super.writeString(text, offset, len));
    }

    public JsonGenerator writeString(String text) {
        return this.writePotentiallyMaskedValue(text, () -> super.writeString(text));
    }

    public JsonGenerator writeString(SerializableString text) {
        return this.writePotentiallyMaskedValue(text.getValue(), () -> super.writeString(text));
    }

    public JsonGenerator writeString(Reader reader, int len) {
        if (!this.maskingInProgress()) {
            super.writeString(reader, len);
        }
        return this;
    }

    public JsonGenerator writeUTF8String(byte[] text, int offset, int length) {
        return this.writePotentiallyMaskedValue(new String(text, offset, length, StandardCharsets.UTF_8), () -> super.writeUTF8String(text, offset, length));
    }

    public JsonGenerator writeTypeId(Object id) {
        if (!this.maskingInProgress()) {
            super.writeTypeId(id);
        }
        return this;
    }

    public JsonGenerator writeEndArray() {
        if (!this.maskingInProgress()) {
            super.writeEndArray();
        }
        return this;
    }

    public JsonGenerator writeEndObject() {
        if (this.maskingInProgress()) {
            this.decrementMaskDepth();
        }
        if (!this.maskingInProgress()) {
            super.writeEndObject();
        }
        return this;
    }

    private Object getMaskedValueForCurrentPath() {
        TokenStreamContext context = this.streamWriteContext();
        for (FieldMasker fieldMasker : this.fieldMaskers) {
            Object maskedValue = fieldMasker.mask(context);
            if (maskedValue == null) continue;
            return maskedValue;
        }
        return null;
    }

    private Object getMaskedValueForCurrentPathAndValue(Object originalValue) {
        TokenStreamContext context = this.streamWriteContext();
        Object localValue = originalValue;
        for (ValueMasker valueMasker : this.valueMaskers) {
            Object maskedValue = valueMasker.mask(context, localValue);
            if (maskedValue == null) continue;
            localValue = maskedValue;
        }
        if (localValue != originalValue) {
            return localValue;
        }
        return null;
    }

    private JsonGenerator writePotentiallyMaskedValue(Object value, Runnable doWriteUnmaskedValue) {
        if (!this.maskingInProgress()) {
            Object maskedValue = this.getMaskedValueForCurrentPathAndValue(value);
            if (maskedValue != null) {
                this.delegate.writePOJO(maskedValue);
            } else {
                doWriteUnmaskedValue.run();
            }
        }
        return this;
    }

    private void incrementMaskDepth() {
        ++this.maskDepth;
    }

    private void decrementMaskDepth() {
        --this.maskDepth;
    }

    boolean maskingInProgress() {
        return this.maskDepth != 0;
    }
}

