/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.criteria.api;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.n2oapp.criteria.api.Criteria;

public class CriteriaAccessor {
    private static CriteriaAccessor ourInstance = new CriteriaAccessor();
    private Map<Class, Map<String, Method>> criteriaReadMethods = new ConcurrentHashMap<Class, Map<String, Method>>();
    private Map<Class, Map<String, Method>> criteriaWriteMethods = new ConcurrentHashMap<Class, Map<String, Method>>();

    public static CriteriaAccessor getInstance() {
        return ourInstance;
    }

    public <T> T read(Criteria criteria, String field) {
        Method method = this.getReadMethod(criteria.getClass(), field);
        if (method != null) {
            try {
                return (T)method.invoke((Object)criteria, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Read access error: criteria " + criteria.getClass() + ", field " + field, e);
            }
        }
        if (criteria instanceof Map) {
            return (T)((Map)((Object)criteria)).get(field);
        }
        throw new IllegalStateException("Field not found: criteria " + criteria.getClass() + ", field " + field);
    }

    public void write(Criteria criteria, String field, Object value) {
        Method method = this.getWriteMethod(criteria.getClass(), field);
        this.write(criteria, field, value, method);
    }

    public void write(Criteria criteria, String field, Object value, Method method) {
        if (method != null) {
            try {
                method.invoke((Object)criteria, value);
                return;
            }
            catch (Exception e) {
                throw new RuntimeException("Write access error: criteria " + criteria.getClass() + ", field " + field, e);
            }
        }
        if (criteria instanceof Map) {
            ((Map)((Object)criteria)).put(field, value);
            return;
        }
        throw new IllegalStateException("Field not found: criteria " + criteria.getClass() + ", field " + field);
    }

    private Method getReadMethod(Class criteriaClass, String field) {
        if (!this.criteriaReadMethods.containsKey(criteriaClass)) {
            this.init(criteriaClass);
        }
        return this.criteriaReadMethods.get(criteriaClass).get(CriteriaAccessor.toCamelCase(field));
    }

    public Method getWriteMethod(Class criteriaClass, String field) {
        if (!this.criteriaWriteMethods.containsKey(criteriaClass)) {
            this.init(criteriaClass);
        }
        return this.criteriaWriteMethods.get(criteriaClass).get(CriteriaAccessor.toCamelCase(field));
    }

    private synchronized void init(Class criteriaClass) {
        BeanInfo info;
        if (this.criteriaWriteMethods.containsKey(criteriaClass)) {
            return;
        }
        try {
            info = Introspector.getBeanInfo(criteriaClass);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        PropertyDescriptor[] pds = info.getPropertyDescriptors();
        HashMap<String, Method> readMap = new HashMap<String, Method>();
        HashMap<String, Method> writeMap = new HashMap<String, Method>();
        for (PropertyDescriptor pd : pds) {
            readMap.put(pd.getName(), pd.getReadMethod());
            writeMap.put(pd.getName(), pd.getWriteMethod());
        }
        this.criteriaReadMethods.put(criteriaClass, readMap);
        this.criteriaWriteMethods.put(criteriaClass, writeMap);
    }

    public static String toCamelCase(String init) {
        if (init == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder(init.length());
        String[] words = init.split("\\.");
        for (int k = 0; k < words.length; ++k) {
            if (k == 0) {
                ret.append(words[k]);
                continue;
            }
            if (words[k].isEmpty()) continue;
            ret.append(words[k].substring(0, 1).toUpperCase());
            ret.append(words[k].substring(1).toLowerCase());
        }
        return ret.toString();
    }

    public boolean contains(Criteria criteria, String field) {
        Method method = this.getReadMethod(criteria.getClass(), field);
        if (method != null) {
            return true;
        }
        if (criteria instanceof Map) {
            return ((Map)((Object)criteria)).containsKey(field);
        }
        throw new IllegalStateException("Field not found: criteria " + criteria.getClass() + ", field " + field);
    }
}

