/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.criteria.api.constructor;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import net.n2oapp.criteria.api.Direction;

public class CriteriaConstructorResult
implements Serializable {
    private String selectClause;
    private String whereClause;
    private String orderByClause;
    private String joinClause;
    private Map<String, Object> parameters = new LinkedHashMap<String, Object>();

    public CriteriaConstructorResult() {
    }

    public CriteriaConstructorResult(String whereClause) {
        this(whereClause, new LinkedHashMap<String, Object>());
    }

    public CriteriaConstructorResult(String whereClause, Map<String, Object> parameters) {
        this.whereClause = whereClause;
        this.parameters = parameters;
    }

    public CriteriaConstructorResult addParameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    public CriteriaConstructorResult addParameter(Object value) {
        return this.addParameter("{0}", value);
    }

    public CriteriaConstructorResult addSearch(String search) {
        StringBuilder sb = new StringBuilder();
        if (this.notEmpty(this.whereClause)) {
            sb.append(this.whereClause).append(" and ");
        }
        this.whereClause = sb.append(search).toString();
        return this;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public CriteriaConstructorResult addSorting(String sortingQuery, Direction direction) {
        StringBuilder sb = new StringBuilder();
        if (this.notEmpty(this.orderByClause)) {
            sb.append(this.orderByClause).append(", ");
        }
        sb.append(sortingQuery);
        if (direction != null) {
            sb.append(' ').append(direction.getExpression());
        }
        this.orderByClause = sb.toString();
        return this;
    }

    public CriteriaConstructorResult addColumn(String columnQuery) {
        StringBuilder sb = new StringBuilder();
        if (this.notEmpty(this.selectClause)) {
            sb.append(this.selectClause).append(", ");
        }
        sb.append(columnQuery);
        this.selectClause = sb.toString();
        return this;
    }

    public CriteriaConstructorResult addJoin(String join) {
        StringBuilder sb = new StringBuilder();
        if (this.notEmpty(this.joinClause)) {
            sb.append(this.joinClause).append(" ");
        }
        sb.append(join);
        this.joinClause = sb.toString();
        return this;
    }

    private boolean notEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public String getQueryStringFormat() {
        return this.whereClause;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getSelectClause() {
        return this.selectClause;
    }

    public String getOrderByClause() {
        return this.orderByClause;
    }

    public String getJoinClause() {
        return this.joinClause;
    }
}

