/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.access.metadata.accesspoint.util;

import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;

public class AntPathRequestMatcher {
    private static final String MATCH_ALL = "/**";
    private final Matcher matcher;
    private final String pattern;

    public AntPathRequestMatcher(String pattern) {
        Assert.hasText((String)pattern, (String)"Pattern cannot be null or empty");
        if (pattern.equals(MATCH_ALL) || pattern.equals("**")) {
            pattern = MATCH_ALL;
            this.matcher = null;
        } else {
            this.matcher = (pattern = this.ignoreStartSeparater(pattern)).endsWith(MATCH_ALL) && pattern.indexOf(63) == -1 && pattern.indexOf("*") == pattern.length() - 2 ? new SubpathMatcher(pattern.substring(0, pattern.length() - 3)) : new SpringAntMatcher(pattern);
        }
        this.pattern = pattern;
    }

    public boolean matches(String url) {
        return this.pattern.equals(MATCH_ALL) || this.matcher.matches(this.ignoreStartSeparater(url));
    }

    private String ignoreStartSeparater(String url) {
        return url.startsWith("/") ? url : "/" + url;
    }

    private static class SubpathMatcher
    implements Matcher {
        private final String subpath;
        private final int length;

        private SubpathMatcher(String subpath) {
            assert (!subpath.contains("*"));
            this.subpath = subpath;
            this.length = subpath.length();
        }

        @Override
        public boolean matches(String path) {
            return path.startsWith(this.subpath) && (path.length() == this.length || path.charAt(this.length) == '/');
        }
    }

    private static class SpringAntMatcher
    implements Matcher {
        private static final AntPathMatcher antMatcher = new AntPathMatcher();
        private final String pattern;

        private SpringAntMatcher(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(String path) {
            return antMatcher.match(this.pattern, path);
        }
    }

    private static interface Matcher {
        public boolean matches(String var1);
    }
}

