/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.access.api.model;

import net.n2oapp.framework.access.exception.AccessDeniedException;
import net.n2oapp.framework.access.exception.N2oSecurityException;
import net.n2oapp.framework.api.exception.N2oUserException;

public class Permission {
    private boolean allowed;
    private String detailedMessage;
    private String techMessage;
    private Object placeholders;

    public static Permission denied(String detailedMessage, String techMessage) {
        Permission res = new Permission(false);
        res.setDetailedMessage(detailedMessage);
        res.setTechMessage(techMessage);
        return res;
    }

    public static Permission denied(String techMessage) {
        Permission res = new Permission(false);
        res.setTechMessage(techMessage);
        return res;
    }

    public static Permission allowed(String techMessage) {
        Permission res = new Permission(true);
        res.setTechMessage(techMessage);
        return res;
    }

    public static Permission allowed() {
        return new Permission(true);
    }

    public Permission(boolean allowed) {
        this.allowed = allowed;
    }

    public void setDetailedMessage(String detailedMessage) {
        this.detailedMessage = detailedMessage;
    }

    public void setTechMessage(String techMessage) {
        this.techMessage = techMessage;
    }

    public void setPlaceholders(Object placeholders) {
        this.placeholders = placeholders;
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public String getDetailedMessage() {
        return this.detailedMessage;
    }

    public String getTechMessage() {
        return this.techMessage;
    }

    private void throwException() throws N2oSecurityException {
        throw this.getException();
    }

    public N2oUserException getException() {
        return new AccessDeniedException(this.detailedMessage);
    }

    public void resolveToException() throws N2oSecurityException {
        if (!this.allowed) {
            this.throwException();
        }
    }

    public void addCommentToTechInfo(String comment) {
        if (this.getTechMessage() != null) {
            this.setTechMessage("[" + comment + "]\r\n" + this.getTechMessage());
        }
    }

    public String toString() {
        return String.format("{allowed:%s, message:%s, tech-message:%s}", this.allowed, this.detailedMessage, this.techMessage);
    }
}

