/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.access.metadata.accesspoint.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.n2oapp.criteria.filters.FilterType;
import net.n2oapp.framework.access.api.model.filter.N2oAccessFilter;

public class FilterMerger {
    public static List<N2oAccessFilter> merge(List<N2oAccessFilter> filters) {
        LinkedHashMap<String, List<N2oAccessFilter>> map = new LinkedHashMap<String, List<N2oAccessFilter>>();
        for (N2oAccessFilter filter : filters) {
            map.putIfAbsent(filter.getFieldId(), new ArrayList());
            ((List)map.get(filter.getFieldId())).add(filter);
        }
        ArrayList<N2oAccessFilter> res = new ArrayList<N2oAccessFilter>();
        for (String fieldId : map.keySet()) {
            FilterMerger.merge(map, fieldId);
            res.addAll(FilterMerger.validate((List)map.get(fieldId)));
        }
        return res;
    }

    private static List<N2oAccessFilter> validate(List<N2oAccessFilter> filters) {
        if (filters == null) {
            return Collections.emptyList();
        }
        Set fieldIds = filters.stream().filter(filter -> filter.getType().equals((Object)FilterType.in) && (filter.getValues() == null || filter.getValues().size() == 0)).map(N2oAccessFilter::getFieldId).collect(Collectors.toSet());
        if (fieldIds.size() > 0) {
            throw new IllegalArgumentException(String.format("Filter by field [%s] has type [in], but hasn't values", fieldIds.iterator().next()));
        }
        return filters;
    }

    private static void merge(Map<String, List<N2oAccessFilter>> map, String fieldId) {
        int size = map.get(fieldId).size();
        ArrayList<N2oAccessFilter> result = new ArrayList<N2oAccessFilter>();
        for (N2oAccessFilter filter : map.get(fieldId)) {
            FilterMerger.addToResult(result, filter);
        }
        map.put(fieldId, result);
        List<N2oAccessFilter> fieldFilters = map.get(fieldId);
        if (fieldFilters.size() != size) {
            FilterMerger.merge(map, fieldId);
        } else if (fieldFilters.get(0).getType().equals((Object)FilterType.infinite)) {
            fieldFilters.clear();
        }
    }

    private static void addToResult(List<N2oAccessFilter> result, N2oAccessFilter newFilter) {
        if (result.size() == 0) {
            result.add(newFilter);
        } else {
            for (N2oAccessFilter filter : new ArrayList<N2oAccessFilter>(result)) {
                result.remove(filter);
                result.addAll(FilterMerger.merge(filter, newFilter));
            }
        }
    }

    private static List<N2oAccessFilter> merge(N2oAccessFilter filter, N2oAccessFilter newFilter) {
        ArrayList<N2oAccessFilter> res = new ArrayList<N2oAccessFilter>();
        if (filter.getType().equals((Object)FilterType.infinite) || newFilter.getType().equals((Object)FilterType.infinite)) {
            res.add(new N2oAccessFilter(filter.getFieldId(), FilterType.infinite));
        } else if (filter.getType().equals((Object)FilterType.empty) || newFilter.getType().equals((Object)FilterType.empty)) {
            res.add(new N2oAccessFilter(filter.getFieldId(), FilterType.empty));
        } else if (filter.getType().equals((Object)FilterType.in) && newFilter.getType().equals((Object)FilterType.isNull)) {
            FilterMerger.InIsNull(filter, newFilter, res);
        } else if (filter.getType().equals((Object)FilterType.isNull) && newFilter.getType().equals((Object)FilterType.in)) {
            FilterMerger.InIsNull(newFilter, filter, res);
        } else if (filter.getType().equals((Object)FilterType.eq) && newFilter.getType().equals((Object)FilterType.isNull)) {
            FilterMerger.EqIsNull(filter, newFilter, res);
        } else if (filter.getType().equals((Object)FilterType.isNull) && newFilter.getType().equals((Object)FilterType.eq)) {
            FilterMerger.EqIsNull(newFilter, filter, res);
        } else if (filter.getType().equals((Object)FilterType.eq) && newFilter.getType().equals((Object)FilterType.eq)) {
            FilterMerger.EqEq(filter, newFilter, res);
        } else if (filter.getType().equals((Object)FilterType.eq) && newFilter.getType().equals((Object)FilterType.in)) {
            FilterMerger.EqIn(filter, newFilter, res);
        } else if (filter.getType().equals((Object)FilterType.in) && newFilter.getType().equals((Object)FilterType.eq)) {
            FilterMerger.EqIn(newFilter, filter, res);
        } else if (filter.getType().equals((Object)FilterType.eq) && newFilter.getType().equals((Object)FilterType.overlaps)) {
            FilterMerger.eqOverlap(filter, newFilter, res);
        } else if (filter.getType().equals((Object)FilterType.overlaps) && newFilter.getType().equals((Object)FilterType.eq)) {
            FilterMerger.eqOverlap(newFilter, filter, res);
        } else if (filter.getType().equals((Object)FilterType.notEq) && newFilter.getType().equals((Object)FilterType.notEq)) {
            FilterMerger.NotEqNotEq(filter, newFilter, res);
        } else if (filter.getType().equals((Object)FilterType.eq) && newFilter.getType().equals((Object)FilterType.notEq)) {
            FilterMerger.EqNotEq(filter, newFilter, res);
        } else if (filter.getType() == FilterType.notEq && newFilter.getType() == FilterType.eq) {
            FilterMerger.EqNotEq(newFilter, filter, res);
        } else if (filter.getType().equals((Object)FilterType.isNull) && newFilter.getType().equals((Object)FilterType.isNotNull) || filter.getType().equals((Object)FilterType.isNotNull) && newFilter.getType().equals((Object)FilterType.isNull)) {
            res.add(new N2oAccessFilter(filter.getFieldId(), FilterType.infinite));
        } else if (filter.getType().equals((Object)FilterType.in) && newFilter.getType().equals((Object)FilterType.in)) {
            FilterMerger.InIn(filter, newFilter, res);
        } else if (filter.getType().equals((Object)FilterType.in) && newFilter.getType().equals((Object)FilterType.overlaps)) {
            FilterMerger.inOverlap(filter, newFilter, res);
        } else if (filter.getType().equals((Object)FilterType.overlaps) && newFilter.getType().equals((Object)FilterType.in)) {
            FilterMerger.inOverlap(newFilter, filter, res);
        } else if (filter.getType().equals((Object)FilterType.overlaps) && newFilter.getType().equals((Object)FilterType.overlaps)) {
            FilterMerger.overlapOverlap(filter, newFilter, res);
        } else if (filter.getType().equals((Object)FilterType.notIn) && newFilter.getType().equals((Object)FilterType.notIn)) {
            FilterMerger.NotInNotIn(filter, newFilter, res);
        } else if (filter.getType().equals((Object)FilterType.notIn) && newFilter.getType().equals((Object)FilterType.in)) {
            FilterMerger.NotInIn(filter, newFilter, res);
        } else if (filter.getType().equals((Object)FilterType.in) && newFilter.getType().equals((Object)FilterType.notIn)) {
            FilterMerger.NotInIn(newFilter, filter, res);
        } else if (filter.getType().equals((Object)FilterType.notIn) && newFilter.getType().equals((Object)FilterType.eq)) {
            FilterMerger.NotInEq(filter, newFilter, res);
        } else if (filter.getType().equals((Object)FilterType.eq) && newFilter.getType().equals((Object)FilterType.notIn)) {
            FilterMerger.NotInEq(newFilter, filter, res);
        } else {
            res.add(filter);
            res.add(newFilter);
        }
        return res;
    }

    private static void InIsNull(N2oAccessFilter inFilter, N2oAccessFilter isNullFilter, List<N2oAccessFilter> res) {
        N2oAccessFilter inOrIsNullFilter = new N2oAccessFilter(inFilter.getFieldId(), FilterType.inOrIsNull);
        inOrIsNullFilter.setValues(inFilter.getValues());
        res.add(inOrIsNullFilter);
    }

    private static void EqIsNull(N2oAccessFilter eqFilter, N2oAccessFilter isNullFilter, List<N2oAccessFilter> res) {
        N2oAccessFilter eqOrIsNullFilter = new N2oAccessFilter(eqFilter.getFieldId(), FilterType.eqOrIsNull);
        eqOrIsNullFilter.setValue(eqFilter.getValue());
        res.add(eqOrIsNullFilter);
    }

    private static void NotInEq(N2oAccessFilter notInFilter, N2oAccessFilter eqFilter, List<N2oAccessFilter> res) {
        N2oAccessFilter inFilter = new N2oAccessFilter(eqFilter.getFieldId(), FilterType.in);
        inFilter.setValues(new ArrayList<String>(Collections.singletonList(eqFilter.getValue())));
        FilterMerger.NotInIn(notInFilter, inFilter, res);
    }

    private static void NotInIn(N2oAccessFilter notInFilter, N2oAccessFilter inFilter, List<N2oAccessFilter> res) {
        N2oAccessFilter result;
        ArrayList<String> values = new ArrayList<String>(notInFilter.getValues());
        inFilter.getValues().forEach(values::remove);
        if (values.size() == 0) {
            result = new N2oAccessFilter(notInFilter.getFieldId(), FilterType.infinite);
        } else {
            result = new N2oAccessFilter(notInFilter.getFieldId(), FilterType.notIn);
            result.setValues(values);
        }
        res.add(result);
    }

    private static void EqIn(N2oAccessFilter filter, N2oAccessFilter newFilter, List<N2oAccessFilter> res) {
        if (newFilter.getValues().contains(filter.getValue())) {
            res.add(newFilter);
        } else {
            N2oAccessFilter result = new N2oAccessFilter(filter.getFieldId(), FilterType.in);
            ArrayList<String> tmp = new ArrayList<String>(newFilter.getValues());
            tmp.add(filter.getValue());
            result.setValues(tmp);
            res.add(result);
        }
    }

    private static void eqOverlap(N2oAccessFilter filter, N2oAccessFilter newFilter, List<N2oAccessFilter> res) {
        if (newFilter.getValues().contains(filter.getValue())) {
            res.add(newFilter);
        } else {
            N2oAccessFilter result = new N2oAccessFilter(filter.getFieldId(), FilterType.overlaps);
            ArrayList<String> tmp = new ArrayList<String>(newFilter.getValues());
            tmp.add(filter.getValue());
            result.setValues(tmp);
            res.add(result);
        }
    }

    private static void NotInNotIn(N2oAccessFilter filter, N2oAccessFilter newFilter, List<N2oAccessFilter> res) {
        List<String> cross = filter.getValues().stream().filter(s -> newFilter.getValues().contains(s)).collect(Collectors.toList());
        if (cross.size() != 0) {
            N2oAccessFilter result = new N2oAccessFilter(filter.getFieldId(), FilterType.notIn);
            result.setValues(cross);
            res.add(result);
        } else {
            res.add(new N2oAccessFilter(filter.getFieldId(), FilterType.infinite));
        }
    }

    private static void InIn(N2oAccessFilter filter, N2oAccessFilter newFilter, List<N2oAccessFilter> res) {
        ArrayList<String> resultList = new ArrayList<String>(filter.getValues());
        newFilter.getValues().stream().filter(s -> !resultList.contains(s)).forEach(resultList::add);
        N2oAccessFilter result = new N2oAccessFilter(filter.getFieldId(), FilterType.in);
        result.setValues(resultList);
        res.add(result);
    }

    private static void overlapOverlap(N2oAccessFilter filter, N2oAccessFilter newFilter, List<N2oAccessFilter> res) {
        ArrayList<String> resultList = new ArrayList<String>(filter.getValues());
        newFilter.getValues().stream().filter(s -> !resultList.contains(s)).forEach(resultList::add);
        N2oAccessFilter result = new N2oAccessFilter(filter.getFieldId(), FilterType.overlaps);
        result.setValues(resultList);
        res.add(result);
    }

    private static void inOverlap(N2oAccessFilter filter, N2oAccessFilter newFilter, List<N2oAccessFilter> res) {
        ArrayList<String> resultList = new ArrayList<String>(filter.getValues());
        newFilter.getValues().stream().filter(s -> !resultList.contains(s)).forEach(resultList::add);
        N2oAccessFilter result = new N2oAccessFilter(filter.getFieldId(), FilterType.overlaps);
        result.setValues(resultList);
        res.add(result);
    }

    private static void EqNotEq(N2oAccessFilter filter, N2oAccessFilter newFilter, List<N2oAccessFilter> res) {
        if (!Objects.equals(filter.getValue(), newFilter.getValue())) {
            res.add(newFilter);
        } else {
            res.add(new N2oAccessFilter(filter.getFieldId(), FilterType.infinite));
        }
    }

    private static void NotEqNotEq(N2oAccessFilter filter, N2oAccessFilter newFilter, List<N2oAccessFilter> res) {
        if (Objects.equals(filter.getValue(), newFilter.getValue())) {
            N2oAccessFilter result = new N2oAccessFilter(filter.getFieldId(), FilterType.notEq);
            result.setValue(filter.getValue());
            res.add(result);
        } else {
            res.add(new N2oAccessFilter(filter.getFieldId(), FilterType.infinite));
        }
    }

    private static void EqEq(N2oAccessFilter filter, N2oAccessFilter newFilter, List<N2oAccessFilter> res) {
        N2oAccessFilter result;
        if (Objects.equals(filter.getValue(), newFilter.getValue())) {
            result = new N2oAccessFilter(filter.getFieldId(), FilterType.eq);
            result.setValue(filter.getValue());
        } else {
            result = new N2oAccessFilter(filter.getFieldId(), FilterType.in);
            result.setValues(Arrays.asList(filter.getValue(), newFilter.getValue()));
        }
        res.add(result);
    }
}

