/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.access.simple;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.n2oapp.framework.access.api.model.filter.N2oAccessFilter;
import net.n2oapp.framework.access.functions.TripleFunction;
import net.n2oapp.framework.access.metadata.accesspoint.AccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oColumnAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oFilterAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oObjectAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oPageAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oReferenceAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oUrlAccessPoint;
import net.n2oapp.framework.access.metadata.schema.permission.N2oPermission;
import net.n2oapp.framework.access.metadata.schema.role.N2oRole;
import net.n2oapp.framework.access.metadata.schema.simple.SimpleCompiledAccessSchema;
import net.n2oapp.framework.access.metadata.schema.user.N2oUserAccess;
import net.n2oapp.framework.api.StringUtils;

public class PermissionAndRoleCollector {
    public static final BiFunction<String, String, Predicate<N2oObjectAccessPoint>> OBJECT_ACCESS = (objectId, actionId) -> ac -> StringUtils.maskMatch((String)ac.getObjectId(), (String)objectId) && (actionId == null || StringUtils.maskMatch((String)ac.getAction(), (String)actionId));
    public static final Function<String, Predicate<N2oUrlAccessPoint>> URL_ACCESS = pattern -> ac -> ac.getMatcher().matches((String)pattern);
    public static final Function<String, Predicate<N2oPageAccessPoint>> PAGE_ACCESS = pageId -> ac -> ac.getPage().equals(pageId);
    public static final Function<String, Predicate<N2oReferenceAccessPoint>> REFERENCE_ACCESS = objectId -> ac -> ac.getObjectId().equals(objectId);
    public static final TripleFunction<String, String, String, Predicate<N2oColumnAccessPoint>> COLUMN_ACCESS = (pageId, containerId, columnId) -> ac -> ac.getPageId().equals(pageId) && ac.getContainerId().equals(containerId) && ac.getColumnId().equals(columnId);
    public static final BiFunction<String, String, Predicate<N2oFilterAccessPoint>> FILTER_ACCESS = (queryId, filterId) -> ac -> ac.getQueryId().equals(queryId) && ac.getFilterId().equals(filterId);

    public static <A extends AccessPoint> List<N2oRole> collectRoles(Class<A> type, Predicate<A> predicate, SimpleCompiledAccessSchema schema) {
        return PermissionAndRoleCollector.collect(() -> schema.getN2oRoles(), N2oRole::getAccessPoints, type, predicate);
    }

    public static <A extends AccessPoint> List<N2oPermission> collectPermission(Class<A> type, Predicate<A> predicate, SimpleCompiledAccessSchema schema) {
        return PermissionAndRoleCollector.collect(() -> schema.getN2oPermissions(), N2oPermission::getAccessPoints, type, predicate);
    }

    public static <A extends AccessPoint> List<N2oUserAccess> collectUsers(Class<A> type, Predicate<A> predicate, SimpleCompiledAccessSchema schema) {
        return PermissionAndRoleCollector.collect(() -> schema.getN2oUserAccesses(), N2oUserAccess::getAccessPoints, type, predicate);
    }

    public static <T, A extends AccessPoint> List<T> collect(Supplier<List<T>> supplier, Function<T, AccessPoint[]> getter, Class<A> type, Predicate<A> predicate) {
        List<T> ts = supplier.get();
        if (ts == null || ts.size() == 0) {
            return Collections.emptyList();
        }
        return ts.stream().filter(p -> Arrays.stream((AccessPoint[])getter.apply(p)).filter(type::isInstance).map(type::cast).anyMatch(predicate)).collect(Collectors.toList());
    }

    public static List<N2oAccessFilter> collectFilters(Predicate<N2oRole> rolePredicate, Predicate<N2oPermission> permissionPredicate, Predicate<N2oUserAccess> userPredicate, String objectId, String actionId, SimpleCompiledAccessSchema schema) {
        List roles = PermissionAndRoleCollector.collectRoles(N2oObjectAccessPoint.class, OBJECT_ACCESS.apply(objectId, actionId), schema).stream().filter(rolePredicate).collect(Collectors.toList());
        List permissions = PermissionAndRoleCollector.collectPermission(N2oObjectAccessPoint.class, OBJECT_ACCESS.apply(objectId, actionId), schema).stream().filter(permissionPredicate).collect(Collectors.toList());
        List users = PermissionAndRoleCollector.collectUsers(N2oObjectAccessPoint.class, OBJECT_ACCESS.apply(objectId, actionId), schema).stream().filter(userPredicate).collect(Collectors.toList());
        ArrayList<N2oAccessFilter> filters = new ArrayList<N2oAccessFilter>();
        filters.addAll(PermissionAndRoleCollector.collectFilters(roles, N2oRole::getAccessPoints, objectId, actionId));
        filters.addAll(PermissionAndRoleCollector.collectFilters(permissions, N2oPermission::getAccessPoints, objectId, actionId));
        filters.addAll(PermissionAndRoleCollector.collectFilters(users, N2oUserAccess::getAccessPoints, objectId, actionId));
        return filters;
    }

    private static <T> List<N2oAccessFilter> collectFilters(List<T> list, Function<T, AccessPoint[]> getter, String objectId, String actionId) {
        return null;
    }
}

