/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.event.action.N2oAnchor;
import net.n2oapp.framework.api.metadata.event.action.N2oCloseAction;
import net.n2oapp.framework.api.metadata.global.view.action.control.Target;
import net.n2oapp.framework.api.metadata.meta.action.AbstractAction;
import net.n2oapp.framework.api.metadata.meta.action.ActionPayload;
import net.n2oapp.framework.api.metadata.meta.action.close.CloseAction;
import net.n2oapp.framework.api.metadata.meta.action.close.CloseActionPayload;
import net.n2oapp.framework.api.metadata.meta.saga.MetaSaga;
import net.n2oapp.framework.api.metadata.meta.saga.RedirectSaga;
import net.n2oapp.framework.api.metadata.meta.saga.RefreshSaga;
import net.n2oapp.framework.config.metadata.compile.action.AbstractActionCompiler;
import net.n2oapp.framework.config.metadata.compile.context.DialogContext;
import net.n2oapp.framework.config.metadata.compile.context.ModalPageContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import org.springframework.stereotype.Component;

@Component
public class CloseActionCompiler
extends AbstractActionCompiler<AbstractAction, N2oCloseAction> {
    public Class<? extends Source> getSourceClass() {
        return N2oCloseAction.class;
    }

    public AbstractAction compile(N2oCloseAction source, CompileContext<?, ?> context, CompileProcessor p) {
        if (context instanceof ModalPageContext || context instanceof DialogContext) {
            CloseAction closeAction = new CloseAction();
            this.compileAction(closeAction, source, p);
            closeAction.setType((String)p.resolve(Placeholders.property((String)"n2o.api.action.close.type"), String.class));
            closeAction.setMeta(this.initMeta(closeAction, source, context, p));
            CloseActionPayload payload = new CloseActionPayload();
            if (context instanceof ModalPageContext) {
                payload.setPageId(((PageContext)context).getClientPageId());
                payload.setPrompt((Boolean)p.cast((Object)((PageContext)context).getUnsavedDataPromptOnClose(), (Object)source.getPrompt(), new Object[]{true}));
            } else {
                payload.setPageId(((DialogContext)context).getParentWidgetId());
            }
            closeAction.setPayload((ActionPayload)payload);
            return closeAction;
        }
        N2oAnchor anchor = new N2oAnchor();
        if (source.getRedirectUrl() != null) {
            anchor.setHref(source.getRedirectUrl());
            anchor.setTarget(source.getRedirectTarget());
        } else if (context instanceof PageContext) {
            String backRoute = ((PageContext)context).getParentRoute();
            anchor.setHref((String)p.cast((Object)backRoute, (Object)"/", new Object[0]));
            anchor.setTarget(Target.application);
        } else {
            anchor.setHref("/");
            anchor.setTarget(Target.application);
        }
        return (AbstractAction)p.compile((Object)anchor, context, new Object[0]);
    }

    private MetaSaga initMeta(CloseAction closeAction, N2oCloseAction source, CompileContext<?, ?> context, CompileProcessor p) {
        boolean redirect;
        MetaSaga meta = new MetaSaga();
        boolean refresh = (Boolean)p.cast((Object)(Boolean.TRUE.equals(source.getRefreshOnClose()) || Boolean.TRUE.equals(source.getRefresh()) ? 1 : 0), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.action.close.refresh_on_close"), Boolean.class)), new Object[0]);
        boolean bl = redirect = source.getRedirectUrl() != null;
        if (!redirect && context instanceof ModalPageContext) {
            meta.setModalsToClose(Integer.valueOf(1));
        }
        if (refresh) {
            meta.setRefresh(new RefreshSaga());
            meta.getRefresh().setType(RefreshSaga.Type.widget);
            String refreshWidgetId = null;
            if (context instanceof PageContext) {
                refreshWidgetId = ((PageContext)context).getParentClientWidgetId();
            }
            meta.getRefresh().getOptions().setWidgetId(refreshWidgetId);
        }
        if (redirect) {
            meta.setRedirect(new RedirectSaga());
            meta.getRedirect().setPath(source.getRedirectUrl());
            meta.getRedirect().setTarget(source.getRedirectTarget());
        }
        return meta;
    }
}

