/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import java.util.Map;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.event.action.N2oShowModal;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.action.show_modal.ShowModal;
import net.n2oapp.framework.api.metadata.meta.action.show_modal.ShowModalPayload;
import net.n2oapp.framework.config.metadata.compile.action.AbstractOpenPageCompiler;
import net.n2oapp.framework.config.metadata.compile.context.ModalPageContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.register.route.RouteUtil;
import net.n2oapp.framework.config.util.StylesResolver;
import org.springframework.stereotype.Component;

@Component
public class ShowModalCompiler
extends AbstractOpenPageCompiler<ShowModal, N2oShowModal> {
    public Class<? extends Source> getSourceClass() {
        return N2oShowModal.class;
    }

    public ShowModal compile(N2oShowModal source, CompileContext<?, ?> context, CompileProcessor p) {
        ShowModal showModal = new ShowModal();
        showModal.setType((String)p.resolve(Placeholders.property((String)"n2o.api.action.show_modal.type"), String.class));
        showModal.setObjectId(source.getObjectId());
        showModal.setOperationId(source.getOperationId());
        showModal.setPageId(source.getPageId());
        this.compileAction(showModal, source, p);
        PageContext pageContext = this.initPageContext(showModal, source, context, p);
        this.compilePayload(showModal, source, pageContext, p);
        return showModal;
    }

    @Override
    protected PageContext constructContext(String pageId, String route) {
        ModalPageContext modalPageContext = new ModalPageContext(pageId, route);
        modalPageContext.setClientPageId(RouteUtil.convertPathToId(route));
        return modalPageContext;
    }

    @Override
    protected void initPageRoute(ShowModal compiled, String route, Map<String, ModelLink> pathMapping, Map<String, ModelLink> queryMapping) {
        ShowModalPayload payload = (ShowModalPayload)compiled.getPayload();
        String modalPageId = RouteUtil.convertPathToId(route);
        payload.setName(modalPageId);
        payload.setPageId(modalPageId);
        payload.setPageUrl(route);
        payload.setPathMapping(pathMapping);
        payload.setQueryMapping(queryMapping);
    }

    private void compilePayload(ShowModal showModal, N2oShowModal source, PageContext pageContext, CompileProcessor p) {
        ShowModalPayload payload = (ShowModalPayload)showModal.getPayload();
        payload.setSize((String)p.cast((Object)source.getModalSize(), (Object)((String)p.resolve(Placeholders.property((String)"n2o.api.action.show_modal.size"), String.class)), new Object[0]));
        payload.setScrollable((Boolean)p.cast((Object)source.getScrollable(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.action.show_modal.scrollable"), Boolean.class)), new Object[0]));
        payload.setCloseButton(Boolean.valueOf(true));
        payload.setPrompt(pageContext.getUnsavedDataPromptOnClose());
        payload.setHasHeader((Boolean)p.cast((Object)source.getHasHeader(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.action.show_modal.has_header"), Boolean.class)), new Object[0]));
        payload.setClassName(source.getClassName());
        String backdrop = (String)p.cast((Object)source.getBackdrop(), (Object)((String)p.resolve(Placeholders.property((String)"n2o.api.action.show_modal.backdrop"), String.class)), new Object[0]);
        payload.setBackdrop("true".equals(backdrop) || "false".equals(backdrop) ? Boolean.valueOf(backdrop) : backdrop);
        payload.setStyle(StylesResolver.resolveStyles(source.getStyle()));
    }
}

