/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import java.util.Set;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.N2oButtonField;
import net.n2oapp.framework.api.metadata.event.action.N2oAction;
import net.n2oapp.framework.api.metadata.global.view.ActionsBar;
import net.n2oapp.framework.api.metadata.global.view.action.LabelType;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oForm;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.Confirm;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.ConfirmType;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.api.metadata.meta.action.LinkAction;
import net.n2oapp.framework.api.metadata.meta.action.invoke.InvokeAction;
import net.n2oapp.framework.api.metadata.meta.control.ButtonField;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.control.FieldCompiler;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetObjectScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import org.springframework.stereotype.Component;

@Component
public class ButtonFieldCompiler
extends FieldCompiler<ButtonField, N2oButtonField> {
    public Class<? extends Source> getSourceClass() {
        return N2oButtonField.class;
    }

    public ButtonField compile(N2oButtonField source, CompileContext<?, ?> context, CompileProcessor p) {
        ButtonField field = new ButtonField();
        this.compileField(field, source, context, p);
        field.setColor(source.getColor());
        this.initItem(field, source, context, p);
        if (source.getValidate() != null && source.getValidate().booleanValue()) {
            field.setValidatedWidgetId(this.initWidgetId(source, context, p));
        }
        return field;
    }

    @Override
    protected String getSrcProperty() {
        return "n2o.api.control.button_field.src";
    }

    protected void initItem(ButtonField button, N2oButtonField source, CompileContext<?, ?> context, CompileProcessor p) {
        button.setProperties(p.mapAttributes((ExtensionAttributesAware)source));
        if (source.getType() != null && source.getType() == LabelType.icon) {
            button.setLabel(null);
            button.setIcon(source.getIcon());
        } else if (source.getType() != null && source.getType() == LabelType.text) {
            button.setLabel(source.getLabel());
        } else {
            button.setIcon(source.getIcon());
            button.setLabel(source.getLabel());
        }
        CompiledObject.Operation operation = null;
        Action action = null;
        WidgetObjectScope widgetObjectScope = (WidgetObjectScope)p.getScope(WidgetObjectScope.class);
        CompiledObject compiledObject = widgetObjectScope != null && widgetObjectScope.containsKey(source.getWidgetId()) ? widgetObjectScope.getObject(source.getWidgetId()) : (CompiledObject)p.getScope(CompiledObject.class);
        if (source.getActionId() != null) {
            ComponentScope scope = (ComponentScope)p.getScope(ComponentScope.class);
            N2oAction act = this.getAction(scope, source.getActionId());
            if (act != null) {
                act.setId(button.getId());
                action = (Action)p.compile((Object)act, context, new Object[]{compiledObject, scope});
            }
        } else {
            N2oAction butAction = source.getAction();
            if (butAction != null) {
                butAction.setId((String)p.cast((Object)butAction.getId(), (Object)button.getId(), new Object[0]));
                action = (Action)p.compile((Object)butAction, context, new Object[]{compiledObject, new ComponentScope(source)});
            }
        }
        if (action != null) {
            button.setAction(action);
            if (action instanceof InvokeAction) {
                operation = compiledObject != null && compiledObject.getOperations() != null && compiledObject.getOperations().containsKey(((InvokeAction)action).getOperationId()) ? (CompiledObject.Operation)compiledObject.getOperations().get(((InvokeAction)action).getOperationId()) : null;
            } else if (action instanceof LinkAction) {
                LinkAction linkAction = (LinkAction)button.getAction();
                button.setUrl(linkAction.getUrl());
                button.setTarget(linkAction.getTarget());
                button.setPathMapping(linkAction.getPathMapping());
                button.setQueryMapping(linkAction.getQueryMapping());
            }
        }
        this.initConfirm(button, source, context, p, operation);
        String hint = LabelType.icon.equals((Object)source.getType()) ? (String)p.cast((Object)source.getDescription(), (Object)source.getLabel(), new Object[0]) : source.getDescription();
        if (hint != null) {
            button.setHint(hint.trim());
            button.setHintPosition(source.getTooltipPosition());
        }
        if (source.getModel() == null) {
            source.setModel(ReduxModel.RESOLVE);
        }
        button.setValidate(source.getValidate());
    }

    private N2oAction getAction(ComponentScope scope, String actionId) {
        N2oForm form;
        if (scope != null && (form = scope.unwrap(N2oForm.class)) != null && form.getActions() != null) {
            for (ActionsBar act : form.getActions()) {
                if (!actionId.equals(act.getId())) continue;
                return act.getAction();
            }
        }
        return null;
    }

    private void initConfirm(ButtonField button, N2oButtonField source, CompileContext<?, ?> context, CompileProcessor p, CompiledObject.Operation operation) {
        if (!(source.getConfirm() != null && source.getConfirm().booleanValue() || source.getConfirm() == null && operation != null && operation.getConfirm() != null && operation.getConfirm().booleanValue())) {
            return;
        }
        Confirm confirm = new Confirm();
        confirm.setMode((ConfirmType)p.cast((Object)source.getConfirmType(), (Object)ConfirmType.modal, new Object[0]));
        confirm.setText((String)p.cast((Object)source.getConfirmText(), (Object)(operation != null ? operation.getConfirmationText() : null), new Object[]{p.getMessage("n2o.confirm.text", new Object[0])}));
        confirm.setTitle((String)p.cast((Object)source.getConfirmTitle(), (Object)(operation != null ? operation.getFormSubmitLabel() : null), new Object[]{p.getMessage("n2o.confirm.title", new Object[0])}));
        confirm.setOkLabel((String)p.cast((Object)source.getConfirmOkLabel(), (Object)p.getMessage("n2o.confirm.default.okLabel", new Object[0]), new Object[0]));
        confirm.setCancelLabel((String)p.cast((Object)source.getConfirmCancelLabel(), (Object)p.getMessage("n2o.confirm.default.cancelLabel", new Object[0]), new Object[0]));
        if (StringUtils.hasLink((String)confirm.getText())) {
            Set links = StringUtils.collectLinks((String)confirm.getText());
            String text = Placeholders.js((String)("'" + confirm.getText() + "'"));
            for (String link : links) {
                text = text.replace(Placeholders.ref((String)link), "' + this." + link + " + '");
            }
            confirm.setText(text);
        }
        if (StringUtils.isJs((Object)confirm.getText())) {
            String widgetId = this.initWidgetId(source, context, p);
            ReduxModel reduxModel = source.getModel();
            confirm.setModelLink(new ModelLink(reduxModel == null ? ReduxModel.RESOLVE : reduxModel, widgetId).getBindLink());
        }
        button.setConfirm(confirm);
    }

    protected String initWidgetId(N2oButtonField source, CompileContext<?, ?> context, CompileProcessor p) {
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        if (source.getWidgetId() != null) {
            return pageScope == null ? source.getWidgetId() : pageScope.getGlobalWidgetId(source.getWidgetId());
        }
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (widgetScope != null) {
            return widgetScope.getClientWidgetId();
        }
        if (context instanceof PageContext && ((PageContext)context).getResultWidgetId() != null) {
            return pageScope.getGlobalWidgetId(((PageContext)context).getResultWidgetId());
        }
        throw new N2oException("Unknown widgetId for invoke action!");
    }
}

