/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.N2oImageField;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.ImageStatusElement;
import net.n2oapp.framework.api.metadata.meta.control.ImageField;
import net.n2oapp.framework.api.metadata.meta.control.TextPosition;
import net.n2oapp.framework.config.metadata.compile.control.FieldCompiler;
import org.springframework.stereotype.Component;

@Component
public class ImageFieldCompiler
extends FieldCompiler<ImageField, N2oImageField> {
    public Class<? extends Source> getSourceClass() {
        return N2oImageField.class;
    }

    public ImageField compile(N2oImageField source, CompileContext<?, ?> context, CompileProcessor p) {
        ImageField imageField = new ImageField();
        this.compileField(imageField, source, context, p);
        imageField.setUrl(p.resolveJS(source.getUrl()));
        imageField.setData(p.resolveJS(source.getData()));
        imageField.setTitle(p.resolveJS(source.getTitle()));
        imageField.setDescription(p.resolveJS(source.getDescription()));
        imageField.setTextPosition((TextPosition)p.cast((Object)source.getTextPosition(), (Object)((TextPosition)p.resolve(Placeholders.property((String)"n2o.api.field.image_field.text_position"), TextPosition.class)), new Object[0]));
        imageField.setWidth((String)p.cast((Object)source.getWidth(), (Object)((String)p.resolve(Placeholders.property((String)"n2o.api.field.image_field.width"), String.class)), new Object[0]));
        imageField.setStatuses(this.compileStatuses(source.getStatuses(), p));
        return imageField;
    }

    private ImageStatusElement[] compileStatuses(ImageStatusElement[] statuses, CompileProcessor p) {
        if (statuses == null) {
            return null;
        }
        int i = 0;
        ImageStatusElement[] statusElements = new ImageStatusElement[statuses.length];
        for (ImageStatusElement e : statuses) {
            ImageStatusElement statusElement = new ImageStatusElement();
            statusElement.setSrc((String)p.cast((Object)e.getSrc(), (Object)"Status", new Object[0]));
            statusElement.setFieldId(e.getFieldId());
            statusElement.setIcon(p.resolveJS(e.getIcon()));
            statusElement.setPlace((ImageStatusElement.Place)p.cast((Object)e.getPlace(), (Object)((ImageStatusElement.Place)p.resolve(Placeholders.property((String)"n2o.api.field.image.status_place"), ImageStatusElement.Place.class)), new Object[0]));
            statusElements[i++] = statusElement;
        }
        return statusElements;
    }

    @Override
    protected String getSrcProperty() {
        return "n2o.api.field.image_field.src";
    }
}

