/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.plain.N2oInputText;
import net.n2oapp.framework.api.metadata.domain.Domain;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.control.InputText;
import net.n2oapp.framework.api.metadata.meta.control.StandardField;
import net.n2oapp.framework.config.metadata.compile.control.StandardFieldCompiler;
import org.springframework.stereotype.Component;

@Component
public class InputTextCompiler
extends StandardFieldCompiler<InputText, N2oInputText> {
    @Override
    protected String getControlSrcProperty() {
        return "n2o.api.control.input.number.src";
    }

    public Class<? extends Source> getSourceClass() {
        return N2oInputText.class;
    }

    public StandardField<InputText> compile(N2oInputText source, CompileContext<?, ?> context, CompileProcessor p) {
        InputText inputText = new InputText();
        inputText.setPlaceholder(p.resolveJS(source.getPlaceholder()));
        inputText.setMeasure(source.getMeasure());
        this.compileDomain(inputText, source, p);
        if (source.getStep() != null && source.getStep().replace(",", "").replace(".", "").replace("0", "").isEmpty()) {
            inputText.setShowButtons(Boolean.valueOf(false));
        }
        return this.compileStandardField(inputText, source, context, p);
    }

    private void compileDomain(InputText inputText, N2oInputText source, CompileProcessor p) {
        Domain domain = Domain.getByName((String)source.getDomain());
        if (domain == null) {
            domain = Domain.STRING;
        }
        switch (domain) {
            case INTEGER: {
                inputText.setMin(p.cast(p.resolveJS(source.getMin(), Integer.class), (Object)Integer.MIN_VALUE, new Object[0]));
                inputText.setMax(p.cast(p.resolveJS(source.getMax(), Integer.class), (Object)Integer.MAX_VALUE, new Object[0]));
                inputText.setStep(CompileUtil.castDefault((String)source.getStep(), (String)"1", (String[])new String[0]));
                return;
            }
            case LONG: {
                inputText.setMin(p.cast(p.resolveJS(source.getMin(), Long.class), (Object)"-99999999999999", new Object[0]));
                inputText.setMax(p.cast(p.resolveJS(source.getMax(), Long.class), (Object)"99999999999999", new Object[0]));
                inputText.setStep(CompileUtil.castDefault((String)source.getStep(), (String)"1", (String[])new String[0]));
                return;
            }
            case SHORT: {
                inputText.setMin(p.cast(p.resolveJS(source.getMin(), Short.class), (Object)Short.MIN_VALUE, new Object[0]));
                inputText.setMax(p.cast(p.resolveJS(source.getMax(), Short.class), (Object)Short.MAX_VALUE, new Object[0]));
                inputText.setStep(CompileUtil.castDefault((String)source.getStep(), (String)"1", (String[])new String[0]));
                return;
            }
            case NUMERIC: {
                inputText.setMin(p.cast(p.resolveJS(source.getMin(), Long.class), (Object)"-999999999", new Object[0]));
                inputText.setMax(p.cast(p.resolveJS(source.getMax(), Long.class), (Object)"999999999", new Object[0]));
                inputText.setStep(CompileUtil.castDefault((String)source.getStep(), (String)"0.01", (String[])new String[0]));
                inputText.setPrecision((Integer)p.cast((Object)source.getPrecision(), (Object)((Integer)p.resolve(Placeholders.property((String)"n2o.api.control.input.text.precision"), Integer.class)), new Object[0]));
                return;
            }
            case STRING: {
                inputText.setLength(source.getLength());
                inputText.setSrc((String)p.cast((Object)source.getSrc(), (Object)((String)p.resolve(Placeholders.property((String)"n2o.api.control.input.text.src"), String.class)), new Object[0]));
                return;
            }
        }
    }
}

