/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.page;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.SourceComponent;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.event.action.SubmitActionType;
import net.n2oapp.framework.api.metadata.global.N2oMetadata;
import net.n2oapp.framework.api.metadata.global.view.ActionsBar;
import net.n2oapp.framework.api.metadata.global.view.page.BasePageUtil;
import net.n2oapp.framework.api.metadata.global.view.page.GenerateType;
import net.n2oapp.framework.api.metadata.global.view.page.N2oBasePage;
import net.n2oapp.framework.api.metadata.global.view.page.N2oPage;
import net.n2oapp.framework.api.metadata.global.view.region.N2oCustomRegion;
import net.n2oapp.framework.api.metadata.global.view.region.N2oRegion;
import net.n2oapp.framework.api.metadata.global.view.region.N2oTabsRegion;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oGroup;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oSubmenu;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.ToolbarItem;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.util.StrictMap;
import net.n2oapp.framework.api.metadata.meta.BreadcrumbList;
import net.n2oapp.framework.api.metadata.meta.Models;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.api.metadata.meta.page.PageRoutes;
import net.n2oapp.framework.api.metadata.meta.page.StandardPage;
import net.n2oapp.framework.api.metadata.meta.region.Region;
import net.n2oapp.framework.api.metadata.meta.toolbar.Toolbar;
import net.n2oapp.framework.api.metadata.meta.widget.Widget;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.PageRoutesScope;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.ValidationList;
import net.n2oapp.framework.config.metadata.compile.context.ObjectContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.page.PageCompiler;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.toolbar.ToolbarPlaceScope;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.PageWidgetsScope;
import net.n2oapp.framework.config.metadata.compile.widget.SearchBarScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetObjectScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.register.route.RouteUtil;
import org.springframework.util.CollectionUtils;

public abstract class BasePageCompiler<S extends N2oBasePage, D extends StandardPage>
extends PageCompiler<S, D> {
    protected abstract void initRegions(S var1, D var2, CompileProcessor var3, PageContext var4, PageScope var5, PageRoutes var6, PageWidgetsScope var7);

    public D compilePage(S source, D page, PageContext context, CompileProcessor p, SourceComponent[] items, SearchBarScope searchBarScope) {
        List<N2oWidget> sourceWidgets = this.collectWidgets(items);
        String pageRoute = this.initPageRoute((N2oPage)source, context, p);
        page.setId((String)p.cast((Object)context.getClientPageId(), (Object)RouteUtil.convertPathToId(pageRoute), new Object[0]));
        PageScope pageScope = new PageScope();
        pageScope.setPageId(page.getId());
        N2oWidget resultWidget = this.initResultWidget(context, sourceWidgets);
        if (context.getSubmitOperationId() != null || SubmitActionType.copy.equals((Object)context.getSubmitActionType())) {
            pageScope.setObjectId(source.getObjectId());
            pageScope.setResultWidgetId(resultWidget == null ? null : resultWidget.getId());
        }
        String pageName = (String)p.cast((Object)context.getPageName(), (Object)source.getName(), new Object[0]);
        boolean showTitle = (Boolean)p.cast((Object)source.getShowTitle(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.default.page.show_title"), Boolean.class)), new Object[]{false});
        page.setPageProperty(this.initPageName(pageName, showTitle, context, p));
        page.setProperties(p.mapAttributes(source));
        BreadcrumbList breadcrumb = this.initBreadcrumb(pageName, context, p);
        page.setBreadcrumb((List)breadcrumb);
        Models models = new Models();
        page.setModels(models);
        PageRoutes pageRoutes = new PageRoutes();
        pageRoutes.addRoute(new PageRoutes.Route(pageRoute));
        if (resultWidget != null) {
            this.initDefaults(context, resultWidget);
        }
        ParentRouteScope routeScope = new ParentRouteScope(pageRoute, context.getPathRouteMapping(), context.getQueryRouteMapping());
        ValidationList validationList = new ValidationList(new HashMap<ReduxModel, Map<String, List<Validation>>>());
        PageRoutesScope pageRoutesScope = new PageRoutesScope();
        WidgetObjectScope widgetObjectScope = new WidgetObjectScope();
        if (!CollectionUtils.isEmpty(sourceWidgets)) {
            pageScope.setWidgetIdQueryIdMap(sourceWidgets.stream().filter(w -> w.getQueryId() != null).collect(Collectors.toMap(N2oMetadata::getId, N2oWidget::getQueryId)));
        }
        Map<String, Widget> compiledWidgets = this.initWidgets(routeScope, pageRoutes, sourceWidgets, context, p, pageScope, breadcrumb, validationList, models, pageRoutesScope, widgetObjectScope, searchBarScope);
        this.registerRoutes(pageRoutes, context, p);
        page.setRoutes(pageRoutes);
        this.initRegions(source, page, p, context, pageScope, pageRoutes, new PageWidgetsScope(compiledWidgets));
        CompiledObject object = source.getObjectId() != null ? (CompiledObject)p.getCompiled((CompileContext)new ObjectContext(source.getObjectId())) : null;
        page.setObject(object);
        page.setSrc((String)p.cast((Object)source.getSrc(), (Object)((String)p.resolve(Placeholders.property((String)this.getPropertyPageSrc()), String.class)), new Object[0]));
        page.setProperties(p.mapAttributes(source));
        if (context.getSubmitOperationId() != null || SubmitActionType.copy.equals((Object)context.getSubmitActionType())) {
            this.initToolbarGenerate(source, resultWidget == null ? null : resultWidget.getId());
        }
        MetaActions metaActions = new MetaActions();
        this.compileToolbarAndAction((StandardPage)page, source, context, p, metaActions, pageScope, routeScope, pageRoutes, object, breadcrumb, validationList, compiledWidgets, widgetObjectScope);
        page.setActions((Map)metaActions);
        return page;
    }

    protected List<N2oWidget> collectWidgets(SourceComponent[] items) {
        ArrayList<N2oWidget> result = new ArrayList<N2oWidget>();
        if (items != null) {
            HashMap<String, Integer> ids = new HashMap<String, Integer>();
            this.addWidgets(items, result, ids, "w");
        }
        return result;
    }

    private void addWidgets(SourceComponent[] items, List<N2oWidget> result, Map<String, Integer> ids, String prefix) {
        if (!ids.containsKey(prefix)) {
            ids.put(prefix, 1);
        }
        for (SourceComponent item : items) {
            if (item instanceof N2oWidget) {
                N2oWidget widget = (N2oWidget)item;
                if (widget.getId() == null) {
                    widget.setId(prefix + ids.put(prefix, ids.get(prefix) + 1));
                }
                result.add(widget);
                continue;
            }
            if (item instanceof N2oTabsRegion) {
                if (((N2oTabsRegion)item).getTabs() == null) continue;
                for (N2oTabsRegion.Tab tab : ((N2oTabsRegion)item).getTabs()) {
                    if (tab.getContent() == null) continue;
                    this.addWidgets(tab.getContent(), result, ids, ((N2oTabsRegion)item).getAlias());
                }
                continue;
            }
            if (!(item instanceof N2oRegion) || ((N2oRegion)item).getContent() == null) continue;
            this.addWidgets(((N2oRegion)item).getContent(), result, ids, ((N2oRegion)item).getAlias());
        }
    }

    protected void initRegions(SourceComponent[] pageItems, Map<String, List<Region>> regionMap, String defaultPlace, PageContext context, CompileProcessor p, Object ... scopes) {
        if (pageItems == null) {
            return;
        }
        ArrayList<N2oWidget> widgets = new ArrayList<N2oWidget>();
        BasePageUtil.resolveRegionItems((SourceComponent[])pageItems, item -> {
            if (!widgets.isEmpty()) {
                this.createCustomRegion(widgets, regionMap, defaultPlace, context, p, scopes);
            }
            this.createRegion((N2oRegion)item, regionMap, defaultPlace, context, p, scopes);
        }, widgets::add);
        if (!widgets.isEmpty()) {
            this.createCustomRegion(widgets, regionMap, defaultPlace, context, p, scopes);
        }
    }

    private void createCustomRegion(List<N2oWidget> widgets, Map<String, List<Region>> regionMap, String defaultPlace, PageContext context, CompileProcessor p, Object ... scopes) {
        N2oCustomRegion n2oRegion = new N2oCustomRegion();
        N2oWidget[] content = new N2oWidget[widgets.size()];
        widgets.toArray(content);
        n2oRegion.setContent((SourceComponent[])content);
        this.createRegion((N2oRegion)n2oRegion, regionMap, defaultPlace, context, p, scopes);
        widgets.clear();
    }

    private void createRegion(N2oRegion n2oRegion, Map<String, List<Region>> regionMap, String defaultPlace, PageContext context, CompileProcessor p, Object ... scopes) {
        Region region = (Region)p.compile((Object)n2oRegion, (CompileContext)context, scopes);
        String place = (String)p.cast((Object)n2oRegion.getPlace(), (Object)defaultPlace, new Object[0]);
        if (regionMap.get(place) != null) {
            regionMap.get(place).add(region);
        } else {
            ArrayList<Region> regionList = new ArrayList<Region>();
            regionList.add(region);
            regionMap.put(place, regionList);
        }
    }

    private void initDefaults(PageContext context, N2oWidget resultWidget) {
        if (resultWidget != null && (context.getPreFilters() != null && !context.getPreFilters().isEmpty() || context.getUpload() != null)) {
            resultWidget.addPreFilters(context.getPreFilters());
            resultWidget.setUpload(context.getUpload());
        }
    }

    private N2oWidget initResultWidget(PageContext context, List<N2oWidget> sourceWidgets) {
        String resultWidgetId = context.getResultWidgetId();
        if (resultWidgetId != null) {
            for (N2oWidget sourceWidget : sourceWidgets) {
                if (!resultWidgetId.equals(sourceWidget.getId())) continue;
                return sourceWidget;
            }
            throw new N2oException("Widget " + resultWidgetId + " not found!");
        }
        List<N2oWidget> sourceIndependents = this.getSourceIndependents(sourceWidgets);
        if (!sourceIndependents.isEmpty()) {
            return sourceIndependents.get(0);
        }
        return null;
    }

    private void compileToolbarAndAction(StandardPage compiled, S source, PageContext context, CompileProcessor p, MetaActions metaActions, PageScope pageScope, ParentRouteScope routeScope, PageRoutes pageRoutes, CompiledObject object, BreadcrumbList breadcrumbs, ValidationList validationList, Map<String, Widget> widgets, WidgetObjectScope widgetObjectScope) {
        this.actionsToToolbar(source);
        compiled.setToolbar(this.compileToolbar(source, context, p, metaActions, pageRoutes, object, breadcrumbs, validationList, pageScope, routeScope, widgetObjectScope));
        this.compileActions(source, context, p, metaActions, pageScope, routeScope, pageRoutes, breadcrumbs, object, validationList, widgets);
    }

    private void actionsToToolbar(S source) {
        if (source.getActions() == null || source.getToolbars() == null) {
            return;
        }
        HashMap<String, ActionsBar> actionMap = new HashMap<String, ActionsBar>();
        Stream.of(source.getActions()).forEach(a -> actionMap.put(a.getId(), (ActionsBar)a));
        for (N2oToolbar toolbar : source.getToolbars()) {
            if (toolbar.getItems() == null) continue;
            ToolbarItem[] toolbarItems = toolbar.getItems();
            this.copyActionForToolbarItem(actionMap, toolbarItems);
        }
    }

    private void copyActionForToolbarItem(Map<String, ActionsBar> actionMap, ToolbarItem[] toolbarItems) {
        for (ToolbarItem item : toolbarItems) {
            if (item instanceof N2oButton) {
                this.copyAction((N2oButton)item, actionMap);
                continue;
            }
            if (item instanceof N2oSubmenu) {
                for (N2oButton subItem : ((N2oSubmenu)item).getMenuItems()) {
                    this.copyAction(subItem, actionMap);
                }
                continue;
            }
            if (!(item instanceof N2oGroup)) continue;
            this.copyActionForToolbarItem(actionMap, (ToolbarItem[])((N2oGroup)item).getItems());
        }
    }

    private void copyAction(N2oButton item, Map<String, ActionsBar> actionMap) {
        if (item.getAction() == null && item.getActionId() != null) {
            ActionsBar actionsBar = actionMap.get(item.getActionId());
            if (actionsBar == null) {
                throw new N2oException("Toolbar has reference to nonexistent action by actionId {0}!").addData(new Object[]{item.getActionId()});
            }
            item.setAction(actionsBar.getAction());
            if (item.getModel() == null) {
                item.setModel(actionsBar.getModel());
            }
            if (item.getWidgetId() == null) {
                item.setWidgetId(actionsBar.getWidgetId());
            }
            if (item.getLabel() == null) {
                item.setLabel(actionsBar.getLabel());
            }
            if (item.getIcon() == null) {
                item.setIcon(actionsBar.getIcon());
            }
        }
    }

    private Toolbar compileToolbar(S source, PageContext context, CompileProcessor p, MetaActions metaActions, PageRoutes pageRoutes, CompiledObject object, BreadcrumbList breadcrumbs, ValidationList validationList, Object ... scopes) {
        if (source.getToolbars() == null) {
            return null;
        }
        ToolbarPlaceScope toolbarPlaceScope = new ToolbarPlaceScope((String)p.resolve(Placeholders.property((String)"n2o.api.page.toolbar.place"), String.class));
        Toolbar toolbar = new Toolbar();
        for (N2oToolbar n2oToolbar : source.getToolbars()) {
            toolbar.putAll((Map)p.compile((Object)n2oToolbar, (CompileContext)context, new Object[]{metaActions, pageRoutes, object, breadcrumbs, validationList, new IndexScope(), toolbarPlaceScope, scopes}));
        }
        return toolbar;
    }

    private Map<String, Widget> initWidgets(ParentRouteScope routeScope, PageRoutes pageRoutes, List<N2oWidget> sourceWidgets, PageContext context, CompileProcessor p, PageScope pageScope, BreadcrumbList breadcrumbs, ValidationList validationList, Models models, PageRoutesScope pageRoutesScope, WidgetObjectScope widgetObjectScope, SearchBarScope searchBarScope) {
        StrictMap compiledWidgets = new StrictMap();
        IndexScope indexScope = new IndexScope();
        List<N2oWidget> independents = this.getSourceIndependents(sourceWidgets);
        if (searchBarScope != null && searchBarScope.getWidgetId() == null) {
            searchBarScope.setWidgetId(independents.get(0).getId());
        }
        independents.forEach(arg_0 -> this.lambda$initWidgets$3(pageRoutes, routeScope, sourceWidgets, (Map)compiledWidgets, context, p, breadcrumbs, validationList, models, indexScope, searchBarScope, pageScope, pageRoutesScope, widgetObjectScope, arg_0));
        return compiledWidgets;
    }

    private void compileWidget(N2oWidget w, PageRoutes routes, ParentRouteScope parentRoute, String parentWidgetId, String parentQueryId, List<N2oWidget> sourceWidgets, Map<String, Widget> compiledWidgets, PageContext context, CompileProcessor p, BreadcrumbList breadcrumbs, ValidationList validationList, Models models, IndexScope indexScope, SearchBarScope searchBarScope, Object ... scopes) {
        WidgetScope widgetScope = new WidgetScope();
        widgetScope.setDependsOnWidgetId(parentWidgetId);
        widgetScope.setDependsOnQueryId(parentQueryId);
        Widget compiledWidget = (Widget)p.compile((Object)w, (CompileContext)context, new Object[]{indexScope, routes, widgetScope, parentRoute, breadcrumbs, validationList, models, searchBarScope, scopes});
        compiledWidgets.put(compiledWidget.getId(), compiledWidget);
        ParentRouteScope parentRouteScope = new ParentRouteScope(compiledWidget.getRoute(), parentRoute);
        this.getDetails(w.getId(), sourceWidgets).forEach(detWgt -> this.compileWidget((N2oWidget)detWgt, routes, parentRouteScope, compiledWidget.getId(), compiledWidget.getQueryId(), sourceWidgets, compiledWidgets, context, p, breadcrumbs, validationList, models, indexScope, searchBarScope, scopes));
    }

    private void initToolbarGenerate(S source, String resultWidgetId) {
        N2oToolbar n2oToolbar = new N2oToolbar();
        String[] generate = new String[]{GenerateType.submit.name(), GenerateType.close.name()};
        n2oToolbar.setGenerate(generate);
        n2oToolbar.setTargetWidgetId(resultWidgetId);
        if (source.getToolbars() == null) {
            source.setToolbars(new N2oToolbar[0]);
        }
        int length = source.getToolbars().length;
        N2oToolbar[] n2oToolbars = new N2oToolbar[length + 1];
        System.arraycopy(source.getToolbars(), 0, n2oToolbars, 0, length);
        n2oToolbars[length] = n2oToolbar;
        source.setToolbars(n2oToolbars);
    }

    private List<N2oWidget> getSourceIndependents(List<N2oWidget> sourceWidgets) {
        ArrayList<N2oWidget> independents = new ArrayList<N2oWidget>();
        for (N2oWidget widget : sourceWidgets) {
            if (widget.getDependsOn() != null) continue;
            independents.add(widget);
        }
        return independents;
    }

    private List<N2oWidget> getDetails(String widgetId, List<N2oWidget> widgets) {
        ArrayList<N2oWidget> details = new ArrayList<N2oWidget>();
        for (N2oWidget widget : widgets) {
            if (widget.getDependsOn() == null || !widget.getDependsOn().equals(widgetId)) continue;
            details.add(widget);
        }
        return details;
    }

    private void compileActions(S source, PageContext context, CompileProcessor p, MetaActions actions, PageScope pageScope, ParentRouteScope routeScope, PageRoutes pageRoutes, BreadcrumbList breadcrumbs, CompiledObject object, ValidationList validationList, Map<String, Widget> widgets) {
        if (source.getActions() != null) {
            Stream.of(source.getActions()).forEach(a -> {
                a.getAction().setId(a.getId());
                Widget widget = null;
                CompiledObject compiledObject = object;
                if (widgets.containsKey(a.getWidgetId())) {
                    widget = (Widget)widgets.get(a.getWidgetId());
                }
                if (widget != null) {
                    compiledObject = new CompiledObject();
                    compiledObject.setId(widget.getObjectId());
                }
                Action action = (Action)p.compile((Object)a.getAction(), (CompileContext)context, new Object[]{pageScope, routeScope, pageRoutes, compiledObject, breadcrumbs, validationList, new ComponentScope(a)});
                actions.addAction(a.getId(), action);
            });
        }
    }

    private /* synthetic */ void lambda$initWidgets$3(PageRoutes pageRoutes, ParentRouteScope routeScope, List sourceWidgets, Map compiledWidgets, PageContext context, CompileProcessor p, BreadcrumbList breadcrumbs, ValidationList validationList, Models models, IndexScope indexScope, SearchBarScope searchBarScope, PageScope pageScope, PageRoutesScope pageRoutesScope, WidgetObjectScope widgetObjectScope, N2oWidget w) {
        this.compileWidget(w, pageRoutes, routeScope, null, null, sourceWidgets, compiledWidgets, context, p, breadcrumbs, validationList, models, indexScope, searchBarScope, pageScope, pageRoutesScope, widgetObjectScope);
    }
}

