/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.page;

import java.util.HashMap;
import java.util.List;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.meta.BindLink;
import net.n2oapp.framework.api.metadata.meta.Breadcrumb;
import net.n2oapp.framework.api.metadata.meta.Filter;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.Models;
import net.n2oapp.framework.api.metadata.meta.control.DefaultValues;
import net.n2oapp.framework.api.metadata.meta.page.Page;
import net.n2oapp.framework.api.metadata.meta.page.PageRoutes;
import net.n2oapp.framework.api.metadata.meta.widget.Widget;
import net.n2oapp.framework.config.metadata.compile.BaseMetadataBinder;
import net.n2oapp.framework.config.metadata.compile.redux.Redux;

public abstract class PageBinder<D extends Page>
implements BaseMetadataBinder<D> {
    public D bindPage(D page, BindProcessor p, List<Widget> widgets) {
        if (widgets != null) {
            widgets.forEach(arg_0 -> ((BindProcessor)p).bind(arg_0));
        }
        if (page.getRoutes() != null) {
            HashMap pathMappings = new HashMap();
            page.getRoutes().getPathMapping().forEach((k, v) -> pathMappings.put(k, Redux.createBindLink(v)));
            for (PageRoutes.Route route : page.getRoutes().getList()) {
                route.setPath(p.resolveUrl(route.getPath(), pathMappings, null));
            }
            if (page.getRoutes().getQueryMapping() != null) {
                if (page.getModels() == null) {
                    page.setModels(new Models());
                }
                HashMap resolvedModelLinks = new HashMap();
                page.getRoutes().getQueryMapping().keySet().stream().filter(param -> ((PageRoutes.Query)page.getRoutes().getQueryMapping().get(param)).getOnSet() instanceof ModelLink).forEach(param -> resolvedModelLinks.put(param, (ModelLink)p.resolveLink(((PageRoutes.Query)page.getRoutes().getQueryMapping().get(param)).getOnSet())));
                resolvedModelLinks.keySet().stream().filter(param -> ((ModelLink)resolvedModelLinks.get(param)).isConst() && ((ModelLink)resolvedModelLinks.get(param)).isLink()).forEach(param -> {
                    ModelLink modelLink = (ModelLink)resolvedModelLinks.get(param);
                    if (modelLink.getSubModelQuery() == null) {
                        page.getModels().add(modelLink.getModel(), modelLink.getWidgetId(), modelLink.getFieldId(), modelLink);
                    } else {
                        page.getModels().add(modelLink.getModel(), modelLink.getWidgetId(), modelLink.getFieldId(), (ModelLink)((PageRoutes.Query)page.getRoutes().getQueryMapping().get(param)).getOnSet());
                    }
                });
            }
        }
        if (page.getBreadcrumb() != null) {
            page.getBreadcrumb().stream().filter(b -> b.getPath() != null).forEach(b -> {
                b.setPath(p.resolveUrl(b.getPath()));
                b.setLabel(p.resolveText(b.getLabel(), b.getModelLink()));
            });
        }
        if (page.getModels() != null) {
            page.getModels().values().forEach(bl -> {
                if (bl.getValue() instanceof String) {
                    bl.setValue((Object)p.resolveText((String)bl.getValue()));
                } else if (bl.getValue() instanceof DefaultValues) {
                    DefaultValues dv = (DefaultValues)bl.getValue();
                    for (String key : dv.getValues().keySet()) {
                        if (!(dv.getValues().get(key) instanceof String)) continue;
                        dv.getValues().put(key, p.resolveText((String)dv.getValues().get(key)));
                    }
                }
            });
            this.collectFiltersToModels(page.getModels(), widgets);
            this.resolveLinks(page.getModels(), p);
        }
        if (page.getPageProperty() != null) {
            page.getPageProperty().setTitle(p.resolveText(page.getPageProperty().getTitle(), page.getPageProperty().getModelLink()));
            page.getPageProperty().setHtmlTitle(p.resolveText(page.getPageProperty().getHtmlTitle(), page.getPageProperty().getModelLink()));
            page.getPageProperty().setHeaderTitle(p.resolveText(page.getPageProperty().getHeaderTitle(), page.getPageProperty().getModelLink()));
        }
        if (page.getBreadcrumb() != null) {
            for (Breadcrumb crumb : page.getBreadcrumb()) {
                crumb.setLabel(p.resolveText(crumb.getLabel(), crumb.getModelLink()));
            }
        }
        return page;
    }

    private void collectFiltersToModels(Models models, List<Widget> widgets) {
        if (widgets != null) {
            for (Widget w : widgets) {
                if (w.getFilters() == null) continue;
                for (Filter f : w.getFilters()) {
                    if (!f.getRoutable().booleanValue() || f.getLink().getSubModelQuery() == null) continue;
                    this.addToModels(models, f);
                }
            }
        }
    }

    private void addToModels(Models models, Filter f) {
        ReduxModel model = f.getLink().getModel();
        String widgetId = f.getLink().getWidgetId();
        String fieldId = f.getLink().getSubModelQuery().getSubModel();
        ModelLink link = new ModelLink(model, widgetId, fieldId);
        link.setParam(f.getParam());
        link.setSubModelQuery(f.getLink().getSubModelQuery());
        if (models.get(model, widgetId, fieldId) != null) {
            link.setValue(models.get(model, widgetId, fieldId).getValue());
        }
        if (link.getValue() == null) {
            link.setValue(f.getLink().getValue());
        }
        models.add(model, widgetId, fieldId, link);
    }

    private void resolveLinks(Models models, BindProcessor p) {
        models.keySet().forEach(param -> {
            models.put(param, (Object)((ModelLink)p.resolveLink((BindLink)models.get(param))));
            p.resolveSubModels((ModelLink)models.get(param));
        });
    }
}

